/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.query.GremlinQueryComposer;
import org.apache.atlas.query.IdentifierHelper;
import org.apache.atlas.query.Lookup;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.lang.StringUtils;

class RegistryBasedLookup
implements Lookup {
    private static final Set<String> SYSTEM_ATTRIBUTES = new HashSet<String>(Arrays.asList(Constants.GUID_PROPERTY_KEY, Constants.MODIFIED_BY_KEY, Constants.CREATED_BY_KEY, Constants.STATE_PROPERTY_KEY, Constants.TIMESTAMP_PROPERTY_KEY, Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, Constants.HOME_ID_KEY));
    private static final Map<String, String> NUMERIC_ATTRIBUTES = new HashMap<String, String>(){
        {
            this.put("short", "");
            this.put("int", "");
            this.put("long", "L");
            this.put("float", "f");
            this.put("double", "d");
            this.put("biginteger", "");
            this.put("bigdecimal", "");
        }
    };
    private final AtlasTypeRegistry typeRegistry;

    public RegistryBasedLookup(AtlasTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    @Override
    public AtlasType getType(String typeName) throws AtlasBaseException {
        Object ret = typeName.equalsIgnoreCase("_CLASSIFIED") ? SearchContext.MATCH_ALL_CLASSIFIED : (typeName.equalsIgnoreCase("_NOT_CLASSIFIED") ? SearchContext.MATCH_ALL_NOT_CLASSIFIED : this.typeRegistry.getType(typeName));
        return ret;
    }

    @Override
    public String getQualifiedName(GremlinQueryComposer.Context context, String name) throws AtlasBaseException {
        AtlasEntityType et = context.getActiveEntityType();
        if (et == null) {
            return "";
        }
        if (this.isSystemAttribute(name)) {
            return name;
        }
        return et.getQualifiedAttributeName(name);
    }

    private boolean isSystemAttribute(String s) {
        return SYSTEM_ATTRIBUTES.contains(s);
    }

    @Override
    public boolean isPrimitive(GremlinQueryComposer.Context context, String attributeName) {
        AtlasEntityType et = context.getActiveEntityType();
        if (et == null) {
            return false;
        }
        if (this.isSystemAttribute(attributeName)) {
            return true;
        }
        AtlasType at = this.getAttributeType(et, attributeName);
        if (at == null) {
            return false;
        }
        TypeCategory tc = at.getTypeCategory();
        if (this.isPrimitiveUsingTypeCategory(tc)) {
            return true;
        }
        if (tc != null && tc == TypeCategory.ARRAY) {
            AtlasArrayType ct = (AtlasArrayType)at;
            return this.isPrimitiveUsingTypeCategory(ct.getElementType().getTypeCategory());
        }
        if (tc != null && tc == TypeCategory.MAP) {
            AtlasMapType ct = (AtlasMapType)at;
            return this.isPrimitiveUsingTypeCategory(ct.getValueType().getTypeCategory());
        }
        return false;
    }

    private boolean isPrimitiveUsingTypeCategory(TypeCategory tc) {
        return tc != null && (tc == TypeCategory.PRIMITIVE || tc == TypeCategory.ENUM);
    }

    @Override
    public String getRelationshipEdgeLabel(GremlinQueryComposer.Context context, String attributeName) {
        AtlasEntityType et = context.getActiveEntityType();
        if (et == null) {
            return "";
        }
        AtlasStructType.AtlasAttribute attr = this.getAttribute(et, attributeName);
        return attr != null ? attr.getRelationshipEdgeLabel() : "";
    }

    @Override
    public boolean hasAttribute(GremlinQueryComposer.Context context, String typeName) {
        AtlasEntityType entityType = context.getActiveEntityType();
        return entityType != null && (this.isSystemAttribute(typeName) || entityType.hasAttribute(typeName) || entityType.hasRelationshipAttribute(typeName));
    }

    @Override
    public boolean doesTypeHaveSubTypes(GremlinQueryComposer.Context context) {
        return context.getActiveEntityType() != null && context.getActiveEntityType().getAllSubTypes().size() > 0;
    }

    @Override
    public String getTypeAndSubTypes(GremlinQueryComposer.Context context) {
        String[] str;
        String[] stringArray = str = context.getActiveEntityType() != null ? context.getActiveEntityType().getTypeAndAllSubTypes().toArray(new String[0]) : new String[]{};
        if (str.length == 0) {
            return null;
        }
        Object[] quoted = new String[str.length];
        for (int i = 0; i < str.length; ++i) {
            quoted[i] = IdentifierHelper.getQuoted(str[i]);
        }
        return StringUtils.join((Object[])quoted, (String)",");
    }

    @Override
    public boolean isTraitType(String typeName) {
        Object t = null;
        try {
            t = typeName.equalsIgnoreCase("_CLASSIFIED") ? SearchContext.MATCH_ALL_CLASSIFIED : (typeName.equalsIgnoreCase("_NOT_CLASSIFIED") ? SearchContext.MATCH_ALL_NOT_CLASSIFIED : this.typeRegistry.getType(typeName));
        }
        catch (AtlasBaseException e) {
            return false;
        }
        return this.isTraitType((AtlasType)t);
    }

    private boolean isTraitType(AtlasType t) {
        return t != null && t.getTypeCategory() == TypeCategory.CLASSIFICATION;
    }

    @Override
    public String getTypeFromEdge(GremlinQueryComposer.Context context, String item) {
        AtlasEntityType et = context.getActiveEntityType();
        if (et == null) {
            return "";
        }
        AtlasStructType.AtlasAttribute attr = this.getAttribute(et, item);
        if (attr == null) {
            return null;
        }
        AtlasType at = attr.getAttributeType();
        switch (at.getTypeCategory()) {
            case ARRAY: {
                AtlasArrayType arrType = (AtlasArrayType)at;
                return this.getCollectionElementType(arrType.getElementType());
            }
            case MAP: {
                AtlasMapType mapType = (AtlasMapType)at;
                return this.getCollectionElementType(mapType.getValueType());
            }
        }
        return this.getAttribute(context.getActiveEntityType(), item).getTypeName();
    }

    private String getCollectionElementType(AtlasType elemType) {
        if (elemType.getTypeCategory() == TypeCategory.OBJECT_ID_TYPE) {
            return ((AtlasBuiltInTypes.AtlasObjectIdType)elemType).getObjectType();
        }
        return elemType.getTypeName();
    }

    @Override
    public boolean isDate(GremlinQueryComposer.Context context, String attributeName) {
        AtlasEntityType et = context.getActiveEntityType();
        if (et == null) {
            return false;
        }
        AtlasType attr = this.getAttributeType(et, attributeName);
        return attr != null && attr.getTypeName().equals("date");
    }

    @Override
    public boolean isNumeric(GremlinQueryComposer.Context context, String attrName) {
        boolean ret;
        AtlasEntityType et = context.getActiveEntityType();
        if (et == null) {
            return false;
        }
        AtlasType attr = this.getAttributeType(et, attrName);
        boolean bl = ret = attr != null && NUMERIC_ATTRIBUTES.containsKey(attr.getTypeName());
        if (ret) {
            context.setNumericTypeFormatter(NUMERIC_ATTRIBUTES.get(attr.getTypeName()));
        }
        return ret;
    }

    private AtlasStructType.AtlasAttribute getAttribute(AtlasEntityType entityType, String attrName) {
        AtlasStructType.AtlasAttribute ret = null;
        if (entityType != null && (ret = entityType.getAttribute(attrName)) == null) {
            ret = entityType.getRelationshipAttribute(attrName, null);
        }
        return ret;
    }

    private AtlasType getAttributeType(AtlasEntityType entityType, String attrName) {
        AtlasStructType.AtlasAttribute attribute = this.getAttribute(entityType, attrName);
        return attribute != null ? attribute.getAttributeType() : null;
    }
}

