/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.query.GremlinQueryComposer;
import org.apache.atlas.query.Lookup;
import org.apache.atlas.query.SelectClauseComposer;
import org.apache.commons.lang.StringUtils;

public class IdentifierHelper {
    private static final Pattern SINGLE_QUOTED_IDENTIFIER = Pattern.compile("'(\\w[\\w\\d\\.\\s]*)'");
    private static final Pattern DOUBLE_QUOTED_IDENTIFIER = Pattern.compile("\"(\\w[\\w\\d\\.\\s]*)\"");
    private static final Pattern BACKTICK_QUOTED_IDENTIFIER = Pattern.compile("`(\\w[\\w\\d\\.\\s]*)`");

    public static String get(String quotedIdentifier) {
        String ret = quotedIdentifier.charAt(0) == '`' ? IdentifierHelper.extract(BACKTICK_QUOTED_IDENTIFIER, quotedIdentifier) : (quotedIdentifier.charAt(0) == '\'' ? IdentifierHelper.extract(SINGLE_QUOTED_IDENTIFIER, quotedIdentifier) : (quotedIdentifier.charAt(0) == '\"' ? IdentifierHelper.extract(DOUBLE_QUOTED_IDENTIFIER, quotedIdentifier) : quotedIdentifier));
        return ret;
    }

    public static Info create(GremlinQueryComposer.Context context, Lookup lookup, String identifier) {
        Info idInfo = new Info(identifier);
        idInfo.update(lookup, context);
        return idInfo;
    }

    private static String extract(Pattern p, String s) {
        Matcher m = p.matcher(s);
        return m.find() ? m.group(1) : s;
    }

    public static String getQualifiedName(Lookup lookup, GremlinQueryComposer.Context context, String name) {
        try {
            return lookup.getQualifiedName(context, name);
        }
        catch (AtlasBaseException e) {
            context.error(e, AtlasErrorCode.INVALID_DSL_QUALIFIED_NAME, context.getActiveTypeName(), name);
            return "";
        }
    }

    public static boolean isQuoted(String val) {
        char last;
        char first;
        boolean ret = false;
        if (val != null && val.length() > 1 && (first = val.charAt(0)) == (last = val.charAt(val.length() - 1)) && (first == '\'' || first == '\"' || first == '`')) {
            ret = true;
        }
        return ret;
    }

    public static String removeQuotes(String rhs) {
        return rhs.replace("\"", "").replace("'", "").replace("`", "");
    }

    public static String getQuoted(String s) {
        return String.format("'%s'", s);
    }

    public static boolean isTrueOrFalse(String rhs) {
        return rhs.equalsIgnoreCase("true") || rhs.equalsIgnoreCase("false");
    }

    public static String getFixedRegEx(String s) {
        return s.replace("*", ".*").replace('?', '.');
    }

    public static class Info {
        private String raw;
        private String actual;
        private String[] parts;
        private String typeName;
        private String attributeName;
        private boolean isPrimitive;
        private String edgeLabel;
        private boolean introduceType;
        private boolean hasSubtypes;
        private String subTypes;
        private boolean isTrait;
        private boolean newContext;
        private boolean isAttribute;
        private String qualifiedName;
        private boolean isDate;
        private boolean isNumeric;

        public Info(String s) {
            this.raw = IdentifierHelper.removeQuotes(s);
            this.actual = IdentifierHelper.get(this.raw);
        }

        private void update(Lookup lookup, GremlinQueryComposer.Context context) {
            try {
                this.newContext = context.isEmpty();
                if (!this.newContext) {
                    if (context.hasAlias(this.raw)) {
                        this.raw = context.getTypeNameFromAlias(this.raw);
                    }
                    this.updateParts();
                    this.updateTypeInfo(lookup, context);
                    this.setIsTrait(context, lookup, this.attributeName);
                    this.updateEdgeInfo(lookup, context);
                    this.introduceType = !this.isPrimitive() && !context.hasAlias(this.parts[0]);
                    this.updateSubTypes(lookup, context);
                }
            }
            catch (NullPointerException ex) {
                context.getErrorList().add(ex.getMessage());
            }
        }

        private void setIsTrait(GremlinQueryComposer.Context ctx, Lookup lookup, String s) {
            this.isTrait = lookup.isTraitType(s);
        }

        private void updateSubTypes(Lookup lookup, GremlinQueryComposer.Context context) {
            if (this.isTrait) {
                return;
            }
            this.hasSubtypes = lookup.doesTypeHaveSubTypes(context);
            if (this.hasSubtypes) {
                this.subTypes = lookup.getTypeAndSubTypes(context);
            }
        }

        private void updateEdgeInfo(Lookup lookup, GremlinQueryComposer.Context context) {
            if (!this.isPrimitive && !this.isTrait && this.typeName != this.attributeName) {
                this.edgeLabel = lookup.getRelationshipEdgeLabel(context, this.attributeName);
                this.typeName = lookup.getTypeFromEdge(context, this.attributeName);
            }
        }

        private void updateTypeInfo(Lookup lookup, GremlinQueryComposer.Context context) {
            if (this.parts.length == 1) {
                this.typeName = context.hasAlias(this.parts[0]) ? context.getTypeNameFromAlias(this.parts[0]) : context.getActiveTypeName();
                this.qualifiedName = this.getDefaultQualifiedNameForSinglePartName(context, this.parts[0]);
                this.attributeName = this.parts[0];
            }
            if (this.parts.length == 2) {
                boolean isAttrOfActiveType = lookup.hasAttribute(context, this.parts[0]);
                if (isAttrOfActiveType) {
                    this.attributeName = this.parts[0];
                } else {
                    this.typeName = context.hasAlias(this.parts[0]) ? context.getTypeNameFromAlias(this.parts[0]) : this.parts[0];
                    this.attributeName = this.parts[1];
                }
            }
            this.isAttribute = lookup.hasAttribute(context, this.attributeName);
            this.isPrimitive = lookup.isPrimitive(context, this.attributeName);
            this.setQualifiedName(lookup, context, this.isAttribute, this.attributeName);
            this.setIsDate(lookup, context, this.isPrimitive, this.attributeName);
            this.setIsNumeric(lookup, context, this.isPrimitive, this.attributeName);
        }

        private String getDefaultQualifiedNameForSinglePartName(GremlinQueryComposer.Context context, String s) {
            String qn = context.getTypeNameFromAlias(s);
            if (StringUtils.isEmpty((String)qn) && SelectClauseComposer.isKeyword(s)) {
                return s;
            }
            return qn;
        }

        private void setQualifiedName(Lookup lookup, GremlinQueryComposer.Context context, boolean isAttribute, String attrName) {
            if (isAttribute) {
                this.qualifiedName = this.getQualifiedName(lookup, context, attrName);
            }
        }

        private String getQualifiedName(Lookup lookup, GremlinQueryComposer.Context context, String name) {
            return IdentifierHelper.getQualifiedName(lookup, context, name);
        }

        private void setIsDate(Lookup lookup, GremlinQueryComposer.Context context, boolean isPrimitive, String attrName) {
            if (isPrimitive) {
                this.isDate = lookup.isDate(context, attrName);
            }
        }

        private void setIsNumeric(Lookup lookup, GremlinQueryComposer.Context context, boolean isPrimitive, String attrName) {
            if (isPrimitive) {
                this.isNumeric = lookup.isNumeric(context, attrName);
            }
        }

        private void updateParts() {
            this.parts = StringUtils.split((String)this.raw, (String)".");
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public boolean isPrimitive() {
            return this.isPrimitive;
        }

        public boolean isAttribute() {
            return this.isAttribute;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getEdgeLabel() {
            return this.edgeLabel;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean isReferredType() {
            return this.introduceType;
        }

        public boolean isTrait() {
            return this.isTrait;
        }

        public boolean hasSubtypes() {
            return this.hasSubtypes;
        }

        public String getSubTypes() {
            return this.subTypes;
        }

        public String get() {
            return this.actual;
        }

        public boolean isDate() {
            return this.isDate;
        }

        public boolean hasParts() {
            return this.parts.length > 1;
        }

        public String getRaw() {
            return this.raw;
        }

        public boolean isNumeric() {
            return this.isNumeric;
        }
    }
}

