/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import com.google.common.annotations.VisibleForTesting;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.query.AtlasDSL;
import org.apache.atlas.query.GremlinClause;
import org.apache.atlas.query.GremlinClauseList;
import org.apache.atlas.query.IdentifierHelper;
import org.apache.atlas.query.Lookup;
import org.apache.atlas.query.RegistryBasedLookup;
import org.apache.atlas.query.SelectClauseComposer;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinQueryComposer {
    private static final Logger LOG = LoggerFactory.getLogger(GremlinQueryComposer.class);
    private static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String ISO8601_DATE_FORMAT = "yyyy-MM-dd";
    private static final ThreadLocal<DateFormat[]> DSL_DATE_FORMAT = ThreadLocal.withInitial(() -> {
        String[] formats = new String[]{ISO8601_FORMAT, ISO8601_DATE_FORMAT};
        DateFormat[] dfs = new DateFormat[formats.length];
        for (int i = 0; i < formats.length; ++i) {
            dfs[i] = new SimpleDateFormat(formats[i]);
            dfs[i].setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return dfs;
    });
    private final String EMPTY_STRING = "";
    private final int DEFAULT_QUERY_RESULT_LIMIT = 25;
    private final int DEFAULT_QUERY_RESULT_OFFSET = 0;
    private final GremlinClauseList queryClauses = new GremlinClauseList();
    private final Set<String> attributesProcessed = new HashSet<String>();
    private final Lookup lookup;
    private final boolean isNestedQuery;
    private final AtlasDSL.QueryMetadata queryMetadata;
    private int providedLimit = 25;
    private int providedOffset = 0;
    private Context context;

    public GremlinQueryComposer(Lookup registryLookup, AtlasDSL.QueryMetadata qmd, boolean isNestedQuery) {
        this.isNestedQuery = isNestedQuery;
        this.lookup = registryLookup;
        this.queryMetadata = qmd;
        this.init();
    }

    public GremlinQueryComposer(AtlasTypeRegistry typeRegistry, AtlasDSL.QueryMetadata qmd, int limit, int offset) {
        this((Lookup)new RegistryBasedLookup(typeRegistry), qmd, false);
        this.context = new Context(this.lookup);
        this.providedLimit = limit;
        this.providedOffset = offset < 0 ? 0 : offset;
    }

    @VisibleForTesting
    GremlinQueryComposer(Lookup lookup, Context context, AtlasDSL.QueryMetadata qmd) {
        this.isNestedQuery = false;
        this.lookup = lookup;
        this.context = context;
        this.queryMetadata = qmd;
        this.init();
    }

    public void addFrom(String typeName) {
        IdentifierHelper.Info typeInfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug("addFrom(typeName={})", (Object)typeName);
        }
        if (this.context.shouldRegister((typeInfo = this.createInfo(typeName)).get())) {
            this.context.registerActive(typeInfo.get());
            IdentifierHelper.Info ia = this.createInfo(typeInfo.get());
            if (ia.isTrait()) {
                String traitName = ia.get();
                if (traitName.equalsIgnoreCase("_CLASSIFIED")) {
                    this.addTrait(GremlinClause.ANY_TRAIT, ia);
                } else if (traitName.equalsIgnoreCase("_NOT_CLASSIFIED")) {
                    this.addTrait(GremlinClause.NO_TRAIT, ia);
                } else {
                    this.addTrait(GremlinClause.TRAIT, ia);
                }
            } else if (ia.hasSubtypes()) {
                this.add(GremlinClause.HAS_TYPE_WITHIN, ia.getSubTypes());
            } else {
                this.add(GremlinClause.HAS_TYPE, ia);
            }
        } else {
            IdentifierHelper.Info ia = this.createInfo(typeInfo.get());
            this.introduceType(ia);
        }
    }

    public void addFromProperty(String typeName, String attribute) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addFromProperty(typeName={}, attribute={})", (Object)typeName, (Object)attribute);
        }
        if (!this.isNestedQuery) {
            this.addFrom(typeName);
        }
        this.add(GremlinClause.HAS_PROPERTY, this.createInfo(attribute));
    }

    public void addIsA(String typeName, String traitName) {
        if (!this.isNestedQuery) {
            this.addFrom(typeName);
        }
        IdentifierHelper.Info traitInfo = this.createInfo(traitName);
        if (StringUtils.equals((String)traitName, (String)"_CLASSIFIED")) {
            this.addTrait(GremlinClause.ANY_TRAIT, traitInfo);
        } else if (StringUtils.equals((String)traitName, (String)"_NOT_CLASSIFIED")) {
            this.addTrait(GremlinClause.NO_TRAIT, traitInfo);
        } else {
            this.addTrait(GremlinClause.TRAIT, traitInfo);
        }
    }

    public void addWhere(String lhs, String operator, String rhs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addWhere(lhs={}, operator={}, rhs={})", new Object[]{lhs, operator, rhs});
        }
        String currentType = this.context.getActiveTypeName();
        IdentifierHelper.Info org = null;
        IdentifierHelper.Info lhsI = this.createInfo(lhs);
        if (!lhsI.isPrimitive()) {
            this.introduceType(lhsI);
            org = lhsI;
            lhsI = this.createInfo(lhs);
        }
        if (!this.context.validator.isValidQualifiedName(lhsI.getQualifiedName(), lhsI.getRaw())) {
            return;
        }
        if (lhsI.isDate()) {
            rhs = this.parseDate(rhs);
        } else if (lhsI.isNumeric()) {
            rhs = this.parseNumber(rhs, this.context);
        }
        rhs = this.addQuotesIfNecessary(lhsI, rhs);
        SearchParameters.Operator op = SearchParameters.Operator.fromString((String)operator);
        if (op == SearchParameters.Operator.LIKE) {
            this.add(GremlinClause.TEXT_CONTAINS, lhsI.getQualifiedName(), IdentifierHelper.getFixedRegEx(rhs));
        } else if (op == SearchParameters.Operator.IN) {
            this.add(GremlinClause.HAS_OPERATOR, lhsI.getQualifiedName(), "within", rhs);
        } else {
            this.add(GremlinClause.HAS_OPERATOR, lhsI.getQualifiedName(), op.getSymbols()[1], rhs);
        }
        this.attributesProcessed.add(lhsI.getQualifiedName());
        if (org != null && org.isReferredType()) {
            this.add(GremlinClause.DEDUP, new String[0]);
            this.add(GremlinClause.IN, org.getEdgeLabel());
            this.context.registerActive(currentType);
        }
    }

    private String parseNumber(String rhs, Context context) {
        return rhs.replace("'", "").replace("\"", "") + context.getNumericTypeFormatter();
    }

    public void addAndClauses(List<String> clauses) {
        this.add(GremlinClause.AND, String.join((CharSequence)",", clauses));
    }

    public void addOrClauses(List<String> clauses) {
        this.add(GremlinClause.OR, String.join((CharSequence)",", clauses));
    }

    public Set<String> getAttributesProcessed() {
        return this.attributesProcessed;
    }

    public void addProcessedAttributes(Set<String> attributesProcessed) {
        this.attributesProcessed.addAll(attributesProcessed);
    }

    public void addSelect(SelectClauseComposer selectClauseComposer) {
        this.process(selectClauseComposer);
        if (CollectionUtils.isEmpty(this.context.getErrorList())) {
            this.addSelectAttrExistsCheck(selectClauseComposer);
        }
        if (!this.queryMetadata.hasOrderBy() || !this.queryMetadata.hasGroupBy()) {
            this.addSelectTransformation(selectClauseComposer, null, false);
        }
        this.context.setSelectClauseComposer(selectClauseComposer);
    }

    public GremlinQueryComposer createNestedProcessor() {
        GremlinQueryComposer qp = new GremlinQueryComposer(this.lookup, this.queryMetadata, true);
        qp.context = this.context;
        return qp;
    }

    public void addFromAlias(String typeName, String alias) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addFromAlias(typeName={}, alias={})", (Object)typeName, (Object)alias);
        }
        this.addFrom(typeName);
        this.addAsClause(alias);
        this.context.registerAlias(alias);
    }

    public void addAsClause(String alias) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addAsClause(stepName={})", (Object)alias);
        }
        this.add(GremlinClause.AS, alias);
    }

    public void addGroupBy(String item) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addGroupBy(item={})", (Object)item);
        }
        this.addGroupByClause(item);
    }

    public void addLimit(String limit, String offset) {
        SelectClauseComposer scc;
        if (LOG.isDebugEnabled()) {
            LOG.debug("addLimit(limit={}, offset={})", (Object)limit, (Object)offset);
        }
        if ((scc = this.context.getSelectClauseComposer()) == null) {
            this.addLimitHelper(limit, offset);
        } else if (!scc.hasAggregators()) {
            this.addLimitHelper(limit, offset);
        }
    }

    public void addDefaultLimit() {
        this.addLimit(Integer.toString(this.providedLimit), Integer.toString(this.providedOffset));
    }

    public String get() {
        String s;
        this.close();
        boolean mustTransform = !this.isNestedQuery && this.queryMetadata.needTransformation();
        CharSequence[] items = this.getFormattedClauses(mustTransform);
        String string = s = mustTransform ? this.getTransformedClauses((String[])items) : String.join((CharSequence)".", items);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Gremlin: {}", (Object)s);
        }
        return s;
    }

    public List<String> getErrorList() {
        return this.context.getErrorList();
    }

    public void addOrderBy(String name, boolean isDesc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addOrderBy(name={}, isDesc={})", (Object)name, (Object)isDesc);
        }
        IdentifierHelper.Info ia = this.createInfo(name);
        if (this.queryMetadata.hasSelect() && this.queryMetadata.hasGroupBy()) {
            this.addSelectTransformation(this.context.selectClauseComposer, this.getQualifiedName(ia), isDesc);
        } else if (this.queryMetadata.hasGroupBy()) {
            this.addOrderByClause(this.getQualifiedName(ia), isDesc);
            this.moveToLast(GremlinClause.GROUP_BY);
        } else {
            this.addOrderByClause(this.getQualifiedName(ia), isDesc);
        }
    }

    public long getDateFormat(String s) {
        for (DateFormat dateFormat : DSL_DATE_FORMAT.get()) {
            try {
                return dateFormat.parse(s).getTime();
            }
            catch (ParseException parseException) {
            }
        }
        this.context.validator.check(false, AtlasErrorCode.INVALID_DSL_INVALID_DATE, s);
        return -1L;
    }

    public boolean hasFromClause() {
        return this.queryClauses.contains(GremlinClause.HAS_TYPE) != -1 || this.queryClauses.contains(GremlinClause.HAS_TYPE_WITHIN) != -1;
    }

    private String getQualifiedName(IdentifierHelper.Info ia) {
        return this.context.validator.isValidQualifiedName(ia.getQualifiedName(), ia.getRaw()) ? ia.getQualifiedName() : ia.getRaw();
    }

    private void addSelectAttrExistsCheck(SelectClauseComposer selectClauseComposer) {
        String[] qualifiedAttributes = selectClauseComposer.getAttributes();
        if (qualifiedAttributes != null && qualifiedAttributes.length > 0) {
            for (int i = 0; i < qualifiedAttributes.length; ++i) {
                String qualifiedAttribute = qualifiedAttributes[i];
                IdentifierHelper.Info idMetadata = this.createInfo(qualifiedAttribute);
                if (!idMetadata.isPrimitive() || selectClauseComposer.isAggregatorIdx(i) || this.attributesProcessed.contains(qualifiedAttribute)) continue;
                this.add(GremlinClause.HAS_PROPERTY, qualifiedAttribute);
            }
            this.moveToLast(GremlinClause.GROUP_BY);
        }
    }

    private void process(SelectClauseComposer scc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addSelect(items.length={})", (Object)(scc.getItems() != null ? scc.getItems().length : 0));
        }
        if (scc.getItems() == null) {
            return;
        }
        for (int i = 0; i < scc.getItems().length; ++i) {
            IdentifierHelper.Info ia = this.createInfo(scc.getItem(i));
            if (scc.isAggregatorWithArgument(i) && !ia.isPrimitive()) {
                this.context.check(false, AtlasErrorCode.INVALID_DSL_SELECT_INVALID_AGG, ia.getQualifiedName());
                return;
            }
            if (!scc.getItem(i).equals(scc.getLabel(i))) {
                this.context.addAlias(scc.getLabel(i), this.getQualifiedName(ia));
            }
            if (scc.updateAsApplicable(i, this.getQualifiedName(ia))) continue;
            scc.isSelectNoop = this.hasNoopCondition(ia);
            if (scc.isSelectNoop) {
                return;
            }
            if (this.introduceType(ia)) {
                scc.incrementTypesIntroduced();
                boolean bl = scc.isSelectNoop = !ia.hasParts();
                if (!ia.hasParts()) continue;
                scc.assign(i, this.getQualifiedName(this.createInfo(ia.get())), GremlinClause.INLINE_GET_PROPERTY);
                continue;
            }
            scc.assign(i, this.getQualifiedName(ia), GremlinClause.INLINE_GET_PROPERTY);
            scc.incrementPrimitiveType();
        }
        this.context.validator.check(!scc.hasMultipleReferredTypes(), AtlasErrorCode.INVALID_DSL_SELECT_REFERRED_ATTR, Integer.toString(scc.getIntroducedTypesCount()));
        this.context.validator.check(!scc.hasMixedAttributes(), AtlasErrorCode.INVALID_DSL_SELECT_ATTR_MIXING, new String[0]);
    }

    private boolean hasNoopCondition(IdentifierHelper.Info ia) {
        return !ia.isPrimitive() && !ia.isAttribute() && this.context.hasAlias(ia.getRaw());
    }

    private void addLimitHelper(String limit, String offset) {
        if (offset.equalsIgnoreCase("0")) {
            this.add(GremlinClause.LIMIT, limit, limit);
        } else {
            this.addRangeClause(offset, limit);
        }
    }

    private String getTransformedClauses(String[] items) {
        String body = String.join((CharSequence)".", Stream.of(items).filter(Objects::nonNull).collect(Collectors.toList()));
        String inlineFn = this.queryClauses.getValue(this.queryClauses.size() - 1);
        String funCall = String.format(inlineFn, body);
        String ret = this.isNestedQuery ? String.join((CharSequence)".", this.queryClauses.getValue(0), funCall) : this.queryClauses.getValue(0) + funCall;
        return ret;
    }

    private String[] getFormattedClauses(boolean needTransformation) {
        String[] items = new String[this.queryClauses.size()];
        int startIdx = needTransformation ? 1 : 0;
        int endIdx = needTransformation ? this.queryClauses.size() - 1 : this.queryClauses.size();
        for (int i = startIdx; i < endIdx; ++i) {
            items[i] = this.queryClauses.getValue(i);
        }
        return items;
    }

    private void addSelectTransformation(SelectClauseComposer selectClauseComposer, String orderByQualifiedAttrName, boolean isDesc) {
        GremlinClause fn;
        if (selectClauseComposer.isSelectNoop) {
            fn = GremlinClause.SELECT_NOOP_FN;
        } else if (this.queryMetadata.hasGroupBy()) {
            fn = selectClauseComposer.onlyAggregators() ? GremlinClause.SELECT_ONLY_AGG_GRP_FN : GremlinClause.SELECT_MULTI_ATTR_GRP_FN;
        } else {
            GremlinClause gremlinClause = fn = selectClauseComposer.onlyAggregators() ? GremlinClause.SELECT_ONLY_AGG_FN : GremlinClause.SELECT_FN;
        }
        if (StringUtils.isEmpty((String)orderByQualifiedAttrName)) {
            this.add(0, fn, selectClauseComposer.getLabelHeader(), selectClauseComposer.hasAssignmentExpr() ? selectClauseComposer.getAssignmentExprString() : "", selectClauseComposer.getItemsString(), "");
        } else {
            int itemIdx = selectClauseComposer.getAttrIndex(orderByQualifiedAttrName);
            GremlinClause sortClause = GremlinClause.INLINE_DEFAULT_TUPLE_SORT;
            if (itemIdx != -1) {
                sortClause = isDesc ? GremlinClause.INLINE_TUPLE_SORT_DESC : GremlinClause.INLINE_TUPLE_SORT_ASC;
            }
            String idxStr = String.valueOf(itemIdx);
            this.add(0, fn, selectClauseComposer.getLabelHeader(), selectClauseComposer.hasAssignmentExpr() ? selectClauseComposer.getAssignmentExprString() : "", selectClauseComposer.getItemsString(), sortClause.get(idxStr, idxStr));
        }
        this.add(GremlinClause.INLINE_TRANSFORM_CALL, new String[0]);
    }

    private String addQuotesIfNecessary(IdentifierHelper.Info rhsI, String rhs) {
        if (rhsI.isNumeric()) {
            return rhs;
        }
        if (IdentifierHelper.isTrueOrFalse(rhs)) {
            return rhs;
        }
        if (IdentifierHelper.isQuoted(rhs)) {
            return rhs;
        }
        return IdentifierHelper.getQuoted(rhs);
    }

    private String parseDate(String rhs) {
        String s = IdentifierHelper.isQuoted(rhs) ? IdentifierHelper.removeQuotes(rhs) : rhs;
        return String.format("'%d'", this.getDateFormat(s));
    }

    private void close() {
        if (this.isNestedQuery) {
            return;
        }
        if (this.queryClauses.size() > 2) {
            this.add(GremlinClause.DEDUP, new String[0]);
            this.moveToLast(GremlinClause.RANGE);
            this.moveToLast(GremlinClause.LIMIT);
        }
        if (!this.queryMetadata.hasLimitOffset()) {
            this.addDefaultLimit();
        }
        if (this.queryClauses.isEmpty()) {
            this.queryClauses.clear();
            return;
        }
        this.moveToLast(GremlinClause.LIMIT);
        this.add(GremlinClause.TO_LIST, new String[0]);
        this.moveToLast(GremlinClause.INLINE_TRANSFORM_CALL);
    }

    private void moveToLast(GremlinClause clause) {
        int index = this.queryClauses.contains(clause);
        if (-1 == index) {
            return;
        }
        GremlinClauseValue gcv = this.queryClauses.remove(index);
        this.queryClauses.add(gcv);
    }

    private void init() {
        if (!this.isNestedQuery) {
            this.add(GremlinClause.G, new String[0]);
            this.add(GremlinClause.V, new String[0]);
        } else {
            this.add(GremlinClause.NESTED_START, new String[0]);
        }
    }

    private boolean introduceType(IdentifierHelper.Info ia) {
        if (ia.isReferredType()) {
            this.add(GremlinClause.OUT, ia.getEdgeLabel());
            this.context.registerActive(ia);
        }
        return ia.isReferredType();
    }

    private IdentifierHelper.Info createInfo(String actualTypeName) {
        return IdentifierHelper.create(this.context, this.lookup, actualTypeName);
    }

    private void addRangeClause(String startIndex, String endIndex) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addRangeClause(startIndex={}, endIndex={})", (Object)startIndex, (Object)endIndex);
        }
        if (this.queryMetadata.hasSelect()) {
            this.add(this.queryClauses.size() - 1, GremlinClause.RANGE, startIndex, startIndex, endIndex, startIndex, startIndex, endIndex);
        } else {
            this.add(GremlinClause.RANGE, startIndex, startIndex, endIndex, startIndex, startIndex, endIndex);
        }
    }

    private void addOrderByClause(String name, boolean descr) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addOrderByClause(name={})", (Object)name, (Object)descr);
        }
        IdentifierHelper.Info ia = this.createInfo(name);
        this.add(!descr ? GremlinClause.ORDER_BY : GremlinClause.ORDER_BY_DESC, ia);
    }

    private void addGroupByClause(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addGroupByClause(name={})", (Object)name);
        }
        IdentifierHelper.Info ia = this.createInfo(name);
        this.add(GremlinClause.GROUP_BY, ia);
    }

    private void add(GremlinClause clause, IdentifierHelper.Info idInfo) {
        if (this.context != null && !this.context.validator.isValid(this.context, clause, idInfo)) {
            return;
        }
        this.add(clause, idInfo.getQualifiedName() == null ? idInfo.get() : idInfo.getQualifiedName());
    }

    private void add(GremlinClause clause, String ... args) {
        this.queryClauses.add(new GremlinClauseValue(clause, clause.get(args)));
    }

    private void add(int idx, GremlinClause clause, String ... args) {
        this.queryClauses.add(idx, new GremlinClauseValue(clause, clause.get(args)));
    }

    private void addTrait(GremlinClause clause, IdentifierHelper.Info idInfo) {
        if (this.context != null && !this.context.validator.isValid(this.context, clause, idInfo)) {
            return;
        }
        this.add(clause, idInfo.get(), idInfo.get());
    }

    private static class ClauseValidator {
        private final Lookup lookup;
        List<String> errorList = new ArrayList<String>();

        public ClauseValidator(Lookup lookup) {
            this.lookup = lookup;
        }

        public boolean isValid(Context ctx, GremlinClause clause, IdentifierHelper.Info ia) {
            switch (clause) {
                case TRAIT: 
                case ANY_TRAIT: 
                case NO_TRAIT: {
                    return this.check(ia.isTrait(), AtlasErrorCode.INVALID_DSL_UNKNOWN_CLASSIFICATION, ia.getRaw());
                }
                case HAS_TYPE: {
                    TypeCategory typeCategory = ctx.getActiveType().getTypeCategory();
                    return this.check(StringUtils.isNotEmpty((String)ia.getTypeName()) && typeCategory == TypeCategory.CLASSIFICATION || typeCategory == TypeCategory.ENTITY, AtlasErrorCode.INVALID_DSL_UNKNOWN_TYPE, ia.getRaw());
                }
                case HAS_PROPERTY: {
                    return this.check(ia.isPrimitive(), AtlasErrorCode.INVALID_DSL_HAS_PROPERTY, ia.getRaw());
                }
                case ORDER_BY: {
                    return this.check(ia.isPrimitive(), AtlasErrorCode.INVALID_DSL_ORDERBY, ia.getRaw());
                }
                case GROUP_BY: {
                    return this.check(ia.isPrimitive(), AtlasErrorCode.INVALID_DSL_SELECT_INVALID_AGG, ia.getRaw());
                }
            }
            return this.getErrorList().size() == 0;
        }

        public boolean check(Exception ex, AtlasErrorCode vm, String ... args) {
            String[] extraArgs = this.getExtraSlotArgs(args, ex.getMessage());
            return this.check(false, vm, extraArgs);
        }

        public boolean check(boolean condition, AtlasErrorCode vm, String ... args) {
            if (!condition) {
                this.addError(vm, args);
            }
            return condition;
        }

        public void addError(AtlasErrorCode ec, String ... messages) {
            this.errorList.add(ec.getFormattedErrorMessage(messages));
        }

        public List<String> getErrorList() {
            return this.errorList;
        }

        public boolean isValidQualifiedName(String qualifiedName, String raw) {
            return this.check(StringUtils.isNotEmpty((String)qualifiedName), AtlasErrorCode.INVALID_DSL_QUALIFIED_NAME, raw);
        }

        private String[] getExtraSlotArgs(String[] args, String s) {
            String[] argsPlus1 = new String[args.length + 1];
            System.arraycopy(args, 0, argsPlus1, 0, args.length);
            argsPlus1[args.length] = s;
            return argsPlus1;
        }
    }

    @VisibleForTesting
    static class Context {
        private static final AtlasStructType UNKNOWN_TYPE = new AtlasStructType(new AtlasStructDef());
        private final Lookup lookup;
        private final Map<String, String> aliasMap = new HashMap<String, String>();
        private AtlasType activeType;
        private SelectClauseComposer selectClauseComposer;
        private ClauseValidator validator;
        private String numericTypeFormatter = "";

        public Context(Lookup lookup) {
            this.lookup = lookup;
            this.validator = new ClauseValidator(lookup);
        }

        public void registerActive(String typeName) {
            if (this.shouldRegister(typeName)) {
                try {
                    this.activeType = this.lookup.getType(typeName);
                    this.aliasMap.put(typeName, typeName);
                }
                catch (AtlasBaseException e) {
                    this.validator.check((Exception)((Object)e), AtlasErrorCode.INVALID_DSL_UNKNOWN_TYPE, typeName);
                    this.activeType = UNKNOWN_TYPE;
                }
            }
        }

        public void registerActive(IdentifierHelper.Info info) {
            if (this.validator.check(StringUtils.isNotEmpty((String)info.getTypeName()), AtlasErrorCode.INVALID_DSL_UNKNOWN_TYPE, info.getRaw())) {
                this.registerActive(info.getTypeName());
            } else {
                this.activeType = UNKNOWN_TYPE;
            }
        }

        public AtlasEntityType getActiveEntityType() {
            return this.activeType instanceof AtlasEntityType ? (AtlasEntityType)this.activeType : null;
        }

        public String getActiveTypeName() {
            return this.activeType.getTypeName();
        }

        public AtlasType getActiveType() {
            return this.activeType;
        }

        public boolean shouldRegister(String typeName) {
            return this.activeType == null || this.activeType != null && !StringUtils.equals((String)this.getActiveTypeName(), (String)typeName) && this.activeType != null && !this.lookup.hasAttribute(this, typeName);
        }

        public void registerAlias(String alias) {
            this.addAlias(alias, this.getActiveTypeName());
        }

        public boolean hasAlias(String alias) {
            return this.aliasMap.containsKey(alias);
        }

        public String getTypeNameFromAlias(String alias) {
            return this.aliasMap.get(alias);
        }

        public boolean isEmpty() {
            return this.activeType == null;
        }

        public SelectClauseComposer getSelectClauseComposer() {
            return this.selectClauseComposer;
        }

        public void setSelectClauseComposer(SelectClauseComposer selectClauseComposer) {
            this.selectClauseComposer = selectClauseComposer;
        }

        public void addAlias(String alias, String typeName) {
            if (this.aliasMap.containsKey(alias)) {
                this.check(false, AtlasErrorCode.INVALID_DSL_DUPLICATE_ALIAS, alias, this.getActiveTypeName());
                return;
            }
            this.aliasMap.put(alias, typeName);
        }

        public List<String> getErrorList() {
            return this.validator.getErrorList();
        }

        public boolean error(AtlasBaseException e, AtlasErrorCode ec, String t, String name) {
            return this.validator.check((Exception)((Object)e), ec, t, name);
        }

        public boolean check(boolean condition, AtlasErrorCode vm, String ... args) {
            return this.validator.check(condition, vm, args);
        }

        public void setNumericTypeFormatter(String formatter) {
            this.numericTypeFormatter = formatter;
        }

        public String getNumericTypeFormatter() {
            return this.numericTypeFormatter;
        }
    }

    static class GremlinClauseValue {
        private final GremlinClause clause;
        private final String value;

        public GremlinClauseValue(GremlinClause clause, String value) {
            this.clause = clause;
            this.value = value;
        }

        public GremlinClause getClause() {
            return this.clause;
        }

        public String getValue() {
            return this.value;
        }
    }
}

