/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import java.util.LinkedList;
import java.util.List;
import org.apache.atlas.query.GremlinClause;
import org.apache.atlas.query.GremlinQueryComposer;
import org.apache.atlas.type.AtlasEntityType;

class GremlinClauseList {
    private final List<GremlinQueryComposer.GremlinClauseValue> list = new LinkedList<GremlinQueryComposer.GremlinClauseValue>();

    GremlinClauseList() {
    }

    public void add(GremlinQueryComposer.GremlinClauseValue g) {
        this.list.add(g);
    }

    public void add(int idx, GremlinQueryComposer.GremlinClauseValue g) {
        this.list.add(idx, g);
    }

    public void add(GremlinQueryComposer.GremlinClauseValue g, AtlasEntityType t) {
        this.add(g);
    }

    public void add(int idx, GremlinQueryComposer.GremlinClauseValue g, AtlasEntityType t) {
        this.add(idx, g);
    }

    public void add(GremlinClause clause, String ... args) {
        this.list.add(new GremlinQueryComposer.GremlinClauseValue(clause, clause.get(args)));
    }

    public void add(int i, GremlinClause clause, String ... args) {
        this.list.add(i, new GremlinQueryComposer.GremlinClauseValue(clause, clause.get(args)));
    }

    public GremlinQueryComposer.GremlinClauseValue getAt(int i) {
        return this.list.get(i);
    }

    public String getValue(int i) {
        return this.list.get(i).getValue();
    }

    public GremlinQueryComposer.GremlinClauseValue get(int i) {
        return this.list.get(i);
    }

    public int size() {
        return this.list.size();
    }

    public int contains(GremlinClause clause) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i).getClause() != clause) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.list.size() == 0 || this.containsGVLimit();
    }

    private boolean containsGVLimit() {
        return this.list.size() == 3 && this.list.get(0).getClause() == GremlinClause.G && this.list.get(1).getClause() == GremlinClause.V && this.list.get(2).getClause() == GremlinClause.LIMIT;
    }

    public void clear() {
        this.list.clear();
    }

    public GremlinQueryComposer.GremlinClauseValue remove(int index) {
        GremlinQueryComposer.GremlinClauseValue gcv = this.get(index);
        this.list.remove(index);
        return gcv;
    }
}

