/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.atlas.query.GremlinQueryComposer;
import org.apache.atlas.query.SelectClauseComposer;
import org.apache.atlas.query.antlr4.AtlasDSLParser;
import org.apache.atlas.query.antlr4.AtlasDSLParserBaseVisitor;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSLVisitor
extends AtlasDSLParserBaseVisitor<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(DSLVisitor.class);
    private static final String AND = "AND";
    private static final String OR = "OR";
    private final GremlinQueryComposer gremlinQueryComposer;

    public DSLVisitor(GremlinQueryComposer gremlinQueryComposer) {
        this.gremlinQueryComposer = gremlinQueryComposer;
    }

    @Override
    public Void visitLimitOffset(AtlasDSLParser.LimitOffsetContext ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("=> DSLVisitor.visitLimitOffset({})", (Object)ctx);
        }
        this.gremlinQueryComposer.addLimit(ctx.limitClause().NUMBER().getText(), ctx.offsetClause() == null ? "0" : ctx.offsetClause().NUMBER().getText());
        return (Void)super.visitLimitOffset(ctx);
    }

    @Override
    public Void visitSelectExpr(AtlasDSLParser.SelectExprContext ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("=> DSLVisitor.visitSelectExpr({})", (Object)ctx);
        }
        if (!(ctx.getParent() instanceof AtlasDSLParser.GroupByExpressionContext)) {
            String[] items = new String[ctx.selectExpression().size()];
            String[] labels = new String[ctx.selectExpression().size()];
            SelectClauseComposer selectClauseComposer = new SelectClauseComposer();
            for (int i = 0; i < ctx.selectExpression().size(); ++i) {
                AtlasDSLParser.SelectExpressionContext selectExpression = ctx.selectExpression(i);
                AtlasDSLParser.CountClauseContext countClause = selectExpression.expr().compE().countClause();
                AtlasDSLParser.SumClauseContext sumClause = selectExpression.expr().compE().sumClause();
                AtlasDSLParser.MinClauseContext minClause = selectExpression.expr().compE().minClause();
                AtlasDSLParser.MaxClauseContext maxClause = selectExpression.expr().compE().maxClause();
                AtlasDSLParser.IdentifierContext identifier = selectExpression.identifier();
                String string = labels[i] = identifier != null ? identifier.getText() : selectExpression.getText();
                if (Objects.nonNull((Object)countClause)) {
                    items[i] = "count";
                    selectClauseComposer.setCountIdx(i);
                    continue;
                }
                if (Objects.nonNull((Object)sumClause)) {
                    items[i] = sumClause.expr().getText();
                    selectClauseComposer.setSumIdx(i);
                    continue;
                }
                if (Objects.nonNull((Object)minClause)) {
                    items[i] = minClause.expr().getText();
                    selectClauseComposer.setMinIdx(i);
                    continue;
                }
                if (Objects.nonNull((Object)maxClause)) {
                    items[i] = maxClause.expr().getText();
                    selectClauseComposer.setMaxIdx(i);
                    continue;
                }
                items[i] = selectExpression.expr().getText();
            }
            selectClauseComposer.setItems(items);
            selectClauseComposer.setAttributes(items);
            selectClauseComposer.setLabels(labels);
            this.gremlinQueryComposer.addSelect(selectClauseComposer);
        }
        return (Void)super.visitSelectExpr(ctx);
    }

    @Override
    public Void visitOrderByExpr(AtlasDSLParser.OrderByExprContext ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("=> DSLVisitor.visitOrderByExpr({})", (Object)ctx);
        }
        String text = ctx.expr().getText().replace("(", "").replace(")", "");
        this.gremlinQueryComposer.addOrderBy(text, ctx.sortOrder() != null && ctx.sortOrder().getText().equalsIgnoreCase("desc"));
        return (Void)super.visitOrderByExpr(ctx);
    }

    @Override
    public Void visitWhereClause(AtlasDSLParser.WhereClauseContext ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("=> DSLVisitor.visitWhereClause({})", (Object)ctx);
        }
        AtlasDSLParser.ExprContext expr = ctx.expr();
        this.processExpr(expr, this.gremlinQueryComposer);
        return (Void)super.visitWhereClause(ctx);
    }

    @Override
    public Void visitFromExpression(AtlasDSLParser.FromExpressionContext ctx) {
        AtlasDSLParser.FromSrcContext fromSrc;
        AtlasDSLParser.AliasExprContext aliasExpr;
        if (LOG.isDebugEnabled()) {
            LOG.debug("=> DSLVisitor.visitFromExpression({})", (Object)ctx);
        }
        if ((aliasExpr = (fromSrc = ctx.fromSrc()).aliasExpr()) != null) {
            this.gremlinQueryComposer.addFromAlias(aliasExpr.identifier(0).getText(), aliasExpr.identifier(1).getText());
        } else if (fromSrc.identifier() != null) {
            this.gremlinQueryComposer.addFrom(fromSrc.identifier().getText());
        } else {
            this.gremlinQueryComposer.addFrom(fromSrc.literal().getText());
        }
        return (Void)super.visitFromExpression(ctx);
    }

    @Override
    public Void visitSingleQrySrc(AtlasDSLParser.SingleQrySrcContext ctx) {
        if (ctx.fromExpression() == null) {
            if (ctx.expr() != null && !this.gremlinQueryComposer.hasFromClause()) {
                this.inferFromClause(ctx);
            }
            if (ctx.expr() != null && this.gremlinQueryComposer.hasFromClause()) {
                this.processExpr(ctx.expr(), this.gremlinQueryComposer);
            }
        }
        return (Void)super.visitSingleQrySrc(ctx);
    }

    @Override
    public Void visitGroupByExpression(AtlasDSLParser.GroupByExpressionContext ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("=> DSLVisitor.visitGroupByExpression({})", (Object)ctx);
        }
        String s = ctx.selectExpr().getText();
        this.gremlinQueryComposer.addGroupBy(s);
        return (Void)super.visitGroupByExpression(ctx);
    }

    private Void visitIsClause(GremlinQueryComposer gqc, AtlasDSLParser.IsClauseContext ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("=> DSLVisitor.visitIsClause({})", (Object)ctx);
        }
        gqc.addIsA(ctx.arithE().getText(), ctx.identifier().getText());
        return (Void)super.visitIsClause(ctx);
    }

    private void visitHasClause(GremlinQueryComposer gqc, AtlasDSLParser.HasClauseContext ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("=> DSLVisitor.visitHasClause({})", (Object)ctx);
        }
        gqc.addFromProperty(ctx.arithE().getText(), ctx.identifier().getText());
        super.visitHasClause(ctx);
    }

    private void inferFromClause(AtlasDSLParser.SingleQrySrcContext ctx) {
        if (ctx.fromExpression() != null) {
            return;
        }
        if (ctx.expr() != null && this.gremlinQueryComposer.hasFromClause()) {
            return;
        }
        if (ctx.expr().compE() != null && ctx.expr().compE().isClause() != null && ctx.expr().compE().isClause().arithE() != null) {
            this.gremlinQueryComposer.addFrom(ctx.expr().compE().isClause().arithE().getText());
            return;
        }
        if (ctx.expr().compE() != null && ctx.expr().compE().hasClause() != null && ctx.expr().compE().hasClause().arithE() != null) {
            this.gremlinQueryComposer.addFrom(ctx.expr().compE().hasClause().arithE().getText());
        }
    }

    private void processExpr(AtlasDSLParser.ExprContext expr, GremlinQueryComposer gremlinQueryComposer) {
        if (CollectionUtils.isNotEmpty(expr.exprRight())) {
            this.processExprRight(expr, gremlinQueryComposer);
        } else {
            this.processExpr(expr.compE(), gremlinQueryComposer);
        }
    }

    private void processExprRight(AtlasDSLParser.ExprContext expr, GremlinQueryComposer gremlinQueryComposer) {
        GremlinQueryComposer nestedProcessor = gremlinQueryComposer.createNestedProcessor();
        ArrayList<String> nestedQueries = new ArrayList<String>();
        String prev = null;
        this.processExpr(expr.compE(), nestedProcessor);
        nestedQueries.add(nestedProcessor.get());
        gremlinQueryComposer.addProcessedAttributes(nestedProcessor.getAttributesProcessed());
        for (AtlasDSLParser.ExprRightContext exprRight : expr.exprRight()) {
            nestedProcessor = gremlinQueryComposer.createNestedProcessor();
            if (exprRight.K_AND() != null) {
                if (prev == null) {
                    prev = AND;
                }
                if (OR.equalsIgnoreCase(prev)) {
                    GremlinQueryComposer orClause = nestedProcessor.createNestedProcessor();
                    orClause.addOrClauses(nestedQueries);
                    nestedQueries.clear();
                    nestedQueries.add(orClause.get());
                    gremlinQueryComposer.addProcessedAttributes(orClause.getAttributesProcessed());
                }
                prev = AND;
            }
            if (exprRight.K_OR() != null) {
                if (prev == null) {
                    prev = OR;
                }
                if (AND.equalsIgnoreCase(prev)) {
                    GremlinQueryComposer andClause = nestedProcessor.createNestedProcessor();
                    andClause.addAndClauses(nestedQueries);
                    nestedQueries.clear();
                    nestedQueries.add(andClause.get());
                    gremlinQueryComposer.addProcessedAttributes(andClause.getAttributesProcessed());
                }
                prev = OR;
            }
            this.processExpr(exprRight.compE(), nestedProcessor);
            nestedQueries.add(nestedProcessor.get());
            gremlinQueryComposer.addProcessedAttributes(nestedProcessor.getAttributesProcessed());
        }
        if (AND.equalsIgnoreCase(prev)) {
            gremlinQueryComposer.addAndClauses(nestedQueries);
        }
        if (OR.equalsIgnoreCase(prev)) {
            gremlinQueryComposer.addOrClauses(nestedQueries);
        }
    }

    private void processExpr(AtlasDSLParser.CompEContext compE, GremlinQueryComposer gremlinQueryComposer) {
        if (compE != null && compE.isClause() == null && compE.hasClause() == null) {
            AtlasDSLParser.ExprContext exprContext;
            AtlasDSLParser.ComparisonClauseContext comparisonClause = compE.comparisonClause();
            if (comparisonClause == null && CollectionUtils.isEmpty((exprContext = compE.arithE().multiE().atomE().expr()).exprRight())) {
                comparisonClause = exprContext.compE().comparisonClause();
            }
            if (comparisonClause != null) {
                String rhs;
                String op;
                String lhs = comparisonClause.arithE(0).getText();
                AtlasDSLParser.AtomEContext atomECtx = comparisonClause.arithE(1).multiE().atomE();
                if (atomECtx.literal() == null || atomECtx.literal() != null && atomECtx.literal().valueArray() == null) {
                    op = comparisonClause.operator().getText().toUpperCase();
                    rhs = comparisonClause.arithE(1).getText();
                } else {
                    op = "in";
                    rhs = this.getInClause(atomECtx);
                }
                gremlinQueryComposer.addWhere(lhs, op, rhs);
            } else {
                this.processExpr(compE.arithE().multiE().atomE().expr(), gremlinQueryComposer);
            }
        }
        if (compE != null && compE.isClause() != null) {
            this.visitIsClause(gremlinQueryComposer, compE.isClause());
        }
        if (compE != null && compE.hasClause() != null) {
            this.visitHasClause(gremlinQueryComposer, compE.hasClause());
        }
    }

    private String getInClause(AtlasDSLParser.AtomEContext atomEContext) {
        StringBuilder sb = new StringBuilder();
        AtlasDSLParser.ValueArrayContext valueArrayContext = atomEContext.literal().valueArray();
        int startIdx = 1;
        int endIdx = valueArrayContext.children.size() - 1;
        for (int i = startIdx; i < endIdx; ++i) {
            sb.append(valueArrayContext.getChild(i));
        }
        return sb.toString();
    }
}

