/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.query.DSLVisitor;
import org.apache.atlas.query.GremlinQuery;
import org.apache.atlas.query.GremlinQueryComposer;
import org.apache.atlas.query.antlr4.AtlasDSLLexer;
import org.apache.atlas.query.antlr4.AtlasDSLParser;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasDSL {

    public static class QueryMetadata {
        private boolean hasSelect;
        private boolean hasGroupBy;
        private boolean hasOrderBy;
        private boolean hasLimitOffset;

        public QueryMetadata(AtlasDSLParser.QueryContext queryContext) {
            this.hasSelect = queryContext != null && queryContext.selectClause() != null;
            this.hasGroupBy = queryContext != null && queryContext.groupByExpression() != null;
            this.hasOrderBy = queryContext != null && queryContext.orderByExpr() != null;
            this.hasLimitOffset = queryContext != null && queryContext.limitOffset() != null;
        }

        public boolean hasSelect() {
            return this.hasSelect;
        }

        public boolean hasGroupBy() {
            return this.hasGroupBy;
        }

        public boolean hasOrderBy() {
            return this.hasOrderBy;
        }

        public boolean hasLimitOffset() {
            return this.hasLimitOffset;
        }

        public boolean needTransformation() {
            return this.hasGroupBy && this.hasSelect && this.hasOrderBy || this.hasSelect;
        }
    }

    public static class Translator {
        private static final Logger LOG = LoggerFactory.getLogger(Translator.class);
        private final AtlasDSLParser.QueryContext queryContext;
        private final AtlasTypeRegistry typeRegistry;
        private final int offset;
        private final int limit;
        private final String query;

        public Translator(String query, AtlasTypeRegistry typeRegistry, int offset, int limit) throws AtlasBaseException {
            this.query = query;
            this.queryContext = Parser.parse(query);
            this.typeRegistry = typeRegistry;
            this.offset = offset;
            this.limit = limit;
        }

        public GremlinQuery translate() throws AtlasBaseException {
            QueryMetadata queryMetadata = new QueryMetadata(this.queryContext);
            GremlinQueryComposer gremlinQueryComposer = new GremlinQueryComposer(this.typeRegistry, queryMetadata, this.limit, this.offset);
            DSLVisitor dslVisitor = new DSLVisitor(gremlinQueryComposer);
            this.queryContext.accept(dslVisitor);
            this.processErrorList(gremlinQueryComposer);
            String gremlinQuery = gremlinQueryComposer.get();
            return new GremlinQuery(gremlinQuery, queryMetadata.hasSelect());
        }

        private void processErrorList(GremlinQueryComposer gremlinQueryComposer) throws AtlasBaseException {
            if (CollectionUtils.isNotEmpty(gremlinQueryComposer.getErrorList())) {
                String errorMessage = StringUtils.join(gremlinQueryComposer.getErrorList(), (String)", ");
                LOG.warn("DSL Errors: {}", (Object)errorMessage);
                throw new AtlasBaseException(AtlasErrorCode.INVALID_DSL_QUERY, new String[]{this.query, errorMessage});
            }
        }
    }

    static class Validator
    extends BaseErrorListener {
        private boolean isValid = true;
        private String errorMsg = "";

        Validator() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.isValid = false;
            this.errorMsg = msg;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }
    }

    public static class Parser {
        private static final Logger LOG = LoggerFactory.getLogger(Parser.class);
        private static final Set<String> RESERVED_KEYWORDS = new HashSet<String>(Arrays.asList("[", "]", "(", ")", "=", "<", ">", "!=", "<=", ">=", ",", "and", "or", "+", "-", "*", "/", ".", "select", "from", "where", "groupby", "loop", "isa", "is", "has", "as", "times", "withPath", "limit", "offset", "orderby", "count", "max", "min", "sum", "by", "order", "like"));

        public static boolean isKeyword(String word) {
            return RESERVED_KEYWORDS.contains(word);
        }

        @VisibleForTesting
        static AtlasDSLParser.QueryContext parse(String queryStr) throws AtlasBaseException {
            AtlasDSLParser.QueryContext ret;
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(queryStr.getBytes());
                AtlasDSLLexer lexer = new AtlasDSLLexer(CharStreams.fromStream((InputStream)stream));
                Validator validator = new Validator();
                CommonTokenStream inputTokenStream = new CommonTokenStream((TokenSource)lexer);
                AtlasDSLParser parser = new AtlasDSLParser((TokenStream)inputTokenStream);
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)validator);
                ret = parser.query();
                if (!validator.isValid()) {
                    LOG.error("Invalid DSL: {} Reason: {}", (Object)queryStr, (Object)validator.getErrorMsg());
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_DSL_QUERY, new String[]{queryStr, validator.getErrorMsg()});
                }
            }
            catch (IOException e) {
                throw new AtlasBaseException((Throwable)e);
            }
            return ret;
        }
    }
}

