/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.glossary;

import java.util.Objects;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.glossary.AtlasGlossary;
import org.apache.atlas.model.glossary.AtlasGlossaryCategory;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.glossary.relations.AtlasRelatedTermHeader;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.repository.ogm.DataAccess;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.type.AtlasTypeRegistry;

public abstract class GlossaryUtils {
    public static final String TERM_ASSIGNMENT_ATTR_DESCRIPTION = "description";
    public static final String TERM_ASSIGNMENT_ATTR_EXPRESSION = "expression";
    public static final String TERM_ASSIGNMENT_ATTR_STATUS = "status";
    public static final String TERM_ASSIGNMENT_ATTR_CONFIDENCE = "confidence";
    public static final String TERM_ASSIGNMENT_ATTR_CREATED_BY = "createdBy";
    public static final String TERM_ASSIGNMENT_ATTR_STEWARD = "steward";
    public static final String TERM_ASSIGNMENT_ATTR_SOURCE = "source";
    static final String ATLAS_GLOSSARY_TYPENAME = "AtlasGlossary";
    static final String ATLAS_GLOSSARY_TERM_TYPENAME = "AtlasGlossaryTerm";
    static final String ATLAS_GLOSSARY_CATEGORY_TYPENAME = "AtlasGlossaryCategory";
    protected static final String ATLAS_GLOSSARY_PREFIX = "AtlasGlossary";
    protected static final String TERM_ANCHOR = "AtlasGlossaryTermAnchor";
    protected static final String CATEGORY_ANCHOR = "AtlasGlossaryCategoryAnchor";
    protected static final String CATEGORY_HIERARCHY = "AtlasGlossaryCategoryHierarchyLink";
    protected static final String TERM_CATEGORIZATION = "AtlasGlossaryTermCategorization";
    protected static final String TERM_ASSIGNMENT = "AtlasGlossarySemanticAssignment";
    protected static final String TERM_RELATION_ATTR_EXPRESSION = "expression";
    protected static final String TERM_RELATION_ATTR_DESCRIPTION = "description";
    protected static final String TERM_RELATION_ATTR_STEWARD = "steward";
    protected static final String TERM_RELATION_ATTR_SOURCE = "source";
    protected static final String TERM_RELATION_ATTR_STATUS = "status";
    protected final AtlasRelationshipStore relationshipStore;
    protected final AtlasTypeRegistry typeRegistry;
    protected final DataAccess dataAccess;

    protected GlossaryUtils(AtlasRelationshipStore relationshipStore, AtlasTypeRegistry typeRegistry, DataAccess dataAccess) {
        this.relationshipStore = relationshipStore;
        this.typeRegistry = typeRegistry;
        this.dataAccess = dataAccess;
    }

    public static AtlasGlossary getGlossarySkeleton(String glossaryGuid) {
        AtlasGlossary glossary = new AtlasGlossary();
        glossary.setGuid(glossaryGuid);
        return glossary;
    }

    public static AtlasGlossaryTerm getAtlasGlossaryTermSkeleton(String termGuid) {
        AtlasGlossaryTerm glossaryTerm = new AtlasGlossaryTerm();
        glossaryTerm.setGuid(termGuid);
        return glossaryTerm;
    }

    public static AtlasGlossaryCategory getAtlasGlossaryCategorySkeleton(String categoryGuid) {
        AtlasGlossaryCategory glossaryCategory = new AtlasGlossaryCategory();
        glossaryCategory.setGuid(categoryGuid);
        return glossaryCategory;
    }

    protected void createRelationship(AtlasRelationship relationship) throws AtlasBaseException {
        this.relationshipStore.getOrCreate(relationship);
    }

    protected void updateRelationshipAttributes(AtlasRelationship relationship, AtlasRelatedTermHeader relatedTermHeader) {
        if (Objects.nonNull(relationship)) {
            relationship.setAttribute("expression", (Object)relatedTermHeader.getExpression());
            relationship.setAttribute("description", (Object)relatedTermHeader.getDescription());
            relationship.setAttribute("steward", (Object)relatedTermHeader.getSteward());
            relationship.setAttribute("source", (Object)relatedTermHeader.getSource());
            if (Objects.nonNull(relatedTermHeader.getStatus())) {
                relationship.setAttribute("status", (Object)relatedTermHeader.getStatus().name());
            }
        }
    }

    static enum RelationshipOperation {
        CREATE,
        UPDATE,
        DELETE;

    }
}

