/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.glossary;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.glossary.GlossaryUtils;
import org.apache.atlas.model.glossary.AtlasGlossary;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.glossary.relations.AtlasGlossaryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedTermHeader;
import org.apache.atlas.model.glossary.relations.AtlasTermCategorizationHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.repository.ogm.DataAccess;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryTermUtils
extends GlossaryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GlossaryTermUtils.class);
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();

    protected GlossaryTermUtils(AtlasRelationshipStore relationshipStore, AtlasTypeRegistry typeRegistry, DataAccess dataAccess) {
        super(relationshipStore, typeRegistry, dataAccess);
    }

    public void processTermRelations(AtlasGlossaryTerm storeObject, AtlasGlossaryTerm updatedTerm, GlossaryUtils.RelationshipOperation op) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryTermUtils.processTermRelations({}, {}, {})", new Object[]{storeObject, updatedTerm, op});
        }
        this.processTermAnchor(storeObject, updatedTerm, op);
        this.processRelatedTerms(storeObject, updatedTerm, op);
        this.processAssociatedCategories(storeObject, updatedTerm, op);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryTermUtils.processTermRelations()");
        }
    }

    public void processTermAssignments(AtlasGlossaryTerm glossaryTerm, Collection<AtlasRelatedObjectId> relatedObjectIds) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryTermUtils.processTermAssignments({}, {})", (Object)glossaryTerm, relatedObjectIds);
        }
        Objects.requireNonNull(glossaryTerm);
        Set assignedEntities = glossaryTerm.getAssignedEntities();
        for (AtlasRelatedObjectId objectId : relatedObjectIds) {
            if (CollectionUtils.isNotEmpty((Collection)assignedEntities) && assignedEntities.contains(objectId) && DEBUG_ENABLED) {
                LOG.debug("Skipping already assigned entity {}", (Object)objectId);
                continue;
            }
            if (DEBUG_ENABLED) {
                LOG.debug("Assigning term guid={}, to entity guid = {}", (Object)glossaryTerm.getGuid(), (Object)objectId.getGuid());
            }
            this.createRelationship(this.defineTermAssignment(glossaryTerm.getGuid(), objectId));
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryTermUtils.processTermAssignments()");
        }
    }

    public void processTermDissociation(AtlasGlossaryTerm glossaryTerm, Collection<AtlasRelatedObjectId> relatedObjectIds) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryTermUtils.processTermDissociation({}, {}, {})", new Object[]{glossaryTerm.getGuid(), relatedObjectIds, glossaryTerm});
        }
        Objects.requireNonNull(glossaryTerm);
        Set assignedEntities = glossaryTerm.getAssignedEntities();
        HashMap<String, AtlasRelatedObjectId> assignedEntityMap = new HashMap<String, AtlasRelatedObjectId>();
        if (CollectionUtils.isNotEmpty((Collection)assignedEntities)) {
            for (AtlasRelatedObjectId relatedObjectId : assignedEntities) {
                assignedEntityMap.put(relatedObjectId.getGuid(), relatedObjectId);
            }
        }
        if (CollectionUtils.isNotEmpty(relatedObjectIds)) {
            for (AtlasRelatedObjectId relatedObjectId : relatedObjectIds) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Removing term guid={}, from entity guid = {}", (Object)glossaryTerm.getGuid(), (Object)relatedObjectId.getGuid());
                }
                if (Objects.isNull(relatedObjectId.getRelationshipGuid())) {
                    throw new AtlasBaseException(AtlasErrorCode.TERM_DISSOCIATION_MISSING_RELATION_GUID, new String[0]);
                }
                AtlasRelatedObjectId existingTermRelation = (AtlasRelatedObjectId)assignedEntityMap.get(relatedObjectId.getGuid());
                if (CollectionUtils.isNotEmpty((Collection)assignedEntities) && this.isRelationshipGuidSame(existingTermRelation, relatedObjectId)) {
                    this.relationshipStore.deleteById(relatedObjectId.getRelationshipGuid(), true);
                    continue;
                }
                throw new AtlasBaseException(AtlasErrorCode.INVALID_TERM_DISSOCIATION, new String[]{relatedObjectId.getRelationshipGuid(), glossaryTerm.getGuid(), relatedObjectId.getGuid()});
            }
        }
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryTermUtils.processTermDissociation()");
        }
    }

    private boolean isRelationshipGuidSame(AtlasRelatedObjectId storeObject, AtlasRelatedObjectId relatedObjectId) {
        return StringUtils.equals((String)relatedObjectId.getRelationshipGuid(), (String)storeObject.getRelationshipGuid());
    }

    private void processTermAnchor(AtlasGlossaryTerm storeObject, AtlasGlossaryTerm updatedTerm, GlossaryUtils.RelationshipOperation op) throws AtlasBaseException {
        if (Objects.isNull(updatedTerm.getAnchor()) && op != GlossaryUtils.RelationshipOperation.DELETE) {
            throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ANCHOR, new String[0]);
        }
        AtlasGlossaryHeader existingAnchor = storeObject.getAnchor();
        AtlasGlossaryHeader updatedTermAnchor = updatedTerm.getAnchor();
        switch (op) {
            case CREATE: {
                if (Objects.isNull(updatedTermAnchor.getGlossaryGuid())) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_NEW_ANCHOR_GUID, new String[0]);
                }
                if (DEBUG_ENABLED) {
                    LOG.debug("Creating new term anchor, category = {}, glossary = {}", (Object)storeObject.getGuid(), (Object)updatedTerm.getAnchor().getGlossaryGuid());
                }
                this.createRelationship(this.defineTermAnchorRelation(updatedTermAnchor.getGlossaryGuid(), storeObject.getGuid()));
                break;
            }
            case UPDATE: {
                if (Objects.equals(updatedTermAnchor, existingAnchor)) break;
                if (Objects.isNull(updatedTermAnchor.getGlossaryGuid())) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_NEW_ANCHOR_GUID, new String[0]);
                }
                if (DEBUG_ENABLED) {
                    LOG.debug("Updating term anchor, currAnchor = {}, newAnchor = {} and term = {}", new Object[]{existingAnchor.getGlossaryGuid(), updatedTermAnchor.getGlossaryGuid(), storeObject.getName()});
                }
                this.relationshipStore.deleteById(existingAnchor.getRelationGuid(), true);
                String anchorGlossaryGuid = updatedTermAnchor.getGlossaryGuid();
                AtlasGlossary glossary = this.dataAccess.load(GlossaryTermUtils.getGlossarySkeleton(anchorGlossaryGuid));
                storeObject.setQualifiedName(storeObject.getName() + "@" + glossary.getQualifiedName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Derived qualifiedName = {}", (Object)storeObject.getQualifiedName());
                }
                this.createRelationship(this.defineTermAnchorRelation(updatedTermAnchor.getGlossaryGuid(), storeObject.getGuid()));
                break;
            }
            case DELETE: {
                if (!Objects.nonNull(existingAnchor)) break;
                if (DEBUG_ENABLED) {
                    LOG.debug("Deleting term anchor");
                }
                this.relationshipStore.deleteById(existingAnchor.getRelationGuid(), true);
            }
        }
    }

    private void processRelatedTerms(AtlasGlossaryTerm storeObject, AtlasGlossaryTerm updatedTerm, GlossaryUtils.RelationshipOperation op) throws AtlasBaseException {
        Map newRelatedTerms = updatedTerm.getRelatedTerms();
        Map existingRelatedTerms = storeObject.getRelatedTerms();
        switch (op) {
            case CREATE: {
                for (Map.Entry entry : newRelatedTerms.entrySet()) {
                    AtlasGlossaryTerm.Relation relation = (AtlasGlossaryTerm.Relation)entry.getKey();
                    Set terms = (Set)entry.getValue();
                    if (!Objects.nonNull(terms)) continue;
                    if (DEBUG_ENABLED) {
                        LOG.debug("{} relation {} for term = {}", new Object[]{op, relation, storeObject.getGuid()});
                        LOG.debug("Related Term count = {}", (Object)terms.size());
                    }
                    this.createTermRelationships(storeObject, relation, terms);
                }
                break;
            }
            case UPDATE: {
                for (AtlasGlossaryTerm.Relation relation : AtlasGlossaryTerm.Relation.values()) {
                    Map<String, AtlasRelatedTermHeader> existingTermHeaders = this.getRelatedTermHeaders(existingRelatedTerms, relation);
                    Map<String, AtlasRelatedTermHeader> newTermHeaders = this.getRelatedTermHeaders(newRelatedTerms, relation);
                    if (MapUtils.isEmpty(existingTermHeaders)) {
                        if (DEBUG_ENABLED) {
                            LOG.debug("Creating new term relations, relation = {}, terms = {}", (Object)relation, Objects.nonNull(newTermHeaders) ? Integer.valueOf(newTermHeaders.size()) : "none");
                        }
                        this.createTermRelationships(storeObject, relation, newTermHeaders.values());
                        continue;
                    }
                    if (MapUtils.isEmpty(newTermHeaders)) {
                        if (DEBUG_ENABLED) {
                            LOG.debug("Deleting existing term relations, relation = {}, terms = {}", (Object)relation, (Object)existingTermHeaders.size());
                        }
                        this.deleteTermRelationships(relation, existingTermHeaders.values());
                        continue;
                    }
                    Set<AtlasRelatedTermHeader> toCreate = newTermHeaders.values().stream().filter(t -> !existingTermHeaders.containsKey(t.getTermGuid())).collect(Collectors.toSet());
                    Set<AtlasRelatedTermHeader> toUpdate = newTermHeaders.values().stream().filter(t -> this.updatedExistingTermRelation(existingTermHeaders, (AtlasRelatedTermHeader)t)).collect(Collectors.toSet());
                    Set<AtlasRelatedTermHeader> toDelete = existingTermHeaders.values().stream().filter(t -> !newTermHeaders.containsKey(t.getTermGuid())).collect(Collectors.toSet());
                    this.createTermRelationships(storeObject, relation, toCreate);
                    this.updateTermRelationships(relation, toUpdate);
                    this.deleteTermRelationships(relation, toDelete);
                }
                break;
            }
            case DELETE: {
                for (AtlasGlossaryTerm.Relation relation : AtlasGlossaryTerm.Relation.values()) {
                    Set existingTermHeaders = (Set)existingRelatedTerms.get(relation);
                    this.deleteTermRelationships(relation, existingTermHeaders);
                }
                break;
            }
        }
    }

    private Map<String, AtlasRelatedTermHeader> getRelatedTermHeaders(Map<AtlasGlossaryTerm.Relation, Set<AtlasRelatedTermHeader>> relatedTerms, AtlasGlossaryTerm.Relation relation) {
        if (Objects.nonNull(relatedTerms.get(relation))) {
            HashMap<String, AtlasRelatedTermHeader> map = new HashMap<String, AtlasRelatedTermHeader>();
            for (AtlasRelatedTermHeader t : relatedTerms.get(relation)) {
                AtlasRelatedTermHeader header = (AtlasRelatedTermHeader)map.get(t.getTermGuid());
                if (header != null && (!StringUtils.isEmpty((String)header.getRelationGuid()) || !StringUtils.isNotEmpty((String)t.getRelationGuid()))) continue;
                map.put(t.getTermGuid(), t);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private boolean updatedExistingTermRelation(Map<String, AtlasRelatedTermHeader> existingTermHeaders, AtlasRelatedTermHeader header) {
        return Objects.nonNull(header.getRelationGuid()) && !header.equals((Object)existingTermHeaders.get(header.getTermGuid()));
    }

    private void processAssociatedCategories(AtlasGlossaryTerm storeObject, AtlasGlossaryTerm updatedTerm, GlossaryUtils.RelationshipOperation op) throws AtlasBaseException {
        Map<String, AtlasTermCategorizationHeader> newCategories = this.getAssociatedCategories(updatedTerm);
        Map<String, AtlasTermCategorizationHeader> existingCategories = this.getAssociatedCategories(storeObject);
        switch (op) {
            case CREATE: {
                if (!Objects.nonNull(newCategories)) break;
                if (DEBUG_ENABLED) {
                    LOG.debug("Creating new term categorization, term = {}, categories = {}", (Object)storeObject.getGuid(), (Object)newCategories.size());
                }
                this.createTermCategorizationRelationships(storeObject, newCategories.values());
                break;
            }
            case UPDATE: {
                if (MapUtils.isEmpty(existingCategories)) {
                    if (DEBUG_ENABLED) {
                        LOG.debug("Creating new term categorization, term = {}, categories = {}", (Object)storeObject.getGuid(), Objects.nonNull(newCategories) ? Integer.valueOf(newCategories.size()) : "none");
                    }
                    this.createTermCategorizationRelationships(storeObject, newCategories.values());
                    break;
                }
                if (MapUtils.isEmpty(newCategories)) {
                    if (DEBUG_ENABLED) {
                        LOG.debug("Deleting term categorization, term = {}, categories = {}", (Object)storeObject.getGuid(), (Object)existingCategories.size());
                    }
                    this.deleteCategorizationRelationship(existingCategories.values());
                    break;
                }
                Set<AtlasTermCategorizationHeader> toCreate = newCategories.values().stream().filter(c -> !existingCategories.containsKey(c.getCategoryGuid())).collect(Collectors.toSet());
                this.createTermCategorizationRelationships(storeObject, toCreate);
                Set<AtlasTermCategorizationHeader> toUpdate = newCategories.values().stream().filter(c -> this.updatedExistingCategorizationRelation(existingCategories, (AtlasTermCategorizationHeader)c)).collect(Collectors.toSet());
                this.updateTermCategorizationRelationships(storeObject, toUpdate);
                Set<AtlasTermCategorizationHeader> toDelete = existingCategories.values().stream().filter(c -> !newCategories.containsKey(c.getCategoryGuid())).collect(Collectors.toSet());
                this.deleteCategorizationRelationship(toDelete);
                break;
            }
            case DELETE: {
                this.deleteCategorizationRelationship(existingCategories.values());
            }
        }
    }

    private boolean updatedExistingCategorizationRelation(Map<String, AtlasTermCategorizationHeader> existingCategories, AtlasTermCategorizationHeader header) {
        return Objects.nonNull(header.getRelationGuid()) && !header.equals((Object)existingCategories.get(header.getCategoryGuid()));
    }

    private Map<String, AtlasTermCategorizationHeader> getAssociatedCategories(AtlasGlossaryTerm term) {
        if (Objects.nonNull(term.getCategories())) {
            HashMap<String, AtlasTermCategorizationHeader> map = new HashMap<String, AtlasTermCategorizationHeader>();
            for (AtlasTermCategorizationHeader c : term.getCategories()) {
                AtlasTermCategorizationHeader header = (AtlasTermCategorizationHeader)map.get(c.getCategoryGuid());
                if (header != null && (!StringUtils.isEmpty((String)header.getRelationGuid()) || !StringUtils.isNotEmpty((String)c.getRelationGuid()))) continue;
                map.put(c.getCategoryGuid(), c);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private void createTermCategorizationRelationships(AtlasGlossaryTerm storeObject, Collection<AtlasTermCategorizationHeader> categories) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(categories)) {
            Set existingCategories = storeObject.getCategories();
            for (AtlasTermCategorizationHeader categorizationHeader : categories) {
                if (Objects.nonNull(existingCategories) && existingCategories.contains(categorizationHeader)) {
                    if (!DEBUG_ENABLED) continue;
                    LOG.debug("Skipping existing category guid={}", (Object)categorizationHeader.getCategoryGuid());
                    continue;
                }
                if (DEBUG_ENABLED) {
                    LOG.debug("Creating relation between term = {} and category = {}", (Object)storeObject.getGuid(), (Object)categorizationHeader.getDisplayText());
                }
                this.createRelationship(this.defineCategorizedTerm(categorizationHeader, storeObject.getGuid()));
            }
        }
    }

    private void updateTermCategorizationRelationships(AtlasGlossaryTerm storeObject, Collection<AtlasTermCategorizationHeader> toUpdate) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(toUpdate)) {
            for (AtlasTermCategorizationHeader categorizationHeader : toUpdate) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Updating relation between term = {} and category = {}", (Object)storeObject.getGuid(), (Object)categorizationHeader.getDisplayText());
                }
                AtlasRelationship relationship = this.relationshipStore.getById(categorizationHeader.getRelationGuid());
                this.updateRelationshipAttributes(relationship, categorizationHeader);
                this.relationshipStore.update(relationship);
            }
        }
    }

    private void deleteCategorizationRelationship(Collection<AtlasTermCategorizationHeader> existingCategories) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(existingCategories)) {
            for (AtlasTermCategorizationHeader categorizationHeader : existingCategories) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Deleting relation guid = {}, text = {}", (Object)categorizationHeader.getRelationGuid(), (Object)categorizationHeader.getDisplayText());
                }
                this.relationshipStore.deleteById(categorizationHeader.getRelationGuid(), true);
            }
        }
    }

    private void createTermRelationships(AtlasGlossaryTerm storeObject, AtlasGlossaryTerm.Relation relation, Collection<AtlasRelatedTermHeader> terms) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(terms)) {
            Map existingRelations;
            if (Objects.nonNull(storeObject.getRelatedTerms()) && Objects.nonNull(storeObject.getRelatedTerms().get(relation))) {
                HashMap<String, AtlasRelatedTermHeader> map = new HashMap<String, AtlasRelatedTermHeader>();
                for (AtlasRelatedTermHeader t : (Set)storeObject.getRelatedTerms().get(relation)) {
                    AtlasRelatedTermHeader header = (AtlasRelatedTermHeader)map.get(t.getTermGuid());
                    if (header != null && (!StringUtils.isEmpty((String)header.getRelationGuid()) || !StringUtils.isNotEmpty((String)t.getRelationGuid()))) continue;
                    map.put(t.getTermGuid(), t);
                }
                existingRelations = map;
            } else {
                existingRelations = Collections.emptyMap();
            }
            for (AtlasRelatedTermHeader term : terms) {
                if (existingRelations.containsKey(term.getTermGuid())) {
                    if (!DEBUG_ENABLED) continue;
                    LOG.debug("Skipping existing term relation termGuid={}", (Object)term.getTermGuid());
                    continue;
                }
                if (storeObject.getGuid().equals(term.getTermGuid())) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_TERM_RELATION_TO_SELF, new String[0]);
                }
                if (DEBUG_ENABLED) {
                    LOG.debug("Creating new term relation = {}, terms = {}", (Object)relation, (Object)term.getDisplayText());
                }
                this.createRelationship(this.defineTermRelation(relation, storeObject.getGuid(), term));
            }
        }
    }

    private void updateTermRelationships(AtlasGlossaryTerm.Relation relation, Collection<AtlasRelatedTermHeader> terms) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(terms)) {
            for (AtlasRelatedTermHeader term : terms) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Updating term relation = {}, terms = {}", (Object)relation, (Object)term.getDisplayText());
                }
                AtlasRelationship relationship = this.relationshipStore.getById(term.getRelationGuid());
                this.updateRelationshipAttributes(relationship, term);
                this.relationshipStore.update(relationship);
            }
        }
    }

    private void deleteTermRelationships(AtlasGlossaryTerm.Relation relation, Collection<AtlasRelatedTermHeader> terms) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(terms)) {
            for (AtlasRelatedTermHeader termHeader : terms) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Deleting term relation = {}, terms = {}", (Object)relation, (Object)termHeader.getDisplayText());
                }
                this.relationshipStore.deleteById(termHeader.getRelationGuid(), true);
            }
        }
    }

    private AtlasRelationship defineTermAnchorRelation(String glossaryGuid, String termGuid) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName("AtlasGlossaryTermAnchor");
        AtlasStruct defaultAttrs = relationshipType.createDefaultValue();
        return new AtlasRelationship("AtlasGlossaryTermAnchor", new AtlasObjectId(glossaryGuid), new AtlasObjectId(termGuid), defaultAttrs.getAttributes());
    }

    private AtlasRelationship defineTermRelation(AtlasGlossaryTerm.Relation relation, String end1TermGuid, AtlasRelatedTermHeader end2RelatedTerm) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName(relation.getName());
        AtlasStruct defaultAttrs = relationshipType.createDefaultValue();
        AtlasRelationship relationship = relation.isEnd2Attr() ? new AtlasRelationship(relation.getName(), new AtlasObjectId(end2RelatedTerm.getTermGuid()), new AtlasObjectId(end1TermGuid), defaultAttrs.getAttributes()) : new AtlasRelationship(relation.getName(), new AtlasObjectId(end1TermGuid), new AtlasObjectId(end2RelatedTerm.getTermGuid()), defaultAttrs.getAttributes());
        this.updateRelationshipAttributes(relationship, end2RelatedTerm);
        return relationship;
    }

    private AtlasRelationship defineCategorizedTerm(AtlasTermCategorizationHeader relatedCategoryId, String termId) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName("AtlasGlossaryTermCategorization");
        AtlasStruct defaultAttrs = relationshipType.createDefaultValue();
        AtlasRelationship relationship = new AtlasRelationship("AtlasGlossaryTermCategorization", new AtlasObjectId(relatedCategoryId.getCategoryGuid()), new AtlasObjectId(termId), defaultAttrs.getAttributes());
        this.updateRelationshipAttributes(relationship, relatedCategoryId);
        return relationship;
    }

    private AtlasRelationship defineTermAssignment(String termGuid, AtlasRelatedObjectId relatedObjectId) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName("AtlasGlossarySemanticAssignment");
        AtlasStruct defaultAttrs = relationshipType.createDefaultValue();
        AtlasObjectId end1 = new AtlasObjectId(termGuid);
        AtlasRelationship relationship = new AtlasRelationship("AtlasGlossarySemanticAssignment", end1, (AtlasObjectId)relatedObjectId, defaultAttrs.getAttributes());
        this.updateRelationshipAttributes(relationship, relatedObjectId);
        return relationship;
    }

    private void updateRelationshipAttributes(AtlasRelationship relationship, AtlasTermCategorizationHeader categorizationHeader) {
        if (Objects.nonNull(relationship)) {
            relationship.setAttribute("description", (Object)categorizationHeader.getDescription());
            if (Objects.nonNull(categorizationHeader.getStatus())) {
                relationship.setAttribute("status", (Object)categorizationHeader.getStatus().name());
            }
        }
    }

    private void updateRelationshipAttributes(AtlasRelationship relationship, AtlasRelatedObjectId relatedObjectId) {
        AtlasStruct relationshipAttributes = relatedObjectId.getRelationshipAttributes();
        if (Objects.nonNull(relationshipAttributes)) {
            for (Map.Entry attrEntry : relationshipAttributes.getAttributes().entrySet()) {
                relationship.setAttribute((String)attrEntry.getKey(), attrEntry.getValue());
            }
        }
    }
}

