/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermSearchProcessor
extends SearchProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TermSearchProcessor.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"TermSearchProcessor");
    public static final String ATLAS_GLOSSARY_TERM_ENTITY_TYPE = "AtlasGlossaryTerm";
    public static final String ATLAS_GLOSSARY_TERM_ATTR_QNAME = "qualifiedName";
    public static final String ATLAS_GLOSSARY_TERM_ATTR_ASSIGNED_ENTITIES = "assignedEntities";
    final List<AtlasVertex> assignedEntities;

    public TermSearchProcessor(SearchContext context, List<AtlasVertex> assignedEntities) {
        super(context);
        this.assignedEntities = assignedEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AtlasVertex> execute() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TermSearchProcessor.execute({})", (Object)this.context);
        }
        ArrayList<AtlasVertex> ret = new ArrayList<AtlasVertex>();
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("TermSearchProcessor.execute(" + this.context + ")"));
        }
        try {
            if (CollectionUtils.isNotEmpty(this.assignedEntities)) {
                int startIdx = this.context.getSearchParameters().getOffset();
                int limit = this.context.getSearchParameters().getLimit();
                ArrayList<AtlasVertex> tmpList = new ArrayList<AtlasVertex>(this.assignedEntities);
                super.filter(tmpList);
                this.collectResultVertices(ret, startIdx, limit, 0, tmpList);
            }
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TermSearchProcessor.execute({}): ret.size()={}", (Object)this.context, (Object)ret.size());
        }
        return ret;
    }

    @Override
    public void filter(List<AtlasVertex> entityVertices) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> TermSearchProcessor.filter({})", (Object)entityVertices.size());
        }
        if (CollectionUtils.isNotEmpty(entityVertices)) {
            if (CollectionUtils.isEmpty(this.assignedEntities)) {
                entityVertices.clear();
            } else {
                CollectionUtils.filter(entityVertices, o -> {
                    if (o instanceof AtlasVertex) {
                        AtlasVertex entityVertex = (AtlasVertex)o;
                        for (AtlasVertex assignedEntity : this.assignedEntities) {
                            if (!assignedEntity.getId().equals(entityVertex.getId())) continue;
                            return true;
                        }
                    }
                    return false;
                });
            }
        }
        super.filter(entityVertices);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== TermSearchProcessor.filter(): ret.size()={}", (Object)entityVertices.size());
        }
    }
}

