/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasEnumType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.util.AtlasGremlinQueryProvider;
import org.apache.atlas.util.SearchPredicateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SearchProcessor.class);
    public static final Pattern STRAY_AND_PATTERN = Pattern.compile("(AND\\s+)+\\)");
    public static final Pattern STRAY_OR_PATTERN = Pattern.compile("(OR\\s+)+\\)");
    public static final Pattern STRAY_ELIPSIS_PATTERN = Pattern.compile("(\\(\\s*)\\)");
    public static final int MAX_RESULT_SIZE = SearchProcessor.getApplicationProperty("atlas.graph.index.search.max-result-set-size", 150);
    public static final int MAX_QUERY_STR_LENGTH_TYPES = SearchProcessor.getApplicationProperty("atlas.graph.index.search.types.max-query-str-length", 512);
    public static final int MAX_QUERY_STR_LENGTH_TAGS = SearchProcessor.getApplicationProperty("atlas.graph.index.search.tags.max-query-str-length", 512);
    public static final String INDEX_SEARCH_PREFIX = AtlasGraphUtilsV2.getIndexSearchPrefix();
    public static final String AND_STR = " AND ";
    public static final String EMPTY_STRING = "";
    public static final String SPACE_STRING = " ";
    public static final String BRACE_OPEN_STR = "(";
    public static final String BRACE_CLOSE_STR = ")";
    private static final Map<SearchParameters.Operator, String> OPERATOR_MAP = new HashMap<SearchParameters.Operator, String>();
    private static final Map<SearchParameters.Operator, SearchPredicateUtil.VertexAttributePredicateGenerator> OPERATOR_PREDICATE_MAP = new HashMap<SearchParameters.Operator, SearchPredicateUtil.VertexAttributePredicateGenerator>();
    protected final SearchContext context;
    protected SearchProcessor nextProcessor;
    protected Predicate inMemoryPredicate;

    protected SearchProcessor(SearchContext context) {
        this.context = context;
    }

    public void addProcessor(SearchProcessor processor) {
        if (this.nextProcessor == null) {
            this.nextProcessor = processor;
        } else {
            this.nextProcessor.addProcessor(processor);
        }
    }

    public abstract List<AtlasVertex> execute();

    protected int collectResultVertices(List<AtlasVertex> ret, int startIdx, int limit, int resultIdx, List<AtlasVertex> entityVertices) {
        for (AtlasVertex entityVertex : entityVertices) {
            if (++resultIdx <= startIdx) continue;
            ret.add(entityVertex);
            if (ret.size() != limit) continue;
            break;
        }
        return resultIdx;
    }

    public void filter(List<AtlasVertex> entityVertices) {
        if (this.nextProcessor != null && CollectionUtils.isNotEmpty(entityVertices)) {
            this.nextProcessor.filter(entityVertices);
        }
    }

    protected void processSearchAttributes(AtlasStructType structType, SearchParameters.FilterCriteria filterCriteria, Set<String> indexFiltered, Set<String> graphFiltered, Set<String> allAttributes) {
        block8: {
            block7: {
                if (structType == null || filterCriteria == null) {
                    return;
                }
                SearchParameters.FilterCriteria.Condition filterCondition = filterCriteria.getCondition();
                List criterion = filterCriteria.getCriterion();
                if (filterCondition == null || !CollectionUtils.isNotEmpty((Collection)criterion)) break block7;
                for (SearchParameters.FilterCriteria criteria : criterion) {
                    this.processSearchAttributes(structType, criteria, indexFiltered, graphFiltered, allAttributes);
                }
                break block8;
            }
            if (!StringUtils.isNotEmpty((String)filterCriteria.getAttributeName())) break block8;
            try {
                String attributeName = filterCriteria.getAttributeName();
                if (this.isIndexSearchable(filterCriteria, structType)) {
                    indexFiltered.add(attributeName);
                } else {
                    LOG.warn("not using index-search for attribute '{}'; might cause poor performance", (Object)structType.getQualifiedAttributeName(attributeName));
                    graphFiltered.add(attributeName);
                }
                if (structType instanceof AtlasEntityType) {
                    this.context.getEntityAttributes().add(attributeName);
                }
                allAttributes.add(attributeName);
            }
            catch (AtlasBaseException e) {
                LOG.warn(e.getMessage());
            }
        }
    }

    protected boolean canApplyIndexFilter(AtlasStructType structType, SearchParameters.FilterCriteria filterCriteria, boolean insideOrCondition) {
        if (filterCriteria == null) {
            return true;
        }
        boolean ret = true;
        SearchParameters.FilterCriteria.Condition filterCondition = filterCriteria.getCondition();
        List criterion = filterCriteria.getCriterion();
        Set<String> indexedKeys = this.context.getIndexedKeys();
        if (filterCondition != null && CollectionUtils.isNotEmpty((Collection)criterion)) {
            SearchParameters.FilterCriteria criteria;
            insideOrCondition = insideOrCondition || filterCondition == SearchParameters.FilterCriteria.Condition.OR;
            Iterator iterator = criterion.iterator();
            while (iterator.hasNext() && (ret = this.canApplyIndexFilter(structType, criteria = (SearchParameters.FilterCriteria)iterator.next(), insideOrCondition))) {
            }
        } else if (StringUtils.isNotEmpty((String)filterCriteria.getAttributeName())) {
            try {
                if (insideOrCondition && !this.isIndexSearchable(filterCriteria, structType)) {
                    ret = false;
                }
            }
            catch (AtlasBaseException e) {
                LOG.warn(e.getMessage());
            }
        }
        return ret;
    }

    protected void constructTypeTestQuery(StringBuilder indexQuery, String typeAndAllSubTypesQryStr) {
        if (StringUtils.isNotEmpty((String)typeAndAllSubTypesQryStr)) {
            if (indexQuery.length() > 0) {
                indexQuery.append(AND_STR);
            }
            indexQuery.append(INDEX_SEARCH_PREFIX + "\"").append("__typeName").append("\":").append(typeAndAllSubTypesQryStr);
        }
    }

    protected void constructFilterQuery(StringBuilder indexQuery, AtlasStructType type, SearchParameters.FilterCriteria filterCriteria, Set<String> indexAttributes) {
        if (filterCriteria != null) {
            String filterQuery;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing Filters");
            }
            if (StringUtils.isNotEmpty((String)(filterQuery = this.toIndexQuery(type, filterCriteria, indexAttributes, 0)))) {
                if (indexQuery.length() > 0) {
                    indexQuery.append(AND_STR);
                }
                indexQuery.append(filterQuery);
            }
        }
    }

    protected Predicate constructInMemoryPredicate(AtlasStructType type, SearchParameters.FilterCriteria filterCriteria, Set<String> indexAttributes) {
        Predicate ret = null;
        if (filterCriteria != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing Filters");
            }
            ret = this.toInMemoryPredicate(type, filterCriteria, indexAttributes);
        }
        return ret;
    }

    protected void constructGremlinFilterQuery(StringBuilder gremlinQuery, Map<String, Object> queryBindings, AtlasStructType structType, SearchParameters.FilterCriteria filterCriteria) {
        if (filterCriteria != null) {
            SearchParameters.FilterCriteria.Condition condition = filterCriteria.getCondition();
            if (condition != null) {
                StringBuilder orQuery = new StringBuilder();
                List criterion = filterCriteria.getCriterion();
                for (int i = 0; i < criterion.size(); ++i) {
                    SearchParameters.FilterCriteria criteria = (SearchParameters.FilterCriteria)criterion.get(i);
                    if (condition == SearchParameters.FilterCriteria.Condition.OR) {
                        StringBuilder nestedOrQuery = new StringBuilder("_()");
                        this.constructGremlinFilterQuery(nestedOrQuery, queryBindings, structType, criteria);
                        orQuery.append(i == 0 ? EMPTY_STRING : ",").append((CharSequence)nestedOrQuery);
                        continue;
                    }
                    this.constructGremlinFilterQuery(gremlinQuery, queryBindings, structType, criteria);
                }
                if (condition == SearchParameters.FilterCriteria.Condition.OR) {
                    gremlinQuery.append(".or(").append((CharSequence)orQuery).append(BRACE_CLOSE_STR);
                }
            } else {
                String attributeName = filterCriteria.getAttributeName();
                AtlasStructType.AtlasAttribute attribute = structType.getAttribute(attributeName);
                if (attribute != null) {
                    SearchParameters.Operator operator = filterCriteria.getOperator();
                    String attributeValue = filterCriteria.getAttributeValue();
                    gremlinQuery.append(this.toGremlinComparisonQuery(attribute, operator, attributeValue, queryBindings));
                } else {
                    LOG.warn("Ignoring unknown attribute {}.{}", (Object)structType.getTypeName(), (Object)attributeName);
                }
            }
        }
    }

    protected void constructStateTestQuery(StringBuilder indexQuery) {
        if (indexQuery.length() > 0) {
            indexQuery.append(AND_STR);
        }
        indexQuery.append(INDEX_SEARCH_PREFIX + "\"").append(Constants.STATE_PROPERTY_KEY).append("\":ACTIVE");
    }

    private boolean isIndexSearchable(SearchParameters.FilterCriteria filterCriteria, AtlasStructType structType) throws AtlasBaseException {
        AtlasType attributeType;
        boolean ret;
        String qualifiedName = structType.getQualifiedAttributeName(filterCriteria.getAttributeName());
        Set<String> indexedKeys = this.context.getIndexedKeys();
        boolean bl = ret = indexedKeys != null && indexedKeys.contains(qualifiedName);
        if (ret && "string".equals((attributeType = structType.getAttributeType(filterCriteria.getAttributeName())).getTypeName())) {
            if (filterCriteria.getOperator() == SearchParameters.Operator.NEQ) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("NEQ operator found for string attribute {}, deferring to in-memory or graph query (might cause poor performance)", (Object)qualifiedName);
                }
                ret = false;
            } else if (SearchProcessor.hasIndexQuerySpecialChar(filterCriteria.getAttributeValue())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("special characters found in filter value {}, deferring to in-memory or graph query (might cause poor performance)", (Object)filterCriteria.getAttributeValue());
                }
                ret = false;
            }
        }
        if (LOG.isDebugEnabled() && !ret) {
            LOG.debug("Not using index query for: attribute='{}', operator='{}', value='{}'", new Object[]{qualifiedName, filterCriteria.getOperator(), filterCriteria.getAttributeValue()});
        }
        return ret;
    }

    private String toIndexQuery(AtlasStructType type, SearchParameters.FilterCriteria criteria, Set<String> indexAttributes, int level) {
        return this.toIndexQuery(type, criteria, indexAttributes, new StringBuilder(), level);
    }

    private String toIndexQuery(AtlasStructType type, SearchParameters.FilterCriteria criteria, Set<String> indexAttributes, StringBuilder sb, int level) {
        SearchParameters.FilterCriteria.Condition condition = criteria.getCondition();
        if (condition != null && CollectionUtils.isNotEmpty((Collection)criteria.getCriterion())) {
            boolean needSurroundingBraces;
            StringBuilder nestedExpression = new StringBuilder();
            for (SearchParameters.FilterCriteria filterCriteria : criteria.getCriterion()) {
                String nestedQuery = this.toIndexQuery(type, filterCriteria, indexAttributes, level + 1);
                if (!StringUtils.isNotEmpty((String)nestedQuery)) continue;
                if (nestedExpression.length() > 0) {
                    nestedExpression.append(SPACE_STRING).append(condition).append(SPACE_STRING);
                }
                nestedExpression.append(nestedQuery);
            }
            boolean bl = needSurroundingBraces = level != 0 || condition == SearchParameters.FilterCriteria.Condition.OR && criteria.getCriterion().size() > 1;
            if (nestedExpression.length() > 0) {
                return sb.append(needSurroundingBraces ? BRACE_OPEN_STR : EMPTY_STRING).append((CharSequence)nestedExpression).append(needSurroundingBraces ? BRACE_CLOSE_STR : EMPTY_STRING).toString();
            }
            return EMPTY_STRING;
        }
        if (indexAttributes.contains(criteria.getAttributeName())) {
            return this.toIndexExpression(type, criteria.getAttributeName(), criteria.getOperator(), criteria.getAttributeValue());
        }
        return EMPTY_STRING;
    }

    private Predicate toInMemoryPredicate(AtlasStructType type, SearchParameters.FilterCriteria criteria, Set<String> indexAttributes) {
        if (criteria.getCondition() != null && CollectionUtils.isNotEmpty((Collection)criteria.getCriterion())) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (SearchParameters.FilterCriteria filterCriteria : criteria.getCriterion()) {
                Predicate predicate = this.toInMemoryPredicate(type, filterCriteria, indexAttributes);
                if (predicate == null) continue;
                predicates.add(predicate);
            }
            if (CollectionUtils.isNotEmpty(predicates)) {
                if (criteria.getCondition() == SearchParameters.FilterCriteria.Condition.AND) {
                    return PredicateUtils.allPredicate(predicates);
                }
                return PredicateUtils.anyPredicate(predicates);
            }
        } else if (indexAttributes.contains(criteria.getAttributeName())) {
            return this.toInMemoryPredicate(type, criteria.getAttributeName(), criteria.getOperator(), criteria.getAttributeValue());
        }
        return null;
    }

    private String toIndexExpression(AtlasStructType type, String attrName, SearchParameters.Operator op, String attrVal) {
        String ret = EMPTY_STRING;
        try {
            if (OPERATOR_MAP.get(op) != null) {
                String qualifiedName = type.getQualifiedAttributeName(attrName);
                String escapeIndexQueryValue = AtlasStructType.AtlasAttribute.escapeIndexQueryValue((String)attrVal);
                ret = String.format(OPERATOR_MAP.get(op), qualifiedName, escapeIndexQueryValue);
            }
        }
        catch (AtlasBaseException ex) {
            LOG.warn(ex.getMessage());
        }
        return ret;
    }

    private Predicate toInMemoryPredicate(AtlasStructType type, String attrName, SearchParameters.Operator op, String attrVal) {
        Predicate ret = null;
        AtlasStructType.AtlasAttribute attribute = type.getAttribute(attrName);
        SearchPredicateUtil.VertexAttributePredicateGenerator predicate = OPERATOR_PREDICATE_MAP.get(op);
        if (attribute != null && predicate != null) {
            Object attrValue;
            Class attrClass;
            AtlasType attrType = attribute.getAttributeType();
            switch (attrType.getTypeName()) {
                case "string": {
                    attrClass = String.class;
                    attrValue = attrVal;
                    break;
                }
                case "short": {
                    attrClass = Short.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Short.valueOf(Short.parseShort(attrVal));
                    break;
                }
                case "int": {
                    attrClass = Integer.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Integer.valueOf(Integer.parseInt(attrVal));
                    break;
                }
                case "biginteger": {
                    attrClass = BigInteger.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : new BigInteger(attrVal);
                    break;
                }
                case "boolean": {
                    attrClass = Boolean.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Boolean.valueOf(Boolean.parseBoolean(attrVal));
                    break;
                }
                case "byte": {
                    attrClass = Byte.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Byte.valueOf(Byte.parseByte(attrVal));
                    break;
                }
                case "long": 
                case "date": {
                    attrClass = Long.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Long.valueOf(Long.parseLong(attrVal));
                    break;
                }
                case "float": {
                    attrClass = Float.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Float.valueOf(Float.parseFloat(attrVal));
                    break;
                }
                case "double": {
                    attrClass = Double.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : Double.valueOf(Double.parseDouble(attrVal));
                    break;
                }
                case "bigdecimal": {
                    attrClass = BigDecimal.class;
                    attrValue = StringUtils.isEmpty((String)attrVal) ? null : new BigDecimal(attrVal);
                    break;
                }
                default: {
                    attrClass = attrType instanceof AtlasEnumType ? String.class : (attrType instanceof AtlasArrayType ? List.class : Object.class);
                    attrValue = attrVal;
                }
            }
            ret = predicate.generatePredicate(attribute.getQualifiedName(), attrValue, attrClass);
        }
        return ret;
    }

    protected AtlasGraphQuery toGraphFilterQuery(AtlasStructType type, SearchParameters.FilterCriteria criteria, Set<String> graphAttributes, AtlasGraphQuery query) {
        block18: {
            block19: {
                block20: {
                    if (criteria == null) break block18;
                    if (criteria.getCondition() == null) break block19;
                    if (criteria.getCondition() != SearchParameters.FilterCriteria.Condition.AND) break block20;
                    for (SearchParameters.FilterCriteria filterCriteria : criteria.getCriterion()) {
                        AtlasGraphQuery nestedQuery = this.toGraphFilterQuery(type, filterCriteria, graphAttributes, this.context.getGraph().query());
                        query.addConditionsFrom(nestedQuery);
                    }
                    break block18;
                }
                LinkedList<AtlasGraphQuery> orConditions = new LinkedList<AtlasGraphQuery>();
                for (SearchParameters.FilterCriteria filterCriteria : criteria.getCriterion()) {
                    AtlasGraphQuery nestedQuery = this.toGraphFilterQuery(type, filterCriteria, graphAttributes, this.context.getGraph().query());
                    orConditions.add(this.context.getGraph().query().createChildQuery().addConditionsFrom(nestedQuery));
                }
                if (orConditions.isEmpty()) break block18;
                query.or(orConditions);
                break block18;
            }
            if (!graphAttributes.contains(criteria.getAttributeName())) break block18;
            String attrName = criteria.getAttributeName();
            String attrValue = criteria.getAttributeValue();
            SearchParameters.Operator operator = criteria.getOperator();
            try {
                String qualifiedName = type.getQualifiedAttributeName(attrName);
                switch (operator) {
                    case LT: {
                        query.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.LESS_THAN, (Object)attrValue);
                        break;
                    }
                    case LTE: {
                        query.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.LESS_THAN_EQUAL, (Object)attrValue);
                        break;
                    }
                    case GT: {
                        query.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.GREATER_THAN, (Object)attrValue);
                        break;
                    }
                    case GTE: {
                        query.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.GREATER_THAN_EQUAL, (Object)attrValue);
                        break;
                    }
                    case EQ: {
                        query.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, (Object)attrValue);
                        break;
                    }
                    case NEQ: {
                        query.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.NOT_EQUAL, (Object)attrValue);
                        break;
                    }
                    case LIKE: {
                        query.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.MatchingOperator.REGEX, (Object)attrValue);
                        break;
                    }
                    case CONTAINS: {
                        query.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.MatchingOperator.REGEX, (Object)SearchProcessor.getContainsRegex(attrValue));
                        break;
                    }
                    case STARTS_WITH: {
                        query.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.MatchingOperator.PREFIX, (Object)attrValue);
                        break;
                    }
                    case ENDS_WITH: {
                        query.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.MatchingOperator.REGEX, (Object)SearchProcessor.getSuffixRegex(attrValue));
                        break;
                    }
                    case IS_NULL: {
                        query.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, null);
                        break;
                    }
                    case NOT_NULL: {
                        query.has(qualifiedName, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.NOT_EQUAL, null);
                        break;
                    }
                    default: {
                        LOG.warn("{}: unsupported operator. Ignored", (Object)operator);
                        break;
                    }
                }
            }
            catch (AtlasBaseException e) {
                LOG.error("toGraphFilterQuery(): failed for attrName=" + attrName + "; operator=" + operator + "; attrValue=" + attrValue, (Throwable)e);
            }
        }
        return query;
    }

    private String toGremlinComparisonQuery(AtlasStructType.AtlasAttribute attribute, SearchParameters.Operator operator, String attrValue, Map<String, Object> queryBindings) {
        String bindName = "__bind_" + queryBindings.size();
        Object bindValue = attribute.getAttributeType().getNormalizedValue((Object)attrValue);
        AtlasGremlinQueryProvider queryProvider = AtlasGremlinQueryProvider.INSTANCE;
        String queryTemplate = null;
        switch (operator) {
            case LT: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_LT);
                break;
            }
            case GT: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_GT);
                break;
            }
            case LTE: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_LTE);
                break;
            }
            case GTE: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_GTE);
                break;
            }
            case EQ: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_EQ);
                break;
            }
            case NEQ: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_NEQ);
                break;
            }
            case LIKE: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_MATCHES);
                break;
            }
            case STARTS_WITH: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_STARTS_WITH);
                break;
            }
            case ENDS_WITH: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_ENDS_WITH);
                break;
            }
            case CONTAINS: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_CONTAINS);
                break;
            }
            case IS_NULL: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_IS_NULL);
                break;
            }
            case NOT_NULL: {
                queryTemplate = queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.COMPARE_NOT_NULL);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(queryTemplate)) {
            if (bindValue instanceof Date) {
                bindValue = ((Date)bindValue).getTime();
            }
            queryBindings.put(bindName, bindValue);
            return String.format(queryTemplate, attribute.getQualifiedName(), bindName);
        }
        return EMPTY_STRING;
    }

    private static String getContainsRegex(String attributeValue) {
        return ".*" + SearchProcessor.escapeRegExChars(attributeValue) + ".*";
    }

    private static String getSuffixRegex(String attributeValue) {
        return ".*" + SearchProcessor.escapeRegExChars(attributeValue);
    }

    private static String escapeRegExChars(String val) {
        StringBuilder escapedVal = new StringBuilder();
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (SearchProcessor.isRegExSpecialChar(c)) {
                escapedVal.append('\\');
            }
            escapedVal.append(c);
        }
        return escapedVal.toString();
    }

    private static boolean isRegExSpecialChar(char c) {
        switch (c) {
            case '$': 
            case '(': 
            case '*': 
            case '+': 
            case '/': 
            case '?': 
            case '[': 
            case '^': 
            case '{': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    private static boolean hasIndexQuerySpecialChar(String attributeValue) {
        if (attributeValue == null) {
            return false;
        }
        for (int i = 0; i < attributeValue.length(); ++i) {
            if (!SearchProcessor.isIndexQuerySpecialChar(attributeValue.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isIndexQuerySpecialChar(char c) {
        switch (c) {
            case '!': 
            case '\"': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case ':': 
            case '=': 
            case '?': 
            case '@': 
            case '[': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    protected List<AtlasVertex> getVerticesFromIndexQueryResult(Iterator<AtlasIndexQuery.Result> idxQueryResult, List<AtlasVertex> vertices) {
        if (idxQueryResult != null) {
            while (idxQueryResult.hasNext()) {
                AtlasVertex vertex = idxQueryResult.next().getVertex();
                vertices.add(vertex);
            }
        }
        return vertices;
    }

    protected List<AtlasVertex> getVertices(Iterator<AtlasVertex> iterator, List<AtlasVertex> vertices) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                AtlasVertex vertex = iterator.next();
                vertices.add(vertex);
            }
        }
        return vertices;
    }

    protected Set<String> getGuids(List<AtlasVertex> vertices) {
        HashSet<String> ret = new HashSet<String>();
        if (vertices != null) {
            for (AtlasVertex vertex : vertices) {
                String guid = AtlasGraphUtilsV2.getIdFromVertex(vertex);
                if (!StringUtils.isNotEmpty((String)guid)) continue;
                ret.add(guid);
            }
        }
        return ret;
    }

    private static int getApplicationProperty(String propertyName, int defaultValue) {
        try {
            return ApplicationProperties.get().getInt(propertyName, defaultValue);
        }
        catch (AtlasException atlasException) {
            return defaultValue;
        }
    }

    static {
        OPERATOR_MAP.put(SearchParameters.Operator.LT, INDEX_SEARCH_PREFIX + "\"%s\": [* TO %s}");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.LT, SearchPredicateUtil.getLTPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.GT, INDEX_SEARCH_PREFIX + "\"%s\": {%s TO *]");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.GT, SearchPredicateUtil.getGTPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.LTE, INDEX_SEARCH_PREFIX + "\"%s\": [* TO %s]");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.LTE, SearchPredicateUtil.getLTEPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.GTE, INDEX_SEARCH_PREFIX + "\"%s\": [%s TO *]");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.GTE, SearchPredicateUtil.getGTEPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.EQ, INDEX_SEARCH_PREFIX + "\"%s\": %s");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.EQ, SearchPredicateUtil.getEQPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.NEQ, "(*:* -" + INDEX_SEARCH_PREFIX + "\"%s\": %s)");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.NEQ, SearchPredicateUtil.getNEQPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.IN, INDEX_SEARCH_PREFIX + "\"%s\": (%s)");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.IN, SearchPredicateUtil.getINPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.LIKE, INDEX_SEARCH_PREFIX + "\"%s\": (%s)");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.LIKE, SearchPredicateUtil.getLIKEPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.STARTS_WITH, INDEX_SEARCH_PREFIX + "\"%s\": (%s*)");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.STARTS_WITH, SearchPredicateUtil.getStartsWithPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.ENDS_WITH, INDEX_SEARCH_PREFIX + "\"%s\": (*%s)");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.ENDS_WITH, SearchPredicateUtil.getEndsWithPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.CONTAINS, INDEX_SEARCH_PREFIX + "\"%s\": (*%s*)");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.CONTAINS, SearchPredicateUtil.getContainsPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.IS_NULL, "(*:* NOT " + INDEX_SEARCH_PREFIX + "\"%s\":[* TO *])");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.IS_NULL, SearchPredicateUtil.getIsNullPredicateGenerator());
        OPERATOR_MAP.put(SearchParameters.Operator.NOT_NULL, INDEX_SEARCH_PREFIX + "\"%s\":[* TO *]");
        OPERATOR_PREDICATE_MAP.put(SearchParameters.Operator.NOT_NULL, SearchPredicateUtil.getNotNullPredicateGenerator());
    }
}

