/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.discovery.ClassificationSearchProcessor;
import org.apache.atlas.discovery.EntitySearchProcessor;
import org.apache.atlas.discovery.FullTextSearchProcessor;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.discovery.TermSearchProcessor;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SearchContext {
    private final SearchParameters searchParameters;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasGraph graph;
    private final Set<String> indexedKeys;
    private final Set<String> entityAttributes;
    private final AtlasEntityType entityType;
    private final AtlasClassificationType classificationType;
    private SearchProcessor searchProcessor;
    private boolean terminateSearch = false;
    public static final AtlasClassificationType MATCH_ALL_WILDCARD_CLASSIFICATION = new AtlasClassificationType(new AtlasClassificationDef("*"));
    public static final AtlasClassificationType MATCH_ALL_CLASSIFIED = new AtlasClassificationType(new AtlasClassificationDef("_CLASSIFIED"));
    public static final AtlasClassificationType MATCH_ALL_NOT_CLASSIFIED = new AtlasClassificationType(new AtlasClassificationDef("_NOT_CLASSIFIED"));

    public SearchContext(SearchParameters searchParameters, AtlasTypeRegistry typeRegistry, AtlasGraph graph, Set<String> indexedKeys) throws AtlasBaseException {
        String classificationName = searchParameters.getClassification();
        this.searchParameters = searchParameters;
        this.typeRegistry = typeRegistry;
        this.graph = graph;
        this.indexedKeys = indexedKeys;
        this.entityAttributes = new HashSet<String>();
        this.entityType = typeRegistry.getEntityTypeByName(searchParameters.getTypeName());
        this.classificationType = this.getClassificationType(classificationName);
        if (StringUtils.isNotEmpty((CharSequence)searchParameters.getTypeName()) && this.entityType == null) {
            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPENAME, new String[]{searchParameters.getTypeName()});
        }
        if (StringUtils.isNotEmpty((CharSequence)classificationName) && this.classificationType == null) {
            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_CLASSIFICATION, new String[]{classificationName});
        }
        AtlasVertex glossaryTermVertex = this.getGlossaryTermVertex(searchParameters.getTermName());
        if (StringUtils.isNotEmpty((CharSequence)searchParameters.getTermName()) && glossaryTermVertex == null) {
            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_GLOSSARY_TERM, new String[]{searchParameters.getTermName()});
        }
        this.validateAttributes((AtlasStructType)this.entityType, searchParameters.getEntityFilters());
        this.validateAttributes((AtlasStructType)this.classificationType, searchParameters.getTagFilters());
        if (glossaryTermVertex != null) {
            this.addProcessor(new TermSearchProcessor(this, this.getAssignedEntities(glossaryTermVertex)));
        }
        if (this.needFullTextProcessor()) {
            this.addProcessor(new FullTextSearchProcessor(this));
        }
        if (this.needClassificationProcessor()) {
            this.addProcessor(new ClassificationSearchProcessor(this));
        }
        if (this.needEntityProcessor()) {
            this.addProcessor(new EntitySearchProcessor(this));
        }
    }

    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    public AtlasTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public AtlasGraph getGraph() {
        return this.graph;
    }

    public Set<String> getIndexedKeys() {
        return this.indexedKeys;
    }

    public Set<String> getEntityAttributes() {
        return this.entityAttributes;
    }

    public AtlasEntityType getEntityType() {
        return this.entityType;
    }

    public AtlasClassificationType getClassificationType() {
        return this.classificationType;
    }

    public SearchProcessor getSearchProcessor() {
        return this.searchProcessor;
    }

    public boolean terminateSearch() {
        return this.terminateSearch;
    }

    public void terminateSearch(boolean terminateSearch) {
        this.terminateSearch = terminateSearch;
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("searchParameters=");
        if (this.searchParameters != null) {
            this.searchParameters.toString(sb);
        }
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    boolean needFullTextProcessor() {
        return StringUtils.isNotEmpty((CharSequence)this.searchParameters.getQuery());
    }

    boolean needClassificationProcessor() {
        return this.classificationType != null && (this.entityType == null || this.hasAttributeFilter(this.searchParameters.getTagFilters()));
    }

    boolean needEntityProcessor() {
        return this.entityType != null;
    }

    private void validateAttributes(AtlasStructType structType, SearchParameters.FilterCriteria filterCriteria) throws AtlasBaseException {
        if (filterCriteria != null) {
            SearchParameters.FilterCriteria.Condition condition = filterCriteria.getCondition();
            if (condition != null && CollectionUtils.isNotEmpty((Collection)filterCriteria.getCriterion())) {
                for (SearchParameters.FilterCriteria criteria : filterCriteria.getCriterion()) {
                    this.validateAttributes(structType, criteria);
                }
            } else {
                String attributeName = filterCriteria.getAttributeName();
                if (StringUtils.isNotEmpty((CharSequence)attributeName) && structType.getAttributeType(attributeName) == null) {
                    throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_ATTRIBUTE, new String[]{attributeName, structType.getTypeName()});
                }
            }
        }
    }

    private boolean hasAttributeFilter(SearchParameters.FilterCriteria filterCriteria) {
        return filterCriteria != null && (CollectionUtils.isNotEmpty((Collection)filterCriteria.getCriterion()) || StringUtils.isNotEmpty((CharSequence)filterCriteria.getAttributeName()));
    }

    private void addProcessor(SearchProcessor processor) {
        if (this.searchProcessor == null) {
            this.searchProcessor = processor;
        } else {
            this.searchProcessor.addProcessor(processor);
        }
    }

    private AtlasClassificationType getClassificationType(String classificationName) {
        AtlasClassificationType ret = StringUtils.equals((CharSequence)classificationName, (CharSequence)MATCH_ALL_WILDCARD_CLASSIFICATION.getTypeName()) ? MATCH_ALL_WILDCARD_CLASSIFICATION : (StringUtils.equals((CharSequence)classificationName, (CharSequence)MATCH_ALL_CLASSIFIED.getTypeName()) ? MATCH_ALL_CLASSIFIED : (StringUtils.equals((CharSequence)classificationName, (CharSequence)MATCH_ALL_NOT_CLASSIFIED.getTypeName()) ? MATCH_ALL_NOT_CLASSIFIED : this.typeRegistry.getClassificationTypeByName(classificationName)));
        return ret;
    }

    private AtlasVertex getGlossaryTermVertex(String termName) {
        AtlasVertex ret = null;
        if (StringUtils.isNotEmpty((CharSequence)termName)) {
            AtlasEntityType termType = this.getTermEntityType();
            AtlasStructType.AtlasAttribute attrName = termType.getAttribute("qualifiedName");
            AtlasGraphQuery query = this.graph.query().has(Constants.ENTITY_TYPE_PROPERTY_KEY, (Object)termType.getTypeName()).has(attrName.getVertexPropertyName(), (Object)termName).has(Constants.STATE_PROPERTY_KEY, (Object)AtlasEntity.Status.ACTIVE.name());
            Iterator results = query.vertices().iterator();
            ret = results.hasNext() ? (AtlasVertex)results.next() : null;
        }
        return ret;
    }

    private List<AtlasVertex> getAssignedEntities(AtlasVertex glossaryTerm) {
        ArrayList<AtlasVertex> ret = new ArrayList<AtlasVertex>();
        AtlasEntityType termType = this.getTermEntityType();
        AtlasStructType.AtlasAttribute attr = termType.getRelationshipAttribute("assignedEntities", "AtlasGlossarySemanticAssignment");
        Iterator<AtlasEdge> edges = GraphHelper.getEdgesForLabel(glossaryTerm, attr.getRelationshipEdgeLabel(), attr.getRelationshipEdgeDirection());
        boolean excludeDeletedEntities = this.searchParameters.getExcludeDeletedEntities();
        if (edges != null) {
            while (edges.hasNext()) {
                AtlasEdge edge = edges.next();
                AtlasVertex inVertex = edge.getInVertex();
                if (excludeDeletedEntities && AtlasGraphUtilsV2.getState((AtlasElement)inVertex) == AtlasEntity.Status.DELETED) continue;
                ret.add(inVertex);
            }
        }
        return ret;
    }

    private AtlasEntityType getTermEntityType() {
        return this.typeRegistry.getEntityTypeByName("AtlasGlossaryTerm");
    }
}

