/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.util.SearchPredicateUtil;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySearchProcessor
extends SearchProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(EntitySearchProcessor.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"EntitySearchProcessor");
    private final AtlasIndexQuery indexQuery;
    private final AtlasGraphQuery graphQuery;
    private Predicate graphQueryPredicate;
    private Predicate filterGraphQueryPredicate;

    public EntitySearchProcessor(SearchContext context) {
        super(context);
        Set<String> classificationTypeAndSubTypes;
        boolean filterClassification;
        String typeAndSubTypesQryStr;
        Set<String> typeAndSubTypes;
        AtlasEntityType entityType = context.getEntityType();
        SearchParameters.FilterCriteria filterCriteria = context.getSearchParameters().getEntityFilters();
        HashSet<String> indexAttributes = new HashSet<String>();
        HashSet<String> graphAttributes = new HashSet<String>();
        HashSet<String> allAttributes = new HashSet<String>();
        if (context.getSearchParameters().getIncludeSubTypes()) {
            typeAndSubTypes = entityType.getTypeAndAllSubTypes();
            typeAndSubTypesQryStr = entityType.getTypeAndAllSubTypesQryStr();
        } else {
            typeAndSubTypes = Collections.singleton(entityType.getTypeName());
            typeAndSubTypesQryStr = entityType.getTypeQryStr();
        }
        AtlasClassificationType classificationType = context.getClassificationType();
        if (classificationType != null) {
            boolean bl = filterClassification = !context.needClassificationProcessor();
            classificationTypeAndSubTypes = context.getSearchParameters().getIncludeSubClassifications() ? classificationType.getTypeAndAllSubTypes() : Collections.singleton(classificationType.getTypeName());
        } else {
            filterClassification = false;
            classificationTypeAndSubTypes = Collections.emptySet();
        }
        Predicate typeNamePredicate = SearchPredicateUtil.getINPredicateGenerator().generatePredicate("__typeName", typeAndSubTypes, String.class);
        Predicate activePredicate = SearchPredicateUtil.getEQPredicateGenerator().generatePredicate(Constants.STATE_PROPERTY_KEY, "ACTIVE", String.class);
        Predicate traitPredicate = classificationType == SearchContext.MATCH_ALL_WILDCARD_CLASSIFICATION || classificationType == SearchContext.MATCH_ALL_CLASSIFIED ? PredicateUtils.orPredicate((Predicate)SearchPredicateUtil.getNotEmptyPredicateGenerator().generatePredicate(Constants.TRAIT_NAMES_PROPERTY_KEY, null, List.class), (Predicate)SearchPredicateUtil.getNotEmptyPredicateGenerator().generatePredicate(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, null, List.class)) : (classificationType == SearchContext.MATCH_ALL_NOT_CLASSIFIED ? PredicateUtils.andPredicate((Predicate)SearchPredicateUtil.getIsNullPredicateGenerator().generatePredicate(Constants.TRAIT_NAMES_PROPERTY_KEY, null, List.class), (Predicate)SearchPredicateUtil.getIsNullPredicateGenerator().generatePredicate(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, null, List.class)) : PredicateUtils.orPredicate((Predicate)SearchPredicateUtil.getContainsAnyPredicateGenerator().generatePredicate(Constants.TRAIT_NAMES_PROPERTY_KEY, classificationTypeAndSubTypes, List.class), (Predicate)SearchPredicateUtil.getContainsAnyPredicateGenerator().generatePredicate(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, classificationTypeAndSubTypes, List.class)));
        this.processSearchAttributes((AtlasStructType)entityType, filterCriteria, indexAttributes, graphAttributes, allAttributes);
        boolean typeSearchByIndex = !filterClassification && typeAndSubTypesQryStr.length() <= MAX_QUERY_STR_LENGTH_TYPES;
        boolean attrSearchByIndex = !filterClassification && CollectionUtils.isNotEmpty(indexAttributes) && this.canApplyIndexFilter((AtlasStructType)entityType, filterCriteria, false);
        StringBuilder indexQuery = new StringBuilder();
        if (typeSearchByIndex) {
            this.constructTypeTestQuery(indexQuery, typeAndSubTypesQryStr);
            this.inMemoryPredicate = typeNamePredicate;
        }
        if (attrSearchByIndex) {
            this.constructFilterQuery(indexQuery, (AtlasStructType)entityType, filterCriteria, indexAttributes);
            Predicate attributePredicate = this.constructInMemoryPredicate((AtlasStructType)entityType, filterCriteria, indexAttributes);
            this.inMemoryPredicate = this.inMemoryPredicate != null ? PredicateUtils.andPredicate((Predicate)this.inMemoryPredicate, (Predicate)attributePredicate) : attributePredicate;
        } else {
            graphAttributes.addAll(indexAttributes);
        }
        if (indexQuery.length() > 0) {
            if (context.getSearchParameters().getExcludeDeletedEntities()) {
                this.constructStateTestQuery(indexQuery);
            }
            String indexQueryString = STRAY_AND_PATTERN.matcher(indexQuery).replaceAll(")");
            indexQueryString = STRAY_OR_PATTERN.matcher(indexQueryString).replaceAll(")");
            indexQueryString = STRAY_ELIPSIS_PATTERN.matcher(indexQueryString).replaceAll("");
            this.indexQuery = context.getGraph().indexQuery("vertex_index", indexQueryString);
        } else {
            this.indexQuery = null;
        }
        if (CollectionUtils.isNotEmpty(graphAttributes) || !typeSearchByIndex) {
            AtlasGraphQuery query = context.getGraph().query();
            if (!typeSearchByIndex) {
                query.in("__typeName", typeAndSubTypes);
            }
            if (filterClassification) {
                LinkedList<AtlasGraphQuery> orConditions = new LinkedList<AtlasGraphQuery>();
                if (classificationType == SearchContext.MATCH_ALL_WILDCARD_CLASSIFICATION || classificationType == SearchContext.MATCH_ALL_CLASSIFIED) {
                    orConditions.add(query.createChildQuery().has(Constants.TRAIT_NAMES_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.NOT_EQUAL, null));
                    orConditions.add(query.createChildQuery().has(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.NOT_EQUAL, null));
                } else if (classificationType == SearchContext.MATCH_ALL_NOT_CLASSIFIED) {
                    orConditions.add(query.createChildQuery().has(Constants.TRAIT_NAMES_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, null).has(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, null));
                } else {
                    orConditions.add(query.createChildQuery().in(Constants.TRAIT_NAMES_PROPERTY_KEY, classificationTypeAndSubTypes));
                    orConditions.add(query.createChildQuery().in(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, classificationTypeAndSubTypes));
                }
                query.or(orConditions);
                this.graphQueryPredicate = this.graphQueryPredicate != null ? PredicateUtils.andPredicate((Predicate)this.graphQueryPredicate, (Predicate)traitPredicate) : traitPredicate;
            }
            this.graphQuery = this.toGraphFilterQuery((AtlasStructType)entityType, filterCriteria, graphAttributes, query);
            Predicate attributePredicate = this.constructInMemoryPredicate((AtlasStructType)entityType, filterCriteria, graphAttributes);
            if (attributePredicate != null) {
                this.graphQueryPredicate = this.graphQueryPredicate != null ? PredicateUtils.andPredicate((Predicate)this.graphQueryPredicate, (Predicate)attributePredicate) : attributePredicate;
            }
            if (context.getSearchParameters().getExcludeDeletedEntities() && this.indexQuery == null) {
                this.graphQuery.has(Constants.STATE_PROPERTY_KEY, (Object)"ACTIVE");
                this.graphQueryPredicate = this.graphQueryPredicate != null ? PredicateUtils.andPredicate((Predicate)this.graphQueryPredicate, (Predicate)activePredicate) : activePredicate;
            }
        } else {
            this.graphQuery = null;
            this.graphQueryPredicate = null;
        }
        this.filterGraphQueryPredicate = typeNamePredicate;
        Predicate attributesPredicate = this.constructInMemoryPredicate((AtlasStructType)entityType, filterCriteria, allAttributes);
        if (attributesPredicate != null) {
            this.filterGraphQueryPredicate = PredicateUtils.andPredicate((Predicate)this.filterGraphQueryPredicate, (Predicate)attributesPredicate);
        }
        if (filterClassification) {
            this.filterGraphQueryPredicate = PredicateUtils.andPredicate((Predicate)this.filterGraphQueryPredicate, (Predicate)traitPredicate);
        }
        if (context.getSearchParameters().getExcludeDeletedEntities()) {
            this.filterGraphQueryPredicate = PredicateUtils.andPredicate((Predicate)this.filterGraphQueryPredicate, (Predicate)activePredicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<AtlasVertex> execute() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntitySearchProcessor.execute({})", (Object)this.context);
        }
        ArrayList<AtlasVertex> ret = new ArrayList<AtlasVertex>();
        AtlasPerfTracer perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("EntitySearchProcessor.execute(" + this.context + ")"));
        }
        try {
            int qryOffset;
            int startIdx = this.context.getSearchParameters().getOffset();
            int limit = this.context.getSearchParameters().getLimit();
            int resultIdx = qryOffset = this.nextProcessor != null || this.graphQuery != null && this.indexQuery != null ? 0 : startIdx;
            ArrayList<AtlasVertex> entityVertices = new ArrayList<AtlasVertex>();
            while (ret.size() < limit) {
                boolean isLastResultPage;
                entityVertices.clear();
                if (this.context.terminateSearch()) {
                    LOG.warn("query terminated: {}", (Object)this.context.getSearchParameters());
                    break;
                }
                if (this.indexQuery != null) {
                    Iterator idxQueryResult = this.indexQuery.vertices(qryOffset, limit);
                    this.getVerticesFromIndexQueryResult(idxQueryResult, entityVertices);
                    isLastResultPage = entityVertices.size() < limit;
                    CollectionUtils.filter(entityVertices, (Predicate)this.inMemoryPredicate);
                    if (this.graphQueryPredicate != null) {
                        CollectionUtils.filter(entityVertices, (Predicate)this.graphQueryPredicate);
                    }
                } else {
                    Iterator<AtlasVertex> queryResult = this.graphQuery.vertices(qryOffset, limit).iterator();
                    this.getVertices(queryResult, entityVertices);
                    isLastResultPage = entityVertices.size() < limit;
                }
                super.filter(entityVertices);
                resultIdx = this.collectResultVertices(ret, startIdx, limit, resultIdx, entityVertices);
                if (!isLastResultPage) {
                    qryOffset += limit;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            AtlasPerfTracer.log(perf);
            throw throwable;
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntitySearchProcessor.execute({}): ret.size()={}", (Object)this.context, (Object)ret.size());
        }
        return ret;
    }

    @Override
    public void filter(List<AtlasVertex> entityVertices) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> EntitySearchProcessor.filter({})", (Object)entityVertices.size());
        }
        if (this.filterGraphQueryPredicate != null) {
            LOG.debug("Filtering in-memory");
            CollectionUtils.filter(entityVertices, (Predicate)this.filterGraphQueryPredicate);
        }
        super.filter(entityVertices);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== EntitySearchProcessor.filter(): ret.size()={}", (Object)entityVertices.size());
        }
    }
}

