/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.discovery.AtlasLineageService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.lineage.AtlasLineageInfo;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.atlas.util.AtlasGremlinQueryProvider;
import org.apache.atlas.v1.model.lineage.SchemaResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EntityLineageService
implements AtlasLineageService {
    private static final Logger LOG = LoggerFactory.getLogger(EntityLineageService.class);
    private static final String PROCESS_INPUTS_EDGE = "__Process.inputs";
    private static final String PROCESS_OUTPUTS_EDGE = "__Process.outputs";
    private static final String COLUMNS = "columns";
    private final AtlasGraph graph;
    private final AtlasGremlinQueryProvider gremlinQueryProvider;
    private final EntityGraphRetriever entityRetriever;
    private final AtlasTypeRegistry atlasTypeRegistry;

    @Inject
    EntityLineageService(AtlasTypeRegistry typeRegistry, AtlasGraph atlasGraph) {
        this.graph = atlasGraph;
        this.gremlinQueryProvider = AtlasGremlinQueryProvider.INSTANCE;
        this.entityRetriever = new EntityGraphRetriever(typeRegistry);
        this.atlasTypeRegistry = typeRegistry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @GraphTransaction
    public AtlasLineageInfo getAtlasLineageInfo(String guid, AtlasLineageInfo.LineageDirection direction, int depth) throws AtlasBaseException {
        boolean isProcess;
        AtlasEntityHeader entity = this.entityRetriever.toAtlasEntityHeaderWithClassifications(guid);
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.atlasTypeRegistry, AtlasPrivilege.ENTITY_READ, entity), (Object[])new Object[]{"read entity lineage: guid=", guid});
        AtlasEntityType entityType = this.atlasTypeRegistry.getEntityTypeByName(entity.getTypeName());
        if (entityType == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, new String[]{entity.getTypeName()});
        }
        boolean isDataSet = entityType.getTypeAndAllSuperTypes().contains("DataSet");
        if (!isDataSet && !(isProcess = entityType.getTypeAndAllSuperTypes().contains("Process"))) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_LINEAGE_ENTITY_TYPE, new String[]{guid, entity.getTypeName()});
        }
        if (direction == null) throw new AtlasBaseException(AtlasErrorCode.INSTANCE_LINEAGE_INVALID_PARAMS, new String[]{"direction", null});
        if (direction.equals((Object)AtlasLineageInfo.LineageDirection.INPUT)) {
            return this.getLineageInfo(guid, AtlasLineageInfo.LineageDirection.INPUT, depth, isDataSet);
        }
        if (direction.equals((Object)AtlasLineageInfo.LineageDirection.OUTPUT)) {
            return this.getLineageInfo(guid, AtlasLineageInfo.LineageDirection.OUTPUT, depth, isDataSet);
        }
        if (!direction.equals((Object)AtlasLineageInfo.LineageDirection.BOTH)) throw new AtlasBaseException(AtlasErrorCode.INSTANCE_LINEAGE_INVALID_PARAMS, new String[]{"direction", direction.toString()});
        return this.getBothLineageInfo(guid, depth, isDataSet);
    }

    @Override
    @GraphTransaction
    public SchemaResponse.SchemaDetails getSchemaForHiveTableByName(String datasetName) throws AtlasBaseException {
        if (StringUtils.isEmpty((String)datasetName)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[0]);
        }
        AtlasEntityType hive_table = this.atlasTypeRegistry.getEntityTypeByName("hive_table");
        HashMap<String, Object> lookupAttributes = new HashMap<String, Object>();
        lookupAttributes.put("qualifiedName", datasetName);
        String guid = AtlasGraphUtilsV2.getGuidByUniqueAttributes(hive_table, lookupAttributes);
        return this.getSchemaForHiveTableByGuid(guid);
    }

    @Override
    @GraphTransaction
    public SchemaResponse.SchemaDetails getSchemaForHiveTableByGuid(String guid) throws AtlasBaseException {
        if (StringUtils.isEmpty((String)guid)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[0]);
        }
        SchemaResponse.SchemaDetails ret = new SchemaResponse.SchemaDetails();
        AtlasEntityType hive_column = this.atlasTypeRegistry.getEntityTypeByName("hive_column");
        ret.setDataType(AtlasTypeUtil.toClassTypeDefinition((AtlasEntityType)hive_column));
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.entityRetriever.toAtlasEntityWithExtInfo(guid);
        AtlasEntity entity = entityWithExtInfo.getEntity();
        AtlasAuthorizationUtils.verifyAccess((AtlasEntityAccessRequest)new AtlasEntityAccessRequest(this.atlasTypeRegistry, AtlasPrivilege.ENTITY_READ, new AtlasEntityHeader(entity)), (Object[])new Object[]{"read entity schema: guid=", guid});
        Map referredEntities = entityWithExtInfo.getReferredEntities();
        List<String> columnIds = this.getColumnIds(entity);
        if (MapUtils.isNotEmpty((Map)referredEntities)) {
            List rows = referredEntities.entrySet().stream().filter(e -> this.isColumn(columnIds, (Map.Entry<String, AtlasEntity>)e)).map(e -> AtlasTypeUtil.toMap((AtlasEntity)((AtlasEntity)e.getValue()))).collect(Collectors.toList());
            ret.setRows(rows);
        }
        return ret;
    }

    private List<String> getColumnIds(AtlasEntity entity) {
        ArrayList<String> ret = new ArrayList<String>();
        Object columnObjs = entity.getAttribute(COLUMNS);
        if (columnObjs instanceof List) {
            for (Object pkObj : (List)columnObjs) {
                if (!(pkObj instanceof AtlasObjectId)) continue;
                ret.add(((AtlasObjectId)pkObj).getGuid());
            }
        }
        return ret;
    }

    private boolean isColumn(List<String> columnIds, Map.Entry<String, AtlasEntity> e) {
        return columnIds.contains(e.getValue().getGuid());
    }

    private AtlasLineageInfo getLineageInfo(String guid, AtlasLineageInfo.LineageDirection direction, int depth, boolean isDataSet) throws AtlasBaseException {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        String lineageQuery = this.getLineageQuery(guid, direction, depth, isDataSet, bindings);
        List results = this.executeGremlinScript(bindings, lineageQuery);
        HashMap<String, AtlasEntityHeader> entities = new HashMap<String, AtlasEntityHeader>();
        HashSet<AtlasLineageInfo.LineageRelation> relations = new HashSet<AtlasLineageInfo.LineageRelation>();
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            for (Object result : results) {
                if (result instanceof Map) {
                    for (Map.Entry o : ((Map)result).entrySet()) {
                        Map.Entry entry = o;
                        Object value = entry.getValue();
                        if (value instanceof List) {
                            for (Object elem : (List)value) {
                                if (elem instanceof AtlasEdge) {
                                    this.processEdge((AtlasEdge)elem, entities, relations);
                                    continue;
                                }
                                LOG.warn("Invalid value of type {} found, ignoring", (Object)(elem != null ? elem.getClass().getSimpleName() : "null"));
                            }
                            continue;
                        }
                        if (value instanceof AtlasEdge) {
                            this.processEdge((AtlasEdge)value, entities, relations);
                            continue;
                        }
                        LOG.warn("Invalid value of type {} found, ignoring", (Object)(value != null ? value.getClass().getSimpleName() : "null"));
                    }
                    continue;
                }
                if (!(result instanceof AtlasEdge)) continue;
                this.processEdge((AtlasEdge)result, entities, relations);
            }
        }
        return new AtlasLineageInfo(guid, entities, relations, direction, depth);
    }

    private List executeGremlinScript(Map<String, Object> bindings, String lineageQuery) throws AtlasBaseException {
        List ret;
        ScriptEngine engine = this.graph.getGremlinScriptEngine();
        try {
            ret = (List)this.graph.executeGremlinScript(engine, bindings, lineageQuery, false);
        }
        catch (ScriptException e) {
            throw new AtlasBaseException(AtlasErrorCode.INSTANCE_LINEAGE_QUERY_FAILED, new String[]{lineageQuery});
        }
        finally {
            this.graph.releaseGremlinScriptEngine(engine);
        }
        return ret;
    }

    private void processEdge(AtlasEdge edge, Map<String, AtlasEntityHeader> entities, Set<AtlasLineageInfo.LineageRelation> relations) throws AtlasBaseException {
        AtlasEntityHeader entityHeader;
        AtlasVertex inVertex = edge.getInVertex();
        AtlasVertex outVertex = edge.getOutVertex();
        String inGuid = AtlasGraphUtilsV2.getIdFromVertex(inVertex);
        String outGuid = AtlasGraphUtilsV2.getIdFromVertex(outVertex);
        String relationGuid = AtlasGraphUtilsV2.getEncodedProperty(edge, Constants.RELATIONSHIP_GUID_PROPERTY_KEY, String.class);
        boolean isInputEdge = edge.getLabel().equalsIgnoreCase(PROCESS_INPUTS_EDGE);
        if (!entities.containsKey(inGuid)) {
            entityHeader = this.entityRetriever.toAtlasEntityHeader(inVertex);
            entities.put(inGuid, entityHeader);
        }
        if (!entities.containsKey(outGuid)) {
            entityHeader = this.entityRetriever.toAtlasEntityHeader(outVertex);
            entities.put(outGuid, entityHeader);
        }
        if (isInputEdge) {
            relations.add(new AtlasLineageInfo.LineageRelation(inGuid, outGuid, relationGuid));
        } else {
            relations.add(new AtlasLineageInfo.LineageRelation(outGuid, inGuid, relationGuid));
        }
    }

    private AtlasLineageInfo getBothLineageInfo(String guid, int depth, boolean isDataSet) throws AtlasBaseException {
        AtlasLineageInfo inputLineage = this.getLineageInfo(guid, AtlasLineageInfo.LineageDirection.INPUT, depth, isDataSet);
        AtlasLineageInfo outputLineage = this.getLineageInfo(guid, AtlasLineageInfo.LineageDirection.OUTPUT, depth, isDataSet);
        AtlasLineageInfo ret = inputLineage;
        ret.getRelations().addAll(outputLineage.getRelations());
        ret.getGuidEntityMap().putAll(outputLineage.getGuidEntityMap());
        ret.setLineageDirection(AtlasLineageInfo.LineageDirection.BOTH);
        return ret;
    }

    private String getLineageQuery(String entityGuid, AtlasLineageInfo.LineageDirection direction, int depth, boolean isDataSet, Map<String, Object> bindings) {
        String incomingFrom = null;
        String outgoingTo = null;
        if (direction.equals((Object)AtlasLineageInfo.LineageDirection.INPUT)) {
            incomingFrom = PROCESS_OUTPUTS_EDGE;
            outgoingTo = PROCESS_INPUTS_EDGE;
        } else if (direction.equals((Object)AtlasLineageInfo.LineageDirection.OUTPUT)) {
            incomingFrom = PROCESS_INPUTS_EDGE;
            outgoingTo = PROCESS_OUTPUTS_EDGE;
        }
        bindings.put("guid", entityGuid);
        bindings.put("incomingEdgeLabel", incomingFrom);
        bindings.put("outgoingEdgeLabel", outgoingTo);
        bindings.put("dataSetDepth", depth);
        bindings.put("processDepth", depth - 1);
        String ret = depth < 1 ? (isDataSet ? this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.FULL_LINEAGE_DATASET) : this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.FULL_LINEAGE_PROCESS)) : (isDataSet ? this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.PARTIAL_LINEAGE_DATASET) : this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.PARTIAL_LINEAGE_PROCESS));
        return ret;
    }
}

