/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.SortOrder;
import org.apache.atlas.annotation.GraphTransaction;
import org.apache.atlas.authorize.AtlasAuthorizationUtils;
import org.apache.atlas.authorize.AtlasSearchResultScrubRequest;
import org.apache.atlas.discovery.AtlasDiscoveryService;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.profile.AtlasUserSavedSearch;
import org.apache.atlas.query.AtlasDSL;
import org.apache.atlas.query.GremlinQuery;
import org.apache.atlas.query.QueryParams;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.EntityGraphRetriever;
import org.apache.atlas.repository.userprofile.UserProfileService;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.AtlasGremlinQueryProvider;
import org.apache.atlas.util.SearchTracker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityDiscoveryService
implements AtlasDiscoveryService {
    private static final Logger LOG = LoggerFactory.getLogger(EntityDiscoveryService.class);
    private static final String DEFAULT_SORT_ATTRIBUTE_NAME = "name";
    private final AtlasGraph graph;
    private final EntityGraphRetriever entityRetriever;
    private final AtlasGremlinQueryProvider gremlinQueryProvider;
    private final AtlasTypeRegistry typeRegistry;
    private final GraphBackedSearchIndexer indexer;
    private final SearchTracker searchTracker;
    private final int maxResultSetSize;
    private final int maxTypesLengthInIdxQuery;
    private final int maxTagsLengthInIdxQuery;
    private final String indexSearchPrefix;
    private final UserProfileService userProfileService;

    @Inject
    EntityDiscoveryService(AtlasTypeRegistry typeRegistry, AtlasGraph graph, GraphBackedSearchIndexer indexer, SearchTracker searchTracker, UserProfileService userProfileService) throws AtlasException {
        this.graph = graph;
        this.entityRetriever = new EntityGraphRetriever(typeRegistry);
        this.indexer = indexer;
        this.searchTracker = searchTracker;
        this.gremlinQueryProvider = AtlasGremlinQueryProvider.INSTANCE;
        this.typeRegistry = typeRegistry;
        this.maxResultSetSize = ApplicationProperties.get().getInt("atlas.graph.index.search.max-result-set-size", 150);
        this.maxTypesLengthInIdxQuery = ApplicationProperties.get().getInt("atlas.graph.index.search.types.max-query-str-length", 512);
        this.maxTagsLengthInIdxQuery = ApplicationProperties.get().getInt("atlas.graph.index.search.tags.max-query-str-length", 512);
        this.indexSearchPrefix = AtlasGraphUtilsV2.getIndexSearchPrefix();
        this.userProfileService = userProfileService;
    }

    @Override
    @GraphTransaction
    public AtlasSearchResult searchUsingDslQuery(String dslQuery, int limit, int offset) throws AtlasBaseException {
        Object result;
        AtlasSearchResult ret = new AtlasSearchResult(dslQuery, AtlasSearchResult.AtlasQueryType.DSL);
        GremlinQuery gremlinQuery = this.toGremlinQuery(dslQuery, limit, offset);
        String queryStr = gremlinQuery.queryStr();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing DSL: query={}, gremlinQuery={}", (Object)dslQuery, (Object)queryStr);
        }
        if ((result = this.graph.executeGremlinScript(queryStr, false)) instanceof List && CollectionUtils.isNotEmpty((Collection)((List)result))) {
            List queryResult = (List)result;
            Object firstElement = queryResult.get(0);
            if (firstElement instanceof AtlasVertex) {
                for (Object element : queryResult) {
                    if (element instanceof AtlasVertex) {
                        ret.addEntity(this.entityRetriever.toAtlasEntityHeaderWithClassifications((AtlasVertex)element));
                        continue;
                    }
                    LOG.warn("searchUsingDslQuery({}): expected an AtlasVertex; found unexpected entry in result {}", (Object)dslQuery, element);
                }
            } else if (gremlinQuery.hasSelectList()) {
                ret.setAttributes(this.toAttributesResult(queryResult, gremlinQuery));
            } else if (firstElement instanceof Map) {
                for (Object element : queryResult) {
                    if (!(element instanceof Map)) continue;
                    Map map = (Map)element;
                    for (Object key : map.keySet()) {
                        Object value = map.get(key);
                        if (!(value instanceof List) || !CollectionUtils.isNotEmpty((Collection)((List)value))) continue;
                        for (Object o : (List)value) {
                            Object entry = o;
                            if (!(entry instanceof AtlasVertex)) continue;
                            ret.addEntity(this.entityRetriever.toAtlasEntityHeader((AtlasVertex)entry));
                        }
                    }
                }
            } else {
                LOG.warn("searchUsingDslQuery({}/{}): found unexpected entry in result {}", new Object[]{dslQuery, dslQuery, gremlinQuery.queryStr()});
            }
        }
        this.scrubSearchResults(ret);
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasSearchResult searchUsingFullTextQuery(String fullTextQuery, boolean excludeDeletedEntities, int limit, int offset) throws AtlasBaseException {
        AtlasSearchResult ret = new AtlasSearchResult(fullTextQuery, AtlasSearchResult.AtlasQueryType.FULL_TEXT);
        QueryParams params = QueryParams.getNormalizedParams(limit, offset);
        AtlasIndexQuery idxQuery = this.toAtlasIndexQuery(fullTextQuery);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing Full text query: {}", (Object)fullTextQuery);
        }
        ret.setFullTextResult(this.getIndexQueryResults(idxQuery, params, excludeDeletedEntities));
        this.scrubSearchResults(ret);
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasSearchResult searchUsingBasicQuery(String query, String typeName, String classification, String attrName, String attrValuePrefix, boolean excludeDeletedEntities, int limit, int offset) throws AtlasBaseException {
        AtlasSearchResult ret;
        block32: {
            ret = new AtlasSearchResult(AtlasSearchResult.AtlasQueryType.BASIC);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing basic search query: {} with type: {} and classification: {}", new Object[]{query, typeName, classification});
            }
            QueryParams params = QueryParams.getNormalizedParams(limit, offset);
            Set typeNames = null;
            Set classificationNames = null;
            String attrQualifiedName = null;
            if (StringUtils.isNotEmpty((String)typeName)) {
                AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
                if (entityType == null) {
                    throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_TYPENAME, new String[]{typeName});
                }
                typeNames = entityType.getTypeAndAllSubTypes();
                ret.setType(typeName);
            }
            if (StringUtils.isNotEmpty((String)classification)) {
                AtlasClassificationType classificationType = this.typeRegistry.getClassificationTypeByName(classification);
                if (classificationType == null) {
                    throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATION_NOT_FOUND, new String[]{classification});
                }
                classificationNames = classificationType.getTypeAndAllSubTypes();
                ret.setClassification(classification);
            }
            boolean isAttributeSearch = StringUtils.isNotEmpty((String)attrName) || StringUtils.isNotEmpty((String)attrValuePrefix);
            boolean isGuidPrefixSearch = false;
            if (isAttributeSearch) {
                AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(typeName);
                ret.setQueryType(AtlasSearchResult.AtlasQueryType.ATTRIBUTE);
                if (entityType != null) {
                    AtlasStructType.AtlasAttribute attribute = null;
                    if (StringUtils.isNotEmpty((String)attrName)) {
                        attribute = entityType.getAttribute(attrName);
                        if (attribute == null) {
                            throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_ATTRIBUTE, new String[]{attrName, typeName});
                        }
                    } else {
                        ArrayList<String> defaultAttrNames = new ArrayList<String>(Arrays.asList("qualifiedName", DEFAULT_SORT_ATTRIBUTE_NAME));
                        Iterator iter = defaultAttrNames.iterator();
                        while (iter.hasNext() && attribute == null) {
                            attrName = (String)iter.next();
                            attribute = entityType.getAttribute(attrName);
                        }
                    }
                    if (attribute == null) {
                        isGuidPrefixSearch = true;
                        query = null;
                    } else {
                        attrQualifiedName = attribute.getQualifiedName();
                        String attrQuery = String.format("%s AND (%s *)", attrName, attrValuePrefix.replaceAll("\\.", " "));
                        String string = query = StringUtils.isEmpty((String)query) ? attrQuery : String.format("(%s) AND (%s)", query, attrQuery);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing attribute search attrName: {} and attrValue: {}", (Object)attrName, (Object)attrValuePrefix);
                }
            }
            if (StringUtils.isNotEmpty((String)query)) {
                String idxQuery = this.getQueryForFullTextSearch(query, typeName, classification);
                int startIdx = params.offset();
                int resultSize = params.limit();
                int resultIdx = 0;
                int indexQueryOffset = 0;
                while (true) {
                    Iterator qryResult = this.graph.indexQuery("fulltext_index", idxQuery, indexQueryOffset).vertices();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("indexQuery: query=" + idxQuery + "; offset=" + indexQueryOffset);
                    }
                    if (qryResult.hasNext()) {
                        while (qryResult.hasNext()) {
                            String vertexAttrValue;
                            List<String> traitNames;
                            AtlasVertex vertex = ((AtlasIndexQuery.Result)qryResult.next()).getVertex();
                            String vertexTypeName = GraphHelper.getTypeName((AtlasElement)vertex);
                            if (StringUtils.isEmpty((String)vertexTypeName) || StringUtils.isEmpty((String)GraphHelper.getGuid((AtlasElement)vertex)) || typeNames != null && !typeNames.contains(vertexTypeName) || classificationNames != null && (CollectionUtils.isEmpty(traitNames = GraphHelper.getTraitNames(vertex)) || !CollectionUtils.containsAny((Collection)classificationNames, traitNames)) || isAttributeSearch && StringUtils.isNotEmpty((String)(vertexAttrValue = (String)vertex.getProperty(attrQualifiedName, String.class))) && !vertexAttrValue.startsWith(attrValuePrefix) || this.skipDeletedEntities(excludeDeletedEntities, vertex) || ++resultIdx <= startIdx) continue;
                            AtlasEntityHeader header = this.entityRetriever.toAtlasEntityHeader(vertex);
                            ret.addEntity(header);
                            if (ret.getEntities().size() != resultSize) continue;
                            break;
                        }
                        if (ret.getEntities() == null || ret.getEntities().size() != resultSize) {
                            indexQueryOffset += this.getMaxResultSetSize();
                            continue;
                        }
                    }
                    break block32;
                    break;
                }
            }
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            String basicQuery = "g.V()";
            if (classificationNames != null) {
                bindings.put("traitNames", classificationNames);
                basicQuery = basicQuery + this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.BASIC_SEARCH_CLASSIFICATION_FILTER);
            }
            if (typeNames != null) {
                bindings.put("typeNames", typeNames);
                basicQuery = basicQuery + this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.BASIC_SEARCH_TYPE_FILTER);
            }
            if (excludeDeletedEntities) {
                bindings.put("state", AtlasEntity.Status.ACTIVE.toString());
                basicQuery = basicQuery + this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.BASIC_SEARCH_STATE_FILTER);
            }
            if (isGuidPrefixSearch) {
                bindings.put("guid", attrValuePrefix + ".*");
                basicQuery = basicQuery + this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.GUID_PREFIX_FILTER);
            }
            bindings.put("startIdx", params.offset());
            bindings.put("endIdx", params.offset() + params.limit());
            basicQuery = basicQuery + this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.TO_RANGE_LIST);
            ScriptEngine scriptEngine = this.graph.getGremlinScriptEngine();
            try {
                List queryResult;
                Object firstElement;
                Object result = this.graph.executeGremlinScript(scriptEngine, bindings, basicQuery, false);
                if (result instanceof List && CollectionUtils.isNotEmpty((Collection)((List)result)) && (firstElement = (queryResult = (List)result).get(0)) instanceof AtlasVertex) {
                    for (Object element : queryResult) {
                        if (element instanceof AtlasVertex) {
                            ret.addEntity(this.entityRetriever.toAtlasEntityHeader((AtlasVertex)element));
                            continue;
                        }
                        LOG.warn("searchUsingBasicQuery({}): expected an AtlasVertex; found unexpected entry in result {}", (Object)basicQuery, element);
                    }
                }
            }
            catch (ScriptException e) {
                throw new AtlasBaseException(AtlasErrorCode.DISCOVERY_QUERY_FAILED, new String[]{basicQuery});
            }
            finally {
                this.graph.releaseGremlinScriptEngine(scriptEngine);
            }
        }
        this.scrubSearchResults(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GraphTransaction
    public AtlasSearchResult searchWithParameters(SearchParameters searchParameters) throws AtlasBaseException {
        AtlasSearchResult ret = new AtlasSearchResult(searchParameters);
        QueryParams params = QueryParams.getNormalizedParams(searchParameters.getLimit(), searchParameters.getOffset());
        searchParameters.setLimit(params.limit());
        searchParameters.setOffset(params.offset());
        SearchContext context = new SearchContext(searchParameters, this.typeRegistry, this.graph, this.indexer.getVertexIndexKeys());
        String searchID = this.searchTracker.add(context);
        try {
            AtlasEntityType entityType;
            List<AtlasVertex> resultList = context.getSearchProcessor().execute();
            HashSet<String> resultAttributes = new HashSet<String>();
            HashSet<String> entityAttributes = new HashSet<String>();
            if (CollectionUtils.isNotEmpty((Collection)searchParameters.getAttributes())) {
                resultAttributes.addAll(searchParameters.getAttributes());
            }
            if (CollectionUtils.isNotEmpty(context.getEntityAttributes())) {
                resultAttributes.addAll(context.getEntityAttributes());
            }
            if ((entityType = context.getEntityType()) != null) {
                for (String resultAttribute : resultAttributes) {
                    AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(resultAttribute);
                    if (attribute == null) {
                        attribute = entityType.getRelationshipAttribute(resultAttribute, null);
                    }
                    if (attribute == null) continue;
                    AtlasType attributeType = attribute.getAttributeType();
                    if (attributeType instanceof AtlasArrayType) {
                        attributeType = ((AtlasArrayType)attributeType).getElementType();
                    }
                    if (!(attributeType instanceof AtlasEntityType) && !(attributeType instanceof AtlasBuiltInTypes.AtlasObjectIdType)) continue;
                    entityAttributes.add(resultAttribute);
                }
            }
            for (AtlasVertex atlasVertex : resultList) {
                AtlasEntityHeader entity = this.entityRetriever.toAtlasEntityHeader(atlasVertex, resultAttributes);
                if (searchParameters.getIncludeClassificationAttributes()) {
                    entity.setClassifications(this.entityRetriever.getAllClassifications(atlasVertex));
                }
                ret.addEntity(entity);
                for (String entityAttribute : entityAttributes) {
                    Object attrValue = entity.getAttribute(entityAttribute);
                    if (attrValue instanceof AtlasObjectId) {
                        AtlasObjectId objId = (AtlasObjectId)attrValue;
                        if (ret.getReferredEntities() == null) {
                            ret.setReferredEntities(new HashMap());
                        }
                        if (ret.getReferredEntities().containsKey(objId.getGuid())) continue;
                        ret.getReferredEntities().put(objId.getGuid(), this.entityRetriever.toAtlasEntityHeader(objId.getGuid()));
                        continue;
                    }
                    if (!(attrValue instanceof Collection)) continue;
                    Collection objIds = (Collection)attrValue;
                    for (Object obj : objIds) {
                        if (!(obj instanceof AtlasObjectId)) continue;
                        AtlasObjectId objId = (AtlasObjectId)obj;
                        if (ret.getReferredEntities() == null) {
                            ret.setReferredEntities(new HashMap());
                        }
                        if (ret.getReferredEntities().containsKey(objId.getGuid())) continue;
                        ret.getReferredEntities().put(objId.getGuid(), this.entityRetriever.toAtlasEntityHeader(objId.getGuid()));
                    }
                }
            }
        }
        finally {
            this.searchTracker.remove(searchID);
        }
        this.scrubSearchResults(ret);
        return ret;
    }

    @Override
    @GraphTransaction
    public AtlasSearchResult searchRelatedEntities(String guid, String relation, String sortByAttributeName, SortOrder sortOrder, boolean excludeDeletedEntities, int limit, int offset) throws AtlasBaseException {
        AtlasStructType.AtlasAttribute sortByAttribute;
        AtlasSearchResult ret = new AtlasSearchResult(AtlasSearchResult.AtlasQueryType.RELATIONSHIP);
        if (StringUtils.isEmpty((String)guid) || StringUtils.isEmpty((String)relation)) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_PARAMETERS, new String[]{"guid: '" + guid + "', relation: '" + relation + "'"});
        }
        AtlasVertex entityVertex = this.entityRetriever.getEntityVertex(guid);
        String entityTypeName = GraphHelper.getTypeName((AtlasElement)entityVertex);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName(entityTypeName);
        if (entityType == null) {
            throw new AtlasBaseException(AtlasErrorCode.INVALID_RELATIONSHIP_TYPE, new String[]{entityTypeName, guid});
        }
        AtlasStructType.AtlasAttribute attribute = entityType.getAttribute(relation);
        if (attribute == null) {
            attribute = entityType.getRelationshipAttribute(relation, null);
        }
        if (attribute != null) {
            if (attribute.isObjectRef()) {
                relation = attribute.getRelationshipEdgeLabel();
            } else {
                throw new AtlasBaseException(AtlasErrorCode.INVALID_RELATIONSHIP_ATTRIBUTE, new String[]{relation, attribute.getTypeName()});
            }
        }
        if (StringUtils.isEmpty((String)sortByAttributeName)) {
            sortByAttributeName = DEFAULT_SORT_ATTRIBUTE_NAME;
        }
        if ((sortByAttribute = entityType.getAttribute(sortByAttributeName)) == null) {
            sortByAttributeName = null;
            sortOrder = null;
        } else {
            sortByAttributeName = sortByAttribute.getQualifiedName();
            if (sortOrder == null) {
                sortOrder = SortOrder.ASCENDING;
            }
        }
        QueryParams params = QueryParams.getNormalizedParams(limit, offset);
        ScriptEngine scriptEngine = this.graph.getGremlinScriptEngine();
        Bindings bindings = scriptEngine.createBindings();
        Set<String> states = this.getEntityStates();
        String relatedEntitiesQuery = this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.RELATIONSHIP_SEARCH);
        if (excludeDeletedEntities) {
            states.remove(AtlasEntity.Status.DELETED.toString());
        }
        if (sortOrder == SortOrder.ASCENDING) {
            relatedEntitiesQuery = relatedEntitiesQuery + this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.RELATIONSHIP_SEARCH_ASCENDING_SORT);
            bindings.put("sortAttributeName", (Object)sortByAttributeName);
        } else if (sortOrder == SortOrder.DESCENDING) {
            relatedEntitiesQuery = relatedEntitiesQuery + this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.RELATIONSHIP_SEARCH_DESCENDING_SORT);
            bindings.put("sortAttributeName", (Object)sortByAttributeName);
        }
        relatedEntitiesQuery = relatedEntitiesQuery + this.gremlinQueryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.TO_RANGE_LIST);
        bindings.put("g", (Object)this.graph);
        bindings.put("guid", (Object)guid);
        bindings.put("relation", (Object)relation);
        bindings.put("states", (Object)Collections.unmodifiableSet(states));
        bindings.put("startIdx", (Object)params.offset());
        bindings.put("endIdx", (Object)(params.offset() + params.limit()));
        try {
            List queryResult;
            Object firstElement;
            Object result = this.graph.executeGremlinScript(scriptEngine, (Map)bindings, relatedEntitiesQuery, false);
            if (result instanceof List && CollectionUtils.isNotEmpty((Collection)((List)result)) && (firstElement = (queryResult = (List)result).get(0)) instanceof AtlasVertex) {
                List vertices = queryResult;
                ArrayList<AtlasEntityHeader> resultList = new ArrayList<AtlasEntityHeader>(vertices.size());
                for (AtlasVertex vertex : vertices) {
                    resultList.add(this.entityRetriever.toAtlasEntityHeader(vertex));
                }
                ret.setEntities(resultList);
            }
            if (ret.getEntities() == null) {
                ret.setEntities(new ArrayList());
            }
        }
        catch (ScriptException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Gremlin script execution failed for relationship search query: {}", (Object)relatedEntitiesQuery, (Object)e);
            }
            throw new AtlasBaseException(AtlasErrorCode.INTERNAL_ERROR, new String[]{"Relationship search query failed"});
        }
        finally {
            this.graph.releaseGremlinScriptEngine(scriptEngine);
        }
        this.scrubSearchResults(ret);
        return ret;
    }

    public int getMaxResultSetSize() {
        return this.maxResultSetSize;
    }

    private String getQueryForFullTextSearch(String userKeyedString, String typeName, String classification) {
        String typeFilter = EntityDiscoveryService.getTypeFilter(this.typeRegistry, typeName, this.maxTypesLengthInIdxQuery);
        String classificationFilter = EntityDiscoveryService.getClassificationFilter(this.typeRegistry, classification, this.maxTagsLengthInIdxQuery);
        StringBuilder queryText = new StringBuilder();
        if (!StringUtils.isEmpty((String)userKeyedString)) {
            queryText.append(userKeyedString);
        }
        if (!StringUtils.isEmpty((String)typeFilter)) {
            if (queryText.length() > 0) {
                queryText.append(" AND ");
            }
            queryText.append(typeFilter);
        }
        if (!StringUtils.isEmpty((String)classificationFilter)) {
            if (queryText.length() > 0) {
                queryText.append(" AND ");
            }
            queryText.append(classificationFilter);
        }
        return String.format(this.indexSearchPrefix + "\"%s\":(%s)", Constants.ENTITY_TEXT_PROPERTY_KEY, queryText.toString());
    }

    private List<AtlasSearchResult.AtlasFullTextResult> getIndexQueryResults(AtlasIndexQuery query, QueryParams params, boolean excludeDeletedEntities) throws AtlasBaseException {
        ArrayList<AtlasSearchResult.AtlasFullTextResult> ret = new ArrayList<AtlasSearchResult.AtlasFullTextResult>();
        Iterator iter = query.vertices();
        while (iter.hasNext() && ret.size() < params.limit()) {
            String guid;
            AtlasIndexQuery.Result idxQueryResult = (AtlasIndexQuery.Result)iter.next();
            AtlasVertex vertex = idxQueryResult.getVertex();
            if (this.skipDeletedEntities(excludeDeletedEntities, vertex) || (guid = vertex != null ? (String)vertex.getProperty(Constants.GUID_PROPERTY_KEY, String.class) : null) == null) continue;
            AtlasEntityHeader entity = this.entityRetriever.toAtlasEntityHeader(vertex);
            Double score = idxQueryResult.getScore();
            ret.add(new AtlasSearchResult.AtlasFullTextResult(entity, score));
        }
        return ret;
    }

    private GremlinQuery toGremlinQuery(String query, int limit, int offset) throws AtlasBaseException {
        QueryParams params = QueryParams.getNormalizedParams(limit, offset);
        GremlinQuery gremlinQuery = new AtlasDSL.Translator(query, this.typeRegistry, params.offset(), params.limit()).translate();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translated Gremlin Query: {}", (Object)gremlinQuery.queryStr());
        }
        return gremlinQuery;
    }

    private AtlasIndexQuery toAtlasIndexQuery(String fullTextQuery) {
        String graphQuery = String.format(this.indexSearchPrefix + "\"%s\":(%s)", Constants.ENTITY_TEXT_PROPERTY_KEY, fullTextQuery);
        return this.graph.indexQuery("fulltext_index", graphQuery);
    }

    private AtlasSearchResult.AttributeSearchResult toAttributesResult(List results, GremlinQuery query) {
        AtlasSearchResult.AttributeSearchResult ret = new AtlasSearchResult.AttributeSearchResult();
        List names = (List)results.get(0);
        List<List<Object>> values = this.extractValues(results.subList(1, results.size()));
        ret.setName(names);
        ret.setValues(values);
        return ret;
    }

    private List<String> extractNames(List results) {
        ArrayList<String> names = new ArrayList<String>();
        for (Object obj : results) {
            List list;
            if (obj instanceof Map) {
                Map map = (Map)obj;
                if (!MapUtils.isNotEmpty((Map)map)) continue;
                for (Object key : map.keySet()) {
                    names.add((String)key);
                }
                return names;
            }
            if (!(obj instanceof List) || !CollectionUtils.isNotEmpty((Collection)(list = (List)obj))) continue;
            for (Object o : list) {
                names.add((String)o);
            }
        }
        return names;
    }

    private List<List<Object>> extractValues(List results) {
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        for (Object obj : results) {
            List list;
            if (obj instanceof Map) {
                Map map = (Map)obj;
                ArrayList list2 = new ArrayList();
                if (!MapUtils.isNotEmpty((Map)map)) continue;
                for (Object key : map.keySet()) {
                    Object vals = map.get(key);
                    if (!(vals instanceof List)) continue;
                    List l = (List)vals;
                    list2.addAll(l);
                }
                values.add(list2);
                continue;
            }
            if (!(obj instanceof List) || !CollectionUtils.isNotEmpty((Collection)(list = (List)obj))) continue;
            values.add(list);
        }
        return values;
    }

    private boolean skipDeletedEntities(boolean excludeDeletedEntities, AtlasVertex<?, ?> vertex) {
        return excludeDeletedEntities && GraphHelper.getStatus(vertex) == AtlasEntity.Status.DELETED;
    }

    private static String getClassificationFilter(AtlasTypeRegistry typeRegistry, String classificationName, int maxTypesLengthInIdxQuery) {
        String typeAndSubTypesQryStr;
        AtlasClassificationType type = typeRegistry.getClassificationTypeByName(classificationName);
        String string = typeAndSubTypesQryStr = type != null ? type.getTypeAndAllSubTypesQryStr() : null;
        if (StringUtils.isNotEmpty((String)typeAndSubTypesQryStr) && typeAndSubTypesQryStr.length() <= maxTypesLengthInIdxQuery) {
            return typeAndSubTypesQryStr;
        }
        return "";
    }

    @VisibleForTesting
    static String getTypeFilter(AtlasTypeRegistry typeRegistry, String typeName, int maxTypesLengthInIdxQuery) {
        String typeAndSubTypesQryStr;
        AtlasEntityType type = typeRegistry.getEntityTypeByName(typeName);
        String string = typeAndSubTypesQryStr = type != null ? type.getTypeAndAllSubTypesQryStr() : null;
        if (StringUtils.isNotEmpty((String)typeAndSubTypesQryStr) && typeAndSubTypesQryStr.length() <= maxTypesLengthInIdxQuery) {
            return typeAndSubTypesQryStr;
        }
        return "";
    }

    private Set<String> getEntityStates() {
        return new HashSet<String>(Arrays.asList(AtlasEntity.Status.ACTIVE.toString(), AtlasEntity.Status.DELETED.toString()));
    }

    @Override
    public AtlasUserSavedSearch addSavedSearch(String currentUser, AtlasUserSavedSearch savedSearch) throws AtlasBaseException {
        try {
            if (StringUtils.isEmpty((String)savedSearch.getOwnerName())) {
                savedSearch.setOwnerName(currentUser);
            }
            this.checkSavedSearchOwnership(currentUser, savedSearch);
            return this.userProfileService.addSavedSearch(savedSearch);
        }
        catch (AtlasBaseException e) {
            LOG.error("addSavedSearch({})", (Object)savedSearch, (Object)e);
            throw e;
        }
    }

    @Override
    public AtlasUserSavedSearch updateSavedSearch(String currentUser, AtlasUserSavedSearch savedSearch) throws AtlasBaseException {
        try {
            if (StringUtils.isEmpty((String)savedSearch.getOwnerName())) {
                savedSearch.setOwnerName(currentUser);
            }
            this.checkSavedSearchOwnership(currentUser, savedSearch);
            return this.userProfileService.updateSavedSearch(savedSearch);
        }
        catch (AtlasBaseException e) {
            LOG.error("updateSavedSearch({})", (Object)savedSearch, (Object)e);
            throw e;
        }
    }

    @Override
    public List<AtlasUserSavedSearch> getSavedSearches(String currentUser, String userName) throws AtlasBaseException {
        try {
            if (StringUtils.isEmpty((String)userName)) {
                userName = currentUser;
            } else if (!StringUtils.equals((String)currentUser, (String)userName)) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"invalid data"});
            }
            return this.userProfileService.getSavedSearches(userName);
        }
        catch (AtlasBaseException e) {
            LOG.error("getSavedSearches({})", (Object)userName, (Object)e);
            throw e;
        }
    }

    @Override
    public AtlasUserSavedSearch getSavedSearchByGuid(String currentUser, String guid) throws AtlasBaseException {
        try {
            AtlasUserSavedSearch savedSearch = this.userProfileService.getSavedSearch(guid);
            this.checkSavedSearchOwnership(currentUser, savedSearch);
            return savedSearch;
        }
        catch (AtlasBaseException e) {
            LOG.error("getSavedSearchByGuid({})", (Object)guid, (Object)e);
            throw e;
        }
    }

    @Override
    public AtlasUserSavedSearch getSavedSearchByName(String currentUser, String userName, String searchName) throws AtlasBaseException {
        try {
            if (StringUtils.isEmpty((String)userName)) {
                userName = currentUser;
            } else if (!StringUtils.equals((String)currentUser, (String)userName)) {
                throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"invalid data"});
            }
            return this.userProfileService.getSavedSearch(userName, searchName);
        }
        catch (AtlasBaseException e) {
            LOG.error("getSavedSearchByName({}, {})", new Object[]{userName, searchName, e});
            throw e;
        }
    }

    @Override
    public void deleteSavedSearch(String currentUser, String guid) throws AtlasBaseException {
        try {
            AtlasUserSavedSearch savedSearch = this.userProfileService.getSavedSearch(guid);
            this.checkSavedSearchOwnership(currentUser, savedSearch);
            this.userProfileService.deleteSavedSearch(guid);
        }
        catch (AtlasBaseException e) {
            LOG.error("deleteSavedSearch({})", (Object)guid, (Object)e);
            throw e;
        }
    }

    @Override
    public String getDslQueryUsingTypeNameClassification(String query, String typeName, String classification) {
        String queryStr;
        String string = queryStr = query == null ? "" : query;
        if (StringUtils.isNotEmpty((String)typeName)) {
            queryStr = this.escapeTypeName(typeName) + " " + queryStr;
        }
        if (StringUtils.isNotEmpty((String)classification) && StringUtils.isEmpty((String)query)) {
            queryStr = queryStr + " isa " + classification;
        }
        return queryStr;
    }

    private String escapeTypeName(String typeName) {
        String ret = StringUtils.startsWith((String)typeName, (String)"`") && StringUtils.endsWith((String)typeName, (String)"`") ? typeName : String.format("`%s`", typeName);
        return ret;
    }

    private void checkSavedSearchOwnership(String claimedOwner, AtlasUserSavedSearch savedSearch) throws AtlasBaseException {
        if (savedSearch != null && !StringUtils.equals((String)savedSearch.getOwnerName(), (String)claimedOwner)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[]{"invalid data"});
        }
    }

    private void scrubSearchResults(AtlasSearchResult result) throws AtlasBaseException {
        AtlasAuthorizationUtils.scrubSearchResults((AtlasSearchResultScrubRequest)new AtlasSearchResultScrubRequest(this.typeRegistry, result));
    }
}

