/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.atlas.discovery.SearchContext;
import org.apache.atlas.discovery.SearchProcessor;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.discovery.SearchParameters;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasElement;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.util.AtlasGremlinQueryProvider;
import org.apache.atlas.util.SearchPredicateUtil;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationSearchProcessor
extends SearchProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ClassificationSearchProcessor.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"ClassificationSearchProcessor");
    private final AtlasIndexQuery indexQuery;
    private final AtlasGraphQuery tagGraphQueryWithAttributes;
    private final AtlasGraphQuery entityGraphQueryTraitNames;
    private Predicate entityPredicateTraitNames;
    private final String gremlinTagFilterQuery;
    private final Map<String, Object> gremlinQueryBindings;

    public ClassificationSearchProcessor(SearchContext context) {
        super(context);
        String typeAndSubTypesQryStr;
        Set<String> typeAndSubTypes;
        AtlasClassificationType classificationType = context.getClassificationType();
        SearchParameters.FilterCriteria filterCriteria = context.getSearchParameters().getTagFilters();
        HashSet<String> indexAttributes = new HashSet<String>();
        HashSet<String> graphAttributes = new HashSet<String>();
        HashSet<String> allAttributes = new HashSet<String>();
        if (context.getSearchParameters().getIncludeSubClassifications()) {
            typeAndSubTypes = classificationType.getTypeAndAllSubTypes();
            typeAndSubTypesQryStr = classificationType.getTypeAndAllSubTypesQryStr();
        } else {
            typeAndSubTypes = Collections.singleton(classificationType.getTypeName());
            typeAndSubTypesQryStr = classificationType.getTypeQryStr();
        }
        this.processSearchAttributes((AtlasStructType)classificationType, filterCriteria, indexAttributes, graphAttributes, allAttributes);
        boolean useIndexSearch = classificationType != SearchContext.MATCH_ALL_WILDCARD_CLASSIFICATION && classificationType != SearchContext.MATCH_ALL_CLASSIFIED && classificationType != SearchContext.MATCH_ALL_NOT_CLASSIFIED && typeAndSubTypesQryStr.length() <= MAX_QUERY_STR_LENGTH_TAGS && CollectionUtils.isEmpty(graphAttributes) && this.canApplyIndexFilter((AtlasStructType)classificationType, filterCriteria, false);
        AtlasGraph graph = context.getGraph();
        if (useIndexSearch) {
            StringBuilder indexQuery = new StringBuilder();
            this.constructTypeTestQuery(indexQuery, typeAndSubTypesQryStr);
            this.constructFilterQuery(indexQuery, (AtlasStructType)classificationType, filterCriteria, indexAttributes);
            String indexQueryString = STRAY_AND_PATTERN.matcher(indexQuery).replaceAll(")");
            indexQueryString = STRAY_OR_PATTERN.matcher(indexQueryString).replaceAll(")");
            indexQueryString = STRAY_ELIPSIS_PATTERN.matcher(indexQueryString).replaceAll("");
            this.indexQuery = graph.indexQuery("vertex_index", indexQueryString);
            Predicate typeNamePredicate = SearchPredicateUtil.getINPredicateGenerator().generatePredicate("__typeName", typeAndSubTypes, String.class);
            Predicate attributePredicate = this.constructInMemoryPredicate((AtlasStructType)classificationType, filterCriteria, indexAttributes);
            this.inMemoryPredicate = attributePredicate != null ? PredicateUtils.andPredicate((Predicate)typeNamePredicate, (Predicate)attributePredicate) : typeNamePredicate;
        } else {
            this.indexQuery = null;
        }
        if (context.getSearchParameters().getTagFilters() != null) {
            AtlasGremlinQueryProvider queryProvider = AtlasGremlinQueryProvider.INSTANCE;
            this.tagGraphQueryWithAttributes = this.toGraphFilterQuery((AtlasStructType)classificationType, filterCriteria, allAttributes, graph.query().in("__typeName", typeAndSubTypes));
            this.entityGraphQueryTraitNames = null;
            this.entityPredicateTraitNames = null;
            this.gremlinQueryBindings = new HashMap<String, Object>();
            StringBuilder gremlinQuery = new StringBuilder();
            gremlinQuery.append("g.V().has('__guid', T.in, guids)");
            gremlinQuery.append(queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.BASIC_SEARCH_CLASSIFICATION_FILTER));
            gremlinQuery.append(".as('e').out()");
            gremlinQuery.append(queryProvider.getQuery(AtlasGremlinQueryProvider.AtlasGremlinQuery.BASIC_SEARCH_TYPE_FILTER));
            this.constructGremlinFilterQuery(gremlinQuery, this.gremlinQueryBindings, (AtlasStructType)context.getClassificationType(), context.getSearchParameters().getTagFilters());
            gremlinQuery.append(".back('e').toList()");
            this.gremlinQueryBindings.put("traitNames", typeAndSubTypes);
            this.gremlinQueryBindings.put("typeNames", typeAndSubTypes);
            this.gremlinTagFilterQuery = gremlinQuery.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("gremlinTagFilterQuery={}", (Object)this.gremlinTagFilterQuery);
            }
        } else {
            this.tagGraphQueryWithAttributes = null;
            LinkedList<AtlasGraphQuery> orConditions = new LinkedList<AtlasGraphQuery>();
            if (classificationType == SearchContext.MATCH_ALL_WILDCARD_CLASSIFICATION || classificationType == SearchContext.MATCH_ALL_CLASSIFIED) {
                orConditions.add(graph.query().createChildQuery().has(Constants.TRAIT_NAMES_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.NOT_EQUAL, null));
                orConditions.add(graph.query().createChildQuery().has(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.NOT_EQUAL, null));
                this.entityGraphQueryTraitNames = graph.query().or(orConditions);
                this.entityPredicateTraitNames = PredicateUtils.orPredicate((Predicate)SearchPredicateUtil.getNotEmptyPredicateGenerator().generatePredicate(Constants.TRAIT_NAMES_PROPERTY_KEY, null, List.class), (Predicate)SearchPredicateUtil.getNotEmptyPredicateGenerator().generatePredicate(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, null, List.class));
            } else if (classificationType == SearchContext.MATCH_ALL_NOT_CLASSIFIED) {
                orConditions.add(graph.query().createChildQuery().has(Constants.GUID_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.NOT_EQUAL, null).has(Constants.ENTITY_TYPE_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.NOT_EQUAL, null).has(Constants.TRAIT_NAMES_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, null).has(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, null));
                this.entityGraphQueryTraitNames = graph.query().or(orConditions);
                this.entityPredicateTraitNames = PredicateUtils.andPredicate((Predicate)SearchPredicateUtil.getIsNullPredicateGenerator().generatePredicate(Constants.TRAIT_NAMES_PROPERTY_KEY, null, List.class), (Predicate)SearchPredicateUtil.getIsNullPredicateGenerator().generatePredicate(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, null, List.class));
            } else {
                orConditions.add(graph.query().createChildQuery().in(Constants.TRAIT_NAMES_PROPERTY_KEY, typeAndSubTypes));
                orConditions.add(graph.query().createChildQuery().in(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, typeAndSubTypes));
                this.entityGraphQueryTraitNames = graph.query().or(orConditions);
                this.entityPredicateTraitNames = PredicateUtils.orPredicate((Predicate)SearchPredicateUtil.getContainsAnyPredicateGenerator().generatePredicate(Constants.TRAIT_NAMES_PROPERTY_KEY, classificationType.getTypeAndAllSubTypes(), List.class), (Predicate)SearchPredicateUtil.getContainsAnyPredicateGenerator().generatePredicate(Constants.PROPAGATED_TRAIT_NAMES_PROPERTY_KEY, classificationType.getTypeAndAllSubTypes(), List.class));
            }
            if (context.getSearchParameters().getExcludeDeletedEntities()) {
                this.entityGraphQueryTraitNames.has(Constants.STATE_PROPERTY_KEY, (Object)"ACTIVE");
                Predicate activePredicate = SearchPredicateUtil.getEQPredicateGenerator().generatePredicate(Constants.STATE_PROPERTY_KEY, "ACTIVE", String.class);
                this.entityPredicateTraitNames = PredicateUtils.andPredicate((Predicate)this.entityPredicateTraitNames, (Predicate)activePredicate);
            }
            this.gremlinTagFilterQuery = null;
            this.gremlinQueryBindings = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public List<AtlasVertex> execute() {
        if (ClassificationSearchProcessor.LOG.isDebugEnabled()) {
            ClassificationSearchProcessor.LOG.debug("==> ClassificationSearchProcessor.execute({})", (Object)this.context);
        }
        ret = new ArrayList<AtlasVertex>();
        perf = null;
        if (AtlasPerfTracer.isPerfTraceEnabled((Logger)ClassificationSearchProcessor.PERF_LOG)) {
            perf = AtlasPerfTracer.getPerfTracer((Logger)ClassificationSearchProcessor.PERF_LOG, (String)("ClassificationSearchProcessor.execute(" + this.context + ")"));
        }
        try {
            startIdx = this.context.getSearchParameters().getOffset();
            limit = this.context.getSearchParameters().getLimit();
            activeOnly = this.context.getSearchParameters().getExcludeDeletedEntities();
            resultIdx = qryOffset = 0;
            processedGuids = new HashSet<String>();
            entityVertices = new ArrayList<AtlasVertex>();
            classificationVertices = new ArrayList<AtlasVertex>();
            while (ret.size() < limit) {
                entityVertices.clear();
                classificationVertices.clear();
                if (this.context.terminateSearch()) {
                    ClassificationSearchProcessor.LOG.warn("query terminated: {}", (Object)this.context.getSearchParameters());
                    ** break;
                }
                if (this.indexQuery != null) {
                    queryResult = this.indexQuery.vertices(qryOffset, limit);
                    this.getVerticesFromIndexQueryResult((Iterator<AtlasIndexQuery.Result>)queryResult, classificationVertices);
                    isLastResultPage = classificationVertices.size() < limit;
                    CollectionUtils.filter(classificationVertices, (Predicate)this.inMemoryPredicate);
                } else if (this.context.getSearchParameters().getTagFilters() == null) {
                    queryResult = this.entityGraphQueryTraitNames.vertices(qryOffset, limit).iterator();
                    this.getVertices(queryResult, entityVertices);
                    isLastResultPage = entityVertices.size() < limit;
                } else {
                    queryResult = this.tagGraphQueryWithAttributes.vertices(qryOffset, limit).iterator();
                    this.getVertices(queryResult, classificationVertices);
                    isLastResultPage = classificationVertices.size() < limit;
                    CollectionUtils.filter(classificationVertices, (Predicate)this.inMemoryPredicate);
                }
                if (CollectionUtils.isNotEmpty(classificationVertices)) {
                    for (AtlasVertex classificationVertex : classificationVertices) {
                        edges = classificationVertex.getEdges(AtlasEdgeDirection.IN);
                        for (AtlasEdge edge : edges) {
                            entityVertex = edge.getOutVertex();
                            if (activeOnly && AtlasGraphUtilsV2.getState((AtlasElement)entityVertex) != AtlasEntity.Status.ACTIVE || processedGuids.contains(guid = AtlasGraphUtilsV2.getIdFromVertex(entityVertex))) continue;
                            entityVertices.add(entityVertex);
                            processedGuids.add(guid);
                        }
                    }
                }
                super.filter(entityVertices);
                resultIdx = this.collectResultVertices(ret, startIdx, limit, resultIdx, entityVertices);
                if (isLastResultPage) ** break;
                qryOffset += limit;
            }
        }
        catch (Throwable var19_19) {
            AtlasPerfTracer.log(perf);
            throw var19_19;
        }
lbl60:
        // 3 sources

        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        if (ClassificationSearchProcessor.LOG.isDebugEnabled()) {
            ClassificationSearchProcessor.LOG.debug("<== ClassificationSearchProcessor.execute({}): ret.size()={}", (Object)this.context, (Object)ret.size());
        }
        return ret;
    }

    @Override
    public void filter(List<AtlasVertex> entityVertices) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> ClassificationSearchProcessor.filter({})", (Object)entityVertices.size());
        }
        if (this.gremlinTagFilterQuery != null && this.gremlinQueryBindings != null) {
            Set<String> guids = this.getGuids(entityVertices);
            entityVertices.clear();
            if (CollectionUtils.isNotEmpty(guids)) {
                this.gremlinQueryBindings.put("guids", guids);
                try {
                    AtlasGraph graph = this.context.getGraph();
                    ScriptEngine gremlinScriptEngine = graph.getGremlinScriptEngine();
                    List atlasVertices = (List)graph.executeGremlinScript(gremlinScriptEngine, this.gremlinQueryBindings, this.gremlinTagFilterQuery, false);
                    if (CollectionUtils.isNotEmpty((Collection)atlasVertices)) {
                        entityVertices.addAll(atlasVertices);
                    }
                }
                catch (ScriptException | AtlasBaseException e) {
                    LOG.warn(e.getMessage(), e);
                }
            }
        } else if (this.entityPredicateTraitNames != null) {
            CollectionUtils.filter(entityVertices, (Predicate)this.entityPredicateTraitNames);
        }
        super.filter(entityVertices);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== ClassificationSearchProcessor.filter(): ret.size()={}", (Object)entityVertices.size());
        }
    }
}

