/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.exception.NotFoundException;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GraphTransactionInterceptor
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(GraphTransactionInterceptor.class);
    @VisibleForTesting
    private static final ObjectUpdateSynchronizer OBJECT_UPDATE_SYNCHRONIZER = new ObjectUpdateSynchronizer();
    private static final ThreadLocal<List<PostTransactionHook>> postTransactionHooks = new ThreadLocal();
    private static final ThreadLocal<Boolean> isTxnOpen = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final ThreadLocal<Boolean> innerFailure = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final ThreadLocal<Map<String, AtlasVertex>> guidVertexCache = ThreadLocal.withInitial(() -> new HashMap());
    private final AtlasGraph graph;

    @Inject
    public GraphTransactionInterceptor(AtlasGraph graph) {
        this.graph = graph;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object object;
        Method method = invocation.getMethod();
        String invokingClass = method.getDeclaringClass().getSimpleName();
        String invokedMethodName = method.getName();
        boolean isInnerTxn = isTxnOpen.get();
        isTxnOpen.set(Boolean.TRUE);
        if (LOG.isDebugEnabled() && isInnerTxn) {
            LOG.debug("Txn entry-point {}.{} is inner txn. Commit/Rollback will be ignored", (Object)invokingClass, (Object)invokedMethodName);
        }
        boolean isSuccess = false;
        AtlasPerfMetrics.MetricRecorder metric = null;
        try {
            Object response = invocation.proceed();
            if (isInnerTxn) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring commit for nested/inner transaction {}.{}", (Object)invokingClass, (Object)invokedMethodName);
                }
            } else {
                metric = RequestContext.get().startMetricRecord("graphCommit");
                this.doCommitOrRollback(invokingClass, invokedMethodName);
            }
            isSuccess = innerFailure.get() == false;
            object = response;
        }
        catch (Throwable t) {
            try {
                if (isInnerTxn) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Ignoring rollback for nested/inner transaction {}.{}", (Object)invokingClass, (Object)invokedMethodName);
                    }
                    innerFailure.set(true);
                } else {
                    this.doRollback(t);
                }
                throw t;
            }
            catch (Throwable throwable) {
                RequestContext.get().endMetricRecord(metric);
                if (!isInnerTxn) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Closing outer txn");
                    }
                    isTxnOpen.set(Boolean.FALSE);
                    innerFailure.set(Boolean.FALSE);
                    guidVertexCache.get().clear();
                    List<PostTransactionHook> trxHooks = postTransactionHooks.get();
                    if (trxHooks != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Processing post-txn hooks");
                        }
                        postTransactionHooks.remove();
                        for (PostTransactionHook trxHook : trxHooks) {
                            try {
                                trxHook.onComplete(isSuccess);
                            }
                            catch (Throwable t2) {
                                LOG.error("postTransactionHook failed", t2);
                            }
                        }
                    }
                }
                OBJECT_UPDATE_SYNCHRONIZER.releaseLockedObjects();
                throw throwable;
            }
        }
        RequestContext.get().endMetricRecord(metric);
        if (!isInnerTxn) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing outer txn");
            }
            isTxnOpen.set(Boolean.FALSE);
            innerFailure.set(Boolean.FALSE);
            guidVertexCache.get().clear();
            List<PostTransactionHook> trxHooks = postTransactionHooks.get();
            if (trxHooks != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Processing post-txn hooks");
                }
                postTransactionHooks.remove();
                for (PostTransactionHook trxHook : trxHooks) {
                    try {
                        trxHook.onComplete(isSuccess);
                    }
                    catch (Throwable t) {
                        LOG.error("postTransactionHook failed", t);
                    }
                }
            }
        }
        OBJECT_UPDATE_SYNCHRONIZER.releaseLockedObjects();
        return object;
    }

    private void doCommitOrRollback(String invokingClass, String invokedMethodName) {
        if (innerFailure.get().booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Inner/Nested call threw exception. Rollback on txn entry-point, {}.{}", (Object)invokingClass, (Object)invokedMethodName);
            }
            this.graph.rollback();
        } else {
            this.doCommit(invokingClass, invokedMethodName);
        }
    }

    private void doCommit(String invokingClass, String invokedMethodName) {
        this.graph.commit();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Graph commit txn {}.{}", (Object)invokingClass, (Object)invokedMethodName);
        }
    }

    private void doRollback(Throwable t) {
        if (this.logException(t)) {
            LOG.error("graph rollback due to exception ", t);
        } else {
            LOG.error("graph rollback due to exception {}:{}", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
        }
        this.graph.rollback();
    }

    public static void lockObjectAndReleasePostCommit(String guid) {
        GraphTransactionInterceptor.OBJECT_UPDATE_SYNCHRONIZER.lockObject(guid);
    }

    public static void lockObjectAndReleasePostCommit(List<String> guids) {
        OBJECT_UPDATE_SYNCHRONIZER.lockObject(guids);
    }

    public static void addToVertexCache(String guid, AtlasVertex vertex) {
        Map<String, AtlasVertex> cache = guidVertexCache.get();
        cache.put(guid, vertex);
    }

    public static void removeFromVertexCache(String guid) {
        Map<String, AtlasVertex> cache = guidVertexCache.get();
        cache.remove(guid);
    }

    public static AtlasVertex getVertexFromCache(String guid) {
        Map<String, AtlasVertex> cache = guidVertexCache.get();
        return cache.get(guid);
    }

    boolean logException(Throwable t) {
        if (t instanceof AtlasBaseException) {
            Response.Status httpCode = ((AtlasBaseException)t).getAtlasErrorCode().getHttpCode();
            return httpCode != Response.Status.NOT_FOUND && httpCode != Response.Status.NO_CONTENT;
        }
        return !(t instanceof NotFoundException);
    }

    public static class ObjectUpdateSynchronizer {
        private final Map<String, RefCountedReentrantLock> guidLockMap = new ConcurrentHashMap<String, RefCountedReentrantLock>();
        private final ThreadLocal<List<String>> lockedGuids = new ThreadLocal<List<String>>(){

            @Override
            protected List<String> initialValue() {
                return new ArrayList<String>();
            }
        };

        public void lockObject(List<String> guids) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> lockObject(): guids: {}", guids);
            }
            Collections.sort(guids);
            for (String g : guids) {
                this.lockObject(g);
            }
        }

        private void lockObject(String guid) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> lockObject(): guid: {}, guidLockMap.size: {}", (Object)guid, (Object)this.guidLockMap.size());
            }
            RefCountedReentrantLock lock = this.getOrCreateObjectLock(guid);
            lock.lock();
            this.lockedGuids.get().add(guid);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== lockObject(): guid: {}, guidLockMap.size: {}", (Object)guid, (Object)this.guidLockMap.size());
            }
        }

        public void releaseLockedObjects() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> releaseLockedObjects(): lockedGuids.size: {}", (Object)this.lockedGuids.get().size());
            }
            for (String guid : this.lockedGuids.get()) {
                this.releaseObjectLock(guid);
            }
            this.lockedGuids.get().clear();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== releaseLockedObjects(): lockedGuids.size: {}", (Object)this.lockedGuids.get().size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RefCountedReentrantLock getOrCreateObjectLock(String guid) {
            Map<String, RefCountedReentrantLock> map = this.guidLockMap;
            synchronized (map) {
                RefCountedReentrantLock ret = this.guidLockMap.get(guid);
                if (ret == null) {
                    ret = new RefCountedReentrantLock();
                    this.guidLockMap.put(guid, ret);
                }
                ret.increment();
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RefCountedReentrantLock releaseObjectLock(String guid) {
            Map<String, RefCountedReentrantLock> map = this.guidLockMap;
            synchronized (map) {
                RefCountedReentrantLock lock = this.guidLockMap.get(guid);
                if (lock != null && lock.isHeldByCurrentThread()) {
                    int refCount = lock.decrement();
                    if (refCount == 0) {
                        this.guidLockMap.remove(guid);
                    }
                    lock.unlock();
                } else {
                    LOG.warn("releaseLockedObjects: {} Attempting to release a lock not held by current thread.", (Object)guid);
                }
                return lock;
            }
        }
    }

    private static class RefCountedReentrantLock
    extends ReentrantLock {
        private int refCount = 0;

        public int increment() {
            return ++this.refCount;
        }

        public int decrement() {
            return --this.refCount;
        }

        public int getRefCount() {
            return this.refCount;
        }
    }

    public static abstract class PostTransactionHook {
        protected PostTransactionHook() {
            ArrayList<PostTransactionHook> trxHooks = (ArrayList<PostTransactionHook>)postTransactionHooks.get();
            if (trxHooks == null) {
                trxHooks = new ArrayList<PostTransactionHook>();
                postTransactionHooks.set(trxHooks);
            }
            trxHooks.add(this);
        }

        public abstract void onComplete(boolean var1);
    }
}

