/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.types.pojo;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Test;

public class TestSchema {
    private static Field field(String name, boolean nullable, ArrowType type, Field ... children) {
        return new Field(name, new FieldType(nullable, type, null, null), Arrays.asList(children));
    }

    private static Field field(String name, ArrowType type, Field ... children) {
        return TestSchema.field(name, true, type, children);
    }

    @Test
    public void testComplex() throws IOException {
        Schema schema = new Schema(Arrays.asList(TestSchema.field("a", false, (ArrowType)new ArrowType.Int(8, true), new Field[0]), TestSchema.field("b", (ArrowType)new ArrowType.Struct(), TestSchema.field("c", (ArrowType)new ArrowType.Int(16, true), new Field[0]), TestSchema.field("d", (ArrowType)new ArrowType.Utf8(), new Field[0])), TestSchema.field("e", (ArrowType)new ArrowType.List(), TestSchema.field(null, (ArrowType)new ArrowType.Date(DateUnit.MILLISECOND), new Field[0])), TestSchema.field("f", (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), new Field[0]), TestSchema.field("g", (ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "UTC"), new Field[0]), TestSchema.field("h", (ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null), new Field[0]), TestSchema.field("i", (ArrowType)new ArrowType.Interval(IntervalUnit.DAY_TIME), new Field[0])));
        this.roundTrip(schema);
        Assert.assertEquals((Object)"Schema<a: Int(8, true) not null, b: Struct<c: Int(16, true), d: Utf8>, e: List<Date(MILLISECOND)>, f: FloatingPoint(SINGLE), g: Timestamp(MILLISECOND, UTC), h: Timestamp(MICROSECOND, null), i: Interval(DAY_TIME)>", (Object)schema.toString());
    }

    @Test
    public void testAll() throws IOException {
        Schema schema = new Schema(Arrays.asList(TestSchema.field("a", false, (ArrowType)new ArrowType.Null(), new Field[0]), TestSchema.field("b", (ArrowType)new ArrowType.Struct(), TestSchema.field("ba", (ArrowType)new ArrowType.Null(), new Field[0])), TestSchema.field("c", (ArrowType)new ArrowType.List(), TestSchema.field("ca", (ArrowType)new ArrowType.Null(), new Field[0])), TestSchema.field("d", (ArrowType)new ArrowType.Union(UnionMode.Sparse, new int[]{1, 2, 3}), TestSchema.field("da", (ArrowType)new ArrowType.Null(), new Field[0])), TestSchema.field("e", (ArrowType)new ArrowType.Int(8, true), new Field[0]), TestSchema.field("f", (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), new Field[0]), TestSchema.field("g", (ArrowType)new ArrowType.Utf8(), new Field[0]), TestSchema.field("h", (ArrowType)new ArrowType.Binary(), new Field[0]), TestSchema.field("i", (ArrowType)new ArrowType.Bool(), new Field[0]), TestSchema.field("j", (ArrowType)new ArrowType.Decimal(5, 5), new Field[0]), TestSchema.field("k", (ArrowType)new ArrowType.Date(DateUnit.DAY), new Field[0]), TestSchema.field("l", (ArrowType)new ArrowType.Date(DateUnit.MILLISECOND), new Field[0]), TestSchema.field("m", (ArrowType)new ArrowType.Time(TimeUnit.SECOND, 32), new Field[0]), TestSchema.field("n", (ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32), new Field[0]), TestSchema.field("o", (ArrowType)new ArrowType.Time(TimeUnit.MICROSECOND, 64), new Field[0]), TestSchema.field("p", (ArrowType)new ArrowType.Time(TimeUnit.NANOSECOND, 64), new Field[0]), TestSchema.field("q", (ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "UTC"), new Field[0]), TestSchema.field("r", (ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null), new Field[0]), TestSchema.field("s", (ArrowType)new ArrowType.Interval(IntervalUnit.DAY_TIME), new Field[0])));
        this.roundTrip(schema);
    }

    @Test
    public void testUnion() throws IOException {
        Schema schema = new Schema(Arrays.asList(TestSchema.field("d", (ArrowType)new ArrowType.Union(UnionMode.Sparse, new int[]{1, 2, 3}), TestSchema.field("da", (ArrowType)new ArrowType.Null(), new Field[0]))));
        this.roundTrip(schema);
        this.contains(schema, "Sparse");
    }

    @Test
    public void testDate() throws IOException {
        Schema schema = new Schema(Arrays.asList(TestSchema.field("a", (ArrowType)new ArrowType.Date(DateUnit.DAY), new Field[0]), TestSchema.field("b", (ArrowType)new ArrowType.Date(DateUnit.MILLISECOND), new Field[0])));
        this.roundTrip(schema);
        Assert.assertEquals((Object)"Schema<a: Date(DAY), b: Date(MILLISECOND)>", (Object)schema.toString());
    }

    @Test
    public void testTime() throws IOException {
        Schema schema = new Schema(Arrays.asList(TestSchema.field("a", (ArrowType)new ArrowType.Time(TimeUnit.SECOND, 32), new Field[0]), TestSchema.field("b", (ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32), new Field[0]), TestSchema.field("c", (ArrowType)new ArrowType.Time(TimeUnit.MICROSECOND, 64), new Field[0]), TestSchema.field("d", (ArrowType)new ArrowType.Time(TimeUnit.NANOSECOND, 64), new Field[0])));
        this.roundTrip(schema);
        Assert.assertEquals((Object)"Schema<a: Time(SECOND, 32), b: Time(MILLISECOND, 32), c: Time(MICROSECOND, 64), d: Time(NANOSECOND, 64)>", (Object)schema.toString());
    }

    @Test
    public void testTS() throws IOException {
        Schema schema = new Schema(Arrays.asList(TestSchema.field("a", (ArrowType)new ArrowType.Timestamp(TimeUnit.SECOND, "UTC"), new Field[0]), TestSchema.field("b", (ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "UTC"), new Field[0]), TestSchema.field("c", (ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, "UTC"), new Field[0]), TestSchema.field("d", (ArrowType)new ArrowType.Timestamp(TimeUnit.NANOSECOND, "UTC"), new Field[0]), TestSchema.field("e", (ArrowType)new ArrowType.Timestamp(TimeUnit.SECOND, null), new Field[0]), TestSchema.field("f", (ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null), new Field[0]), TestSchema.field("g", (ArrowType)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null), new Field[0]), TestSchema.field("h", (ArrowType)new ArrowType.Timestamp(TimeUnit.NANOSECOND, null), new Field[0])));
        this.roundTrip(schema);
        Assert.assertEquals((Object)"Schema<a: Timestamp(SECOND, UTC), b: Timestamp(MILLISECOND, UTC), c: Timestamp(MICROSECOND, UTC), d: Timestamp(NANOSECOND, UTC), e: Timestamp(SECOND, null), f: Timestamp(MILLISECOND, null), g: Timestamp(MICROSECOND, null), h: Timestamp(NANOSECOND, null)>", (Object)schema.toString());
    }

    @Test
    public void testInterval() throws IOException {
        Schema schema = new Schema(Arrays.asList(TestSchema.field("a", (ArrowType)new ArrowType.Interval(IntervalUnit.YEAR_MONTH), new Field[0]), TestSchema.field("b", (ArrowType)new ArrowType.Interval(IntervalUnit.DAY_TIME), new Field[0])));
        this.roundTrip(schema);
        this.contains(schema, "YEAR_MONTH", "DAY_TIME");
    }

    @Test
    public void testFP() throws IOException {
        Schema schema = new Schema(Arrays.asList(TestSchema.field("a", (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.HALF), new Field[0]), TestSchema.field("b", (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), new Field[0]), TestSchema.field("c", (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), new Field[0])));
        this.roundTrip(schema);
        this.contains(schema, "HALF", "SINGLE", "DOUBLE");
    }

    private void roundTrip(Schema schema) throws IOException {
        String json = schema.toJson();
        Schema actual = Schema.fromJSON((String)json);
        Assert.assertEquals((Object)schema.toJson(), (Object)actual.toJson());
        Assert.assertEquals((Object)schema, (Object)actual);
        this.validateFieldsHashcode(schema.getFields(), actual.getFields());
        Assert.assertEquals((long)schema.hashCode(), (long)actual.hashCode());
    }

    private void validateFieldsHashcode(List<Field> schemaFields, List<Field> actualFields) {
        Assert.assertEquals((long)schemaFields.size(), (long)actualFields.size());
        if (schemaFields.size() == 0) {
            return;
        }
        for (int i = 0; i < schemaFields.size(); ++i) {
            Field schemaField = schemaFields.get(i);
            Field actualField = actualFields.get(i);
            this.validateFieldsHashcode(schemaField.getChildren(), actualField.getChildren());
            this.validateHashCode(schemaField.getType(), actualField.getType());
            this.validateHashCode(schemaField, actualField);
        }
    }

    private void validateHashCode(Object o1, Object o2) {
        Assert.assertEquals((Object)o1, (Object)o2);
        Assert.assertEquals((String)(o1 + " == " + o2), (long)o1.hashCode(), (long)o2.hashCode());
    }

    private void contains(Schema schema, String ... s) throws IOException {
        String json = schema.toJson();
        for (String string : s) {
            Assert.assertTrue((String)(json + " contains " + string), (boolean)json.contains(string));
        }
    }
}

