/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.stream;

import io.netty.buffer.ArrowBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.file.ArrowBlock;
import org.apache.arrow.vector.file.ReadChannel;
import org.apache.arrow.vector.file.WriteChannel;
import org.apache.arrow.vector.schema.ArrowFieldNode;
import org.apache.arrow.vector.schema.ArrowMessage;
import org.apache.arrow.vector.schema.ArrowRecordBatch;
import org.apache.arrow.vector.stream.MessageSerializer;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MessageSerializerTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    public static ArrowBuf buf(BufferAllocator alloc, byte[] bytes) {
        ArrowBuf buffer = alloc.buffer(bytes.length);
        buffer.writeBytes(bytes);
        return buffer;
    }

    public static byte[] array(ArrowBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return bytes;
    }

    @Test
    public void testSchemaMessageSerialization() throws IOException {
        Schema schema = MessageSerializerTest.testSchema();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        long size = MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(out)), (Schema)schema);
        Assert.assertEquals((long)size, (long)out.toByteArray().length);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Schema deserialized = MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel(Channels.newChannel(in)));
        Assert.assertEquals((Object)schema, (Object)deserialized);
        Assert.assertEquals((long)1L, (long)deserialized.getFields().size());
    }

    @Test
    public void testSchemaDictionaryMessageSerialization() throws IOException {
        DictionaryEncoding dictionary = new DictionaryEncoding(9L, false, new ArrowType.Int(8, true));
        Field field = new Field("test", new FieldType(true, (ArrowType)ArrowType.Utf8.INSTANCE, dictionary, null), null);
        Schema schema = new Schema(Collections.singletonList(field));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        long size = MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(out)), (Schema)schema);
        Assert.assertEquals((long)size, (long)out.toByteArray().length);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Schema deserialized = MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel(Channels.newChannel(in)));
        Assert.assertEquals((Object)schema, (Object)deserialized);
    }

    @Test
    public void testdeSerializeRecordBatchLongMetaData() throws IOException {
        this.expectedEx.expect(IOException.class);
        this.expectedEx.expectMessage("Cannot currently deserialize record batches over 2GB");
        int offset = 0;
        int metadataLength = 1;
        long bodyLength = 0x80000009L;
        ArrowBlock block = new ArrowBlock((long)offset, metadataLength, bodyLength);
        long totalLen = (long)block.getMetadataLength() + block.getBodyLength();
        MessageSerializer.deserializeRecordBatch(null, (ArrowBlock)block, null);
    }

    @Test
    public void testSerializeRecordBatch() throws IOException {
        byte[] validity = new byte[]{-1, 0};
        byte[] values = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        RootAllocator alloc = new RootAllocator(Long.MAX_VALUE);
        ArrowBuf validityb = MessageSerializerTest.buf((BufferAllocator)alloc, validity);
        ArrowBuf valuesb = MessageSerializerTest.buf((BufferAllocator)alloc, values);
        ArrowRecordBatch batch = new ArrowRecordBatch(16, Arrays.asList(new ArrowFieldNode(16, 8)), Arrays.asList(validityb, valuesb));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(out)), (ArrowRecordBatch)batch);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ReadChannel channel = new ReadChannel(Channels.newChannel(in));
        ArrowMessage deserialized = MessageSerializer.deserializeMessageBatch((ReadChannel)channel, (BufferAllocator)alloc);
        Assert.assertEquals(ArrowRecordBatch.class, deserialized.getClass());
        MessageSerializerTest.verifyBatch((ArrowRecordBatch)deserialized, validity, values);
    }

    public static Schema testSchema() {
        return new Schema(Arrays.asList(new Field("testField", FieldType.nullable((ArrowType)new ArrowType.Int(8, true)), Collections.emptyList())));
    }

    public static void verifyBatch(ArrowRecordBatch batch, byte[] validity, byte[] values) {
        Assert.assertTrue((batch != null ? 1 : 0) != 0);
        List nodes = batch.getNodes();
        Assert.assertEquals((long)1L, (long)nodes.size());
        ArrowFieldNode node = (ArrowFieldNode)nodes.get(0);
        Assert.assertEquals((long)16L, (long)node.getLength());
        Assert.assertEquals((long)8L, (long)node.getNullCount());
        List buffers = batch.getBuffers();
        Assert.assertEquals((long)2L, (long)buffers.size());
        Assert.assertArrayEquals((byte[])validity, (byte[])MessageSerializerTest.array((ArrowBuf)buffers.get(0)));
        Assert.assertArrayEquals((byte[])values, (byte[])MessageSerializerTest.array((ArrowBuf)buffers.get(1)));
    }
}

