/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.pojo;

import com.google.common.collect.ImmutableList;
import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import org.apache.arrow.flatbuf.Schema;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.Assert;
import org.junit.Test;

public class TestConvert {
    @Test
    public void simple() {
        Field initialField = new Field("a", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null);
        this.run(initialField);
    }

    @Test
    public void complex() {
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        childrenBuilder.add((Object)new Field("child1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), null));
        childrenBuilder.add((Object)new Field("child2", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), (List)ImmutableList.of()));
        Field initialField = new Field("a", FieldType.nullable((ArrowType)ArrowType.Struct.INSTANCE), (List)childrenBuilder.build());
        this.run(initialField);
    }

    @Test
    public void schema() {
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        childrenBuilder.add((Object)new Field("child1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), null));
        childrenBuilder.add((Object)new Field("child2", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), (List)ImmutableList.of()));
        org.apache.arrow.vector.types.pojo.Schema initialSchema = new org.apache.arrow.vector.types.pojo.Schema((Iterable)childrenBuilder.build());
        this.run(initialSchema);
    }

    @Test
    public void schemaMetadata() {
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        childrenBuilder.add((Object)new Field("child1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), null));
        childrenBuilder.add((Object)new Field("child2", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), (List)ImmutableList.of()));
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("key1", "value1");
        metadata.put("key2", "value2");
        org.apache.arrow.vector.types.pojo.Schema initialSchema = new org.apache.arrow.vector.types.pojo.Schema((Iterable)childrenBuilder.build(), metadata);
        this.run(initialSchema);
    }

    @Test
    public void nestedSchema() {
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        childrenBuilder.add((Object)new Field("child1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), null));
        childrenBuilder.add((Object)new Field("child2", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), (List)ImmutableList.of()));
        childrenBuilder.add((Object)new Field("child3", FieldType.nullable((ArrowType)new ArrowType.Struct()), (List)ImmutableList.of((Object)new Field("child3.1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), null), (Object)new Field("child3.2", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)), (List)ImmutableList.of()))));
        childrenBuilder.add((Object)new Field("child4", FieldType.nullable((ArrowType)new ArrowType.List()), (List)ImmutableList.of((Object)new Field("child4.1", FieldType.nullable((ArrowType)ArrowType.Utf8.INSTANCE), null))));
        childrenBuilder.add((Object)new Field("child5", FieldType.nullable((ArrowType)new ArrowType.Union(UnionMode.Sparse, new int[]{Types.MinorType.TIMESTAMPMILLI.ordinal(), Types.MinorType.FLOAT8.ordinal()})), (List)ImmutableList.of((Object)new Field("child5.1", FieldType.nullable((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null)), null), (Object)new Field("child5.2", FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)), (List)ImmutableList.of()), (Object)new Field("child5.3", true, (ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, "UTC"), null))));
        org.apache.arrow.vector.types.pojo.Schema initialSchema = new org.apache.arrow.vector.types.pojo.Schema((Iterable)childrenBuilder.build());
        this.run(initialSchema);
    }

    private void run(Field initialField) {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        builder.finish(initialField.getField(builder));
        org.apache.arrow.flatbuf.Field flatBufField = org.apache.arrow.flatbuf.Field.getRootAsField((ByteBuffer)builder.dataBuffer());
        Field finalField = Field.convertField((org.apache.arrow.flatbuf.Field)flatBufField);
        Assert.assertEquals((Object)initialField, (Object)finalField);
    }

    private void run(org.apache.arrow.vector.types.pojo.Schema initialSchema) {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        builder.finish(initialSchema.getSchema(builder));
        Schema flatBufSchema = Schema.getRootAsSchema((ByteBuffer)builder.dataBuffer());
        org.apache.arrow.vector.types.pojo.Schema finalSchema = org.apache.arrow.vector.types.pojo.Schema.convertSchema((Schema)flatBufSchema);
        Assert.assertEquals((Object)initialSchema, (Object)finalSchema);
    }
}

