/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.file.json;

import java.io.File;
import java.io.IOException;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.NullableMapVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.file.BaseFileTest;
import org.apache.arrow.vector.file.json.JsonFileReader;
import org.apache.arrow.vector.file.json.JsonFileWriter;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestJSONFile
extends BaseFileTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestJSONFile.class);

    @Test
    public void testWriteReadComplexJSON() throws IOException {
        File file = new File("target/mytest_complex.json");
        int count = 10;
        try (BufferAllocator originalVectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             MapVector parent = MapVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
            this.writeComplexData(count, parent);
            this.writeJSON(file, new VectorSchemaRoot(parent.getChild("root")), null);
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            JsonFileReader reader = new JsonFileReader(file, readerAllocator);
            Schema schema = reader.start();
            LOGGER.debug("reading schema: " + schema);
            try (VectorSchemaRoot root = reader.read();){
                this.validateComplexContent(count, root);
            }
            reader.close();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testWriteComplexJSON() throws IOException {
        File file = new File("target/mytest_write_complex.json");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             NullableMapVector parent = NullableMapVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
            this.writeComplexData(count, (MapVector)parent);
            VectorSchemaRoot root = new VectorSchemaRoot(parent.getChild("root"));
            this.validateComplexContent(root.getRowCount(), root);
            this.writeJSON(file, root, null);
        }
    }

    public void writeJSON(File file, VectorSchemaRoot root, DictionaryProvider provider) throws IOException {
        JsonFileWriter writer = new JsonFileWriter(file, JsonFileWriter.config().pretty(true));
        writer.start(root.getSchema(), provider);
        writer.write(root);
        writer.close();
    }

    @Test
    public void testWriteReadUnionJSON() throws IOException {
        Throwable throwable;
        File file = new File("target/mytest_write_union.json");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (NullableMapVector parent = NullableMapVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
                this.writeUnionData(count, parent);
                this.printVectors(parent.getChildrenFromFields());
                VectorSchemaRoot root = new VectorSchemaRoot(parent.getChild("root"));
                this.validateUnionData(count, root);
                this.writeJSON(file, root, null);
            }
            catch (Throwable root) {
                throwable = root;
                throw root;
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable = null;
            try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("final vectors", 0L, Integer.MAX_VALUE);){
                JsonFileReader reader = new JsonFileReader(file, readerAllocator);
                Schema schema = reader.start();
                LOGGER.debug("reading schema: " + schema);
                try (VectorSchemaRoot root = reader.read();){
                    this.validateUnionData(count, root);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var4_4 = throwable3;
            throw throwable3;
        }
    }

    @Test
    public void testWriteReadDateTimeJSON() throws IOException {
        VectorSchemaRoot root;
        File file = new File("target/mytest_datetime.json");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             NullableMapVector parent = NullableMapVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
            this.writeDateTimeData(count, parent);
            this.printVectors(parent.getChildrenFromFields());
            root = new VectorSchemaRoot(parent.getChild("root"));
            this.validateDateTimeContent(count, root);
            this.writeJSON(file, new VectorSchemaRoot(parent.getChild("root")), null);
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            JsonFileReader reader = new JsonFileReader(file, readerAllocator);
            Schema schema = reader.start();
            LOGGER.debug("reading schema: " + schema);
            root = reader.read();
            Throwable throwable = null;
            try {
                this.validateDateTimeContent(count, root);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (root != null) {
                    if (throwable != null) {
                        try {
                            root.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        root.close();
                    }
                }
            }
            reader.close();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testWriteReadDictionaryJSON() throws IOException {
        File file = new File("target/mytest_dictionary.json");
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
            try (Object root = this.writeFlatDictionaryData(vectorAllocator, provider);){
                this.printVectors(root.getFieldVectors());
                this.validateFlatDictionary((VectorSchemaRoot)root, (DictionaryProvider)provider);
                this.writeJSON(file, (VectorSchemaRoot)root, (DictionaryProvider)provider);
            }
            root = provider.getDictionaryIds().iterator();
            while (root.hasNext()) {
                long id = (Long)root.next();
                provider.lookup(id).getVector().close();
            }
        }
        var3_3 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            JsonFileReader reader = new JsonFileReader(file, readerAllocator);
            Schema schema = reader.start();
            LOGGER.debug("reading schema: " + schema);
            try (VectorSchemaRoot root = reader.read();){
                this.validateFlatDictionary(root, (DictionaryProvider)reader);
            }
            reader.close();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testWriteReadNestedDictionaryJSON() throws IOException {
        File file = new File("target/mytest_dict_nested.json");
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
            try (Object root = this.writeNestedDictionaryData(vectorAllocator, provider);){
                this.printVectors(root.getFieldVectors());
                this.validateNestedDictionary((VectorSchemaRoot)root, (DictionaryProvider)provider);
                this.writeJSON(file, (VectorSchemaRoot)root, (DictionaryProvider)provider);
            }
            root = provider.getDictionaryIds().iterator();
            while (root.hasNext()) {
                long id = (Long)root.next();
                provider.lookup(id).getVector().close();
            }
        }
        var3_3 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            JsonFileReader reader = new JsonFileReader(file, readerAllocator);
            Schema schema = reader.start();
            LOGGER.debug("reading schema: " + schema);
            try (VectorSchemaRoot root = reader.read();){
                this.validateNestedDictionary(root, (DictionaryProvider)reader);
            }
            reader.close();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSetStructLength() throws IOException {
        File file = new File("../../integration/data/struct_example.json");
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            JsonFileReader reader = new JsonFileReader(file, readerAllocator);
            Schema schema = reader.start();
            LOGGER.debug("reading schema: " + schema);
            try (VectorSchemaRoot root = reader.read();){
                FieldVector vector = root.getVector("struct_nullable");
                Assert.assertEquals((long)7L, (long)vector.getAccessor().getValueCount());
            }
        }
    }
}

