/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.NullableTinyIntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.file.BaseFileTest;
import org.apache.arrow.vector.stream.ArrowStreamReader;
import org.apache.arrow.vector.stream.ArrowStreamWriter;
import org.apache.arrow.vector.stream.MessageSerializerTest;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Test;

public class TestArrowStream
extends BaseFileTest {
    @Test
    public void testEmptyStream() throws IOException {
        Schema schema = MessageSerializerTest.testSchema();
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArrowStreamWriter writer = new ArrowStreamWriter(root, null, (OutputStream)out);
        Throwable throwable = null;
        if (writer != null) {
            if (throwable != null) {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                writer.close();
            }
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        try (ArrowStreamReader reader = new ArrowStreamReader((InputStream)in, this.allocator);){
            Assert.assertEquals((Object)schema, (Object)reader.getVectorSchemaRoot().getSchema());
            Assert.assertFalse((boolean)reader.loadNextBatch());
            Assert.assertEquals((long)0L, (long)reader.getVectorSchemaRoot().getRowCount());
            Assert.assertFalse((boolean)reader.loadNextBatch());
            Assert.assertEquals((long)0L, (long)reader.getVectorSchemaRoot().getRowCount());
        }
    }

    @Test
    public void testReadWrite() throws IOException {
        Schema schema = MessageSerializerTest.testSchema();
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator);){
            int numBatches = 1;
            ((FieldVector)root.getFieldVectors().get(0)).allocateNew();
            NullableTinyIntVector.Mutator mutator = (NullableTinyIntVector.Mutator)((FieldVector)root.getFieldVectors().get(0)).getMutator();
            for (int i = 0; i < 16; ++i) {
                mutator.set(i, i < 8 ? 1 : 0, (byte)(i + 1));
            }
            mutator.setValueCount(16);
            root.setRowCount(16);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            long bytesWritten = 0L;
            try (ArrowStreamWriter writer = new ArrowStreamWriter(root, null, (OutputStream)out);){
                writer.start();
                for (int i = 0; i < numBatches; ++i) {
                    writer.writeBatch();
                }
                writer.end();
                bytesWritten = writer.bytesWritten();
            }
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            try (ArrowStreamReader reader = new ArrowStreamReader((InputStream)in, this.allocator);){
                Schema readSchema = reader.getVectorSchemaRoot().getSchema();
                Assert.assertEquals((Object)schema, (Object)readSchema);
                for (int i = 0; i < numBatches; ++i) {
                    Assert.assertTrue((boolean)reader.loadNextBatch());
                }
                Assert.assertEquals((long)bytesWritten, (long)(reader.bytesRead() + 4L));
                Assert.assertFalse((boolean)reader.loadNextBatch());
                Assert.assertEquals((long)0L, (long)reader.getVectorSchemaRoot().getRowCount());
            }
        }
    }
}

