/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.file;

import com.google.flatbuffers.Table;
import io.netty.buffer.ArrowBuf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.flatbuf.FieldNode;
import org.apache.arrow.flatbuf.Message;
import org.apache.arrow.flatbuf.RecordBatch;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.TestUtils;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.file.ArrowBlock;
import org.apache.arrow.vector.file.ArrowFileReader;
import org.apache.arrow.vector.file.ArrowFileWriter;
import org.apache.arrow.vector.file.SeekableReadChannel;
import org.apache.arrow.vector.schema.ArrowFieldNode;
import org.apache.arrow.vector.schema.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestArrowReaderWriter {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    ArrowBuf buf(byte[] bytes) {
        ArrowBuf buffer = this.allocator.buffer(bytes.length);
        buffer.writeBytes(bytes);
        return buffer;
    }

    byte[] array(ArrowBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return bytes;
    }

    @Test
    public void test() throws IOException {
        Throwable throwable;
        Schema schema = new Schema(Arrays.asList(new Field("testField", FieldType.nullable((ArrowType)new ArrowType.Int(8, true)), Collections.emptyList())));
        ArrowType type = ((Field)schema.getFields().get(0)).getType();
        FieldVector vector = TestUtils.newVector(FieldVector.class, "testField", type, this.allocator);
        vector.initializeChildrenFromFields(((Field)schema.getFields().get(0)).getChildren());
        byte[] validity = new byte[]{-1, 0};
        byte[] values = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (VectorSchemaRoot root = new VectorSchemaRoot(schema.getFields(), Arrays.asList(vector), 16);){
            throwable = null;
            try (ArrowFileWriter writer = new ArrowFileWriter(root, null, Channels.newChannel(out));){
                ArrowBuf validityb = this.buf(validity);
                ArrowBuf valuesb = this.buf(values);
                writer.writeRecordBatch(new ArrowRecordBatch(16, Arrays.asList(new ArrowFieldNode(16, 8)), Arrays.asList(validityb, valuesb)));
            }
            catch (Throwable validityb) {
                throwable = validityb;
                throw validityb;
            }
        }
        byte[] byteArray = out.toByteArray();
        SeekableReadChannel channel = new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(byteArray));
        throwable = null;
        try (ArrowFileReader reader = new ArrowFileReader(channel, this.allocator);){
            Schema readSchema = reader.getVectorSchemaRoot().getSchema();
            Assert.assertEquals((Object)schema, (Object)readSchema);
            Assert.assertTrue((String)((Field)readSchema.getFields().get(0)).getTypeLayout().getVectorTypes().toString(), (((Field)readSchema.getFields().get(0)).getTypeLayout().getVectors().size() > 0 ? 1 : 0) != 0);
            List recordBatches = reader.getRecordBlocks();
            Assert.assertEquals((long)1L, (long)recordBatches.size());
            ArrowRecordBatch recordBatch = (ArrowRecordBatch)reader.readMessage(channel, this.allocator);
            List nodes = recordBatch.getNodes();
            Assert.assertEquals((long)1L, (long)nodes.size());
            ArrowFieldNode node = (ArrowFieldNode)nodes.get(0);
            Assert.assertEquals((long)16L, (long)node.getLength());
            Assert.assertEquals((long)8L, (long)node.getNullCount());
            List buffers = recordBatch.getBuffers();
            Assert.assertEquals((long)2L, (long)buffers.size());
            Assert.assertArrayEquals((byte[])validity, (byte[])this.array((ArrowBuf)buffers.get(0)));
            Assert.assertArrayEquals((byte[])values, (byte[])this.array((ArrowBuf)buffers.get(1)));
            ByteBuffer headerBuffer = ByteBuffer.allocate(((ArrowBlock)recordBatches.get(0)).getMetadataLength());
            headerBuffer.put(byteArray, (int)((ArrowBlock)recordBatches.get(0)).getOffset(), headerBuffer.capacity());
            headerBuffer.position(4);
            Message messageFB = Message.getRootAsMessage((ByteBuffer)headerBuffer);
            RecordBatch recordBatchFB = (RecordBatch)messageFB.header((Table)new RecordBatch());
            Assert.assertEquals((long)2L, (long)recordBatchFB.buffersLength());
            Assert.assertEquals((long)1L, (long)recordBatchFB.nodesLength());
            FieldNode nodeFB = recordBatchFB.nodes(0);
            Assert.assertEquals((long)16L, (long)nodeFB.length());
            Assert.assertEquals((long)8L, (long)nodeFB.nullCount());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }
}

