/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.file;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.NullableFloat4Vector;
import org.apache.arrow.vector.NullableIntVector;
import org.apache.arrow.vector.NullableTinyIntVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.NullableMapVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.file.ArrowBlock;
import org.apache.arrow.vector.file.ArrowFileReader;
import org.apache.arrow.vector.file.ArrowFileWriter;
import org.apache.arrow.vector.file.BaseFileTest;
import org.apache.arrow.vector.file.ReadChannel;
import org.apache.arrow.vector.file.SeekableReadChannel;
import org.apache.arrow.vector.schema.ArrowBuffer;
import org.apache.arrow.vector.schema.ArrowMessage;
import org.apache.arrow.vector.schema.ArrowRecordBatch;
import org.apache.arrow.vector.stream.ArrowStreamReader;
import org.apache.arrow.vector.stream.ArrowStreamWriter;
import org.apache.arrow.vector.stream.MessageSerializerTest;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestArrowFile
extends BaseFileTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestArrowFile.class);

    @Test
    public void testWrite() throws IOException {
        File file = new File("target/mytest_write.arrow");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             MapVector parent = MapVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
            this.writeData(count, parent);
            this.write(parent.getChild("root"), file, new ByteArrayOutputStream());
        }
    }

    @Test
    public void testWriteComplex() throws IOException {
        File file = new File("target/mytest_write_complex.arrow");
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             NullableMapVector parent = NullableMapVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
            this.writeComplexData(count, (MapVector)parent);
            FieldVector root = parent.getChild("root");
            this.validateComplexContent(count, new VectorSchemaRoot(root));
            this.write(root, file, new ByteArrayOutputStream());
        }
    }

    @Test
    public void testWriteRead() throws IOException {
        Throwable throwable;
        Object arrowReader2;
        Throwable throwable2;
        File file = new File("target/mytest.arrow");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int count = 10;
        try (BufferAllocator originalVectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable2 = null;
            try (MapVector parent = MapVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
                this.writeData(count, parent);
                this.write(parent.getChild("root"), file, stream);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
        }
        var5_5 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable2 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                arrowReader2 = new ArrowFileReader(fileInputStream.getChannel(), readerAllocator){

                    protected ArrowMessage readMessage(SeekableReadChannel in, BufferAllocator allocator) throws IOException {
                        ArrowMessage message = super.readMessage(in, allocator);
                        if (message != null) {
                            ArrowRecordBatch batch = (ArrowRecordBatch)message;
                            List buffersLayout = batch.getBuffersLayout();
                            for (ArrowBuffer arrowBuffer : buffersLayout) {
                                Assert.assertEquals((long)0L, (long)(arrowBuffer.getOffset() % 8L));
                            }
                        }
                        return message;
                    }
                };
                throwable = null;
                try {
                    Schema schema = arrowReader2.getVectorSchemaRoot().getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    VectorSchemaRoot root = arrowReader2.getVectorSchemaRoot();
                    for (ArrowBlock rbBlock : arrowReader2.getRecordBlocks()) {
                        arrowReader2.loadRecordBatch(rbBlock);
                        Assert.assertEquals((long)count, (long)root.getRowCount());
                        this.validateContent(count, root);
                    }
                }
                catch (Throwable schema) {
                    throwable = schema;
                    throw schema;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable schema) {
                                throwable.addSuppressed(schema);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable arrowReader2) {
                throwable2 = arrowReader2;
                throw arrowReader2;
            }
        }
        catch (Throwable fileInputStream) {
            var5_5 = fileInputStream;
            throw fileInputStream;
        }
        readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);
        var5_5 = null;
        try {
            throwable2 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(stream.toByteArray());){
                arrowReader2 = new ArrowStreamReader(input, readerAllocator){

                    protected ArrowMessage readMessage(ReadChannel in, BufferAllocator allocator) throws IOException {
                        ArrowMessage message = super.readMessage(in, allocator);
                        if (message != null) {
                            ArrowRecordBatch batch = (ArrowRecordBatch)message;
                            List buffersLayout = batch.getBuffersLayout();
                            for (ArrowBuffer arrowBuffer : buffersLayout) {
                                Assert.assertEquals((long)0L, (long)(arrowBuffer.getOffset() % 8L));
                            }
                        }
                        return message;
                    }
                };
                throwable = null;
                try {
                    VectorSchemaRoot root = arrowReader2.getVectorSchemaRoot();
                    Schema schema = root.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    Assert.assertTrue((boolean)arrowReader2.loadNextBatch());
                    Assert.assertEquals((long)count, (long)root.getRowCount());
                    this.validateContent(count, root);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                throwable2 = throwable6;
                throw throwable6;
            }
        }
        catch (Throwable throwable7) {
            var5_5 = throwable7;
            throw throwable7;
        }
        finally {
            if (readerAllocator != null) {
                if (var5_5 != null) {
                    try {
                        readerAllocator.close();
                    }
                    catch (Throwable throwable8) {
                        var5_5.addSuppressed(throwable8);
                    }
                } else {
                    readerAllocator.close();
                }
            }
        }
    }

    @Test
    public void testWriteReadComplex() throws IOException {
        Schema schema;
        VectorSchemaRoot root2;
        Throwable throwable;
        ArrowFileReader arrowReader2;
        Throwable throwable2;
        File file = new File("target/mytest_complex.arrow");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int count = 10;
        try (BufferAllocator originalVectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable2 = null;
            try (MapVector parent = MapVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
                this.writeComplexData(count, parent);
                this.write(parent.getChild("root"), file, stream);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
        }
        var5_5 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable2 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                arrowReader2 = new ArrowFileReader((SeekableByteChannel)fileInputStream.getChannel(), readerAllocator);
                throwable = null;
                try {
                    root2 = arrowReader2.getVectorSchemaRoot();
                    schema = root2.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    for (ArrowBlock rbBlock : arrowReader2.getRecordBlocks()) {
                        arrowReader2.loadRecordBatch(rbBlock);
                        Assert.assertEquals((long)count, (long)root2.getRowCount());
                        this.validateComplexContent(count, root2);
                    }
                }
                catch (Throwable root2) {
                    throwable = root2;
                    throw root2;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable root2) {
                                throwable.addSuppressed(root2);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable arrowReader2) {
                throwable2 = arrowReader2;
                throw arrowReader2;
            }
        }
        catch (Throwable fileInputStream) {
            var5_5 = fileInputStream;
            throw fileInputStream;
        }
        readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);
        var5_5 = null;
        try {
            throwable2 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(stream.toByteArray());){
                arrowReader2 = new ArrowStreamReader((InputStream)input, readerAllocator);
                throwable = null;
                try {
                    root2 = arrowReader2.getVectorSchemaRoot();
                    schema = root2.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    Assert.assertTrue((boolean)arrowReader2.loadNextBatch());
                    Assert.assertEquals((long)count, (long)root2.getRowCount());
                    this.validateComplexContent(count, root2);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                throwable2 = throwable6;
                throw throwable6;
            }
        }
        catch (Throwable throwable7) {
            var5_5 = throwable7;
            throw throwable7;
        }
        finally {
            if (readerAllocator != null) {
                if (var5_5 != null) {
                    try {
                        readerAllocator.close();
                    }
                    catch (Throwable throwable8) {
                        var5_5.addSuppressed(throwable8);
                    }
                } else {
                    readerAllocator.close();
                }
            }
        }
    }

    @Test
    public void testWriteReadMultipleRBs() throws IOException {
        int i;
        Schema schema;
        ArrowFileReader arrowReader2;
        VectorSchemaRoot root2;
        Throwable throwable;
        Throwable throwable2;
        File file = new File("target/mytest_multiple.arrow");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int[] counts = new int[]{10, 5};
        try (BufferAllocator originalVectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable2 = null;
            try (MapVector parent = MapVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
                throwable = null;
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    this.writeData(counts[0], parent);
                    root2 = new VectorSchemaRoot(parent.getChild("root"));
                    try (ArrowFileWriter fileWriter = new ArrowFileWriter(root2, null, (WritableByteChannel)fileOutputStream.getChannel());
                         ArrowStreamWriter streamWriter = new ArrowStreamWriter(root2, null, (OutputStream)stream);){
                        fileWriter.start();
                        streamWriter.start();
                        fileWriter.writeBatch();
                        streamWriter.writeBatch();
                        parent.allocateNew();
                        this.writeData(counts[1], parent);
                        root2.setRowCount(counts[1]);
                        fileWriter.writeBatch();
                        streamWriter.writeBatch();
                        fileWriter.end();
                        streamWriter.end();
                    }
                }
                catch (Throwable root2) {
                    throwable = root2;
                    throw root2;
                }
            }
            catch (Throwable fileOutputStream) {
                throwable2 = fileOutputStream;
                throw fileOutputStream;
            }
        }
        var5_5 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable2 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                arrowReader2 = new ArrowFileReader((SeekableByteChannel)fileInputStream.getChannel(), readerAllocator);
                throwable = null;
                try {
                    root2 = arrowReader2.getVectorSchemaRoot();
                    schema = root2.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    i = 0;
                    List recordBatches = arrowReader2.getRecordBlocks();
                    Assert.assertEquals((long)2L, (long)recordBatches.size());
                    long previousOffset = 0L;
                    for (ArrowBlock rbBlock : recordBatches) {
                        Assert.assertTrue((String)(rbBlock.getOffset() + " > " + previousOffset), (rbBlock.getOffset() > previousOffset ? 1 : 0) != 0);
                        previousOffset = rbBlock.getOffset();
                        arrowReader2.loadRecordBatch(rbBlock);
                        Assert.assertEquals((String)("RB #" + i), (long)counts[i], (long)root2.getRowCount());
                        this.validateContent(counts[i], root2);
                        ++i;
                    }
                }
                catch (Throwable root3) {
                    throwable = root3;
                    throw root3;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable root3) {
                                throwable.addSuppressed(root3);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable arrowReader2) {
                throwable2 = arrowReader2;
                throw arrowReader2;
            }
        }
        catch (Throwable fileInputStream) {
            var5_5 = fileInputStream;
            throw fileInputStream;
        }
        readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);
        var5_5 = null;
        try {
            throwable2 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(stream.toByteArray());){
                arrowReader2 = new ArrowStreamReader((InputStream)input, readerAllocator);
                throwable = null;
                try {
                    root2 = arrowReader2.getVectorSchemaRoot();
                    schema = root2.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    i = 0;
                    for (int n = 0; n < 2; ++n) {
                        Assert.assertTrue((boolean)arrowReader2.loadNextBatch());
                        Assert.assertEquals((String)("RB #" + i), (long)counts[i], (long)root2.getRowCount());
                        this.validateContent(counts[i], root2);
                        ++i;
                    }
                    Assert.assertFalse((boolean)arrowReader2.loadNextBatch());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
        }
        catch (Throwable throwable6) {
            var5_5 = throwable6;
            throw throwable6;
        }
        finally {
            if (readerAllocator != null) {
                if (var5_5 != null) {
                    try {
                        readerAllocator.close();
                    }
                    catch (Throwable throwable7) {
                        var5_5.addSuppressed(throwable7);
                    }
                } else {
                    readerAllocator.close();
                }
            }
        }
    }

    @Test
    public void testWriteReadUnion() throws IOException {
        Schema schema;
        VectorSchemaRoot root2;
        Throwable throwable;
        ArrowFileReader arrowReader2;
        Throwable throwable2;
        File file = new File("target/mytest_write_union.arrow");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int count = 10;
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable2 = null;
            try (NullableMapVector parent = NullableMapVector.empty((String)"parent", (BufferAllocator)vectorAllocator);){
                this.writeUnionData(count, parent);
                this.validateUnionData(count, new VectorSchemaRoot(parent.getChild("root")));
                this.write(parent.getChild("root"), file, stream);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
        }
        var5_5 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable2 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                arrowReader2 = new ArrowFileReader((SeekableByteChannel)fileInputStream.getChannel(), readerAllocator);
                throwable = null;
                try {
                    root2 = arrowReader2.getVectorSchemaRoot();
                    schema = root2.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    Assert.assertTrue((boolean)arrowReader2.loadNextBatch());
                    this.validateUnionData(count, root2);
                }
                catch (Throwable root2) {
                    throwable = root2;
                    throw root2;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable root2) {
                                throwable.addSuppressed(root2);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable arrowReader2) {
                throwable2 = arrowReader2;
                throw arrowReader2;
            }
        }
        catch (Throwable fileInputStream) {
            var5_5 = fileInputStream;
            throw fileInputStream;
        }
        readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);
        var5_5 = null;
        try {
            throwable2 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(stream.toByteArray());){
                arrowReader2 = new ArrowStreamReader((InputStream)input, readerAllocator);
                throwable = null;
                try {
                    root2 = arrowReader2.getVectorSchemaRoot();
                    schema = root2.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    Assert.assertTrue((boolean)arrowReader2.loadNextBatch());
                    this.validateUnionData(count, root2);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                throwable2 = throwable6;
                throw throwable6;
            }
        }
        catch (Throwable throwable7) {
            var5_5 = throwable7;
            throw throwable7;
        }
        finally {
            if (readerAllocator != null) {
                if (var5_5 != null) {
                    try {
                        readerAllocator.close();
                    }
                    catch (Throwable throwable8) {
                        var5_5.addSuppressed(throwable8);
                    }
                } else {
                    readerAllocator.close();
                }
            }
        }
    }

    @Test
    public void testWriteReadTiny() throws IOException {
        Schema schema;
        VectorSchemaRoot root3;
        Throwable throwable;
        ArrowFileReader arrowReader2;
        Throwable throwable2;
        File file = new File("target/mytest_write_tiny.arrow");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (VectorSchemaRoot root2 = VectorSchemaRoot.create((Schema)MessageSerializerTest.testSchema(), (BufferAllocator)this.allocator);){
            ((FieldVector)root2.getFieldVectors().get(0)).allocateNew();
            NullableTinyIntVector.Mutator mutator = (NullableTinyIntVector.Mutator)((FieldVector)root2.getFieldVectors().get(0)).getMutator();
            for (int i = 0; i < 16; ++i) {
                mutator.set(i, i < 8 ? 1 : 0, (byte)(i + 1));
            }
            mutator.setValueCount(16);
            root2.setRowCount(16);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                 ArrowFileWriter arrowWriter = new ArrowFileWriter(root2, null, (WritableByteChannel)fileOutputStream.getChannel());){
                LOGGER.debug("writing schema: " + root2.getSchema());
                arrowWriter.start();
                arrowWriter.writeBatch();
                arrowWriter.end();
            }
            var7_14 = null;
            try (ArrowStreamWriter arrowWriter = new ArrowStreamWriter(root2, null, (OutputStream)stream);){
                arrowWriter.start();
                arrowWriter.writeBatch();
                arrowWriter.end();
            }
            catch (Throwable throwable3) {
                var7_14 = throwable3;
                throw throwable3;
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("fileReader", 0L, Integer.MAX_VALUE);){
            throwable2 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                arrowReader2 = new ArrowFileReader((SeekableByteChannel)fileInputStream.getChannel(), readerAllocator);
                throwable = null;
                try {
                    root3 = arrowReader2.getVectorSchemaRoot();
                    schema = root3.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    Assert.assertTrue((boolean)arrowReader2.loadNextBatch());
                    this.validateTinyData(root3);
                }
                catch (Throwable root3) {
                    throwable = root3;
                    throw root3;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable root3) {
                                throwable.addSuppressed(root3);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable arrowReader2) {
                throwable2 = arrowReader2;
                throw arrowReader2;
            }
        }
        catch (Throwable fileInputStream) {
            var4_4 = fileInputStream;
            throw fileInputStream;
        }
        readerAllocator = this.allocator.newChildAllocator("streamReader", 0L, Integer.MAX_VALUE);
        var4_4 = null;
        try {
            throwable2 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(stream.toByteArray());){
                arrowReader2 = new ArrowStreamReader((InputStream)input, readerAllocator);
                throwable = null;
                try {
                    root3 = arrowReader2.getVectorSchemaRoot();
                    schema = root3.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    Assert.assertTrue((boolean)arrowReader2.loadNextBatch());
                    this.validateTinyData(root3);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                throwable2 = throwable6;
                throw throwable6;
            }
        }
        catch (Throwable throwable7) {
            var4_4 = throwable7;
            throw throwable7;
        }
        finally {
            if (readerAllocator != null) {
                if (var4_4 != null) {
                    try {
                        readerAllocator.close();
                    }
                    catch (Throwable throwable8) {
                        var4_4.addSuppressed(throwable8);
                    }
                } else {
                    readerAllocator.close();
                }
            }
        }
    }

    private void validateTinyData(VectorSchemaRoot root) {
        Assert.assertEquals((long)16L, (long)root.getRowCount());
        NullableTinyIntVector vector = (NullableTinyIntVector)root.getFieldVectors().get(0);
        for (int i = 0; i < 16; ++i) {
            if (i < 8) {
                Assert.assertEquals((long)((byte)(i + 1)), (long)vector.getAccessor().get(i));
                continue;
            }
            Assert.assertTrue((boolean)vector.getAccessor().isNull(i));
        }
    }

    @Test
    public void testWriteReadMetadata() throws IOException {
        int i;
        Field top;
        Schema schema;
        VectorSchemaRoot root3;
        Throwable throwable;
        ArrowFileReader arrowReader2;
        Throwable throwable2;
        File file = new File("target/mytest_metadata.arrow");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ArrayList<Field> childFields = new ArrayList<Field>();
        childFields.add(new Field("varchar-child", new FieldType(true, (ArrowType)ArrowType.Utf8.INSTANCE, null, this.metadata(1)), null));
        childFields.add(new Field("float-child", new FieldType(true, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null, this.metadata(2)), null));
        childFields.add(new Field("int-child", new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null, this.metadata(3)), null));
        childFields.add(new Field("list-child", new FieldType(true, (ArrowType)ArrowType.List.INSTANCE, null, this.metadata(4)), (List)ImmutableList.of((Object)new Field("l1", FieldType.nullable((ArrowType)new ArrowType.Int(16, true)), null))));
        Field field = new Field("meta", new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null, this.metadata(0)), childFields);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("s1", "v1");
        metadata.put("s2", "v2");
        Schema originalSchema = new Schema((Iterable)ImmutableList.of((Object)field), metadata);
        Assert.assertEquals(metadata, (Object)originalSchema.getCustomMetadata());
        try (BufferAllocator originalVectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable2 = null;
            try (NullableMapVector vector = (NullableMapVector)field.createVector(originalVectorAllocator);){
                vector.allocateNewSafe();
                vector.getMutator().setValueCount(0);
                ImmutableList vectors = ImmutableList.of((Object)vector);
                VectorSchemaRoot root2 = new VectorSchemaRoot(originalSchema, (List)vectors, 0);
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                     ArrowFileWriter fileWriter = new ArrowFileWriter(root2, null, (WritableByteChannel)fileOutputStream.getChannel());
                     ArrowStreamWriter streamWriter = new ArrowStreamWriter(root2, null, (OutputStream)stream);){
                    LOGGER.debug("writing schema: " + root2.getSchema());
                    fileWriter.start();
                    streamWriter.start();
                    fileWriter.writeBatch();
                    streamWriter.writeBatch();
                    fileWriter.end();
                    streamWriter.end();
                }
            }
            catch (Throwable vectors) {
                throwable2 = vectors;
                throw vectors;
            }
        }
        var8_8 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable2 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                arrowReader2 = new ArrowFileReader((SeekableByteChannel)fileInputStream.getChannel(), readerAllocator);
                throwable = null;
                try {
                    root3 = arrowReader2.getVectorSchemaRoot();
                    schema = root3.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    Assert.assertEquals((Object)originalSchema, (Object)schema);
                    Assert.assertEquals((Object)originalSchema.getCustomMetadata(), (Object)schema.getCustomMetadata());
                    top = (Field)schema.getFields().get(0);
                    Assert.assertEquals(this.metadata(0), (Object)top.getMetadata());
                    for (i = 0; i < 4; ++i) {
                        Assert.assertEquals(this.metadata(i + 1), (Object)((Field)top.getChildren().get(i)).getMetadata());
                    }
                }
                catch (Throwable root3) {
                    throwable = root3;
                    throw root3;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable root3) {
                                throwable.addSuppressed(root3);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable arrowReader2) {
                throwable2 = arrowReader2;
                throw arrowReader2;
            }
        }
        catch (Throwable fileInputStream) {
            var8_8 = fileInputStream;
            throw fileInputStream;
        }
        readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);
        var8_8 = null;
        try {
            throwable2 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(stream.toByteArray());){
                arrowReader2 = new ArrowStreamReader((InputStream)input, readerAllocator);
                throwable = null;
                try {
                    root3 = arrowReader2.getVectorSchemaRoot();
                    schema = root3.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    Assert.assertEquals((Object)originalSchema, (Object)schema);
                    Assert.assertEquals((Object)originalSchema.getCustomMetadata(), (Object)schema.getCustomMetadata());
                    top = (Field)schema.getFields().get(0);
                    Assert.assertEquals(this.metadata(0), (Object)top.getMetadata());
                    for (i = 0; i < 4; ++i) {
                        Assert.assertEquals(this.metadata(i + 1), (Object)((Field)top.getChildren().get(i)).getMetadata());
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
        }
        catch (Throwable throwable6) {
            var8_8 = throwable6;
            throw throwable6;
        }
        finally {
            if (readerAllocator != null) {
                if (var8_8 != null) {
                    try {
                        readerAllocator.close();
                    }
                    catch (Throwable throwable7) {
                        var8_8.addSuppressed(throwable7);
                    }
                } else {
                    readerAllocator.close();
                }
            }
        }
    }

    private Map<String, String> metadata(int i) {
        return ImmutableMap.of((Object)("k_" + i), (Object)("v_" + i), (Object)("k2_" + i), (Object)("v2_" + i));
    }

    @Test
    public void testWriteReadDictionary() throws IOException {
        Schema schema;
        VectorSchemaRoot root3;
        Throwable throwable;
        ArrowFileReader arrowReader2;
        Object object;
        File file = new File("target/mytest_dict.arrow");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (BufferAllocator originalVectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
            try (VectorSchemaRoot root2 = this.writeFlatDictionaryData(originalVectorAllocator, provider);
                 FileOutputStream fileOutputStream = new FileOutputStream(file);
                 ArrowFileWriter fileWriter = new ArrowFileWriter(root2, (DictionaryProvider)provider, (WritableByteChannel)fileOutputStream.getChannel());
                 ArrowStreamWriter streamWriter = new ArrowStreamWriter(root2, (DictionaryProvider)provider, (OutputStream)stream);){
                LOGGER.debug("writing schema: " + root2.getSchema());
                fileWriter.start();
                streamWriter.start();
                fileWriter.writeBatch();
                streamWriter.writeBatch();
                fileWriter.end();
                streamWriter.end();
            }
            object = provider.getDictionaryIds().iterator();
            while (object.hasNext()) {
                long id = (Long)object.next();
                provider.lookup(id).getVector().close();
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            FileInputStream fileInputStream = new FileInputStream(file);
            object = null;
            try {
                arrowReader2 = new ArrowFileReader((SeekableByteChannel)fileInputStream.getChannel(), readerAllocator);
                throwable = null;
                try {
                    root3 = arrowReader2.getVectorSchemaRoot();
                    schema = root3.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    Assert.assertTrue((boolean)arrowReader2.loadNextBatch());
                    this.validateFlatDictionary(root3, (DictionaryProvider)arrowReader2);
                }
                catch (Throwable root3) {
                    throwable = root3;
                    throw root3;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable root3) {
                                throwable.addSuppressed(root3);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable arrowReader2) {
                object = arrowReader2;
                throw arrowReader2;
            }
            finally {
                if (fileInputStream != null) {
                    if (object != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable arrowReader2) {
                            ((Throwable)object).addSuppressed(arrowReader2);
                        }
                    } else {
                        fileInputStream.close();
                    }
                }
            }
        }
        catch (Throwable fileInputStream) {
            var4_4 = fileInputStream;
            throw fileInputStream;
        }
        readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);
        var4_4 = null;
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(stream.toByteArray());
            object = null;
            try {
                arrowReader2 = new ArrowStreamReader((InputStream)input, readerAllocator);
                throwable = null;
                try {
                    root3 = arrowReader2.getVectorSchemaRoot();
                    schema = root3.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    Assert.assertTrue((boolean)arrowReader2.loadNextBatch());
                    this.validateFlatDictionary(root3, (DictionaryProvider)arrowReader2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                object = throwable4;
                throw throwable4;
            }
            finally {
                if (input != null) {
                    if (object != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable5) {
                            ((Throwable)object).addSuppressed(throwable5);
                        }
                    } else {
                        input.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var4_4 = throwable6;
            throw throwable6;
        }
        finally {
            if (readerAllocator != null) {
                if (var4_4 != null) {
                    try {
                        readerAllocator.close();
                    }
                    catch (Throwable throwable7) {
                        var4_4.addSuppressed(throwable7);
                    }
                } else {
                    readerAllocator.close();
                }
            }
        }
    }

    @Test
    public void testWriteReadNestedDictionary() throws IOException {
        Schema schema;
        VectorSchemaRoot root3;
        Throwable throwable;
        ArrowFileReader arrowReader2;
        Object object;
        File file = new File("target/mytest_dict_nested.arrow");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (BufferAllocator vectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
            try (VectorSchemaRoot root2 = this.writeNestedDictionaryData(vectorAllocator, provider);
                 FileOutputStream fileOutputStream = new FileOutputStream(file);
                 ArrowFileWriter fileWriter = new ArrowFileWriter(root2, (DictionaryProvider)provider, (WritableByteChannel)fileOutputStream.getChannel());
                 ArrowStreamWriter streamWriter = new ArrowStreamWriter(root2, (DictionaryProvider)provider, (OutputStream)stream);){
                this.validateNestedDictionary(root2, (DictionaryProvider)provider);
                LOGGER.debug("writing schema: " + root2.getSchema());
                fileWriter.start();
                streamWriter.start();
                fileWriter.writeBatch();
                streamWriter.writeBatch();
                fileWriter.end();
                streamWriter.end();
            }
            object = provider.getDictionaryIds().iterator();
            while (object.hasNext()) {
                long id = (Long)object.next();
                provider.lookup(id).getVector().close();
            }
        }
        var4_4 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            FileInputStream fileInputStream = new FileInputStream(file);
            object = null;
            try {
                arrowReader2 = new ArrowFileReader((SeekableByteChannel)fileInputStream.getChannel(), readerAllocator);
                throwable = null;
                try {
                    root3 = arrowReader2.getVectorSchemaRoot();
                    schema = root3.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    Assert.assertTrue((boolean)arrowReader2.loadNextBatch());
                    this.validateNestedDictionary(root3, (DictionaryProvider)arrowReader2);
                }
                catch (Throwable root3) {
                    throwable = root3;
                    throw root3;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable root3) {
                                throwable.addSuppressed(root3);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable arrowReader2) {
                object = arrowReader2;
                throw arrowReader2;
            }
            finally {
                if (fileInputStream != null) {
                    if (object != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable arrowReader2) {
                            ((Throwable)object).addSuppressed(arrowReader2);
                        }
                    } else {
                        fileInputStream.close();
                    }
                }
            }
        }
        catch (Throwable fileInputStream) {
            var4_4 = fileInputStream;
            throw fileInputStream;
        }
        readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);
        var4_4 = null;
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(stream.toByteArray());
            object = null;
            try {
                arrowReader2 = new ArrowStreamReader((InputStream)input, readerAllocator);
                throwable = null;
                try {
                    root3 = arrowReader2.getVectorSchemaRoot();
                    schema = root3.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    Assert.assertTrue((boolean)arrowReader2.loadNextBatch());
                    this.validateNestedDictionary(root3, (DictionaryProvider)arrowReader2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                object = throwable4;
                throw throwable4;
            }
            finally {
                if (input != null) {
                    if (object != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable5) {
                            ((Throwable)object).addSuppressed(throwable5);
                        }
                    } else {
                        input.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var4_4 = throwable6;
            throw throwable6;
        }
        finally {
            if (readerAllocator != null) {
                if (var4_4 != null) {
                    try {
                        readerAllocator.close();
                    }
                    catch (Throwable throwable7) {
                        var4_4.addSuppressed(throwable7);
                    }
                } else {
                    readerAllocator.close();
                }
            }
        }
    }

    @Test
    public void testWriteReadFixedSizeList() throws IOException {
        Schema schema;
        VectorSchemaRoot root2;
        Throwable throwable;
        ArrowFileReader arrowReader2;
        Throwable throwable2;
        File file = new File("target/mytest_fixed_list.arrow");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int count = 10;
        try (BufferAllocator originalVectorAllocator = this.allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            throwable2 = null;
            try (NullableMapVector parent = NullableMapVector.empty((String)"parent", (BufferAllocator)originalVectorAllocator);){
                FixedSizeListVector tuples = (FixedSizeListVector)parent.addOrGet("float-pairs", FieldType.nullable((ArrowType)new ArrowType.FixedSizeList(2)), FixedSizeListVector.class);
                NullableFloat4Vector floats = (NullableFloat4Vector)tuples.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.FLOAT4.getType())).getVector();
                NullableIntVector ints = (NullableIntVector)parent.addOrGet("ints", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), NullableIntVector.class);
                parent.allocateNew();
                for (int i = 0; i < 10; ++i) {
                    tuples.getMutator().setNotNull(i);
                    floats.getMutator().set(i * 2, (float)i + 0.1f);
                    floats.getMutator().set(i * 2 + 1, (float)i + 10.1f);
                    ints.getMutator().set(i, i);
                }
                parent.getMutator().setValueCount(10);
                this.write((FieldVector)parent, file, stream);
            }
            catch (Throwable tuples) {
                throwable2 = tuples;
                throw tuples;
            }
        }
        var5_5 = null;
        try (BufferAllocator readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);){
            throwable2 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                arrowReader2 = new ArrowFileReader((SeekableByteChannel)fileInputStream.getChannel(), readerAllocator);
                throwable = null;
                try {
                    root2 = arrowReader2.getVectorSchemaRoot();
                    schema = root2.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    for (ArrowBlock rbBlock : arrowReader2.getRecordBlocks()) {
                        arrowReader2.loadRecordBatch(rbBlock);
                        Assert.assertEquals((long)count, (long)root2.getRowCount());
                        for (int i = 0; i < 10; ++i) {
                            Assert.assertEquals((Object)Lists.newArrayList((Object[])new Float[]{Float.valueOf((float)i + 0.1f), Float.valueOf((float)i + 10.1f)}), (Object)root2.getVector("float-pairs").getAccessor().getObject(i));
                            Assert.assertEquals((Object)i, (Object)root2.getVector("ints").getAccessor().getObject(i));
                        }
                    }
                }
                catch (Throwable root2) {
                    throwable = root2;
                    throw root2;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable root2) {
                                throwable.addSuppressed(root2);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable arrowReader2) {
                throwable2 = arrowReader2;
                throw arrowReader2;
            }
        }
        catch (Throwable fileInputStream) {
            var5_5 = fileInputStream;
            throw fileInputStream;
        }
        readerAllocator = this.allocator.newChildAllocator("reader", 0L, Integer.MAX_VALUE);
        var5_5 = null;
        try {
            throwable2 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(stream.toByteArray());){
                arrowReader2 = new ArrowStreamReader((InputStream)input, readerAllocator);
                throwable = null;
                try {
                    root2 = arrowReader2.getVectorSchemaRoot();
                    schema = root2.getSchema();
                    LOGGER.debug("reading schema: " + schema);
                    arrowReader2.loadNextBatch();
                    Assert.assertEquals((long)count, (long)root2.getRowCount());
                    for (int i = 0; i < 10; ++i) {
                        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Float[]{Float.valueOf((float)i + 0.1f), Float.valueOf((float)i + 10.1f)}), (Object)root2.getVector("float-pairs").getAccessor().getObject(i));
                        Assert.assertEquals((Object)i, (Object)root2.getVector("ints").getAccessor().getObject(i));
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (arrowReader2 != null) {
                        if (throwable != null) {
                            try {
                                arrowReader2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            arrowReader2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
        }
        catch (Throwable throwable6) {
            var5_5 = throwable6;
            throw throwable6;
        }
        finally {
            if (readerAllocator != null) {
                if (var5_5 != null) {
                    try {
                        readerAllocator.close();
                    }
                    catch (Throwable throwable7) {
                        var5_5.addSuppressed(throwable7);
                    }
                } else {
                    readerAllocator.close();
                }
            }
        }
    }

    private void write(FieldVector parent, File file, OutputStream outStream) throws IOException {
        VectorSchemaRoot root = new VectorSchemaRoot(parent);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             ArrowFileWriter arrowWriter = new ArrowFileWriter(root, null, (WritableByteChannel)fileOutputStream.getChannel());){
            LOGGER.debug("writing schema: " + root.getSchema());
            arrowWriter.start();
            arrowWriter.writeBatch();
            arrowWriter.end();
        }
        if (outStream != null) {
            var6_6 = null;
            try (ArrowStreamWriter arrowWriter = new ArrowStreamWriter(root, null, outStream);){
                arrowWriter.start();
                arrowWriter.writeBatch();
                arrowWriter.end();
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
        }
    }
}

