/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.file;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ArrowBuf;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.NullableDateMilliVector;
import org.apache.arrow.vector.NullableIntVector;
import org.apache.arrow.vector.NullableTimeMilliVector;
import org.apache.arrow.vector.NullableVarCharVector;
import org.apache.arrow.vector.TestUtils;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.NullableMapVector;
import org.apache.arrow.vector.complex.impl.ComplexWriterImpl;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.BigIntWriter;
import org.apache.arrow.vector.complex.writer.DateMilliWriter;
import org.apache.arrow.vector.complex.writer.IntWriter;
import org.apache.arrow.vector.complex.writer.TimeMilliWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMilliTZWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMilliWriter;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryEncoder;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.DateUtility;
import org.apache.arrow.vector.util.Text;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseFileTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseFileTest.class);
    protected static final int COUNT = 10;
    protected BufferAllocator allocator;
    private DateTimeZone defaultTimezone = DateTimeZone.getDefault();

    @Before
    public void init() {
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forOffsetHours((int)2));
        this.allocator = new RootAllocator(Integer.MAX_VALUE);
    }

    @After
    public void tearDown() {
        this.allocator.close();
        DateTimeZone.setDefault((DateTimeZone)this.defaultTimezone);
    }

    protected void validateContent(int count, VectorSchemaRoot root) {
        for (int i = 0; i < count; ++i) {
            Assert.assertEquals((Object)i, (Object)root.getVector("int").getAccessor().getObject(i));
            Assert.assertEquals((Object)i, (Object)root.getVector("bigInt").getAccessor().getObject(i));
        }
    }

    protected void writeComplexData(int count, MapVector parent) {
        ArrowBuf varchar = this.allocator.buffer(3);
        varchar.readerIndex(0);
        varchar.setByte(0, 97);
        varchar.setByte(1, 98);
        varchar.setByte(2, 99);
        varchar.writerIndex(3);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        IntWriter intWriter = rootWriter.integer("int");
        BigIntWriter bigIntWriter = rootWriter.bigInt("bigInt");
        BaseWriter.ListWriter listWriter = rootWriter.list("list");
        BaseWriter.MapWriter mapWriter = rootWriter.map("map");
        for (int i = 0; i < count; ++i) {
            if (i % 5 != 3) {
                intWriter.setPosition(i);
                intWriter.writeInt(i);
            }
            bigIntWriter.setPosition(i);
            bigIntWriter.writeBigInt((long)i);
            listWriter.setPosition(i);
            listWriter.startList();
            for (int j = 0; j < i % 3; ++j) {
                listWriter.varChar().writeVarChar(0, 3, varchar);
            }
            listWriter.endList();
            mapWriter.setPosition(i);
            mapWriter.start();
            mapWriter.timeStampMilli("timestamp").writeTimeStampMilli((long)i);
            mapWriter.end();
        }
        writer.setValueCount(count);
        varchar.release();
    }

    public void printVectors(List<FieldVector> vectors) {
        for (FieldVector vector : vectors) {
            LOGGER.debug(vector.getField().getName());
            ValueVector.Accessor accessor = vector.getAccessor();
            int valueCount = accessor.getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                LOGGER.debug(String.valueOf(accessor.getObject(i)));
            }
        }
    }

    protected void validateComplexContent(int count, VectorSchemaRoot root) {
        Assert.assertEquals((long)count, (long)root.getRowCount());
        this.printVectors(root.getFieldVectors());
        for (int i = 0; i < count; ++i) {
            Object intVal = root.getVector("int").getAccessor().getObject(i);
            if (i % 5 != 3) {
                Assert.assertEquals((Object)i, (Object)intVal);
            } else {
                Assert.assertNull((Object)intVal);
            }
            Assert.assertEquals((Object)i, (Object)root.getVector("bigInt").getAccessor().getObject(i));
            Assert.assertEquals((long)(i % 3), (long)((List)root.getVector("list").getAccessor().getObject(i)).size());
            NullableTimeStampMilliHolder h = new NullableTimeStampMilliHolder();
            FieldReader mapReader = root.getVector("map").getReader();
            mapReader.setPosition(i);
            mapReader.reader("timestamp").read(h);
            Assert.assertEquals((long)i, (long)h.value);
        }
    }

    private LocalDateTime makeDateTimeFromCount(int i) {
        return new LocalDateTime(2000 + i, 1 + i, 1 + i, i, i, i, i);
    }

    protected void writeDateTimeData(int count, NullableMapVector parent) {
        Assert.assertTrue((count < 100 ? 1 : 0) != 0);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", (MapVector)parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        DateMilliWriter dateWriter = rootWriter.dateMilli("date");
        TimeMilliWriter timeWriter = rootWriter.timeMilli("time");
        TimeStampMilliWriter timeStampMilliWriter = rootWriter.timeStampMilli("timestamp-milli");
        TimeStampMilliTZWriter timeStampMilliTZWriter = rootWriter.timeStampMilliTZ("timestamp-milliTZ", "Europe/Paris");
        for (int i = 0; i < count; ++i) {
            LocalDateTime dt = this.makeDateTimeFromCount(i);
            dateWriter.setPosition(i);
            long dateLong = DateUtility.toMillis((LocalDateTime)dt.minusMillis(dt.getMillisOfDay()));
            dateWriter.writeDateMilli(dateLong);
            timeWriter.setPosition(i);
            timeWriter.writeTimeMilli(dt.getMillisOfDay());
            timeStampMilliWriter.setPosition(i);
            timeStampMilliWriter.writeTimeStampMilli(DateUtility.toMillis((LocalDateTime)dt));
            timeStampMilliTZWriter.setPosition(i);
            timeStampMilliTZWriter.writeTimeStampMilliTZ(DateUtility.toMillis((LocalDateTime)dt));
        }
        writer.setValueCount(count);
    }

    protected void validateDateTimeContent(int count, VectorSchemaRoot root) {
        Assert.assertEquals((long)count, (long)root.getRowCount());
        this.printVectors(root.getFieldVectors());
        for (int i = 0; i < count; ++i) {
            long dateVal = ((NullableDateMilliVector)root.getVector("date")).getAccessor().get(i);
            LocalDateTime dt = this.makeDateTimeFromCount(i);
            LocalDateTime dateExpected = dt.minusMillis(dt.getMillisOfDay());
            Assert.assertEquals((long)DateUtility.toMillis((LocalDateTime)dateExpected), (long)dateVal);
            long timeVal = ((NullableTimeMilliVector)root.getVector("time")).getAccessor().get(i);
            Assert.assertEquals((long)dt.getMillisOfDay(), (long)timeVal);
            Object timestampMilliVal = root.getVector("timestamp-milli").getAccessor().getObject(i);
            Assert.assertEquals((Object)dt, (Object)timestampMilliVal);
            Object timestampMilliTZVal = root.getVector("timestamp-milliTZ").getAccessor().getObject(i);
            Assert.assertEquals((Object)DateUtility.toMillis((LocalDateTime)dt), (Object)timestampMilliTZVal);
        }
    }

    protected VectorSchemaRoot writeFlatDictionaryData(BufferAllocator bufferAllocator, DictionaryProvider.MapDictionaryProvider provider) {
        NullableVarCharVector dictionary1Vector = TestUtils.newNullableVarCharVector("D1", bufferAllocator);
        dictionary1Vector.allocateNewSafe();
        NullableVarCharVector.Mutator mutator = dictionary1Vector.getMutator();
        mutator.set(0, "foo".getBytes(StandardCharsets.UTF_8));
        mutator.set(1, "bar".getBytes(StandardCharsets.UTF_8));
        mutator.set(2, "baz".getBytes(StandardCharsets.UTF_8));
        mutator.setValueCount(3);
        Dictionary dictionary1 = new Dictionary((FieldVector)dictionary1Vector, new DictionaryEncoding(1L, false, null));
        provider.put(dictionary1);
        NullableVarCharVector dictionary2Vector = TestUtils.newNullableVarCharVector("D2", bufferAllocator);
        dictionary2Vector.allocateNewSafe();
        mutator = dictionary2Vector.getMutator();
        mutator.set(0, "micro".getBytes(StandardCharsets.UTF_8));
        mutator.set(1, "small".getBytes(StandardCharsets.UTF_8));
        mutator.set(2, "large".getBytes(StandardCharsets.UTF_8));
        mutator.setValueCount(3);
        Dictionary dictionary2 = new Dictionary((FieldVector)dictionary2Vector, new DictionaryEncoding(2L, false, null));
        provider.put(dictionary2);
        NullableVarCharVector vector1A = TestUtils.newNullableVarCharVector("varcharA", bufferAllocator);
        vector1A.allocateNewSafe();
        mutator = vector1A.getMutator();
        mutator.set(0, "foo".getBytes(StandardCharsets.UTF_8));
        mutator.set(1, "bar".getBytes(StandardCharsets.UTF_8));
        mutator.set(3, "baz".getBytes(StandardCharsets.UTF_8));
        mutator.set(4, "bar".getBytes(StandardCharsets.UTF_8));
        mutator.set(5, "baz".getBytes(StandardCharsets.UTF_8));
        mutator.setValueCount(6);
        FieldVector encodedVector1A = (FieldVector)DictionaryEncoder.encode((ValueVector)vector1A, (Dictionary)dictionary1);
        vector1A.close();
        NullableIntVector encodedVector1B = new NullableIntVector("varcharB", bufferAllocator);
        encodedVector1B.allocateNewSafe();
        NullableIntVector.Mutator mutator1B = encodedVector1B.getMutator();
        mutator1B.set(0, 2);
        mutator1B.set(1, 1);
        mutator1B.set(2, 2);
        mutator1B.set(4, 1);
        mutator1B.set(5, 0);
        mutator1B.setValueCount(6);
        NullableVarCharVector vector2 = TestUtils.newNullableVarCharVector("sizes", bufferAllocator);
        vector2.allocateNewSafe();
        mutator = vector2.getMutator();
        mutator.set(1, "large".getBytes(StandardCharsets.UTF_8));
        mutator.set(2, "small".getBytes(StandardCharsets.UTF_8));
        mutator.set(3, "small".getBytes(StandardCharsets.UTF_8));
        mutator.set(4, "large".getBytes(StandardCharsets.UTF_8));
        mutator.setValueCount(6);
        FieldVector encodedVector2 = (FieldVector)DictionaryEncoder.encode((ValueVector)vector2, (Dictionary)dictionary2);
        vector2.close();
        ImmutableList fields = ImmutableList.of((Object)encodedVector1A.getField(), (Object)encodedVector1B.getField(), (Object)encodedVector2.getField());
        ImmutableList vectors = ImmutableList.of((Object)encodedVector1A, (Object)encodedVector1B, (Object)encodedVector2);
        return new VectorSchemaRoot((List)fields, (List)vectors, encodedVector1A.getAccessor().getValueCount());
    }

    protected void validateFlatDictionary(VectorSchemaRoot root, DictionaryProvider provider) {
        FieldVector vector1A = root.getVector("varcharA");
        Assert.assertNotNull((Object)vector1A);
        DictionaryEncoding encoding1A = vector1A.getField().getDictionary();
        Assert.assertNotNull((Object)encoding1A);
        Assert.assertEquals((long)1L, (long)encoding1A.getId());
        ValueVector.Accessor accessor = vector1A.getAccessor();
        Assert.assertEquals((long)6L, (long)accessor.getValueCount());
        Assert.assertEquals((Object)0, (Object)accessor.getObject(0));
        Assert.assertEquals((Object)1, (Object)accessor.getObject(1));
        Assert.assertEquals(null, (Object)accessor.getObject(2));
        Assert.assertEquals((Object)2, (Object)accessor.getObject(3));
        Assert.assertEquals((Object)1, (Object)accessor.getObject(4));
        Assert.assertEquals((Object)2, (Object)accessor.getObject(5));
        FieldVector vector1B = root.getVector("varcharB");
        Assert.assertNotNull((Object)vector1B);
        DictionaryEncoding encoding1B = vector1A.getField().getDictionary();
        Assert.assertNotNull((Object)encoding1B);
        Assert.assertTrue((boolean)encoding1A.equals((Object)encoding1B));
        Assert.assertEquals((long)1L, (long)encoding1B.getId());
        accessor = vector1B.getAccessor();
        Assert.assertEquals((long)6L, (long)accessor.getValueCount());
        Assert.assertEquals((Object)2, (Object)accessor.getObject(0));
        Assert.assertEquals((Object)1, (Object)accessor.getObject(1));
        Assert.assertEquals((Object)2, (Object)accessor.getObject(2));
        Assert.assertEquals(null, (Object)accessor.getObject(3));
        Assert.assertEquals((Object)1, (Object)accessor.getObject(4));
        Assert.assertEquals((Object)0, (Object)accessor.getObject(5));
        FieldVector vector2 = root.getVector("sizes");
        Assert.assertNotNull((Object)vector2);
        DictionaryEncoding encoding2 = vector2.getField().getDictionary();
        Assert.assertNotNull((Object)encoding2);
        Assert.assertEquals((long)2L, (long)encoding2.getId());
        accessor = vector2.getAccessor();
        Assert.assertEquals((long)6L, (long)accessor.getValueCount());
        Assert.assertEquals(null, (Object)accessor.getObject(0));
        Assert.assertEquals((Object)2, (Object)accessor.getObject(1));
        Assert.assertEquals((Object)1, (Object)accessor.getObject(2));
        Assert.assertEquals((Object)1, (Object)accessor.getObject(3));
        Assert.assertEquals((Object)2, (Object)accessor.getObject(4));
        Assert.assertEquals(null, (Object)accessor.getObject(5));
        Dictionary dictionary1 = provider.lookup(1L);
        Assert.assertNotNull((Object)dictionary1);
        NullableVarCharVector.Accessor dictionaryAccessor = ((NullableVarCharVector)dictionary1.getVector()).getAccessor();
        Assert.assertEquals((long)3L, (long)dictionaryAccessor.getValueCount());
        Assert.assertEquals((Object)new Text("foo"), (Object)dictionaryAccessor.getObject(0));
        Assert.assertEquals((Object)new Text("bar"), (Object)dictionaryAccessor.getObject(1));
        Assert.assertEquals((Object)new Text("baz"), (Object)dictionaryAccessor.getObject(2));
        Dictionary dictionary2 = provider.lookup(2L);
        Assert.assertNotNull((Object)dictionary2);
        dictionaryAccessor = ((NullableVarCharVector)dictionary2.getVector()).getAccessor();
        Assert.assertEquals((long)3L, (long)dictionaryAccessor.getValueCount());
        Assert.assertEquals((Object)new Text("micro"), (Object)dictionaryAccessor.getObject(0));
        Assert.assertEquals((Object)new Text("small"), (Object)dictionaryAccessor.getObject(1));
        Assert.assertEquals((Object)new Text("large"), (Object)dictionaryAccessor.getObject(2));
    }

    protected VectorSchemaRoot writeNestedDictionaryData(BufferAllocator bufferAllocator, DictionaryProvider.MapDictionaryProvider provider) {
        NullableVarCharVector dictionaryVector = TestUtils.newNullableVarCharVector("D2", bufferAllocator);
        dictionaryVector.allocateNewSafe();
        dictionaryVector.getMutator().set(0, "foo".getBytes(StandardCharsets.UTF_8));
        dictionaryVector.getMutator().set(1, "bar".getBytes(StandardCharsets.UTF_8));
        dictionaryVector.getMutator().setValueCount(2);
        Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(2L, false, null));
        provider.put(dictionary);
        ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)bufferAllocator);
        DictionaryEncoding encoding = dictionary.getEncoding();
        listVector.addOrGetVector(new FieldType(true, (ArrowType)encoding.getIndexType(), encoding));
        listVector.allocateNew();
        UnionListWriter listWriter = new UnionListWriter(listVector);
        listWriter.startList();
        listWriter.writeInt(0);
        listWriter.writeInt(1);
        listWriter.endList();
        listWriter.startList();
        listWriter.writeInt(0);
        listWriter.endList();
        listWriter.startList();
        listWriter.writeInt(1);
        listWriter.endList();
        listWriter.setValueCount(3);
        ImmutableList fields = ImmutableList.of((Object)listVector.getField());
        ImmutableList vectors = ImmutableList.of((Object)listVector);
        return new VectorSchemaRoot((List)fields, (List)vectors, 3);
    }

    protected void validateNestedDictionary(VectorSchemaRoot root, DictionaryProvider provider) {
        FieldVector vector = (FieldVector)root.getFieldVectors().get(0);
        Assert.assertNotNull((Object)vector);
        Assert.assertNull((Object)vector.getField().getDictionary());
        Field nestedField = (Field)vector.getField().getChildren().get(0);
        DictionaryEncoding encoding = nestedField.getDictionary();
        Assert.assertNotNull((Object)encoding);
        Assert.assertEquals((long)2L, (long)encoding.getId());
        Assert.assertEquals((Object)new ArrowType.Int(32, true), (Object)encoding.getIndexType());
        ValueVector.Accessor accessor = vector.getAccessor();
        Assert.assertEquals((long)3L, (long)accessor.getValueCount());
        Assert.assertEquals(Arrays.asList(0, 1), (Object)accessor.getObject(0));
        Assert.assertEquals(Arrays.asList(0), (Object)accessor.getObject(1));
        Assert.assertEquals(Arrays.asList(1), (Object)accessor.getObject(2));
        Dictionary dictionary = provider.lookup(2L);
        Assert.assertNotNull((Object)dictionary);
        NullableVarCharVector.Accessor dictionaryAccessor = ((NullableVarCharVector)dictionary.getVector()).getAccessor();
        Assert.assertEquals((long)2L, (long)dictionaryAccessor.getValueCount());
        Assert.assertEquals((Object)new Text("foo"), (Object)dictionaryAccessor.getObject(0));
        Assert.assertEquals((Object)new Text("bar"), (Object)dictionaryAccessor.getObject(1));
    }

    protected void validateNestedDictionary(ListVector vector, DictionaryProvider provider) {
        Assert.assertNotNull((Object)vector);
        Assert.assertNull((Object)vector.getField().getDictionary());
        Field nestedField = (Field)vector.getField().getChildren().get(0);
        DictionaryEncoding encoding = nestedField.getDictionary();
        Assert.assertNotNull((Object)encoding);
        Assert.assertEquals((long)2L, (long)encoding.getId());
        Assert.assertEquals((Object)new ArrowType.Int(32, true), (Object)encoding.getIndexType());
        ListVector.Accessor accessor = vector.getAccessor();
        Assert.assertEquals((long)3L, (long)accessor.getValueCount());
        Assert.assertEquals(Arrays.asList(0, 1), (Object)accessor.getObject(0));
        Assert.assertEquals(Arrays.asList(0), (Object)accessor.getObject(1));
        Assert.assertEquals(Arrays.asList(1), (Object)accessor.getObject(2));
        Dictionary dictionary = provider.lookup(2L);
        Assert.assertNotNull((Object)dictionary);
        NullableVarCharVector.Accessor dictionaryAccessor = ((NullableVarCharVector)dictionary.getVector()).getAccessor();
        Assert.assertEquals((long)2L, (long)dictionaryAccessor.getValueCount());
        Assert.assertEquals((Object)new Text("foo"), (Object)dictionaryAccessor.getObject(0));
        Assert.assertEquals((Object)new Text("bar"), (Object)dictionaryAccessor.getObject(1));
    }

    protected void writeData(int count, MapVector parent) {
        ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        IntWriter intWriter = rootWriter.integer("int");
        BigIntWriter bigIntWriter = rootWriter.bigInt("bigInt");
        for (int i = 0; i < count; ++i) {
            intWriter.setPosition(i);
            intWriter.writeInt(i);
            bigIntWriter.setPosition(i);
            bigIntWriter.writeBigInt((long)i);
        }
        writer.setValueCount(count);
    }

    public void validateUnionData(int count, VectorSchemaRoot root) {
        FieldReader unionReader = root.getVector("union").getReader();
        block6: for (int i = 0; i < count; ++i) {
            unionReader.setPosition(i);
            switch (i % 4) {
                case 0: {
                    Assert.assertEquals((long)i, (long)unionReader.readInteger().intValue());
                    continue block6;
                }
                case 1: {
                    Assert.assertEquals((long)i, (long)unionReader.readLong());
                    continue block6;
                }
                case 2: {
                    Assert.assertEquals((long)(i % 3), (long)unionReader.size());
                    continue block6;
                }
                case 3: {
                    NullableTimeStampMilliHolder h = new NullableTimeStampMilliHolder();
                    unionReader.reader("timestamp").read(h);
                    Assert.assertEquals((long)i, (long)h.value);
                }
            }
        }
    }

    public void writeUnionData(int count, NullableMapVector parent) {
        ArrowBuf varchar = this.allocator.buffer(3);
        varchar.readerIndex(0);
        varchar.setByte(0, 97);
        varchar.setByte(1, 98);
        varchar.setByte(2, 99);
        varchar.writerIndex(3);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", (MapVector)parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        IntWriter intWriter = rootWriter.integer("union");
        BigIntWriter bigIntWriter = rootWriter.bigInt("union");
        BaseWriter.ListWriter listWriter = rootWriter.list("union");
        BaseWriter.MapWriter mapWriter = rootWriter.map("union");
        block6: for (int i = 0; i < count; ++i) {
            switch (i % 4) {
                case 0: {
                    intWriter.setPosition(i);
                    intWriter.writeInt(i);
                    continue block6;
                }
                case 1: {
                    bigIntWriter.setPosition(i);
                    bigIntWriter.writeBigInt((long)i);
                    continue block6;
                }
                case 2: {
                    listWriter.setPosition(i);
                    listWriter.startList();
                    for (int j = 0; j < i % 3; ++j) {
                        listWriter.varChar().writeVarChar(0, 3, varchar);
                    }
                    listWriter.endList();
                    continue block6;
                }
                case 3: {
                    mapWriter.setPosition(i);
                    mapWriter.start();
                    mapWriter.timeStampMilli("timestamp").writeTimeStampMilli((long)i);
                    mapWriter.end();
                }
            }
        }
        writer.setValueCount(count);
        varchar.release();
    }
}

