/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.complex.writer;

import io.netty.buffer.ArrowBuf;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.SchemaChangeCallBack;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.NullableMapVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.ComplexWriterImpl;
import org.apache.arrow.vector.complex.impl.SingleMapReaderImpl;
import org.apache.arrow.vector.complex.impl.UnionListReader;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.impl.UnionReader;
import org.apache.arrow.vector.complex.impl.UnionWriter;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.BigIntWriter;
import org.apache.arrow.vector.complex.writer.IntWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMicroTZWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMicroWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMilliTZWriter;
import org.apache.arrow.vector.complex.writer.TimeStampMilliWriter;
import org.apache.arrow.vector.complex.writer.TimeStampNanoTZWriter;
import org.apache.arrow.vector.complex.writer.TimeStampNanoWriter;
import org.apache.arrow.vector.complex.writer.TimeStampSecTZWriter;
import org.apache.arrow.vector.complex.writer.TimeStampSecWriter;
import org.apache.arrow.vector.complex.writer.VarCharWriter;
import org.apache.arrow.vector.holders.IntHolder;
import org.apache.arrow.vector.holders.NullableTimeStampNanoTZHolder;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.CallBack;
import org.apache.arrow.vector.util.DateUtility;
import org.apache.arrow.vector.util.JsonStringArrayList;
import org.apache.arrow.vector.util.JsonStringHashMap;
import org.apache.arrow.vector.util.TransferPair;
import org.joda.time.LocalDateTime;
import org.junit.Assert;
import org.junit.Test;

public class TestComplexWriter {
    private static final BufferAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
    private static final int COUNT = 100;

    @Test
    public void simpleNestedTypes() {
        MapVector parent = this.populateMapVector(null);
        FieldReader rootReader = new SingleMapReaderImpl(parent).reader("root");
        for (int i = 0; i < 100; ++i) {
            rootReader.setPosition(i);
            Assert.assertEquals((long)i, (long)rootReader.reader("int").readInteger().intValue());
            Assert.assertEquals((long)i, (long)rootReader.reader("bigInt").readLong());
        }
        parent.close();
    }

    @Test
    public void transferPairSchemaChange() {
        SchemaChangeCallBack callBack1 = new SchemaChangeCallBack();
        SchemaChangeCallBack callBack2 = new SchemaChangeCallBack();
        MapVector parent = this.populateMapVector((CallBack)callBack1);
        TransferPair tp = parent.getTransferPair("newVector", allocator, (CallBack)callBack2);
        ComplexWriterImpl writer = new ComplexWriterImpl("newWriter", parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        IntWriter intWriter = rootWriter.integer("newInt");
        intWriter.writeInt(1);
        writer.setValueCount(1);
        Assert.assertTrue((boolean)callBack1.getSchemaChangedAndReset());
        Assert.assertFalse((boolean)callBack1.getSchemaChangedAndReset());
    }

    private MapVector populateMapVector(CallBack callBack) {
        MapVector parent = new MapVector("parent", allocator, new FieldType(false, (ArrowType)ArrowType.Struct.INSTANCE, null, null), callBack);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        IntWriter intWriter = rootWriter.integer("int");
        BigIntWriter bigIntWriter = rootWriter.bigInt("bigInt");
        for (int i = 0; i < 100; ++i) {
            rootWriter.start();
            intWriter.writeInt(i);
            bigIntWriter.writeBigInt((long)i);
            rootWriter.end();
        }
        writer.setValueCount(100);
        return parent;
    }

    @Test
    public void nullableMap() {
        try (MapVector mapVector = MapVector.empty((String)"parent", (BufferAllocator)allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", mapVector);
            BaseWriter.MapWriter rootWriter = writer.rootAsMap();
            for (int i = 0; i < 100; ++i) {
                rootWriter.start();
                if (i % 2 == 0) {
                    BaseWriter.MapWriter mapWriter = rootWriter.map("map");
                    mapWriter.setPosition(i);
                    mapWriter.start();
                    mapWriter.bigInt("nested").writeBigInt((long)i);
                    mapWriter.end();
                }
                rootWriter.end();
            }
            writer.setValueCount(100);
            this.checkNullableMap(mapVector);
        }
    }

    @Test
    public void nullableMap2() {
        try (MapVector mapVector = MapVector.empty((String)"parent", (BufferAllocator)allocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", mapVector);
            BaseWriter.MapWriter rootWriter = writer.rootAsMap();
            BaseWriter.MapWriter mapWriter = rootWriter.map("map");
            for (int i = 0; i < 100; ++i) {
                rootWriter.start();
                if (i % 2 == 0) {
                    mapWriter.setPosition(i);
                    mapWriter.start();
                    mapWriter.bigInt("nested").writeBigInt((long)i);
                    mapWriter.end();
                }
                rootWriter.end();
            }
            writer.setValueCount(100);
            this.checkNullableMap(mapVector);
        }
    }

    private void checkNullableMap(MapVector mapVector) {
        FieldReader rootReader = new SingleMapReaderImpl(mapVector).reader("root");
        for (int i = 0; i < 100; ++i) {
            rootReader.setPosition(i);
            Assert.assertTrue((String)("index is set: " + i), (boolean)rootReader.isSet());
            FieldReader map = rootReader.reader("map");
            if (i % 2 == 0) {
                Assert.assertTrue((String)("index is set: " + i), (boolean)map.isSet());
                Assert.assertNotNull((String)("index is set: " + i), (Object)map.readObject());
                Assert.assertEquals((long)i, (long)map.reader("nested").readLong());
                continue;
            }
            Assert.assertFalse((String)("index is not set: " + i), (boolean)map.isSet());
            Assert.assertNull((String)("index is not set: " + i), (Object)map.readObject());
        }
    }

    @Test
    public void testList() {
        MapVector parent = MapVector.empty((String)"parent", (BufferAllocator)allocator);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        rootWriter.start();
        rootWriter.bigInt("int").writeBigInt(0L);
        rootWriter.list("list").startList();
        rootWriter.list("list").bigInt().writeBigInt(0L);
        rootWriter.list("list").endList();
        rootWriter.end();
        rootWriter.start();
        rootWriter.bigInt("int").writeBigInt(1L);
        rootWriter.end();
        writer.setValueCount(2);
        FieldReader rootReader = new SingleMapReaderImpl(parent).reader("root");
        rootReader.setPosition(0);
        Assert.assertTrue((String)"row 0 list is not set", (boolean)rootReader.reader("list").isSet());
        Assert.assertEquals((Object)0L, (Object)rootReader.reader("list").reader().readLong());
        rootReader.setPosition(1);
        Assert.assertFalse((String)"row 1 list is set", (boolean)rootReader.reader("list").isSet());
    }

    @Test
    public void listScalarType() {
        ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)allocator);
        listVector.allocateNew();
        UnionListWriter listWriter = new UnionListWriter(listVector);
        for (int i = 0; i < 100; ++i) {
            listWriter.startList();
            for (int j = 0; j < i % 7; ++j) {
                if (j % 2 == 0) {
                    listWriter.writeInt(j);
                    continue;
                }
                IntHolder holder = new IntHolder();
                holder.value = j;
                listWriter.write(holder);
            }
            listWriter.endList();
        }
        listWriter.setValueCount(100);
        UnionListReader listReader = new UnionListReader(listVector);
        for (int i = 0; i < 100; ++i) {
            listReader.setPosition(i);
            for (int j = 0; j < i % 7; ++j) {
                listReader.next();
                Assert.assertEquals((long)j, (long)listReader.reader().readInteger().intValue());
            }
        }
    }

    @Test
    public void listScalarTypeNullable() {
        ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)allocator);
        listVector.allocateNew();
        UnionListWriter listWriter = new UnionListWriter(listVector);
        for (int i = 0; i < 100; ++i) {
            if (i % 2 != 0) continue;
            listWriter.setPosition(i);
            listWriter.startList();
            for (int j = 0; j < i % 7; ++j) {
                listWriter.writeInt(j);
            }
            listWriter.endList();
        }
        listWriter.setValueCount(100);
        UnionListReader listReader = new UnionListReader(listVector);
        for (int i = 0; i < 100; ++i) {
            listReader.setPosition(i);
            if (i % 2 == 0) {
                Assert.assertTrue((String)("index is set: " + i), (boolean)listReader.isSet());
                Assert.assertEquals((String)("correct length at: " + i), (long)(i % 7), (long)((List)listReader.readObject()).size());
                continue;
            }
            Assert.assertFalse((String)("index is not set: " + i), (boolean)listReader.isSet());
            Assert.assertNull((String)("index is not set: " + i), (Object)listReader.readObject());
        }
    }

    @Test
    public void listMapType() {
        ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)allocator);
        listVector.allocateNew();
        UnionListWriter listWriter = new UnionListWriter(listVector);
        BaseWriter.MapWriter mapWriter = listWriter.map();
        for (int i = 0; i < 100; ++i) {
            listWriter.startList();
            for (int j = 0; j < i % 7; ++j) {
                mapWriter.start();
                mapWriter.integer("int").writeInt(j);
                mapWriter.bigInt("bigInt").writeBigInt((long)j);
                mapWriter.end();
            }
            listWriter.endList();
        }
        listWriter.setValueCount(100);
        UnionListReader listReader = new UnionListReader(listVector);
        for (int i = 0; i < 100; ++i) {
            listReader.setPosition(i);
            for (int j = 0; j < i % 7; ++j) {
                listReader.next();
                Assert.assertEquals((String)("record: " + i), (long)j, (long)listReader.reader().reader("int").readInteger().intValue());
                Assert.assertEquals((long)j, (long)listReader.reader().reader("bigInt").readLong());
            }
        }
    }

    @Test
    public void listListType() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    BaseWriter.ListWriter innerListWriter = listWriter.list();
                    innerListWriter.startList();
                    for (int k = 0; k < i % 13; ++k) {
                        innerListWriter.integer().writeInt(k);
                    }
                    innerListWriter.endList();
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            this.checkListOfLists(listVector);
        }
    }

    @Test
    public void listListType2() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            BaseWriter.ListWriter innerListWriter = listWriter.list();
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    innerListWriter.startList();
                    for (int k = 0; k < i % 13; ++k) {
                        innerListWriter.integer().writeInt(k);
                    }
                    innerListWriter.endList();
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            this.checkListOfLists(listVector);
        }
    }

    private void checkListOfLists(ListVector listVector) {
        UnionListReader listReader = new UnionListReader(listVector);
        for (int i = 0; i < 100; ++i) {
            listReader.setPosition(i);
            for (int j = 0; j < i % 7; ++j) {
                listReader.next();
                FieldReader innerListReader = listReader.reader();
                for (int k = 0; k < i % 13; ++k) {
                    innerListReader.next();
                    Assert.assertEquals((String)("record: " + i), (long)k, (long)innerListReader.reader().readInteger().intValue());
                }
            }
        }
    }

    @Test
    public void unionListListType() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    BaseWriter.ListWriter innerListWriter = listWriter.list();
                    innerListWriter.startList();
                    for (int k = 0; k < i % 13; ++k) {
                        if (k % 2 == 0) {
                            innerListWriter.integer().writeInt(k);
                            continue;
                        }
                        innerListWriter.bigInt().writeBigInt((long)k);
                    }
                    innerListWriter.endList();
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            this.checkUnionList(listVector);
        }
    }

    @Test
    public void unionListListType2() {
        try (ListVector listVector = ListVector.empty((String)"list", (BufferAllocator)allocator);){
            listVector.allocateNew();
            UnionListWriter listWriter = new UnionListWriter(listVector);
            BaseWriter.ListWriter innerListWriter = listWriter.list();
            for (int i = 0; i < 100; ++i) {
                listWriter.startList();
                for (int j = 0; j < i % 7; ++j) {
                    innerListWriter.startList();
                    for (int k = 0; k < i % 13; ++k) {
                        if (k % 2 == 0) {
                            innerListWriter.integer().writeInt(k);
                            continue;
                        }
                        innerListWriter.bigInt().writeBigInt((long)k);
                    }
                    innerListWriter.endList();
                }
                listWriter.endList();
            }
            listWriter.setValueCount(100);
            this.checkUnionList(listVector);
        }
    }

    private void checkUnionList(ListVector listVector) {
        UnionListReader listReader = new UnionListReader(listVector);
        for (int i = 0; i < 100; ++i) {
            listReader.setPosition(i);
            for (int j = 0; j < i % 7; ++j) {
                listReader.next();
                FieldReader innerListReader = listReader.reader();
                for (int k = 0; k < i % 13; ++k) {
                    innerListReader.next();
                    if (k % 2 == 0) {
                        Assert.assertEquals((String)("record: " + i), (long)k, (long)innerListReader.reader().readInteger().intValue());
                        continue;
                    }
                    Assert.assertEquals((String)("record: " + i), (long)k, (long)innerListReader.reader().readLong());
                }
            }
        }
    }

    @Test
    public void simpleUnion() {
        UnionVector vector = new UnionVector("union", allocator, null);
        UnionWriter unionWriter = new UnionWriter(vector);
        unionWriter.allocate();
        for (int i = 0; i < 100; ++i) {
            unionWriter.setPosition(i);
            if (i % 2 == 0) {
                unionWriter.writeInt(i);
                continue;
            }
            unionWriter.writeFloat4((float)i);
        }
        vector.getMutator().setValueCount(100);
        UnionReader unionReader = new UnionReader(vector);
        for (int i = 0; i < 100; ++i) {
            unionReader.setPosition(i);
            if (i % 2 == 0) {
                Assert.assertEquals((float)i, (float)i, (float)unionReader.readInteger().intValue());
                continue;
            }
            Assert.assertEquals((double)i, (double)unionReader.readFloat().floatValue(), (double)1.0E-12);
        }
        vector.close();
    }

    @Test
    public void promotableWriter() {
        Long value;
        FieldReader reader;
        int i;
        MapVector parent = MapVector.empty((String)"parent", (BufferAllocator)allocator);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        for (int i2 = 0; i2 < 100; ++i2) {
            BigIntWriter bigIntWriter = rootWriter.bigInt("a");
            bigIntWriter.setPosition(i2);
            bigIntWriter.writeBigInt((long)i2);
        }
        Field field = (Field)((Field)parent.getField().getChildren().get(0)).getChildren().get(0);
        Assert.assertEquals((Object)"a", (Object)field.getName());
        Assert.assertEquals((Object)ArrowType.Int.TYPE_TYPE, (Object)field.getType().getTypeID());
        ArrowType.Int intType = (ArrowType.Int)field.getType();
        Assert.assertEquals((long)64L, (long)intType.getBitWidth());
        Assert.assertTrue((boolean)intType.getIsSigned());
        for (int i3 = 100; i3 < 200; ++i3) {
            VarCharWriter varCharWriter = rootWriter.varChar("a");
            varCharWriter.setPosition(i3);
            byte[] bytes = Integer.toString(i3).getBytes();
            ArrowBuf tempBuf = allocator.buffer(bytes.length);
            tempBuf.setBytes(0, bytes);
            varCharWriter.writeVarChar(0, bytes.length, tempBuf);
        }
        field = (Field)((Field)parent.getField().getChildren().get(0)).getChildren().get(0);
        Assert.assertEquals((Object)"a", (Object)field.getName());
        Assert.assertEquals((Object)ArrowType.Union.TYPE_TYPE, (Object)field.getType().getTypeID());
        Assert.assertEquals((Object)ArrowType.Int.TYPE_TYPE, (Object)((Field)field.getChildren().get(0)).getType().getTypeID());
        Assert.assertEquals((Object)ArrowType.Utf8.TYPE_TYPE, (Object)((Field)field.getChildren().get(1)).getType().getTypeID());
        FieldReader rootReader = new SingleMapReaderImpl(parent).reader("root");
        for (i = 0; i < 100; ++i) {
            rootReader.setPosition(i);
            reader = rootReader.reader("a");
            value = reader.readLong();
            Assert.assertNotNull((String)("index: " + i), (Object)value);
            Assert.assertEquals((long)i, (long)value.intValue());
        }
        for (i = 100; i < 200; ++i) {
            rootReader.setPosition(i);
            reader = rootReader.reader("a");
            value = reader.readText();
            Assert.assertEquals((Object)Integer.toString(i), (Object)value.toString());
        }
    }

    @Test
    public void promotableWriterSchema() {
        MapVector parent = MapVector.empty((String)"parent", (BufferAllocator)allocator);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        rootWriter.bigInt("a");
        rootWriter.varChar("a");
        Field field = (Field)((Field)parent.getField().getChildren().get(0)).getChildren().get(0);
        Assert.assertEquals((Object)"a", (Object)field.getName());
        Assert.assertEquals((Object)ArrowType.ArrowTypeID.Union, (Object)field.getType().getTypeID());
        Assert.assertEquals((Object)ArrowType.ArrowTypeID.Int, (Object)((Field)field.getChildren().get(0)).getType().getTypeID());
        ArrowType.Int intType = (ArrowType.Int)((Field)field.getChildren().get(0)).getType();
        Assert.assertEquals((long)64L, (long)intType.getBitWidth());
        Assert.assertTrue((boolean)intType.getIsSigned());
        Assert.assertEquals((Object)ArrowType.ArrowTypeID.Utf8, (Object)((Field)field.getChildren().get(1)).getType().getTypeID());
    }

    private Set<String> getFieldNames(List<Field> fields) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (Field field : fields) {
            fieldNames.add(field.getName());
            if (field.getChildren().isEmpty()) continue;
            for (String name : this.getFieldNames(field.getChildren())) {
                fieldNames.add(field.getName() + "::" + name);
            }
        }
        return fieldNames;
    }

    @Test
    public void mapWriterMixedCaseFieldNames() {
        MapVector parent = MapVector.empty((String)"parent", (BufferAllocator)allocator);
        ComplexWriterImpl writer = new ComplexWriterImpl("rootCaseSensitive", parent, false, true);
        BaseWriter.MapWriter rootWriterCaseSensitive = writer.rootAsMap();
        rootWriterCaseSensitive.bigInt("int_field");
        rootWriterCaseSensitive.bigInt("Int_Field");
        rootWriterCaseSensitive.float4("float_field");
        rootWriterCaseSensitive.float4("Float_Field");
        BaseWriter.MapWriter mapFieldWriterCaseSensitive = rootWriterCaseSensitive.map("map_field");
        mapFieldWriterCaseSensitive.varChar("char_field");
        mapFieldWriterCaseSensitive.varChar("Char_Field");
        BaseWriter.ListWriter listFieldWriterCaseSensitive = rootWriterCaseSensitive.list("list_field");
        BaseWriter.MapWriter listMapFieldWriterCaseSensitive = listFieldWriterCaseSensitive.map();
        listMapFieldWriterCaseSensitive.bit("bit_field");
        listMapFieldWriterCaseSensitive.bit("Bit_Field");
        List fieldsCaseSensitive = ((Field)parent.getField().getChildren().get(0)).getChildren();
        Set<String> fieldNamesCaseSensitive = this.getFieldNames(fieldsCaseSensitive);
        Assert.assertEquals((long)11L, (long)fieldNamesCaseSensitive.size());
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("int_field"));
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("Int_Field"));
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("float_field"));
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("Float_Field"));
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("map_field"));
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("map_field::char_field"));
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("map_field::Char_Field"));
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field"));
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field::$data$"));
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field::$data$::bit_field"));
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field::$data$::Bit_Field"));
        ComplexWriterImpl writerCaseInsensitive = new ComplexWriterImpl("rootCaseInsensitive", parent, false, false);
        BaseWriter.MapWriter rootWriterCaseInsensitive = writerCaseInsensitive.rootAsMap();
        rootWriterCaseInsensitive.bigInt("int_field");
        rootWriterCaseInsensitive.bigInt("Int_Field");
        rootWriterCaseInsensitive.float4("float_field");
        rootWriterCaseInsensitive.float4("Float_Field");
        BaseWriter.MapWriter mapFieldWriterCaseInsensitive = rootWriterCaseInsensitive.map("map_field");
        mapFieldWriterCaseInsensitive.varChar("char_field");
        mapFieldWriterCaseInsensitive.varChar("Char_Field");
        BaseWriter.ListWriter listFieldWriterCaseInsensitive = rootWriterCaseInsensitive.list("list_field");
        BaseWriter.MapWriter listMapFieldWriterCaseInsensitive = listFieldWriterCaseInsensitive.map();
        listMapFieldWriterCaseInsensitive.bit("bit_field");
        listMapFieldWriterCaseInsensitive.bit("Bit_Field");
        List fieldsCaseInsensitive = ((Field)parent.getField().getChildren().get(1)).getChildren();
        Set<String> fieldNamesCaseInsensitive = this.getFieldNames(fieldsCaseInsensitive);
        Assert.assertEquals((long)7L, (long)fieldNamesCaseInsensitive.size());
        Assert.assertTrue((boolean)fieldNamesCaseInsensitive.contains("int_field"));
        Assert.assertTrue((boolean)fieldNamesCaseInsensitive.contains("float_field"));
        Assert.assertTrue((boolean)fieldNamesCaseInsensitive.contains("map_field"));
        Assert.assertTrue((boolean)fieldNamesCaseInsensitive.contains("map_field::char_field"));
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field"));
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field::$data$"));
        Assert.assertTrue((boolean)fieldNamesCaseSensitive.contains("list_field::$data$::bit_field"));
    }

    @Test
    public void timeStampSecWriter() throws Exception {
        long expectedSecs = 981173106L;
        LocalDateTime expectedSecDateTime = new LocalDateTime(2001, 2, 3, 4, 5, 6, 0);
        MapVector parent = new MapVector("parent", allocator, null);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        TimeStampSecWriter timeStampSecWriter = rootWriter.timeStampSec("sec");
        timeStampSecWriter.setPosition(0);
        timeStampSecWriter.writeTimeStampSec(981173106L);
        TimeStampSecTZWriter timeStampSecTZWriter = rootWriter.timeStampSecTZ("secTZ", "UTC");
        timeStampSecTZWriter.setPosition(1);
        timeStampSecTZWriter.writeTimeStampSecTZ(981173106L);
        List children = ((Field)parent.getField().getChildren().get(0)).getChildren();
        this.checkTimestampField((Field)children.get(0), "sec");
        this.checkTimestampTZField((Field)children.get(1), "secTZ", "UTC");
        FieldReader rootReader = new SingleMapReaderImpl(parent).reader("root");
        FieldReader secReader = rootReader.reader("sec");
        secReader.setPosition(0);
        LocalDateTime secDateTime = secReader.readLocalDateTime();
        Assert.assertEquals((Object)expectedSecDateTime, (Object)secDateTime);
        long secLong = secReader.readLong();
        Assert.assertEquals((long)981173106L, (long)secLong);
        FieldReader secTZReader = rootReader.reader("secTZ");
        secTZReader.setPosition(1);
        long secTZLong = secTZReader.readLong();
        Assert.assertEquals((long)981173106L, (long)secTZLong);
    }

    @Test
    public void timeStampMilliWriters() throws Exception {
        long expectedMillis = 981173106123L;
        LocalDateTime expectedMilliDateTime = new LocalDateTime(2001, 2, 3, 4, 5, 6, 123);
        MapVector parent = MapVector.empty((String)"parent", (BufferAllocator)allocator);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        TimeStampMilliWriter timeStampWriter = rootWriter.timeStampMilli("milli");
        timeStampWriter.setPosition(0);
        timeStampWriter.writeTimeStampMilli(981173106123L);
        String tz = DateUtility.getTimeZone((int)10);
        TimeStampMilliTZWriter timeStampTZWriter = rootWriter.timeStampMilliTZ("milliTZ", tz);
        timeStampTZWriter.setPosition(0);
        timeStampTZWriter.writeTimeStampMilliTZ(981173106123L);
        List children = ((Field)parent.getField().getChildren().get(0)).getChildren();
        this.checkTimestampField((Field)children.get(0), "milli");
        this.checkTimestampTZField((Field)children.get(1), "milliTZ", tz);
        FieldReader rootReader = new SingleMapReaderImpl(parent).reader("root");
        FieldReader milliReader = rootReader.reader("milli");
        milliReader.setPosition(0);
        LocalDateTime milliDateTime = milliReader.readLocalDateTime();
        Assert.assertEquals((Object)expectedMilliDateTime, (Object)milliDateTime);
        long milliLong = milliReader.readLong();
        Assert.assertEquals((long)981173106123L, (long)milliLong);
        FieldReader milliTZReader = rootReader.reader("milliTZ");
        milliTZReader.setPosition(0);
        long milliTZLong = milliTZReader.readLong();
        Assert.assertEquals((long)981173106123L, (long)milliTZLong);
    }

    private void checkTimestampField(Field field, String name) {
        Assert.assertEquals((Object)name, (Object)field.getName());
        Assert.assertEquals((Object)ArrowType.Timestamp.TYPE_TYPE, (Object)field.getType().getTypeID());
    }

    private void checkTimestampTZField(Field field, String name, String tz) {
        this.checkTimestampField(field, name);
        Assert.assertEquals((Object)tz, (Object)((ArrowType.Timestamp)field.getType()).getTimezone());
    }

    @Test
    public void timeStampMicroWriters() throws Exception {
        long expectedMicros = 981173106123456L;
        LocalDateTime expectedMicroDateTime = new LocalDateTime(2001, 2, 3, 4, 5, 6, 123);
        MapVector parent = new MapVector("parent", allocator, null);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        TimeStampMicroWriter timeStampMicroWriter = rootWriter.timeStampMicro("micro");
        timeStampMicroWriter.setPosition(0);
        timeStampMicroWriter.writeTimeStampMicro(981173106123456L);
        String tz = DateUtility.getTimeZone((int)5);
        TimeStampMicroTZWriter timeStampMicroWriter2 = rootWriter.timeStampMicroTZ("microTZ", tz);
        timeStampMicroWriter2.setPosition(1);
        timeStampMicroWriter2.writeTimeStampMicroTZ(981173106123456L);
        List children = ((Field)parent.getField().getChildren().get(0)).getChildren();
        this.checkTimestampField((Field)children.get(0), "micro");
        this.checkTimestampTZField((Field)children.get(1), "microTZ", tz);
        FieldReader rootReader = new SingleMapReaderImpl(parent).reader("root");
        FieldReader microReader = rootReader.reader("micro");
        microReader.setPosition(0);
        LocalDateTime microDateTime = microReader.readLocalDateTime();
        Assert.assertEquals((Object)expectedMicroDateTime, (Object)microDateTime);
        long microLong = microReader.readLong();
        Assert.assertEquals((long)981173106123456L, (long)microLong);
        microReader = rootReader.reader("microTZ");
        microReader.setPosition(1);
        long microLong2 = microReader.readLong();
        Assert.assertEquals((long)981173106123456L, (long)microLong2);
    }

    @Test
    public void timeStampNanoWriters() throws Exception {
        long expectedNanos = 981173106123456789L;
        LocalDateTime expectedNanoDateTime = new LocalDateTime(2001, 2, 3, 4, 5, 6, 123);
        MapVector parent = new MapVector("parent", allocator, null);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        TimeStampNanoWriter timeStampNanoWriter = rootWriter.timeStampNano("nano");
        timeStampNanoWriter.setPosition(0);
        timeStampNanoWriter.writeTimeStampNano(981173106123456789L);
        String tz = DateUtility.getTimeZone((int)3);
        TimeStampNanoTZWriter timeStampNanoWriter2 = rootWriter.timeStampNanoTZ("nanoTZ", tz);
        timeStampNanoWriter2.setPosition(0);
        timeStampNanoWriter2.writeTimeStampNanoTZ(981173106123456789L);
        List children = ((Field)parent.getField().getChildren().get(0)).getChildren();
        this.checkTimestampField((Field)children.get(0), "nano");
        this.checkTimestampTZField((Field)children.get(1), "nanoTZ", tz);
        FieldReader rootReader = new SingleMapReaderImpl(parent).reader("root");
        FieldReader nanoReader = rootReader.reader("nano");
        nanoReader.setPosition(0);
        LocalDateTime nanoDateTime = nanoReader.readLocalDateTime();
        Assert.assertEquals((Object)expectedNanoDateTime, (Object)nanoDateTime);
        long nanoLong = nanoReader.readLong();
        Assert.assertEquals((long)981173106123456789L, (long)nanoLong);
        nanoReader = rootReader.reader("nanoTZ");
        nanoReader.setPosition(0);
        long nanoLong2 = nanoReader.readLong();
        Assert.assertEquals((long)981173106123456789L, (long)nanoLong2);
        NullableTimeStampNanoTZHolder h = new NullableTimeStampNanoTZHolder();
        nanoReader.read(h);
        Assert.assertEquals((long)981173106123456789L, (long)h.value);
    }

    @Test
    public void complexCopierWithList() {
        MapVector parent = MapVector.empty((String)"parent", (BufferAllocator)allocator);
        ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
        BaseWriter.MapWriter rootWriter = writer.rootAsMap();
        BaseWriter.ListWriter listWriter = rootWriter.list("list");
        BaseWriter.MapWriter innerMapWriter = listWriter.map();
        IntWriter outerIntWriter = listWriter.integer();
        rootWriter.start();
        listWriter.startList();
        outerIntWriter.writeInt(1);
        outerIntWriter.writeInt(2);
        innerMapWriter.start();
        IntWriter intWriter = innerMapWriter.integer("a");
        intWriter.writeInt(1);
        innerMapWriter.end();
        innerMapWriter.start();
        intWriter = innerMapWriter.integer("a");
        intWriter.writeInt(2);
        innerMapWriter.end();
        listWriter.endList();
        rootWriter.end();
        writer.setValueCount(1);
        NullableMapVector mapVector = (NullableMapVector)parent.getChild("root");
        TransferPair tp = mapVector.getTransferPair(allocator);
        tp.splitAndTransfer(0, 1);
        MapVector toMapVector = (MapVector)tp.getTo();
        JsonStringHashMap toMapValue = (JsonStringHashMap)toMapVector.getAccessor().getObject(0);
        JsonStringArrayList object = (JsonStringArrayList)toMapValue.get((Object)"list");
        Assert.assertEquals((Object)1, (Object)object.get(0));
        Assert.assertEquals((Object)2, (Object)object.get(1));
        JsonStringHashMap innerMap = (JsonStringHashMap)object.get(2);
        Assert.assertEquals((Object)1, (Object)innerMap.get((Object)"a"));
        innerMap = (JsonStringHashMap)object.get(3);
        Assert.assertEquals((Object)2, (Object)innerMap.get((Object)"a"));
    }
}

