/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.complex.impl;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.AbstractMapVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.NullableMapVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.complex.impl.ComplexWriterImpl;
import org.apache.arrow.vector.complex.impl.PromotableWriter;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPromotableWriter {
    private static final String EMPTY_SCHEMA_PATH = "";
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testPromoteToUnion() throws Exception {
        try (MapVector container = MapVector.empty((String)EMPTY_SCHEMA_PATH, (BufferAllocator)this.allocator);
             NullableMapVector v = container.addOrGetMap("test");
             PromotableWriter writer = new PromotableWriter((ValueVector)v, (AbstractMapVector)container);){
            container.allocateNew();
            writer.start();
            writer.setPosition(0);
            writer.bit("A").writeBit(0);
            writer.setPosition(1);
            writer.bit("A").writeBit(1);
            writer.decimal("dec", 10, 10);
            writer.setPosition(2);
            writer.integer("A").writeInt(10);
            writer.setPosition(4);
            writer.integer("A").writeInt(100);
            writer.end();
            container.getMutator().setValueCount(5);
            UnionVector uv = (UnionVector)v.getChild("A", UnionVector.class);
            UnionVector.Accessor accessor = uv.getAccessor();
            Assert.assertFalse((String)"0 shouldn't be null", (boolean)accessor.isNull(0));
            Assert.assertEquals((Object)false, (Object)accessor.getObject(0));
            Assert.assertFalse((String)"1 shouldn't be null", (boolean)accessor.isNull(1));
            Assert.assertEquals((Object)true, (Object)accessor.getObject(1));
            Assert.assertFalse((String)"2 shouldn't be null", (boolean)accessor.isNull(2));
            Assert.assertEquals((Object)10, (Object)accessor.getObject(2));
            Assert.assertTrue((String)"3 should be null", (boolean)accessor.isNull(3));
            Assert.assertFalse((String)"4 shouldn't be null", (boolean)accessor.isNull(4));
            Assert.assertEquals((Object)100, (Object)accessor.getObject(4));
            container.clear();
            container.allocateNew();
            ComplexWriterImpl newWriter = new ComplexWriterImpl(EMPTY_SCHEMA_PATH, container);
            BaseWriter.MapWriter newMapWriter = newWriter.rootAsMap();
            newMapWriter.start();
            newMapWriter.setPosition(2);
            newMapWriter.integer("A").writeInt(10);
            Field childField1 = (Field)((Field)container.getField().getChildren().get(0)).getChildren().get(0);
            Field childField2 = (Field)((Field)container.getField().getChildren().get(0)).getChildren().get(1);
            Assert.assertEquals((String)("Child field should be union type: " + childField1.getName()), (Object)ArrowType.ArrowTypeID.Union, (Object)childField1.getType().getTypeID());
            Assert.assertEquals((String)("Child field should be decimal type: " + childField2.getName()), (Object)ArrowType.ArrowTypeID.Decimal, (Object)childField2.getType().getTypeID());
        }
    }
}

