/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import io.netty.buffer.ArrowBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.NullableIntVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.impl.ComplexWriterImpl;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.BigIntWriter;
import org.apache.arrow.vector.complex.writer.IntWriter;
import org.apache.arrow.vector.schema.ArrowFieldNode;
import org.apache.arrow.vector.schema.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorUnloadLoad {
    static final BufferAllocator allocator = new RootAllocator(Integer.MAX_VALUE);

    @Test
    public void testUnloadLoad() throws IOException {
        int count = 10000;
        try (BufferAllocator originalVectorsAllocator = allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             MapVector parent = MapVector.empty((String)"parent", (BufferAllocator)originalVectorsAllocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.MapWriter rootWriter = writer.rootAsMap();
            IntWriter intWriter = rootWriter.integer("int");
            BigIntWriter bigIntWriter = rootWriter.bigInt("bigInt");
            for (int i = 0; i < count; ++i) {
                intWriter.setPosition(i);
                intWriter.writeInt(i);
                bigIntWriter.setPosition(i);
                bigIntWriter.writeBigInt((long)i);
            }
            writer.setValueCount(count);
            FieldVector root = parent.getChild("root");
            Schema schema = new Schema((Iterable)root.getField().getChildren());
            VectorUnloader vectorUnloader = TestVectorUnloadLoad.newVectorUnloader(root);
            try (ArrowRecordBatch recordBatch = vectorUnloader.getRecordBatch();
                 BufferAllocator finalVectorsAllocator = allocator.newChildAllocator("final vectors", 0L, Integer.MAX_VALUE);
                 VectorSchemaRoot newRoot = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)finalVectorsAllocator);){
                VectorLoader vectorLoader = new VectorLoader(newRoot);
                vectorLoader.load(recordBatch);
                FieldReader intReader = newRoot.getVector("int").getReader();
                FieldReader bigIntReader = newRoot.getVector("bigInt").getReader();
                for (int i = 0; i < count; ++i) {
                    intReader.setPosition(i);
                    Assert.assertEquals((long)i, (long)intReader.readInteger().intValue());
                    bigIntReader.setPosition(i);
                    Assert.assertEquals((long)i, (long)bigIntReader.readLong());
                }
            }
        }
    }

    @Test
    public void testUnloadLoadAddPadding() throws IOException {
        int count = 10000;
        try (BufferAllocator originalVectorsAllocator = allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);
             MapVector parent = MapVector.empty((String)"parent", (BufferAllocator)originalVectorsAllocator);){
            ComplexWriterImpl writer = new ComplexWriterImpl("root", parent);
            BaseWriter.MapWriter rootWriter = writer.rootAsMap();
            BaseWriter.ListWriter list = rootWriter.list("list");
            IntWriter intWriter = list.integer();
            for (int i = 0; i < count; ++i) {
                list.setPosition(i);
                list.startList();
                for (int j = 0; j < i % 4 + 1; ++j) {
                    intWriter.writeInt(i);
                }
                list.endList();
            }
            writer.setValueCount(count);
            FieldVector root = parent.getChild("root");
            Schema schema = new Schema((Iterable)root.getField().getChildren());
            VectorUnloader vectorUnloader = TestVectorUnloadLoad.newVectorUnloader(root);
            try (ArrowRecordBatch recordBatch = vectorUnloader.getRecordBatch();
                 BufferAllocator finalVectorsAllocator = allocator.newChildAllocator("final vectors", 0L, Integer.MAX_VALUE);
                 VectorSchemaRoot newRoot = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)finalVectorsAllocator);){
                int i;
                Object oldBuffer2;
                List oldBuffers = recordBatch.getBuffers();
                ArrayList<ArrowBuf> newBuffers = new ArrayList<ArrowBuf>();
                for (Object oldBuffer2 : oldBuffers) {
                    int l = oldBuffer2.readableBytes();
                    if (l % 64 != 0) {
                        l = l + 64 - l % 64;
                    }
                    ArrowBuf newBuffer = allocator.buffer(l);
                    for (i = oldBuffer2.readerIndex(); i < oldBuffer2.writerIndex(); ++i) {
                        newBuffer.setByte(i - oldBuffer2.readerIndex(), oldBuffer2.getByte(i));
                    }
                    newBuffer.readerIndex(0);
                    newBuffer.writerIndex(l);
                    newBuffers.add(newBuffer);
                }
                ArrowRecordBatch newBatch = new ArrowRecordBatch(recordBatch.getLength(), recordBatch.getNodes(), newBuffers);
                oldBuffer2 = null;
                try {
                    VectorLoader vectorLoader = new VectorLoader(newRoot);
                    vectorLoader.load(newBatch);
                    FieldReader reader = newRoot.getVector("list").getReader();
                    for (i = 0; i < count; ++i) {
                        reader.setPosition(i);
                        ArrayList<Integer> expected = new ArrayList<Integer>();
                        for (int j = 0; j < i % 4 + 1; ++j) {
                            expected.add(i);
                        }
                        Assert.assertEquals(expected, (Object)reader.readObject());
                    }
                }
                catch (Throwable throwable) {
                    oldBuffer2 = throwable;
                    throw throwable;
                }
                finally {
                    if (newBatch != null) {
                        if (oldBuffer2 != null) {
                            try {
                                newBatch.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)oldBuffer2).addSuppressed(throwable);
                            }
                        } else {
                            newBatch.close();
                        }
                    }
                }
                for (ArrowBuf newBuf : newBuffers) {
                    newBuf.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadEmptyValidityBuffer() throws IOException {
        Schema schema = new Schema(Arrays.asList(new Field("intDefined", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), Collections.emptyList()), new Field("intNull", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), Collections.emptyList())));
        int count = 10;
        ArrowBuf validity = allocator.buffer(10).slice(0, 0);
        ArrowBuf[] values = new ArrowBuf[2];
        for (int i = 0; i < values.length; ++i) {
            ArrowBuf arrowBuf;
            values[i] = arrowBuf = allocator.buffer(count * 4);
            for (int j = 0; j < count; ++j) {
                arrowBuf.setInt(j * 4, j);
            }
            arrowBuf.writerIndex(count * 4);
        }
        try (ArrowRecordBatch recordBatch = new ArrowRecordBatch(count, Arrays.asList(new ArrowFieldNode(count, 0), new ArrowFieldNode(count, count)), Arrays.asList(validity, values[0], validity, values[1]));
             BufferAllocator finalVectorsAllocator = allocator.newChildAllocator("final vectors", 0L, Integer.MAX_VALUE);
             VectorSchemaRoot newRoot = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)finalVectorsAllocator);){
            VectorLoader vectorLoader = new VectorLoader(newRoot);
            vectorLoader.load(recordBatch);
            NullableIntVector intDefinedVector = (NullableIntVector)newRoot.getVector("intDefined");
            NullableIntVector intNullVector = (NullableIntVector)newRoot.getVector("intNull");
            for (int i = 0; i < count; ++i) {
                Assert.assertFalse((String)("#" + i), (boolean)intDefinedVector.getAccessor().isNull(i));
                Assert.assertEquals((String)("#" + i), (long)i, (long)intDefinedVector.getAccessor().get(i));
                Assert.assertTrue((String)("#" + i), (boolean)intNullVector.getAccessor().isNull(i));
            }
            intDefinedVector.getMutator().setSafe(count + 10, 1234);
            Assert.assertTrue((boolean)intDefinedVector.getAccessor().isNull(count + 1));
            intDefinedVector.getMutator().setSafe(count + 1, 789);
            Assert.assertFalse((boolean)intDefinedVector.getAccessor().isNull(count + 1));
            Assert.assertEquals((long)789L, (long)intDefinedVector.getAccessor().get(count + 1));
            Assert.assertTrue((boolean)intDefinedVector.getAccessor().isNull(count));
            Assert.assertTrue((boolean)intDefinedVector.getAccessor().isNull(count + 2));
            Assert.assertTrue((boolean)intDefinedVector.getAccessor().isNull(count + 3));
            Assert.assertTrue((boolean)intDefinedVector.getAccessor().isNull(count + 4));
            Assert.assertTrue((boolean)intDefinedVector.getAccessor().isNull(count + 5));
            Assert.assertTrue((boolean)intDefinedVector.getAccessor().isNull(count + 6));
            Assert.assertTrue((boolean)intDefinedVector.getAccessor().isNull(count + 7));
            Assert.assertTrue((boolean)intDefinedVector.getAccessor().isNull(count + 8));
            Assert.assertTrue((boolean)intDefinedVector.getAccessor().isNull(count + 9));
            Assert.assertFalse((boolean)intDefinedVector.getAccessor().isNull(count + 10));
            Assert.assertEquals((long)1234L, (long)intDefinedVector.getAccessor().get(count + 10));
        }
        finally {
            for (ArrowBuf arrowBuf : values) {
                arrowBuf.release();
            }
            validity.release();
        }
    }

    @Test
    public void testUnloadLoadDuplicates() throws IOException {
        int count = 10;
        Schema schema = new Schema(Arrays.asList(new Field("duplicate", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), Collections.emptyList()), new Field("duplicate", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), Collections.emptyList())));
        try (BufferAllocator originalVectorsAllocator = allocator.newChildAllocator("original vectors", 0L, Integer.MAX_VALUE);){
            ArrayList<FieldVector> sources = new ArrayList<FieldVector>();
            for (Field field : schema.getFields()) {
                FieldVector vector = field.createVector(originalVectorsAllocator);
                vector.allocateNew();
                sources.add(vector);
                NullableIntVector.Mutator mutator = (NullableIntVector.Mutator)vector.getMutator();
                for (int i = 0; i < count; ++i) {
                    mutator.set(i, i);
                }
                mutator.setValueCount(count);
            }
            try (VectorSchemaRoot root = new VectorSchemaRoot(schema.getFields(), sources, count);){
                VectorUnloader vectorUnloader = new VectorUnloader(root);
                try (ArrowRecordBatch recordBatch = vectorUnloader.getRecordBatch();
                     BufferAllocator finalVectorsAllocator = allocator.newChildAllocator("final vectors", 0L, Integer.MAX_VALUE);
                     VectorSchemaRoot newRoot = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)finalVectorsAllocator);){
                    VectorLoader vectorLoader = new VectorLoader(newRoot);
                    vectorLoader.load(recordBatch);
                    List targets = newRoot.getFieldVectors();
                    Assert.assertEquals((long)sources.size(), (long)targets.size());
                    for (int k = 0; k < sources.size(); ++k) {
                        NullableIntVector.Accessor src = (NullableIntVector.Accessor)((FieldVector)sources.get(k)).getAccessor();
                        NullableIntVector.Accessor tgt = (NullableIntVector.Accessor)((FieldVector)targets.get(k)).getAccessor();
                        Assert.assertEquals((long)src.getValueCount(), (long)tgt.getValueCount());
                        for (int i = 0; i < count; ++i) {
                            Assert.assertEquals((long)src.get(i), (long)tgt.get(i));
                        }
                    }
                }
            }
        }
    }

    public static VectorUnloader newVectorUnloader(FieldVector root) {
        Schema schema = new Schema((Iterable)root.getField().getChildren());
        int valueCount = root.getAccessor().getValueCount();
        List fields = root.getChildrenFromFields();
        VectorSchemaRoot vsr = new VectorSchemaRoot(schema.getFields(), fields, valueCount);
        return new VectorUnloader(vsr);
    }

    @AfterClass
    public static void afterClass() {
        allocator.close();
    }
}

