/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.UInt4Vector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVectorReset {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testFixedTypeReset() {
        try (UInt4Vector vector = new UInt4Vector("", this.allocator);){
            UInt4Vector.Mutator m = vector.getMutator();
            vector.allocateNew();
            int sizeBefore = vector.getAllocationSize();
            vector.reAlloc();
            vector.reset();
            int sizeAfter = vector.getAllocationSize();
            Assert.assertEquals((long)sizeBefore, (long)sizeAfter);
        }
    }
}

