/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.nio.charset.StandardCharsets;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.NullableIntVector;
import org.apache.arrow.vector.NullableVarCharVector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.NullableMapVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVectorReAlloc {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testFixedType() {
        try (UInt4Vector vector = new UInt4Vector("", this.allocator);){
            UInt4Vector.Mutator m = vector.getMutator();
            vector.setInitialCapacity(512);
            vector.allocateNew();
            Assert.assertEquals((long)512L, (long)vector.getValueCapacity());
            try {
                m.set(512, 0);
                Assert.fail((String)"Expected out of bounds exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            vector.reAlloc();
            Assert.assertEquals((long)1024L, (long)vector.getValueCapacity());
            m.set(512, 100);
            Assert.assertEquals((long)100L, (long)vector.getAccessor().get(512));
        }
    }

    @Test
    public void testNullableType() {
        try (NullableVarCharVector vector = new NullableVarCharVector("", this.allocator);){
            NullableVarCharVector.Mutator m = vector.getMutator();
            vector.setInitialCapacity(512);
            vector.allocateNew();
            Assert.assertEquals((long)512L, (long)vector.getValueCapacity());
            try {
                m.set(512, "foo".getBytes(StandardCharsets.UTF_8));
                Assert.fail((String)"Expected out of bounds exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            vector.reAlloc();
            Assert.assertEquals((long)1023L, (long)vector.getValueCapacity());
            m.set(512, "foo".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((Object)"foo", (Object)new String(vector.getAccessor().get(512), StandardCharsets.UTF_8));
        }
    }

    @Test
    public void testListType() {
        try (ListVector vector = ListVector.empty((String)"", (BufferAllocator)this.allocator);){
            vector.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType()));
            vector.setInitialCapacity(512);
            vector.allocateNew();
            Assert.assertEquals((long)1023L, (long)vector.getValueCapacity());
            try {
                vector.getOffsetVector().getAccessor().get(2014);
                Assert.fail((String)"Expected out of bounds exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            vector.reAlloc();
            Assert.assertEquals((long)2047L, (long)vector.getValueCapacity());
            Assert.assertEquals((long)0L, (long)vector.getOffsetVector().getAccessor().get(2014));
        }
    }

    @Test
    public void testMapType() {
        try (NullableMapVector vector = NullableMapVector.empty((String)"", (BufferAllocator)this.allocator);){
            vector.addOrGet("", FieldType.nullable((ArrowType)Types.MinorType.INT.getType()), NullableIntVector.class);
            vector.setInitialCapacity(512);
            vector.allocateNew();
            Assert.assertEquals((long)512L, (long)vector.getValueCapacity());
            try {
                vector.getAccessor().getObject(513);
                Assert.fail((String)"Expected out of bounds exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            vector.reAlloc();
            Assert.assertEquals((long)1024L, (long)vector.getValueCapacity());
            Assert.assertNull((Object)vector.getAccessor().getObject(513));
        }
    }
}

