/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import io.netty.buffer.ArrowBuf;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.NullableFloat4Vector;
import org.apache.arrow.vector.NullableIntVector;
import org.apache.arrow.vector.NullableUInt4Vector;
import org.apache.arrow.vector.NullableVarCharVector;
import org.apache.arrow.vector.TestUtils;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.schema.ArrowRecordBatch;
import org.apache.arrow.vector.schema.TypeLayout;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestValueVector {
    private static final String EMPTY_SCHEMA_PATH = "";
    private BufferAllocator allocator;
    private static final Charset utf8Charset = Charset.forName("UTF-8");
    private static final byte[] STR1 = "AAAAA1".getBytes(utf8Charset);
    private static final byte[] STR2 = "BBBBBBBBB2".getBytes(utf8Charset);
    private static final byte[] STR3 = "CCCC3".getBytes(utf8Charset);
    private static final byte[] STR4 = "DDDDDDDD4".getBytes(utf8Charset);
    private static final byte[] STR5 = "EEE5".getBytes(utf8Charset);
    private static final byte[] STR6 = "FFFFF6".getBytes(utf8Charset);

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testFixedType() {
        try (UInt4Vector vector = new UInt4Vector(EMPTY_SCHEMA_PATH, this.allocator);){
            UInt4Vector.Mutator m = vector.getMutator();
            vector.allocateNew(1024);
            m.setSafe(0, 100);
            m.setSafe(1, 101);
            m.setSafe(100, 102);
            m.setSafe(1022, 103);
            m.setSafe(1023, 104);
            UInt4Vector.Accessor accessor = vector.getAccessor();
            Assert.assertEquals((long)100L, (long)accessor.get(0));
            Assert.assertEquals((long)101L, (long)accessor.get(1));
            Assert.assertEquals((long)102L, (long)accessor.get(100));
            Assert.assertEquals((long)103L, (long)accessor.get(1022));
            Assert.assertEquals((long)104L, (long)accessor.get(1023));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullableVarLen2() {
        try (NullableVarCharVector vector = TestUtils.newNullableVarCharVector(EMPTY_SCHEMA_PATH, this.allocator);){
            NullableVarCharVector.Mutator m = vector.getMutator();
            vector.allocateNew(10240, 1024);
            m.set(0, STR1);
            m.set(1, STR2);
            m.set(2, STR3);
            NullableVarCharVector.Accessor accessor = vector.getAccessor();
            Assert.assertArrayEquals((byte[])STR1, (byte[])accessor.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])accessor.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])accessor.get(2));
            boolean b = false;
            try {
                vector.getAccessor().get(3);
            }
            catch (IllegalStateException e) {
                b = true;
            }
            finally {
                Assert.assertTrue((boolean)b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullableFixedType() {
        try (NullableUInt4Vector vector = TestUtils.newVector(NullableUInt4Vector.class, EMPTY_SCHEMA_PATH, (ArrowType)new ArrowType.Int(32, false), this.allocator);){
            NullableUInt4Vector.Mutator m = vector.getMutator();
            vector.allocateNew(1024);
            m.set(0, 100);
            m.set(1, 101);
            m.set(100, 102);
            m.set(1022, 103);
            m.set(1023, 104);
            NullableUInt4Vector.Accessor accessor = vector.getAccessor();
            Assert.assertEquals((long)100L, (long)accessor.get(0));
            Assert.assertEquals((long)101L, (long)accessor.get(1));
            Assert.assertEquals((long)102L, (long)accessor.get(100));
            Assert.assertEquals((long)103L, (long)accessor.get(1022));
            Assert.assertEquals((long)104L, (long)accessor.get(1023));
            boolean b = false;
            try {
                accessor.get(3);
            }
            catch (IllegalStateException e) {
                b = true;
            }
            finally {
                Assert.assertTrue((boolean)b);
            }
            vector.allocateNew(2048);
            b = false;
            try {
                accessor.get(0);
            }
            catch (IllegalStateException e) {
                b = true;
            }
            finally {
                Assert.assertTrue((boolean)b);
            }
            m.set(0, 100);
            m.set(1, 101);
            m.set(100, 102);
            m.set(1022, 103);
            m.set(1023, 104);
            Assert.assertEquals((long)100L, (long)accessor.get(0));
            Assert.assertEquals((long)101L, (long)accessor.get(1));
            Assert.assertEquals((long)102L, (long)accessor.get(100));
            Assert.assertEquals((long)103L, (long)accessor.get(1022));
            Assert.assertEquals((long)104L, (long)accessor.get(1023));
            b = false;
            try {
                vector.getAccessor().get(3);
            }
            catch (IllegalStateException e) {
                b = true;
            }
            finally {
                Assert.assertTrue((boolean)b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullableFloat() {
        try (NullableFloat4Vector vector = TestUtils.newVector(NullableFloat4Vector.class, EMPTY_SCHEMA_PATH, Types.MinorType.FLOAT4, this.allocator);){
            NullableFloat4Vector.Mutator m = vector.getMutator();
            vector.allocateNew(1024);
            m.set(0, 100.1f);
            m.set(1, 101.2f);
            m.set(100, 102.3f);
            m.set(1022, 103.4f);
            m.set(1023, 104.5f);
            NullableFloat4Vector.Accessor accessor = vector.getAccessor();
            Assert.assertEquals((float)100.1f, (float)accessor.get(0), (float)0.0f);
            Assert.assertEquals((float)101.2f, (float)accessor.get(1), (float)0.0f);
            Assert.assertEquals((float)102.3f, (float)accessor.get(100), (float)0.0f);
            Assert.assertEquals((float)103.4f, (float)accessor.get(1022), (float)0.0f);
            Assert.assertEquals((float)104.5f, (float)accessor.get(1023), (float)0.0f);
            boolean b = false;
            try {
                vector.getAccessor().get(3);
            }
            catch (IllegalStateException e) {
                b = true;
            }
            finally {
                Assert.assertTrue((boolean)b);
            }
            vector.allocateNew(2048);
            b = false;
            try {
                accessor.get(0);
            }
            catch (IllegalStateException e) {
                b = true;
            }
            finally {
                Assert.assertTrue((boolean)b);
            }
        }
    }

    @Test
    public void testNullableInt() {
        try (NullableIntVector vector = TestUtils.newVector(NullableIntVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.INT, this.allocator);){
            int i;
            NullableIntVector.Mutator m = vector.getMutator();
            vector.allocateNew(1024);
            m.set(0, 1);
            m.set(1, 2);
            m.set(100, 3);
            m.set(1022, 4);
            m.set(1023, 5);
            m.setValueCount(1024);
            NullableIntVector.Accessor accessor = vector.getAccessor();
            Assert.assertEquals((long)1L, (long)accessor.get(0));
            Assert.assertEquals((long)2L, (long)accessor.get(1));
            Assert.assertEquals((long)3L, (long)accessor.get(100));
            Assert.assertEquals((long)4L, (long)accessor.get(1022));
            Assert.assertEquals((long)5L, (long)accessor.get(1023));
            Assert.assertTrue((boolean)vector.getAccessor().isNull(3));
            Field field = vector.getField();
            TypeLayout typeLayout = field.getTypeLayout();
            List buffers = vector.getFieldBuffers();
            Assert.assertEquals((long)2L, (long)typeLayout.getVectors().size());
            Assert.assertEquals((long)2L, (long)buffers.size());
            ArrowBuf validityVectorBuf = (ArrowBuf)buffers.get(0);
            Assert.assertEquals((long)128L, (long)validityVectorBuf.readableBytes());
            Assert.assertEquals((long)3L, (long)validityVectorBuf.getByte(0));
            for (i = 1; i < 12; ++i) {
                Assert.assertEquals((long)0L, (long)validityVectorBuf.getByte(i));
            }
            Assert.assertEquals((long)16L, (long)validityVectorBuf.getByte(12));
            for (i = 13; i < 127; ++i) {
                Assert.assertEquals((long)0L, (long)validityVectorBuf.getByte(i));
            }
            Assert.assertEquals((long)-64L, (long)validityVectorBuf.getByte(127));
            vector.allocateNew(2048);
            Assert.assertTrue((boolean)vector.getAccessor().isNull(0));
        }
    }

    @Test
    public void testBitVector() {
        try (BitVector vector = new BitVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            BitVector.Mutator m = vector.getMutator();
            vector.allocateNew(1024);
            m.setValueCount(1024);
            m.set(0, 1);
            m.set(1, 0);
            m.set(100, 0);
            m.set(1022, 1);
            m.setValueCount(1024);
            BitVector.Accessor accessor = vector.getAccessor();
            Assert.assertEquals((long)1L, (long)accessor.get(0));
            Assert.assertEquals((long)0L, (long)accessor.get(1));
            Assert.assertEquals((long)0L, (long)accessor.get(100));
            Assert.assertEquals((long)1L, (long)accessor.get(1022));
            Assert.assertEquals((long)1022L, (long)accessor.getNullCount());
            m.set(0, 1);
            m.set(0, 1);
            m.set(1, 0);
            m.set(1, 0);
            Assert.assertEquals((long)1L, (long)accessor.get(0));
            Assert.assertEquals((long)0L, (long)accessor.get(1));
            m.set(0, 0);
            m.set(1, 1);
            Assert.assertEquals((long)0L, (long)accessor.get(0));
            Assert.assertEquals((long)1L, (long)accessor.get(1));
            Assert.assertEquals((long)1022L, (long)accessor.getNullCount());
            Assert.assertEquals((long)0L, (long)accessor.get(3));
            m.set(1, 0);
            m.set(1022, 0);
            Assert.assertEquals((long)1024L, (long)accessor.getNullCount());
            for (i = 0; i < 1024; ++i) {
                Assert.assertEquals((long)(1024 - i), (long)accessor.getNullCount());
                m.set(i, 1);
            }
            Assert.assertEquals((long)0L, (long)accessor.getNullCount());
            vector.allocateNew(1015);
            m.setValueCount(1015);
            Assert.assertEquals((long)1015L, (long)accessor.getNullCount());
            m.set(0, 1);
            m.set(1014, 1);
            Assert.assertEquals((long)1013L, (long)accessor.getNullCount());
            vector.zeroVector();
            Assert.assertEquals((long)1015L, (long)accessor.getNullCount());
            for (i = 0; i < 1015; ++i) {
                Assert.assertEquals((long)(1015 - i), (long)accessor.getNullCount());
                m.set(i, 1);
            }
            Assert.assertEquals((long)0L, (long)accessor.getNullCount());
        }
    }

    @Test
    public void testBitVectorRangeSetAllOnes() {
        this.validateRange(1000, 0, 1000);
        this.validateRange(1000, 0, 1);
        this.validateRange(1000, 1, 2);
        this.validateRange(1000, 5, 6);
        this.validateRange(1000, 5, 10);
        this.validateRange(1000, 5, 150);
        this.validateRange(1000, 5, 27);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.validateRange(1000, 10 + i, 27 + j);
                this.validateRange(1000, i, j);
            }
        }
    }

    private void validateRange(int length, int start, int count) {
        String desc = "[" + start + ", " + (start + count) + ") ";
        try (BitVector bitVector = new BitVector("bits", this.allocator);){
            int i;
            bitVector.reset();
            bitVector.allocateNew(length);
            bitVector.getMutator().setRangeToOne(start, count);
            for (i = 0; i < start; ++i) {
                Assert.assertEquals((String)(desc + i), (long)0L, (long)bitVector.getAccessor().get(i));
            }
            for (i = start; i < start + count; ++i) {
                Assert.assertEquals((String)(desc + i), (long)1L, (long)bitVector.getAccessor().get(i));
            }
            for (i = start + count; i < length; ++i) {
                Assert.assertEquals((String)(desc + i), (long)0L, (long)bitVector.getAccessor().get(i));
            }
        }
    }

    @Test
    public void testReAllocNullableFixedWidthVector() {
        try (NullableFloat4Vector vector = TestUtils.newVector(NullableFloat4Vector.class, EMPTY_SCHEMA_PATH, Types.MinorType.FLOAT4, this.allocator);){
            NullableFloat4Vector.Mutator m = vector.getMutator();
            vector.allocateNew(1024);
            Assert.assertEquals((long)1024L, (long)vector.getValueCapacity());
            m.setSafe(0, 100.1f);
            m.setSafe(100, 102.3f);
            m.setSafe(1023, 104.5f);
            m.setSafe(2000, 105.5f);
            Assert.assertEquals((long)2048L, (long)vector.getValueCapacity());
            NullableFloat4Vector.Accessor accessor = vector.getAccessor();
            Assert.assertEquals((float)100.1f, (float)accessor.get(0), (float)0.0f);
            Assert.assertEquals((float)102.3f, (float)accessor.get(100), (float)0.0f);
            Assert.assertEquals((float)104.5f, (float)accessor.get(1023), (float)0.0f);
            Assert.assertEquals((float)105.5f, (float)accessor.get(2000), (float)0.0f);
            m.setValueCount(vector.getValueCapacity() + 200);
        }
    }

    @Test
    public void testReAllocNullableVariableWidthVector() {
        try (NullableVarCharVector vector = TestUtils.newVector(NullableVarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);){
            NullableVarCharVector.Mutator m = vector.getMutator();
            vector.allocateNew();
            int initialCapacity = vector.getValueCapacity();
            m.setSafe(0, STR1, 0, STR1.length);
            m.setSafe(initialCapacity - 1, STR2, 0, STR2.length);
            m.setSafe(initialCapacity + 200, STR3, 0, STR3.length);
            Assert.assertEquals((long)((initialCapacity + 1) * 2 - 1), (long)vector.getValueCapacity());
            NullableVarCharVector.Accessor accessor = vector.getAccessor();
            Assert.assertArrayEquals((byte[])STR1, (byte[])accessor.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])accessor.get(initialCapacity - 1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])accessor.get(initialCapacity + 200));
            m.setValueCount(vector.getValueCapacity() + 200);
        }
    }

    @Test
    public void testFillEmptiesNotOverfill() {
        try (NullableVarCharVector vector = TestUtils.newVector(NullableVarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);){
            vector.allocateNew();
            vector.getMutator().setSafe(4094, "hello".getBytes(), 0, 5);
            vector.getMutator().setValueCount(4095);
            Assert.assertEquals((long)16384L, (long)((ArrowBuf)vector.getFieldBuffers().get(1)).capacity());
        }
    }

    @Test
    public void testCopyFromWithNulls() {
        try (NullableVarCharVector vector = TestUtils.newVector(NullableVarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);
             NullableVarCharVector vector2 = TestUtils.newVector(NullableVarCharVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.VARCHAR, this.allocator);){
            int i;
            vector.allocateNew();
            for (i = 0; i < 4095; ++i) {
                if (i % 3 == 0) continue;
                byte[] b = Integer.toString(i).getBytes();
                vector.getMutator().setSafe(i, b, 0, b.length);
            }
            vector.getMutator().setValueCount(4095);
            vector2.allocateNew();
            for (i = 0; i < 4095; ++i) {
                vector2.copyFromSafe(i, i, vector);
            }
            vector2.getMutator().setValueCount(4095);
            for (i = 0; i < 4095; ++i) {
                if (i % 3 == 0) {
                    Assert.assertNull((Object)vector2.getAccessor().getObject(i));
                    continue;
                }
                Assert.assertEquals((Object)Integer.toString(i), (Object)vector2.getAccessor().getObject(i).toString());
            }
        }
    }

    @Test
    public void testSetLastSetUsage() {
        try (NullableVarCharVector vector = new NullableVarCharVector("myvector", this.allocator);){
            NullableVarCharVector.Mutator mutator = vector.getMutator();
            vector.allocateNew(10240, 1024);
            TestValueVector.setBytes(0, STR1, vector);
            TestValueVector.setBytes(1, STR2, vector);
            TestValueVector.setBytes(2, STR3, vector);
            TestValueVector.setBytes(3, STR4, vector);
            TestValueVector.setBytes(4, STR5, vector);
            TestValueVector.setBytes(5, STR6, vector);
            Assert.assertEquals((Object)Integer.toString(-1), (Object)Integer.toString(mutator.getLastSet()));
            NullableVarCharVector.Accessor accessor = vector.getAccessor();
            Assert.assertArrayEquals((byte[])STR1, (byte[])accessor.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])accessor.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])accessor.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])accessor.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])accessor.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])accessor.get(5));
            mutator.setLastSet(5);
            mutator.setValueCount(20);
            Assert.assertArrayEquals((byte[])STR1, (byte[])accessor.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])accessor.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])accessor.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])accessor.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])accessor.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])accessor.get(5));
        }
    }

    @Test
    public void testVectorLoadUnload() {
        try (NullableVarCharVector vector1 = new NullableVarCharVector("myvector", this.allocator);){
            NullableVarCharVector.Mutator mutator1 = vector1.getMutator();
            vector1.allocateNew(10240, 1024);
            mutator1.set(0, STR1);
            mutator1.set(1, STR2);
            mutator1.set(2, STR3);
            mutator1.set(3, STR4);
            mutator1.set(4, STR5);
            mutator1.set(5, STR6);
            Assert.assertEquals((Object)Integer.toString(5), (Object)Integer.toString(mutator1.getLastSet()));
            mutator1.setValueCount(15);
            Assert.assertEquals((Object)Integer.toString(14), (Object)Integer.toString(mutator1.getLastSet()));
            NullableVarCharVector.Accessor accessor1 = vector1.getAccessor();
            Assert.assertArrayEquals((byte[])STR1, (byte[])accessor1.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])accessor1.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])accessor1.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])accessor1.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])accessor1.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])accessor1.get(5));
            Field field = vector1.getField();
            String fieldName = field.getName();
            ArrayList<Field> fields = new ArrayList<Field>();
            ArrayList<NullableVarCharVector> fieldVectors = new ArrayList<NullableVarCharVector>();
            fields.add(field);
            fieldVectors.add(vector1);
            Schema schema = new Schema(fields);
            VectorSchemaRoot schemaRoot1 = new VectorSchemaRoot(schema, fieldVectors, accessor1.getValueCount());
            VectorUnloader vectorUnloader = new VectorUnloader(schemaRoot1);
            try (ArrowRecordBatch recordBatch = vectorUnloader.getRecordBatch();
                 BufferAllocator finalVectorsAllocator = this.allocator.newChildAllocator("new vector", 0L, Long.MAX_VALUE);
                 VectorSchemaRoot schemaRoot2 = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)finalVectorsAllocator);){
                VectorLoader vectorLoader = new VectorLoader(schemaRoot2);
                vectorLoader.load(recordBatch);
                NullableVarCharVector vector2 = (NullableVarCharVector)schemaRoot2.getVector(fieldName);
                NullableVarCharVector.Mutator mutator2 = vector2.getMutator();
                Assert.assertEquals((Object)Integer.toString(14), (Object)Integer.toString(mutator2.getLastSet()));
                mutator2.setValueCount(25);
                Assert.assertEquals((Object)Integer.toString(24), (Object)Integer.toString(mutator2.getLastSet()));
                NullableVarCharVector.Accessor accessor2 = vector2.getAccessor();
                Assert.assertArrayEquals((byte[])STR1, (byte[])accessor2.get(0));
                Assert.assertArrayEquals((byte[])STR2, (byte[])accessor2.get(1));
                Assert.assertArrayEquals((byte[])STR3, (byte[])accessor2.get(2));
                Assert.assertArrayEquals((byte[])STR4, (byte[])accessor2.get(3));
                Assert.assertArrayEquals((byte[])STR5, (byte[])accessor2.get(4));
                Assert.assertArrayEquals((byte[])STR6, (byte[])accessor2.get(5));
            }
        }
    }

    @Test
    public void testFillEmptiesUsage() {
        try (NullableVarCharVector vector = new NullableVarCharVector("myvector", this.allocator);){
            NullableVarCharVector.Mutator mutator = vector.getMutator();
            vector.allocateNew(10240, 1024);
            TestValueVector.setBytes(0, STR1, vector);
            TestValueVector.setBytes(1, STR2, vector);
            TestValueVector.setBytes(2, STR3, vector);
            TestValueVector.setBytes(3, STR4, vector);
            TestValueVector.setBytes(4, STR5, vector);
            TestValueVector.setBytes(5, STR6, vector);
            Assert.assertEquals((Object)Integer.toString(-1), (Object)Integer.toString(mutator.getLastSet()));
            NullableVarCharVector.Accessor accessor = vector.getAccessor();
            Assert.assertArrayEquals((byte[])STR1, (byte[])accessor.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])accessor.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])accessor.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])accessor.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])accessor.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])accessor.get(5));
            mutator.setLastSet(5);
            mutator.fillEmpties(10);
            Assert.assertEquals((Object)Integer.toString(9), (Object)Integer.toString(mutator.getLastSet()));
            Assert.assertArrayEquals((byte[])STR1, (byte[])accessor.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])accessor.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])accessor.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])accessor.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])accessor.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])accessor.get(5));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(accessor.getValueLength(6)));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(accessor.getValueLength(7)));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(accessor.getValueLength(8)));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(accessor.getValueLength(9)));
            TestValueVector.setBytes(10, STR1, vector);
            TestValueVector.setBytes(11, STR2, vector);
            mutator.setLastSet(11);
            mutator.setValueCount(15);
            Assert.assertEquals((Object)Integer.toString(14), (Object)Integer.toString(mutator.getLastSet()));
            Assert.assertArrayEquals((byte[])STR1, (byte[])accessor.get(0));
            Assert.assertArrayEquals((byte[])STR2, (byte[])accessor.get(1));
            Assert.assertArrayEquals((byte[])STR3, (byte[])accessor.get(2));
            Assert.assertArrayEquals((byte[])STR4, (byte[])accessor.get(3));
            Assert.assertArrayEquals((byte[])STR5, (byte[])accessor.get(4));
            Assert.assertArrayEquals((byte[])STR6, (byte[])accessor.get(5));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(accessor.getValueLength(6)));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(accessor.getValueLength(7)));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(accessor.getValueLength(8)));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(accessor.getValueLength(9)));
            Assert.assertArrayEquals((byte[])STR1, (byte[])accessor.get(10));
            Assert.assertArrayEquals((byte[])STR2, (byte[])accessor.get(11));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(accessor.getValueLength(12)));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(accessor.getValueLength(13)));
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(accessor.getValueLength(14)));
            UInt4Vector.Accessor offsetAccessor = vector.values.offsetVector.getAccessor();
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(offsetAccessor.get(0)));
            Assert.assertEquals((Object)Integer.toString(6), (Object)Integer.toString(offsetAccessor.get(1)));
            Assert.assertEquals((Object)Integer.toString(16), (Object)Integer.toString(offsetAccessor.get(2)));
            Assert.assertEquals((Object)Integer.toString(21), (Object)Integer.toString(offsetAccessor.get(3)));
            Assert.assertEquals((Object)Integer.toString(30), (Object)Integer.toString(offsetAccessor.get(4)));
            Assert.assertEquals((Object)Integer.toString(34), (Object)Integer.toString(offsetAccessor.get(5)));
            Assert.assertEquals((Object)Integer.toString(40), (Object)Integer.toString(offsetAccessor.get(6)));
            Assert.assertEquals((Object)Integer.toString(40), (Object)Integer.toString(offsetAccessor.get(7)));
            Assert.assertEquals((Object)Integer.toString(40), (Object)Integer.toString(offsetAccessor.get(8)));
            Assert.assertEquals((Object)Integer.toString(40), (Object)Integer.toString(offsetAccessor.get(9)));
            Assert.assertEquals((Object)Integer.toString(40), (Object)Integer.toString(offsetAccessor.get(10)));
            Assert.assertEquals((Object)Integer.toString(46), (Object)Integer.toString(offsetAccessor.get(11)));
            Assert.assertEquals((Object)Integer.toString(56), (Object)Integer.toString(offsetAccessor.get(12)));
            Assert.assertEquals((Object)Integer.toString(56), (Object)Integer.toString(offsetAccessor.get(13)));
            Assert.assertEquals((Object)Integer.toString(56), (Object)Integer.toString(offsetAccessor.get(14)));
            Assert.assertEquals((Object)Integer.toString(56), (Object)Integer.toString(offsetAccessor.get(15)));
        }
    }

    @Test
    public void testMultipleClose() {
        BufferAllocator vectorAllocator = this.allocator.newChildAllocator("vector_allocator", 0L, Long.MAX_VALUE);
        NullableIntVector vector = TestUtils.newVector(NullableIntVector.class, EMPTY_SCHEMA_PATH, Types.MinorType.INT, vectorAllocator);
        vector.close();
        vectorAllocator.close();
        vector.close();
        vectorAllocator.close();
    }

    public static void setBytes(int index, byte[] bytes, NullableVarCharVector vector) {
        int currentOffset = vector.values.offsetVector.getAccessor().get(index);
        vector.bits.getMutator().setToOne(index);
        vector.values.offsetVector.getMutator().set(index + 1, currentOffset + bytes.length);
        vector.values.data.setBytes(currentOffset, bytes, 0, bytes.length);
    }
}

