/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.vector.holders.NullableBitHolder;
import org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.holders.NullableUInt4Holder;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestUnionVector {
    private static final String EMPTY_SCHEMA_PATH = "";
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testUnionVector() throws Exception {
        NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
        uInt4Holder.value = 100;
        uInt4Holder.isSet = 1;
        try (UnionVector unionVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
            unionVector.allocateNew();
            UnionVector.Mutator mutator = unionVector.getMutator();
            mutator.setType(0, Types.MinorType.UINT4);
            mutator.setSafe(0, uInt4Holder);
            mutator.setType(2, Types.MinorType.UINT4);
            mutator.setSafe(2, uInt4Holder);
            mutator.setValueCount(4);
            UnionVector.Accessor accessor = unionVector.getAccessor();
            Assert.assertEquals((long)4L, (long)accessor.getValueCount());
            Assert.assertEquals((Object)false, (Object)accessor.isNull(0));
            Assert.assertEquals((Object)100, (Object)accessor.getObject(0));
            Assert.assertEquals((Object)true, (Object)accessor.isNull(1));
            Assert.assertEquals((Object)false, (Object)accessor.isNull(2));
            Assert.assertEquals((Object)100, (Object)accessor.getObject(2));
            Assert.assertEquals((Object)true, (Object)accessor.isNull(3));
        }
    }

    @Test
    public void testTransfer() throws Exception {
        try (UnionVector srcVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
            srcVector.allocateNew();
            UnionVector.Mutator mutator = srcVector.getMutator();
            mutator.setType(0, Types.MinorType.INT);
            mutator.setSafe(0, TestUnionVector.newIntHolder(5));
            mutator.setType(1, Types.MinorType.BIT);
            mutator.setSafe(1, TestUnionVector.newBitHolder(false));
            mutator.setType(3, Types.MinorType.INT);
            mutator.setSafe(3, TestUnionVector.newIntHolder(10));
            mutator.setType(5, Types.MinorType.BIT);
            mutator.setSafe(5, TestUnionVector.newBitHolder(false));
            mutator.setValueCount(6);
            try (UnionVector destVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
                TransferPair pair = srcVector.makeTransferPair((ValueVector)destVector);
                Assert.assertEquals((Object)srcVector.getField(), (Object)destVector.getField());
                pair.transfer();
                Assert.assertEquals((Object)srcVector.getField(), (Object)destVector.getField());
                Assert.assertEquals((long)srcVector.getAccessor().getValueCount(), (long)destVector.getAccessor().getValueCount());
                for (int i = 0; i < srcVector.getAccessor().getValueCount(); ++i) {
                    Assert.assertEquals((String)("Different values at index " + i), (Object)srcVector.getAccessor().get(i), (Object)destVector.getAccessor().get(i));
                }
            }
        }
    }

    @Test
    public void testSplitAndTransfer() throws Exception {
        try (UnionVector sourceVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
            UnionVector.Mutator sourceMutator = sourceVector.getMutator();
            UnionVector.Accessor sourceAccessor = sourceVector.getAccessor();
            sourceVector.allocateNew();
            sourceMutator.setType(0, Types.MinorType.INT);
            sourceMutator.setSafe(0, TestUnionVector.newIntHolder(5));
            sourceMutator.setType(1, Types.MinorType.INT);
            sourceMutator.setSafe(1, TestUnionVector.newIntHolder(10));
            sourceMutator.setType(2, Types.MinorType.INT);
            sourceMutator.setSafe(2, TestUnionVector.newIntHolder(15));
            sourceMutator.setType(3, Types.MinorType.INT);
            sourceMutator.setSafe(3, TestUnionVector.newIntHolder(20));
            sourceMutator.setType(4, Types.MinorType.INT);
            sourceMutator.setSafe(4, TestUnionVector.newIntHolder(25));
            sourceMutator.setType(5, Types.MinorType.INT);
            sourceMutator.setSafe(5, TestUnionVector.newIntHolder(30));
            sourceMutator.setType(6, Types.MinorType.INT);
            sourceMutator.setSafe(6, TestUnionVector.newIntHolder(35));
            sourceMutator.setType(7, Types.MinorType.INT);
            sourceMutator.setSafe(7, TestUnionVector.newIntHolder(40));
            sourceMutator.setType(8, Types.MinorType.INT);
            sourceMutator.setSafe(8, TestUnionVector.newIntHolder(45));
            sourceMutator.setType(9, Types.MinorType.INT);
            sourceMutator.setSafe(9, TestUnionVector.newIntHolder(50));
            sourceMutator.setValueCount(10);
            Assert.assertEquals((long)10L, (long)sourceAccessor.getValueCount());
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(0));
            Assert.assertEquals((Object)5, (Object)sourceAccessor.getObject(0));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(1));
            Assert.assertEquals((Object)10, (Object)sourceAccessor.getObject(1));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(2));
            Assert.assertEquals((Object)15, (Object)sourceAccessor.getObject(2));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(3));
            Assert.assertEquals((Object)20, (Object)sourceAccessor.getObject(3));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(4));
            Assert.assertEquals((Object)25, (Object)sourceAccessor.getObject(4));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(5));
            Assert.assertEquals((Object)30, (Object)sourceAccessor.getObject(5));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(6));
            Assert.assertEquals((Object)35, (Object)sourceAccessor.getObject(6));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(7));
            Assert.assertEquals((Object)40, (Object)sourceAccessor.getObject(7));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(8));
            Assert.assertEquals((Object)45, (Object)sourceAccessor.getObject(8));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(9));
            Assert.assertEquals((Object)50, (Object)sourceAccessor.getObject(9));
            try (UnionVector toVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
                int[][] transferLengths;
                TransferPair transferPair = sourceVector.makeTransferPair((ValueVector)toVector);
                UnionVector.Accessor toAccessor = toVector.getAccessor();
                for (int[] transferLength : transferLengths = new int[][]{{0, 3}, {3, 1}, {4, 2}, {6, 1}, {7, 1}, {8, 2}}) {
                    int start = transferLength[0];
                    int length = transferLength[1];
                    transferPair.splitAndTransfer(start, length);
                    for (int i = 0; i < length; ++i) {
                        Assert.assertEquals((String)("Different data at indexes: " + (start + i) + "and " + i), (Object)sourceAccessor.getObject(start + i), (Object)toAccessor.getObject(i));
                    }
                }
            }
        }
    }

    @Test
    public void testSplitAndTransferWithMixedVectors() throws Exception {
        try (UnionVector sourceVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
            UnionVector.Mutator sourceMutator = sourceVector.getMutator();
            UnionVector.Accessor sourceAccessor = sourceVector.getAccessor();
            sourceVector.allocateNew();
            sourceMutator.setType(0, Types.MinorType.INT);
            sourceMutator.setSafe(0, TestUnionVector.newIntHolder(5));
            sourceMutator.setType(1, Types.MinorType.FLOAT4);
            sourceMutator.setSafe(1, TestUnionVector.newFloat4Holder(5.5f));
            sourceMutator.setType(2, Types.MinorType.INT);
            sourceMutator.setSafe(2, TestUnionVector.newIntHolder(10));
            sourceMutator.setType(3, Types.MinorType.FLOAT4);
            sourceMutator.setSafe(3, TestUnionVector.newFloat4Holder(10.5f));
            sourceMutator.setType(4, Types.MinorType.INT);
            sourceMutator.setSafe(4, TestUnionVector.newIntHolder(15));
            sourceMutator.setType(5, Types.MinorType.FLOAT4);
            sourceMutator.setSafe(5, TestUnionVector.newFloat4Holder(15.5f));
            sourceMutator.setType(6, Types.MinorType.INT);
            sourceMutator.setSafe(6, TestUnionVector.newIntHolder(20));
            sourceMutator.setType(7, Types.MinorType.FLOAT4);
            sourceMutator.setSafe(7, TestUnionVector.newFloat4Holder(20.5f));
            sourceMutator.setType(8, Types.MinorType.INT);
            sourceMutator.setSafe(8, TestUnionVector.newIntHolder(30));
            sourceMutator.setType(9, Types.MinorType.FLOAT4);
            sourceMutator.setSafe(9, TestUnionVector.newFloat4Holder(30.5f));
            sourceMutator.setValueCount(10);
            Assert.assertEquals((long)10L, (long)sourceAccessor.getValueCount());
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(0));
            Assert.assertEquals((Object)5, (Object)sourceAccessor.getObject(0));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(1));
            Assert.assertEquals((Object)Float.valueOf(5.5f), (Object)sourceAccessor.getObject(1));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(2));
            Assert.assertEquals((Object)10, (Object)sourceAccessor.getObject(2));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(3));
            Assert.assertEquals((Object)Float.valueOf(10.5f), (Object)sourceAccessor.getObject(3));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(4));
            Assert.assertEquals((Object)15, (Object)sourceAccessor.getObject(4));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(5));
            Assert.assertEquals((Object)Float.valueOf(15.5f), (Object)sourceAccessor.getObject(5));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(6));
            Assert.assertEquals((Object)20, (Object)sourceAccessor.getObject(6));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(7));
            Assert.assertEquals((Object)Float.valueOf(20.5f), (Object)sourceAccessor.getObject(7));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(8));
            Assert.assertEquals((Object)30, (Object)sourceAccessor.getObject(8));
            Assert.assertEquals((Object)false, (Object)sourceAccessor.isNull(9));
            Assert.assertEquals((Object)Float.valueOf(30.5f), (Object)sourceAccessor.getObject(9));
            try (UnionVector toVector = new UnionVector(EMPTY_SCHEMA_PATH, this.allocator, null);){
                int[][] transferLengths;
                TransferPair transferPair = sourceVector.makeTransferPair((ValueVector)toVector);
                UnionVector.Accessor toAccessor = toVector.getAccessor();
                for (int[] transferLength : transferLengths = new int[][]{{0, 2}, {2, 1}, {3, 2}, {5, 3}, {8, 2}}) {
                    int start = transferLength[0];
                    int length = transferLength[1];
                    transferPair.splitAndTransfer(start, length);
                    for (int i = 0; i < length; ++i) {
                        Assert.assertEquals((String)("Different values at index: " + i), (Object)sourceAccessor.getObject(start + i), (Object)toAccessor.getObject(i));
                    }
                }
            }
        }
    }

    private static NullableIntHolder newIntHolder(int value) {
        NullableIntHolder holder = new NullableIntHolder();
        holder.isSet = 1;
        holder.value = value;
        return holder;
    }

    private static NullableBitHolder newBitHolder(boolean value) {
        NullableBitHolder holder = new NullableBitHolder();
        holder.isSet = 1;
        holder.value = value ? 1 : 0;
        return holder;
    }

    private static NullableFloat4Holder newFloat4Holder(float value) {
        NullableFloat4Holder holder = new NullableFloat4Holder();
        holder.isSet = 1;
        holder.value = value;
        return holder;
    }
}

