/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseValueVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.util.OversizedAllocationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOversizedAllocationForValueVector {
    private static final String EMPTY_SCHEMA_PATH = "";
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OversizedAllocationException.class)
    public void testFixedVectorReallocation() {
        int expectedValueCapacity = BaseValueVector.MAX_ALLOCATION_SIZE / 4;
        try (UInt4Vector vector = new UInt4Vector(EMPTY_SCHEMA_PATH, this.allocator);){
            vector.allocateNew(expectedValueCapacity);
            Assert.assertEquals((long)expectedValueCapacity, (long)vector.getValueCapacity());
            vector.reAlloc();
            Assert.assertEquals((long)(expectedValueCapacity * 2), (long)vector.getValueCapacity());
        }
        try {
            vector.allocateNew(BaseValueVector.MAX_ALLOCATION_SIZE / 8);
            vector.reAlloc();
            vector.reAlloc();
        }
        finally {
            vector.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OversizedAllocationException.class)
    public void testBitVectorReallocation() {
        int expectedValueCapacity = 0x20000000;
        try (BitVector vector = new BitVector(EMPTY_SCHEMA_PATH, this.allocator);){
            vector.allocateNew(0x20000000);
            Assert.assertEquals((long)0x20000000L, (long)vector.getValueCapacity());
            vector.reAlloc();
            Assert.assertEquals((long)0x40000000L, (long)vector.getValueCapacity());
        }
        try {
            vector.allocateNew(0x20000000);
            for (int i = 0; i < 3; ++i) {
                vector.reAlloc();
            }
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)vector.getValueCapacity());
            vector.reAlloc();
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)vector.getValueCapacity());
            vector.reAlloc();
        }
        finally {
            vector.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=OversizedAllocationException.class)
    public void testVariableVectorReallocation() {
        VarCharVector vector = new VarCharVector(EMPTY_SCHEMA_PATH, this.allocator);
        int expectedAllocationInBytes = BaseValueVector.MAX_ALLOCATION_SIZE;
        int expectedOffsetSize = 10;
        try {
            vector.allocateNew(expectedAllocationInBytes, 10);
            Assert.assertTrue((10 <= vector.getValueCapacity() ? 1 : 0) != 0);
            Assert.assertTrue((expectedAllocationInBytes <= vector.getBuffer().capacity() ? 1 : 0) != 0);
            vector.reAlloc();
            Assert.assertTrue((20 <= vector.getValueCapacity() ? 1 : 0) != 0);
            Assert.assertTrue((expectedAllocationInBytes * 2 <= vector.getBuffer().capacity() ? 1 : 0) != 0);
        }
        finally {
            vector.close();
        }
        try {
            vector.allocateNew(BaseValueVector.MAX_ALLOCATION_SIZE / 2, 0);
            vector.reAlloc();
            vector.reAlloc();
        }
        finally {
            vector.close();
        }
    }
}

