/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.HashMap;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.complex.NullableMapVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMapVector {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testFieldMetadata() throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("k1", "v1");
        FieldType type = new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null, metadata);
        try (NullableMapVector vector = new NullableMapVector("map", this.allocator, type, null);){
            Assert.assertEquals((Object)vector.getField().getMetadata(), (Object)type.getMetadata());
        }
    }
}

