/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.NullableBigIntVector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.impl.UnionListReader;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestListVector {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testCopyFrom() throws Exception {
        try (ListVector inVector = ListVector.empty((String)"input", (BufferAllocator)this.allocator);
             ListVector outVector = ListVector.empty((String)"output", (BufferAllocator)this.allocator);){
            UnionListWriter writer = inVector.getWriter();
            writer.allocate();
            writer.setPosition(0);
            writer.startList();
            writer.bigInt().writeBigInt(1L);
            writer.bigInt().writeBigInt(2L);
            writer.bigInt().writeBigInt(3L);
            writer.endList();
            writer.setPosition(2);
            writer.startList();
            writer.endList();
            writer.setValueCount(3);
            outVector.allocateNew();
            for (int i = 0; i < 3; ++i) {
                outVector.copyFrom(i, i, inVector);
            }
            outVector.getMutator().setValueCount(3);
            UnionListReader reader = outVector.getReader();
            Assert.assertTrue((String)"shouldn't be null", (boolean)reader.isSet());
            reader.setPosition(1);
            Assert.assertFalse((String)"should be null", (boolean)reader.isSet());
            reader.setPosition(2);
            Assert.assertTrue((String)"shouldn't be null", (boolean)reader.isSet());
            ListVector.Accessor accessor = outVector.getAccessor();
            Object result = accessor.getObject(0);
            ArrayList resultSet = (ArrayList)result;
            Assert.assertEquals((long)3L, (long)resultSet.size());
            Assert.assertEquals((Object)new Long(1L), (Object)((Long)resultSet.get(0)));
            Assert.assertEquals((Object)new Long(2L), (Object)((Long)resultSet.get(1)));
            Assert.assertEquals((Object)new Long(3L), (Object)((Long)resultSet.get(2)));
            result = accessor.getObject(1);
            Assert.assertNull((Object)result);
            result = accessor.getObject(2);
            resultSet = (ArrayList)result;
            Assert.assertEquals((long)0L, (long)resultSet.size());
        }
    }

    @Test
    public void testSetLastSetUsage() throws Exception {
        try (ListVector listVector = ListVector.empty((String)"input", (BufferAllocator)this.allocator);){
            Types.MinorType type = Types.MinorType.BIGINT;
            listVector.addOrGetVector(FieldType.nullable((ArrowType)type.getType()));
            listVector.allocateNew();
            List innerVectors = listVector.getFieldInnerVectors();
            BitVector bitVector = (BitVector)innerVectors.get(0);
            UInt4Vector offsetVector = (UInt4Vector)innerVectors.get(1);
            NullableBigIntVector dataVector = (NullableBigIntVector)listVector.getDataVector();
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(listVector.getMutator().getLastSet()));
            int index = 0;
            int offset = 0;
            bitVector.getMutator().setSafe(index, 1);
            dataVector.getMutator().setSafe(0, 1, 10L);
            dataVector.getMutator().setSafe(1, 1, 11L);
            dataVector.getMutator().setSafe(2, 1, 12L);
            offsetVector.getMutator().setSafe(index + 1, 3);
            bitVector.getMutator().setSafe(++index, 1);
            dataVector.getMutator().setSafe(3, 1, 13L);
            dataVector.getMutator().setSafe(4, 1, 14L);
            offsetVector.getMutator().setSafe(index + 1, 5);
            bitVector.getMutator().setSafe(++index, 1);
            dataVector.getMutator().setSafe(5, 1, 15L);
            dataVector.getMutator().setSafe(6, 1, 16L);
            dataVector.getMutator().setSafe(7, 1, 17L);
            offsetVector.getMutator().setSafe(index + 1, 8);
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(listVector.getMutator().getLastSet()));
            listVector.getMutator().setLastSet(3);
            listVector.getMutator().setValueCount(10);
            UInt4Vector.Accessor offsetAccessor = offsetVector.getAccessor();
            NullableBigIntVector.Accessor valueAccessor = dataVector.getAccessor();
            index = 0;
            offset = offsetAccessor.get(index);
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(offset));
            Object actual = valueAccessor.getObject(offset);
            Assert.assertEquals((Object)new Long(10L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(11L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(12L), (Object)((Long)actual));
            offset = offsetAccessor.get(++index);
            Assert.assertEquals((Object)Integer.toString(3), (Object)Integer.toString(offset));
            actual = valueAccessor.getObject(offset);
            Assert.assertEquals((Object)new Long(13L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(14L), (Object)((Long)actual));
            offset = offsetAccessor.get(++index);
            Assert.assertEquals((Object)Integer.toString(5), (Object)Integer.toString(offset));
            actual = valueAccessor.getObject(offsetAccessor.get(index));
            Assert.assertEquals((Object)new Long(15L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(16L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(17L), (Object)((Long)actual));
            offset = offsetAccessor.get(++index);
            Assert.assertEquals((Object)Integer.toString(8), (Object)Integer.toString(offset));
            actual = valueAccessor.getObject(offsetAccessor.get(index));
            Assert.assertNull((Object)actual);
        }
    }

    @Test
    public void testSplitAndTransfer() throws Exception {
        try (ListVector listVector = ListVector.empty((String)"sourceVector", (BufferAllocator)this.allocator);){
            Types.MinorType type = Types.MinorType.BIGINT;
            listVector.addOrGetVector(FieldType.nullable((ArrowType)type.getType()));
            UnionListWriter listWriter = listVector.getWriter();
            listWriter.allocate();
            listWriter.setPosition(0);
            listWriter.startList();
            listWriter.bigInt().writeBigInt(10L);
            listWriter.bigInt().writeBigInt(11L);
            listWriter.bigInt().writeBigInt(12L);
            listWriter.endList();
            listWriter.setPosition(1);
            listWriter.startList();
            listWriter.bigInt().writeBigInt(13L);
            listWriter.bigInt().writeBigInt(14L);
            listWriter.endList();
            listWriter.setPosition(2);
            listWriter.startList();
            listWriter.bigInt().writeBigInt(15L);
            listWriter.bigInt().writeBigInt(16L);
            listWriter.bigInt().writeBigInt(17L);
            listWriter.bigInt().writeBigInt(18L);
            listWriter.endList();
            listWriter.setPosition(3);
            listWriter.startList();
            listWriter.bigInt().writeBigInt(19L);
            listWriter.endList();
            listWriter.setPosition(4);
            listWriter.startList();
            listWriter.bigInt().writeBigInt(20L);
            listWriter.bigInt().writeBigInt(21L);
            listWriter.bigInt().writeBigInt(22L);
            listWriter.bigInt().writeBigInt(23L);
            listWriter.endList();
            listVector.getMutator().setValueCount(5);
            Assert.assertEquals((long)5L, (long)listVector.getMutator().getLastSet());
            UInt4Vector offsetVector = listVector.getOffsetVector();
            NullableBigIntVector dataVector = (NullableBigIntVector)listVector.getDataVector();
            UInt4Vector.Accessor offsetAccessor = offsetVector.getAccessor();
            NullableBigIntVector.Accessor valueAccessor = dataVector.getAccessor();
            int index = 0;
            int offset = 0;
            Object actual = null;
            Assert.assertFalse((boolean)listVector.getAccessor().isNull(index));
            offset = offsetAccessor.get(index);
            Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(offset));
            actual = valueAccessor.getObject(offset);
            Assert.assertEquals((Object)new Long(10L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(11L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(12L), (Object)((Long)actual));
            Assert.assertFalse((boolean)listVector.getAccessor().isNull(++index));
            offset = offsetAccessor.get(index);
            Assert.assertEquals((Object)Integer.toString(3), (Object)Integer.toString(offset));
            actual = valueAccessor.getObject(offset);
            Assert.assertEquals((Object)new Long(13L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(14L), (Object)((Long)actual));
            Assert.assertFalse((boolean)listVector.getAccessor().isNull(++index));
            offset = offsetAccessor.get(index);
            Assert.assertEquals((Object)Integer.toString(5), (Object)Integer.toString(offset));
            actual = valueAccessor.getObject(offset);
            Assert.assertEquals((Object)new Long(15L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(16L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(17L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(18L), (Object)((Long)actual));
            Assert.assertFalse((boolean)listVector.getAccessor().isNull(++index));
            offset = offsetAccessor.get(index);
            Assert.assertEquals((Object)Integer.toString(9), (Object)Integer.toString(offset));
            actual = valueAccessor.getObject(offset);
            Assert.assertEquals((Object)new Long(19L), (Object)((Long)actual));
            Assert.assertFalse((boolean)listVector.getAccessor().isNull(++index));
            offset = offsetAccessor.get(index);
            Assert.assertEquals((Object)Integer.toString(10), (Object)Integer.toString(offset));
            actual = valueAccessor.getObject(offset);
            Assert.assertEquals((Object)new Long(20L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(21L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(22L), (Object)((Long)actual));
            actual = valueAccessor.getObject(++offset);
            Assert.assertEquals((Object)new Long(23L), (Object)((Long)actual));
            Assert.assertTrue((boolean)listVector.getAccessor().isNull(++index));
            offset = offsetAccessor.get(index);
            Assert.assertEquals((Object)Integer.toString(14), (Object)Integer.toString(offset));
            try (ListVector toVector = ListVector.empty((String)"toVector", (BufferAllocator)this.allocator);){
                int[][] transferLengths;
                TransferPair transferPair = listVector.makeTransferPair((ValueVector)toVector);
                for (int[] transferLength : transferLengths = new int[][]{{0, 2}, {3, 1}, {4, 1}}) {
                    int start = transferLength[0];
                    int splitLength = transferLength[1];
                    int dataLength1 = 0;
                    int dataLength2 = 0;
                    int offset1 = 0;
                    int offset2 = 0;
                    transferPair.splitAndTransfer(start, splitLength);
                    UInt4Vector offsetVector1 = toVector.getOffsetVector();
                    UInt4Vector.Accessor offsetAccessor1 = offsetVector1.getAccessor();
                    NullableBigIntVector dataVector1 = (NullableBigIntVector)toVector.getDataVector();
                    NullableBigIntVector.Accessor valueAccessor1 = dataVector1.getAccessor();
                    for (int i = 0; i < splitLength; ++i) {
                        dataLength1 = offsetAccessor.get(start + i + 1) - offsetAccessor.get(start + i);
                        dataLength2 = offsetAccessor1.get(i + 1) - offsetAccessor1.get(i);
                        Assert.assertEquals((String)("Different data lengths at index: " + i + " and start: " + start), (long)dataLength1, (long)dataLength2);
                        offset1 = offsetAccessor.get(start + i);
                        offset2 = offsetAccessor1.get(i);
                        for (int j = 0; j < dataLength1; ++j) {
                            Assert.assertEquals((String)("Different data at indexes: " + offset1 + " and " + offset2), (Object)valueAccessor.getObject(offset1), (Object)valueAccessor1.getObject(offset2));
                            ++offset1;
                            ++offset2;
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testNestedListVector() throws Exception {
        try (ListVector listVector = ListVector.empty((String)"sourceVector", (BufferAllocator)this.allocator);){
            UnionListWriter listWriter = listVector.getWriter();
            listWriter.allocate();
            listWriter.setPosition(0);
            listWriter.startList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(50L);
            listWriter.list().bigInt().writeBigInt(100L);
            listWriter.list().bigInt().writeBigInt(200L);
            listWriter.list().endList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(75L);
            listWriter.list().bigInt().writeBigInt(125L);
            listWriter.list().bigInt().writeBigInt(150L);
            listWriter.list().bigInt().writeBigInt(175L);
            listWriter.list().endList();
            listWriter.endList();
            listWriter.setPosition(1);
            listWriter.startList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(10L);
            listWriter.list().endList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(15L);
            listWriter.list().bigInt().writeBigInt(20L);
            listWriter.list().endList();
            listWriter.list().startList();
            listWriter.list().bigInt().writeBigInt(25L);
            listWriter.list().bigInt().writeBigInt(30L);
            listWriter.list().bigInt().writeBigInt(35L);
            listWriter.list().endList();
            listWriter.endList();
            Assert.assertEquals((long)2L, (long)listVector.getMutator().getLastSet());
            listVector.getMutator().setValueCount(2);
            ListVector.Accessor accessor = listVector.getAccessor();
            Assert.assertEquals((long)2L, (long)accessor.getValueCount());
            Object result = accessor.getObject(0);
            ArrayList resultSet = (ArrayList)result;
            Assert.assertEquals((long)2L, (long)resultSet.size());
            Assert.assertEquals((long)3L, (long)((ArrayList)resultSet.get(0)).size());
            Assert.assertEquals((long)4L, (long)((ArrayList)resultSet.get(1)).size());
            ArrayList list = (ArrayList)resultSet.get(0);
            Assert.assertEquals((Object)new Long(50L), list.get(0));
            Assert.assertEquals((Object)new Long(100L), list.get(1));
            Assert.assertEquals((Object)new Long(200L), list.get(2));
            list = (ArrayList)resultSet.get(1);
            Assert.assertEquals((Object)new Long(75L), list.get(0));
            Assert.assertEquals((Object)new Long(125L), list.get(1));
            Assert.assertEquals((Object)new Long(150L), list.get(2));
            Assert.assertEquals((Object)new Long(175L), list.get(3));
            result = accessor.getObject(1);
            resultSet = (ArrayList)result;
            Assert.assertEquals((long)3L, (long)resultSet.size());
            Assert.assertEquals((long)1L, (long)((ArrayList)resultSet.get(0)).size());
            Assert.assertEquals((long)2L, (long)((ArrayList)resultSet.get(1)).size());
            Assert.assertEquals((long)3L, (long)((ArrayList)resultSet.get(2)).size());
            list = (ArrayList)resultSet.get(0);
            Assert.assertEquals((Object)new Long(10L), list.get(0));
            list = (ArrayList)resultSet.get(1);
            Assert.assertEquals((Object)new Long(15L), list.get(0));
            Assert.assertEquals((Object)new Long(20L), list.get(1));
            list = (ArrayList)resultSet.get(2);
            Assert.assertEquals((Object)new Long(25L), list.get(0));
            Assert.assertEquals((Object)new Long(30L), list.get(1));
            Assert.assertEquals((Object)new Long(35L), list.get(2));
            Assert.assertFalse((boolean)accessor.isNull(0));
            Assert.assertFalse((boolean)accessor.isNull(1));
            UInt4Vector offsetVector = listVector.getOffsetVector();
            UInt4Vector.Accessor offsetAccessor = offsetVector.getAccessor();
            Assert.assertEquals((long)0L, (long)offsetAccessor.get(0));
            Assert.assertEquals((long)2L, (long)offsetAccessor.get(1));
            Assert.assertEquals((long)5L, (long)offsetAccessor.get(2));
        }
    }
}

