/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import com.google.common.collect.Lists;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.NullableFloat4Vector;
import org.apache.arrow.vector.NullableIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.impl.UnionFixedSizeListReader;
import org.apache.arrow.vector.complex.impl.UnionListReader;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFixedSizeListVector {
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testIntType() {
        try (FixedSizeListVector vector = FixedSizeListVector.empty((String)"list", (int)2, (BufferAllocator)this.allocator);){
            NullableIntVector nested = (NullableIntVector)vector.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType())).getVector();
            NullableIntVector.Mutator mutator = nested.getMutator();
            vector.allocateNew();
            for (int i = 0; i < 10; ++i) {
                vector.getMutator().setNotNull(i);
                mutator.set(i * 2, i);
                mutator.set(i * 2 + 1, i + 10);
            }
            vector.getMutator().setValueCount(10);
            UnionFixedSizeListReader reader = vector.getReader();
            for (int i = 0; i < 10; ++i) {
                reader.setPosition(i);
                Assert.assertTrue((boolean)reader.isSet());
                Assert.assertTrue((boolean)reader.next());
                Assert.assertEquals((long)i, (long)reader.reader().readInteger().intValue());
                Assert.assertTrue((boolean)reader.next());
                Assert.assertEquals((long)(i + 10), (long)reader.reader().readInteger().intValue());
                Assert.assertFalse((boolean)reader.next());
                Assert.assertEquals((Object)Lists.newArrayList((Object[])new Integer[]{i, i + 10}), (Object)reader.readObject());
            }
        }
    }

    @Test
    public void testFloatTypeNullable() {
        try (FixedSizeListVector vector = FixedSizeListVector.empty((String)"list", (int)2, (BufferAllocator)this.allocator);){
            NullableFloat4Vector nested = (NullableFloat4Vector)vector.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.FLOAT4.getType())).getVector();
            NullableFloat4Vector.Mutator mutator = nested.getMutator();
            vector.allocateNew();
            for (int i = 0; i < 10; ++i) {
                if (i % 2 != 0) continue;
                vector.getMutator().setNotNull(i);
                mutator.set(i * 2, (float)i + 0.1f);
                mutator.set(i * 2 + 1, (float)i + 10.1f);
            }
            vector.getMutator().setValueCount(10);
            UnionFixedSizeListReader reader = vector.getReader();
            for (int i = 0; i < 10; ++i) {
                reader.setPosition(i);
                if (i % 2 == 0) {
                    Assert.assertTrue((boolean)reader.isSet());
                    Assert.assertTrue((boolean)reader.next());
                    Assert.assertEquals((double)((float)i + 0.1f), (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
                    Assert.assertTrue((boolean)reader.next());
                    Assert.assertEquals((double)((float)i + 10.1f), (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
                    Assert.assertFalse((boolean)reader.next());
                    Assert.assertEquals((Object)Lists.newArrayList((Object[])new Float[]{Float.valueOf((float)i + 0.1f), Float.valueOf((float)i + 10.1f)}), (Object)reader.readObject());
                    continue;
                }
                Assert.assertFalse((boolean)reader.isSet());
                Assert.assertNull((Object)reader.readObject());
            }
        }
    }

    @Test
    public void testNestedInList() {
        try (ListVector vector = ListVector.empty((String)"list", (BufferAllocator)this.allocator);){
            int j;
            ListVector.Mutator mutator = vector.getMutator();
            FixedSizeListVector tuples = (FixedSizeListVector)vector.addOrGetVector(FieldType.nullable((ArrowType)new ArrowType.FixedSizeList(2))).getVector();
            FixedSizeListVector.Mutator tupleMutator = tuples.getMutator();
            NullableIntVector.Mutator innerMutator = (NullableIntVector.Mutator)tuples.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.INT.getType())).getVector().getMutator();
            vector.allocateNew();
            for (int i = 0; i < 10; ++i) {
                if (i % 2 != 0) continue;
                int position = mutator.startNewValue(i);
                for (j = 0; j < i % 7; ++j) {
                    tupleMutator.setNotNull(position + j);
                    innerMutator.set((position + j) * 2, j);
                    innerMutator.set((position + j) * 2 + 1, j + 1);
                }
                mutator.endValue(i, i % 7);
            }
            mutator.setValueCount(10);
            UnionListReader reader = vector.getReader();
            for (int i = 0; i < 10; ++i) {
                reader.setPosition(i);
                if (i % 2 == 0) {
                    for (j = 0; j < i % 7; ++j) {
                        Assert.assertTrue((boolean)reader.next());
                        FieldReader innerListReader = reader.reader();
                        for (int k = 0; k < 2; ++k) {
                            Assert.assertTrue((boolean)innerListReader.next());
                            Assert.assertEquals((long)(k + j), (long)innerListReader.reader().readInteger().intValue());
                        }
                        Assert.assertFalse((boolean)innerListReader.next());
                    }
                    Assert.assertFalse((boolean)reader.next());
                    continue;
                }
                Assert.assertFalse((boolean)reader.isSet());
                Assert.assertNull((Object)reader.readObject());
            }
        }
    }

    @Test
    public void testTransferPair() {
        try (FixedSizeListVector from = new FixedSizeListVector("from", this.allocator, 2, null, null);
             FixedSizeListVector to = new FixedSizeListVector("to", this.allocator, 2, null, null);){
            NullableFloat4Vector nested = (NullableFloat4Vector)from.addOrGetVector(FieldType.nullable((ArrowType)Types.MinorType.FLOAT4.getType())).getVector();
            NullableFloat4Vector.Mutator mutator = nested.getMutator();
            from.allocateNew();
            for (int i = 0; i < 10; ++i) {
                if (i % 2 != 0) continue;
                from.getMutator().setNotNull(i);
                mutator.set(i * 2, (float)i + 0.1f);
                mutator.set(i * 2 + 1, (float)i + 10.1f);
            }
            from.getMutator().setValueCount(10);
            TransferPair pair = from.makeTransferPair((ValueVector)to);
            pair.copyValueSafe(0, 1);
            pair.copyValueSafe(2, 2);
            to.copyFromSafe(4, 3, from);
            to.getMutator().setValueCount(10);
            UnionFixedSizeListReader reader = to.getReader();
            reader.setPosition(0);
            Assert.assertFalse((boolean)reader.isSet());
            Assert.assertNull((Object)reader.readObject());
            reader.setPosition(1);
            Assert.assertTrue((boolean)reader.isSet());
            Assert.assertTrue((boolean)reader.next());
            Assert.assertEquals((double)0.1f, (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
            Assert.assertTrue((boolean)reader.next());
            Assert.assertEquals((double)10.1f, (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
            Assert.assertFalse((boolean)reader.next());
            Assert.assertEquals((Object)Lists.newArrayList((Object[])new Float[]{Float.valueOf(0.1f), Float.valueOf(10.1f)}), (Object)reader.readObject());
            reader.setPosition(2);
            Assert.assertTrue((boolean)reader.isSet());
            Assert.assertTrue((boolean)reader.next());
            Assert.assertEquals((double)2.1f, (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
            Assert.assertTrue((boolean)reader.next());
            Assert.assertEquals((double)12.1f, (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
            Assert.assertFalse((boolean)reader.next());
            Assert.assertEquals((Object)Lists.newArrayList((Object[])new Float[]{Float.valueOf(2.1f), Float.valueOf(12.1f)}), (Object)reader.readObject());
            reader.setPosition(3);
            Assert.assertTrue((boolean)reader.isSet());
            Assert.assertTrue((boolean)reader.next());
            Assert.assertEquals((double)4.1f, (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
            Assert.assertTrue((boolean)reader.next());
            Assert.assertEquals((double)14.1f, (double)reader.reader().readFloat().floatValue(), (double)1.0E-5);
            Assert.assertFalse((boolean)reader.next());
            Assert.assertEquals((Object)Lists.newArrayList((Object[])new Float[]{Float.valueOf(4.1f), Float.valueOf(14.1f)}), (Object)reader.readObject());
            for (int i = 4; i < 10; ++i) {
                reader.setPosition(i);
                Assert.assertFalse((boolean)reader.isSet());
                Assert.assertNull((Object)reader.readObject());
            }
        }
    }
}

