/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.nio.charset.StandardCharsets;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.DirtyRootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.NullableIntVector;
import org.apache.arrow.vector.NullableVarCharVector;
import org.apache.arrow.vector.TestUtils;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryEncoder;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDictionaryVector {
    private BufferAllocator allocator;
    byte[] zero = "foo".getBytes(StandardCharsets.UTF_8);
    byte[] one = "bar".getBytes(StandardCharsets.UTF_8);
    byte[] two = "baz".getBytes(StandardCharsets.UTF_8);

    @Before
    public void init() {
        this.allocator = new DirtyRootAllocator(Long.MAX_VALUE, 100);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testEncodeStrings() {
        try (NullableVarCharVector vector = TestUtils.newNullableVarCharVector("foo", this.allocator);
             NullableVarCharVector dictionaryVector = TestUtils.newNullableVarCharVector("dict", this.allocator);){
            NullableVarCharVector.Mutator m = vector.getMutator();
            vector.allocateNew(512, 5);
            m.setSafe(0, this.zero, 0, this.zero.length);
            m.setSafe(1, this.one, 0, this.one.length);
            m.setSafe(2, this.one, 0, this.one.length);
            m.setSafe(3, this.two, 0, this.two.length);
            m.setSafe(4, this.zero, 0, this.zero.length);
            m.setValueCount(5);
            NullableVarCharVector.Mutator m2 = dictionaryVector.getMutator();
            dictionaryVector.allocateNew(512, 3);
            m2.setSafe(0, this.zero, 0, this.zero.length);
            m2.setSafe(1, this.one, 0, this.one.length);
            m2.setSafe(2, this.two, 0, this.two.length);
            m2.setValueCount(3);
            Dictionary dictionary = new Dictionary((FieldVector)dictionaryVector, new DictionaryEncoding(1L, false, null));
            try (FieldVector encoded = (FieldVector)DictionaryEncoder.encode((ValueVector)vector, (Dictionary)dictionary);){
                Assert.assertEquals(NullableIntVector.class, encoded.getClass());
                NullableIntVector.Accessor indexAccessor = ((NullableIntVector)encoded).getAccessor();
                Assert.assertEquals((long)5L, (long)indexAccessor.getValueCount());
                Assert.assertEquals((long)0L, (long)indexAccessor.get(0));
                Assert.assertEquals((long)1L, (long)indexAccessor.get(1));
                Assert.assertEquals((long)1L, (long)indexAccessor.get(2));
                Assert.assertEquals((long)2L, (long)indexAccessor.get(3));
                Assert.assertEquals((long)0L, (long)indexAccessor.get(4));
                try (ValueVector decoded = DictionaryEncoder.decode((ValueVector)encoded, (Dictionary)dictionary);){
                    Assert.assertEquals(vector.getClass(), decoded.getClass());
                    Assert.assertEquals((long)vector.getAccessor().getValueCount(), (long)decoded.getAccessor().getValueCount());
                    for (int i = 0; i < 5; ++i) {
                        Assert.assertEquals((Object)vector.getAccessor().getObject(i), (Object)decoded.getAccessor().getObject(i));
                    }
                }
            }
        }
    }
}

