/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import io.netty.buffer.ArrowBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.NullableDecimalVector;
import org.apache.arrow.vector.TestUtils;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.util.DecimalUtility;
import org.junit.Assert;
import org.junit.Test;

public class TestDecimalVector {
    private static long[] intValues = new long[60];
    private int scale = 3;

    @Test
    public void test() {
        int i;
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        NullableDecimalVector decimalVector = TestUtils.newVector(NullableDecimalVector.class, "decimal", (ArrowType)new ArrowType.Decimal(10, this.scale), (BufferAllocator)allocator);
        try (NullableDecimalVector oldConstructor = new NullableDecimalVector("decimal", (BufferAllocator)allocator, 10, this.scale);){
            Assert.assertEquals((Object)decimalVector.getField().getType(), (Object)oldConstructor.getField().getType());
        }
        decimalVector.allocateNew();
        BigDecimal[] values = new BigDecimal[intValues.length];
        for (i = 0; i < intValues.length; ++i) {
            BigDecimal decimal;
            values[i] = decimal = new BigDecimal(BigInteger.valueOf(intValues[i]), this.scale);
            decimalVector.getMutator().setIndexDefined(i);
            DecimalUtility.writeBigDecimalToArrowBuf((BigDecimal)decimal, (ArrowBuf)decimalVector.getBuffer(), (int)i);
        }
        decimalVector.getMutator().setValueCount(intValues.length);
        for (i = 0; i < intValues.length; ++i) {
            BigDecimal value = decimalVector.getAccessor().getObject(i);
            Assert.assertEquals((Object)values[i], (Object)value);
        }
    }

    static {
        for (int i = 0; i < intValues.length / 2; ++i) {
            TestDecimalVector.intValues[i] = 1 << i + 1;
            TestDecimalVector.intValues[2 * i] = -1 * (1 << i + 1);
        }
    }
}

