/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.NullableIntVector;
import org.apache.arrow.vector.NullableVarCharVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.CallBack;
import org.junit.Assert;
import org.junit.Test;

public class TestBufferOwnershipTransfer {
    @Test
    public void testTransferFixedWidth() {
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        BufferAllocator childAllocator1 = allocator.newChildAllocator("child1", 100000L, 100000L);
        BufferAllocator childAllocator2 = allocator.newChildAllocator("child2", 100000L, 100000L);
        NullableIntVector v1 = new NullableIntVector("v1", childAllocator1);
        v1.allocateNew();
        v1.getMutator().setValueCount(4095);
        NullableIntVector v2 = new NullableIntVector("v2", childAllocator2);
        v1.makeTransferPair((ValueVector)v2).transfer();
        Assert.assertEquals((long)0L, (long)childAllocator1.getAllocatedMemory());
        Assert.assertEquals((long)20480L, (long)childAllocator2.getAllocatedMemory());
    }

    @Test
    public void testTransferVariableidth() {
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        BufferAllocator childAllocator1 = allocator.newChildAllocator("child1", 100000L, 100000L);
        BufferAllocator childAllocator2 = allocator.newChildAllocator("child2", 100000L, 100000L);
        NullableVarCharVector v1 = new NullableVarCharVector("v1", childAllocator1);
        v1.allocateNew();
        v1.getMutator().setSafe(4094, "hello world".getBytes(), 0, 11);
        v1.getMutator().setValueCount(4001);
        NullableVarCharVector v2 = new NullableVarCharVector("v2", childAllocator2);
        v1.makeTransferPair((ValueVector)v2).transfer();
        Assert.assertEquals((long)0L, (long)childAllocator1.getAllocatedMemory());
        int expected = 53248;
        Assert.assertEquals((long)expected, (long)childAllocator2.getAllocatedMemory());
    }

    private static CallBack newTriggerCallback(final Pointer<Boolean> trigger) {
        trigger.value = false;
        return new CallBack(){

            public void doWork() {
                trigger.value = true;
            }
        };
    }

    @Test
    public void emptyListTransferShouldNotTriggerSchemaChange() {
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        Pointer<Boolean> trigger1 = new Pointer<Boolean>();
        Pointer<Boolean> trigger2 = new Pointer<Boolean>();
        ListVector v1 = new ListVector("v1", (BufferAllocator)allocator, FieldType.nullable((ArrowType)ArrowType.Null.INSTANCE), TestBufferOwnershipTransfer.newTriggerCallback(trigger1));
        ListVector v2 = new ListVector("v2", (BufferAllocator)allocator, FieldType.nullable((ArrowType)ArrowType.Null.INSTANCE), TestBufferOwnershipTransfer.newTriggerCallback(trigger2));
        v1.makeTransferPair((ValueVector)v2).transfer();
        Assert.assertFalse((boolean)((Boolean)trigger1.value));
        Assert.assertFalse((boolean)((Boolean)trigger2.value));
    }

    private static class Pointer<T> {
        T value;

        private Pointer() {
        }
    }
}

