/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.util.TransferPair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBitVector {
    private static final String EMPTY_SCHEMA_PATH = "";
    private BufferAllocator allocator;

    @Before
    public void init() {
        this.allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @After
    public void terminate() throws Exception {
        this.allocator.close();
    }

    @Test
    public void testBitVectorCopyFromSafe() {
        int size = 20;
        try (BitVector src = new BitVector(EMPTY_SCHEMA_PATH, this.allocator);
             BitVector dst = new BitVector(EMPTY_SCHEMA_PATH, this.allocator);){
            int i;
            src.allocateNew(20);
            dst.allocateNew(10);
            for (i = 0; i < 20; ++i) {
                src.getMutator().set(i, i % 2);
            }
            src.getMutator().setValueCount(20);
            for (i = 0; i < 20; ++i) {
                dst.copyFromSafe(i, i, src);
            }
            dst.getMutator().setValueCount(20);
            for (i = 0; i < 20; ++i) {
                Assert.assertEquals((Object)src.getAccessor().getObject(i), (Object)dst.getAccessor().getObject(i));
            }
        }
    }

    @Test
    public void testSplitAndTransfer() throws Exception {
        try (BitVector sourceVector = new BitVector("bitvector", this.allocator);){
            int[][] transferLengths;
            int i;
            BitVector.Mutator sourceMutator = sourceVector.getMutator();
            BitVector.Accessor sourceAccessor = sourceVector.getAccessor();
            sourceVector.allocateNew(40);
            for (i = 0; i < 40; ++i) {
                if ((i & 1) == 1) {
                    sourceMutator.set(i, 1);
                    continue;
                }
                sourceMutator.set(i, 0);
            }
            sourceMutator.setValueCount(40);
            for (i = 0; i < 40; ++i) {
                int result = sourceAccessor.get(i);
                if ((i & 1) == 1) {
                    Assert.assertEquals((Object)Integer.toString(1), (Object)Integer.toString(result));
                    continue;
                }
                Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(result));
            }
            TransferPair transferPair = sourceVector.getTransferPair(this.allocator);
            BitVector toVector = (BitVector)transferPair.getTo();
            BitVector.Accessor toAccessor = toVector.getAccessor();
            BitVector.Mutator toMutator = toVector.getMutator();
            for (int[] transferLength : transferLengths = new int[][]{{0, 8}, {8, 10}, {18, 0}, {18, 8}, {26, 0}, {26, 14}}) {
                int start = transferLength[0];
                int length = transferLength[1];
                transferPair.splitAndTransfer(start, length);
                for (int i2 = 0; i2 < length; ++i2) {
                    int result = toAccessor.get(i2);
                    if ((i2 & 1) == 1) {
                        Assert.assertEquals((Object)Integer.toString(1), (Object)Integer.toString(result));
                        continue;
                    }
                    Assert.assertEquals((Object)Integer.toString(0), (Object)Integer.toString(result));
                }
                toVector.clear();
            }
            sourceVector.close();
        }
    }
}

