/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class NamespacesCommand
extends Shell.Command {
    private Option disablePaginationOpt;
    private Option namespaceIdOption;
    private static final String DEFAULT_NAMESPACE_DISPLAY_NAME = "\"\"";

    @Override
    public int execute(String fullCommand, final CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, IOException {
        TreeMap namespaces = new TreeMap(shellState.getConnector().namespaceOperations().namespaceIdMap());
        Iterator it = Iterators.transform(namespaces.entrySet().iterator(), (Function)new Function<Map.Entry<String, String>, String>(){

            public String apply(Map.Entry<String, String> entry) {
                String name = entry.getKey();
                if ("".equals(name)) {
                    name = NamespacesCommand.DEFAULT_NAMESPACE_DISPLAY_NAME;
                }
                String id = entry.getValue();
                if (cl.hasOption(NamespacesCommand.this.namespaceIdOption.getOpt())) {
                    return String.format("%-20s => %9s%n", name, id);
                }
                return name;
            }
        });
        shellState.printLines(it, !cl.hasOption(this.disablePaginationOpt.getOpt()));
        return 0;
    }

    @Override
    public String description() {
        return "displays a list of all existing namespaces";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.namespaceIdOption = new Option("l", "list-ids", false, "display internal namespace ids along with the name");
        o.addOption(this.namespaceIdOption);
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        o.addOption(this.disablePaginationOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

