/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.VisibilityConstraint;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.ShellUtil;
import org.apache.accumulo.shell.Token;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;

public class CreateTableCommand
extends Shell.Command {
    private Option createTableOptCopySplits;
    private Option createTableOptCopyConfig;
    private Option createTableOptSplit;
    private Option createTableOptTimeLogical;
    private Option createTableOptTimeMillis;
    private Option createTableNoDefaultIters;
    private Option createTableOptEVC;
    private Option base64Opt;
    private Option createTableOptFormatter;
    private Option createTableOptInitProp;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, IOException, ClassNotFoundException {
        String oldTable;
        String testTableName = cl.getArgs()[0];
        HashMap<String, String> props = new HashMap<String, String>();
        if (!testTableName.matches("^(\\w+\\.)?(\\w+)$")) {
            shellState.getReader().println((CharSequence)"Only letters, numbers and underscores are allowed for use in table names.");
            throw new IllegalArgumentException();
        }
        String tableName = cl.getArgs()[0];
        if (shellState.getConnector().tableOperations().exists(tableName)) {
            throw new TableExistsException(null, tableName, null);
        }
        TreeSet<Text> partitions = new TreeSet<Text>();
        boolean decode = cl.hasOption(this.base64Opt.getOpt());
        if (cl.hasOption(this.createTableOptSplit.getOpt())) {
            partitions.addAll(ShellUtil.scanFile(cl.getOptionValue(this.createTableOptSplit.getOpt()), decode));
        } else if (cl.hasOption(this.createTableOptCopySplits.getOpt())) {
            oldTable = cl.getOptionValue(this.createTableOptCopySplits.getOpt());
            if (!shellState.getConnector().tableOperations().exists(oldTable)) {
                throw new TableNotFoundException(null, oldTable, null);
            }
            partitions.addAll(shellState.getConnector().tableOperations().listSplits(oldTable));
        }
        if (cl.hasOption(this.createTableOptCopyConfig.getOpt())) {
            oldTable = cl.getOptionValue(this.createTableOptCopyConfig.getOpt());
            if (!shellState.getConnector().tableOperations().exists(oldTable)) {
                throw new TableNotFoundException(null, oldTable, null);
            }
        }
        TimeType timeType = TimeType.MILLIS;
        if (cl.hasOption(this.createTableOptTimeLogical.getOpt())) {
            timeType = TimeType.LOGICAL;
        }
        if (cl.hasOption(this.createTableOptInitProp.getOpt())) {
            String[] keyVals;
            for (String keyVal : keyVals = StringUtils.split((String)cl.getOptionValue(this.createTableOptInitProp.getOpt()), (char)',')) {
                String[] sa = StringUtils.split((String)keyVal, (char)'=');
                props.put(sa[0], sa[1]);
            }
        }
        shellState.getConnector().tableOperations().create(tableName, new NewTableConfiguration().setTimeType(timeType).setProperties(props));
        if (partitions.size() > 0) {
            shellState.getConnector().tableOperations().addSplits(tableName, partitions);
        }
        shellState.setTableName(tableName);
        if (cl.hasOption(this.createTableNoDefaultIters.getOpt())) {
            for (String key : IteratorUtil.generateInitialTableProperties((boolean)true).keySet()) {
                shellState.getConnector().tableOperations().removeProperty(tableName, key);
            }
        }
        if (cl.hasOption(this.createTableOptCopyConfig.getOpt()) && shellState.getConnector().tableOperations().exists(tableName)) {
            Iterable configuration = shellState.getConnector().tableOperations().getProperties(cl.getOptionValue(this.createTableOptCopyConfig.getOpt()));
            for (Map.Entry entry : configuration) {
                if (!Property.isValidTablePropertyKey((String)((String)entry.getKey()))) continue;
                shellState.getConnector().tableOperations().setProperty(tableName, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (cl.hasOption(this.createTableOptEVC.getOpt())) {
            try {
                shellState.getConnector().tableOperations().addConstraint(tableName, VisibilityConstraint.class.getName());
            }
            catch (AccumuloException e) {
                Shell.log.warn((Object)(e.getMessage() + " while setting visibility constraint, but table was created"));
            }
        }
        if (cl.hasOption(this.createTableOptFormatter.getOpt())) {
            String formatterClass = cl.getOptionValue(this.createTableOptFormatter.getOpt());
            shellState.getConnector().tableOperations().setProperty(tableName, Property.TABLE_FORMATTER_CLASS.toString(), formatterClass);
        }
        return 0;
    }

    @Override
    public String description() {
        return "creates a new table, with optional aggregators and optionally pre-split";
    }

    @Override
    public String usage() {
        return this.getName() + " <tableName>";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.createTableOptCopyConfig = new Option("cc", "copy-config", true, "table to copy configuration from");
        this.createTableOptCopySplits = new Option("cs", "copy-splits", true, "table to copy current splits from");
        this.createTableOptSplit = new Option("sf", "splits-file", true, "file with a newline-separated list of rows to split the table with");
        this.createTableOptTimeLogical = new Option("tl", "time-logical", false, "use logical time");
        this.createTableOptTimeMillis = new Option("tm", "time-millis", false, "use time in milliseconds");
        this.createTableNoDefaultIters = new Option("ndi", "no-default-iterators", false, "prevent creation of the normal default iterator set");
        this.createTableOptEVC = new Option("evc", "enable-visibility-constraint", false, "prevent users from writing data they cannot read.  When enabling this, consider disabling bulk import and alter table.");
        this.createTableOptFormatter = new Option("f", "formatter", true, "default formatter to set");
        this.createTableOptInitProp = new Option("prop", "init-properties", true, "user defined initial properties");
        this.createTableOptCopyConfig.setArgName("table");
        this.createTableOptCopySplits.setArgName("table");
        this.createTableOptSplit.setArgName("filename");
        this.createTableOptFormatter.setArgName("className");
        this.createTableOptInitProp.setArgName("properties");
        OptionGroup splitOrCopySplit = new OptionGroup();
        splitOrCopySplit.addOption(this.createTableOptSplit);
        splitOrCopySplit.addOption(this.createTableOptCopySplits);
        OptionGroup timeGroup = new OptionGroup();
        timeGroup.addOption(this.createTableOptTimeLogical);
        timeGroup.addOption(this.createTableOptTimeMillis);
        this.base64Opt = new Option("b64", "base64encoded", false, "decode encoded split points");
        o.addOption(this.base64Opt);
        o.addOptionGroup(splitOrCopySplit);
        o.addOptionGroup(timeGroup);
        o.addOption(this.createTableOptSplit);
        o.addOption(this.createTableOptCopyConfig);
        o.addOption(this.createTableNoDefaultIters);
        o.addOption(this.createTableOptEVC);
        o.addOption(this.createTableOptFormatter);
        o.addOption(this.createTableOptInitProp);
        return o;
    }

    @Override
    public int numArgs() {
        return 1;
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> special) {
        this.registerCompletionForNamespaces(root, special);
    }
}

