/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.proxy.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.proxy.thrift.IteratorSetting;
import org.apache.accumulo.proxy.thrift.Range;
import org.apache.accumulo.proxy.thrift.ScanColumn;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ScanOptions
implements TBase<ScanOptions, _Fields>,
Serializable,
Cloneable,
Comparable<ScanOptions> {
    private static final TStruct STRUCT_DESC = new TStruct("ScanOptions");
    private static final TField AUTHORIZATIONS_FIELD_DESC = new TField("authorizations", 14, 1);
    private static final TField RANGE_FIELD_DESC = new TField("range", 12, 2);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 3);
    private static final TField ITERATORS_FIELD_DESC = new TField("iterators", 15, 4);
    private static final TField BUFFER_SIZE_FIELD_DESC = new TField("bufferSize", 8, 5);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public Set<ByteBuffer> authorizations;
    public Range range;
    public List<ScanColumn> columns;
    public List<IteratorSetting> iterators;
    public int bufferSize;
    private static final int __BUFFERSIZE_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private _Fields[] optionals = new _Fields[]{_Fields.AUTHORIZATIONS, _Fields.RANGE, _Fields.COLUMNS, _Fields.ITERATORS, _Fields.BUFFER_SIZE};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ScanOptions() {
    }

    public ScanOptions(ScanOptions other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetAuthorizations()) {
            HashSet<ByteBuffer> __this__authorizations = new HashSet<ByteBuffer>(other.authorizations);
            this.authorizations = __this__authorizations;
        }
        if (other.isSetRange()) {
            this.range = new Range(other.range);
        }
        if (other.isSetColumns()) {
            ArrayList<ScanColumn> __this__columns = new ArrayList<ScanColumn>(other.columns.size());
            for (ScanColumn scanColumn : other.columns) {
                __this__columns.add(new ScanColumn(scanColumn));
            }
            this.columns = __this__columns;
        }
        if (other.isSetIterators()) {
            ArrayList<IteratorSetting> __this__iterators = new ArrayList<IteratorSetting>(other.iterators.size());
            for (IteratorSetting iteratorSetting : other.iterators) {
                __this__iterators.add(new IteratorSetting(iteratorSetting));
            }
            this.iterators = __this__iterators;
        }
        this.bufferSize = other.bufferSize;
    }

    public ScanOptions deepCopy() {
        return new ScanOptions(this);
    }

    public void clear() {
        this.authorizations = null;
        this.range = null;
        this.columns = null;
        this.iterators = null;
        this.setBufferSizeIsSet(false);
        this.bufferSize = 0;
    }

    public int getAuthorizationsSize() {
        return this.authorizations == null ? 0 : this.authorizations.size();
    }

    public Iterator<ByteBuffer> getAuthorizationsIterator() {
        return this.authorizations == null ? null : this.authorizations.iterator();
    }

    public void addToAuthorizations(ByteBuffer elem) {
        if (this.authorizations == null) {
            this.authorizations = new HashSet<ByteBuffer>();
        }
        this.authorizations.add(elem);
    }

    public Set<ByteBuffer> getAuthorizations() {
        return this.authorizations;
    }

    public ScanOptions setAuthorizations(Set<ByteBuffer> authorizations) {
        this.authorizations = authorizations;
        return this;
    }

    public void unsetAuthorizations() {
        this.authorizations = null;
    }

    public boolean isSetAuthorizations() {
        return this.authorizations != null;
    }

    public void setAuthorizationsIsSet(boolean value) {
        if (!value) {
            this.authorizations = null;
        }
    }

    public Range getRange() {
        return this.range;
    }

    public ScanOptions setRange(Range range) {
        this.range = range;
        return this;
    }

    public void unsetRange() {
        this.range = null;
    }

    public boolean isSetRange() {
        return this.range != null;
    }

    public void setRangeIsSet(boolean value) {
        if (!value) {
            this.range = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public Iterator<ScanColumn> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(ScanColumn elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<ScanColumn>();
        }
        this.columns.add(elem);
    }

    public List<ScanColumn> getColumns() {
        return this.columns;
    }

    public ScanOptions setColumns(List<ScanColumn> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public int getIteratorsSize() {
        return this.iterators == null ? 0 : this.iterators.size();
    }

    public Iterator<IteratorSetting> getIteratorsIterator() {
        return this.iterators == null ? null : this.iterators.iterator();
    }

    public void addToIterators(IteratorSetting elem) {
        if (this.iterators == null) {
            this.iterators = new ArrayList<IteratorSetting>();
        }
        this.iterators.add(elem);
    }

    public List<IteratorSetting> getIterators() {
        return this.iterators;
    }

    public ScanOptions setIterators(List<IteratorSetting> iterators) {
        this.iterators = iterators;
        return this;
    }

    public void unsetIterators() {
        this.iterators = null;
    }

    public boolean isSetIterators() {
        return this.iterators != null;
    }

    public void setIteratorsIsSet(boolean value) {
        if (!value) {
            this.iterators = null;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public ScanOptions setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        this.setBufferSizeIsSet(true);
        return this;
    }

    public void unsetBufferSize() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetBufferSize() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setBufferSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case AUTHORIZATIONS: {
                if (value == null) {
                    this.unsetAuthorizations();
                    break;
                }
                this.setAuthorizations((Set)value);
                break;
            }
            case RANGE: {
                if (value == null) {
                    this.unsetRange();
                    break;
                }
                this.setRange((Range)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
                break;
            }
            case ITERATORS: {
                if (value == null) {
                    this.unsetIterators();
                    break;
                }
                this.setIterators((List)value);
                break;
            }
            case BUFFER_SIZE: {
                if (value == null) {
                    this.unsetBufferSize();
                    break;
                }
                this.setBufferSize((Integer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case AUTHORIZATIONS: {
                return this.getAuthorizations();
            }
            case RANGE: {
                return this.getRange();
            }
            case COLUMNS: {
                return this.getColumns();
            }
            case ITERATORS: {
                return this.getIterators();
            }
            case BUFFER_SIZE: {
                return this.getBufferSize();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case AUTHORIZATIONS: {
                return this.isSetAuthorizations();
            }
            case RANGE: {
                return this.isSetRange();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
            case ITERATORS: {
                return this.isSetIterators();
            }
            case BUFFER_SIZE: {
                return this.isSetBufferSize();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ScanOptions) {
            return this.equals((ScanOptions)that);
        }
        return false;
    }

    public boolean equals(ScanOptions that) {
        if (that == null) {
            return false;
        }
        boolean this_present_authorizations = this.isSetAuthorizations();
        boolean that_present_authorizations = that.isSetAuthorizations();
        if (this_present_authorizations || that_present_authorizations) {
            if (!this_present_authorizations || !that_present_authorizations) {
                return false;
            }
            if (!((Object)this.authorizations).equals(that.authorizations)) {
                return false;
            }
        }
        boolean this_present_range = this.isSetRange();
        boolean that_present_range = that.isSetRange();
        if (this_present_range || that_present_range) {
            if (!this_present_range || !that_present_range) {
                return false;
            }
            if (!this.range.equals(that.range)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!((Object)this.columns).equals(that.columns)) {
                return false;
            }
        }
        boolean this_present_iterators = this.isSetIterators();
        boolean that_present_iterators = that.isSetIterators();
        if (this_present_iterators || that_present_iterators) {
            if (!this_present_iterators || !that_present_iterators) {
                return false;
            }
            if (!((Object)this.iterators).equals(that.iterators)) {
                return false;
            }
        }
        boolean this_present_bufferSize = this.isSetBufferSize();
        boolean that_present_bufferSize = that.isSetBufferSize();
        if (this_present_bufferSize || that_present_bufferSize) {
            if (!this_present_bufferSize || !that_present_bufferSize) {
                return false;
            }
            if (this.bufferSize != that.bufferSize) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(ScanOptions other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetAuthorizations()).compareTo(other.isSetAuthorizations());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAuthorizations() && (lastComparison = TBaseHelper.compareTo(this.authorizations, other.authorizations)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRange()).compareTo(other.isSetRange());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRange() && (lastComparison = TBaseHelper.compareTo((Comparable)this.range, (Comparable)other.range)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(other.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, other.columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIterators()).compareTo(other.isSetIterators());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIterators() && (lastComparison = TBaseHelper.compareTo(this.iterators, other.iterators)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBufferSize()).compareTo(other.isSetBufferSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBufferSize() && (lastComparison = TBaseHelper.compareTo((int)this.bufferSize, (int)other.bufferSize)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ScanOptions(");
        boolean first = true;
        if (this.isSetAuthorizations()) {
            sb.append("authorizations:");
            if (this.authorizations == null) {
                sb.append("null");
            } else {
                sb.append(this.authorizations);
            }
            first = false;
        }
        if (this.isSetRange()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("range:");
            if (this.range == null) {
                sb.append("null");
            } else {
                sb.append(this.range);
            }
            first = false;
        }
        if (this.isSetColumns()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("columns:");
            if (this.columns == null) {
                sb.append("null");
            } else {
                sb.append(this.columns);
            }
            first = false;
        }
        if (this.isSetIterators()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("iterators:");
            if (this.iterators == null) {
                sb.append("null");
            } else {
                sb.append(this.iterators);
            }
            first = false;
        }
        if (this.isSetBufferSize()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("bufferSize:");
            sb.append(this.bufferSize);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.range != null) {
            this.range.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ScanOptionsStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ScanOptionsTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.AUTHORIZATIONS, new FieldMetaData("authorizations", 2, (FieldValueMetaData)new SetMetaData(14, new FieldValueMetaData(11, true))));
        tmpMap.put(_Fields.RANGE, new FieldMetaData("range", 2, (FieldValueMetaData)new StructMetaData(12, Range.class)));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, ScanColumn.class))));
        tmpMap.put(_Fields.ITERATORS, new FieldMetaData("iterators", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, IteratorSetting.class))));
        tmpMap.put(_Fields.BUFFER_SIZE, new FieldMetaData("bufferSize", 2, new FieldValueMetaData(8)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ScanOptions.class, metaDataMap);
    }

    private static class ScanOptionsTupleScheme
    extends TupleScheme<ScanOptions> {
        private ScanOptionsTupleScheme() {
        }

        public void write(TProtocol prot, ScanOptions struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetAuthorizations()) {
                optionals.set(0);
            }
            if (struct.isSetRange()) {
                optionals.set(1);
            }
            if (struct.isSetColumns()) {
                optionals.set(2);
            }
            if (struct.isSetIterators()) {
                optionals.set(3);
            }
            if (struct.isSetBufferSize()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetAuthorizations()) {
                oprot.writeI32(struct.authorizations.size());
                for (ByteBuffer _iter38 : struct.authorizations) {
                    oprot.writeBinary(_iter38);
                }
            }
            if (struct.isSetRange()) {
                struct.range.write((TProtocol)oprot);
            }
            if (struct.isSetColumns()) {
                oprot.writeI32(struct.columns.size());
                for (ScanColumn _iter39 : struct.columns) {
                    _iter39.write((TProtocol)oprot);
                }
            }
            if (struct.isSetIterators()) {
                oprot.writeI32(struct.iterators.size());
                for (IteratorSetting _iter40 : struct.iterators) {
                    _iter40.write((TProtocol)oprot);
                }
            }
            if (struct.isSetBufferSize()) {
                oprot.writeI32(struct.bufferSize);
            }
        }

        public void read(TProtocol prot, ScanOptions struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                TSet _set41 = new TSet(11, iprot.readI32());
                struct.authorizations = new HashSet<ByteBuffer>(2 * _set41.size);
                for (int _i42 = 0; _i42 < _set41.size; ++_i42) {
                    ByteBuffer _elem43 = iprot.readBinary();
                    struct.authorizations.add(_elem43);
                }
                struct.setAuthorizationsIsSet(true);
            }
            if (incoming.get(1)) {
                struct.range = new Range();
                struct.range.read((TProtocol)iprot);
                struct.setRangeIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list44 = new TList(12, iprot.readI32());
                struct.columns = new ArrayList<ScanColumn>(_list44.size);
                for (int _i45 = 0; _i45 < _list44.size; ++_i45) {
                    ScanColumn _elem46 = new ScanColumn();
                    _elem46.read((TProtocol)iprot);
                    struct.columns.add(_elem46);
                }
                struct.setColumnsIsSet(true);
            }
            if (incoming.get(3)) {
                TList _list47 = new TList(12, iprot.readI32());
                struct.iterators = new ArrayList<IteratorSetting>(_list47.size);
                for (int _i48 = 0; _i48 < _list47.size; ++_i48) {
                    IteratorSetting _elem49 = new IteratorSetting();
                    _elem49.read((TProtocol)iprot);
                    struct.iterators.add(_elem49);
                }
                struct.setIteratorsIsSet(true);
            }
            if (incoming.get(4)) {
                struct.bufferSize = iprot.readI32();
                struct.setBufferSizeIsSet(true);
            }
        }
    }

    private static class ScanOptionsTupleSchemeFactory
    implements SchemeFactory {
        private ScanOptionsTupleSchemeFactory() {
        }

        public ScanOptionsTupleScheme getScheme() {
            return new ScanOptionsTupleScheme();
        }
    }

    private static class ScanOptionsStandardScheme
    extends StandardScheme<ScanOptions> {
        private ScanOptionsStandardScheme() {
        }

        public void read(TProtocol iprot, ScanOptions struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 14) {
                            TSet _set26 = iprot.readSetBegin();
                            struct.authorizations = new HashSet<ByteBuffer>(2 * _set26.size);
                            for (int _i27 = 0; _i27 < _set26.size; ++_i27) {
                                ByteBuffer _elem28 = iprot.readBinary();
                                struct.authorizations.add(_elem28);
                            }
                            iprot.readSetEnd();
                            struct.setAuthorizationsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.range = new Range();
                            struct.range.read(iprot);
                            struct.setRangeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list29 = iprot.readListBegin();
                            struct.columns = new ArrayList<ScanColumn>(_list29.size);
                            for (int _i30 = 0; _i30 < _list29.size; ++_i30) {
                                ScanColumn _elem31 = new ScanColumn();
                                _elem31.read(iprot);
                                struct.columns.add(_elem31);
                            }
                            iprot.readListEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 15) {
                            TList _list32 = iprot.readListBegin();
                            struct.iterators = new ArrayList<IteratorSetting>(_list32.size);
                            for (int _i33 = 0; _i33 < _list32.size; ++_i33) {
                                IteratorSetting _elem34 = new IteratorSetting();
                                _elem34.read(iprot);
                                struct.iterators.add(_elem34);
                            }
                            iprot.readListEnd();
                            struct.setIteratorsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.bufferSize = iprot.readI32();
                            struct.setBufferSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, ScanOptions struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.authorizations != null && struct.isSetAuthorizations()) {
                oprot.writeFieldBegin(AUTHORIZATIONS_FIELD_DESC);
                oprot.writeSetBegin(new TSet(11, struct.authorizations.size()));
                for (ByteBuffer _iter35 : struct.authorizations) {
                    oprot.writeBinary(_iter35);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            if (struct.range != null && struct.isSetRange()) {
                oprot.writeFieldBegin(RANGE_FIELD_DESC);
                struct.range.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.columns != null && struct.isSetColumns()) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.columns.size()));
                for (ScanColumn _iter36 : struct.columns) {
                    _iter36.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.iterators != null && struct.isSetIterators()) {
                oprot.writeFieldBegin(ITERATORS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.iterators.size()));
                for (IteratorSetting _iter37 : struct.iterators) {
                    _iter37.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetBufferSize()) {
                oprot.writeFieldBegin(BUFFER_SIZE_FIELD_DESC);
                oprot.writeI32(struct.bufferSize);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ScanOptionsStandardSchemeFactory
    implements SchemeFactory {
        private ScanOptionsStandardSchemeFactory() {
        }

        public ScanOptionsStandardScheme getScheme() {
            return new ScanOptionsStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        AUTHORIZATIONS(1, "authorizations"),
        RANGE(2, "range"),
        COLUMNS(3, "columns"),
        ITERATORS(4, "iterators"),
        BUFFER_SIZE(5, "bufferSize");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return AUTHORIZATIONS;
                }
                case 2: {
                    return RANGE;
                }
                case 3: {
                    return COLUMNS;
                }
                case 4: {
                    return ITERATORS;
                }
                case 5: {
                    return BUFFER_SIZE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

