/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.proxy.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ConditionalWriterOptions
implements TBase<ConditionalWriterOptions, _Fields>,
Serializable,
Cloneable,
Comparable<ConditionalWriterOptions> {
    private static final TStruct STRUCT_DESC = new TStruct("ConditionalWriterOptions");
    private static final TField MAX_MEMORY_FIELD_DESC = new TField("maxMemory", 10, 1);
    private static final TField TIMEOUT_MS_FIELD_DESC = new TField("timeoutMs", 10, 2);
    private static final TField THREADS_FIELD_DESC = new TField("threads", 8, 3);
    private static final TField AUTHORIZATIONS_FIELD_DESC = new TField("authorizations", 14, 4);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public long maxMemory;
    public long timeoutMs;
    public int threads;
    public Set<ByteBuffer> authorizations;
    private static final int __MAXMEMORY_ISSET_ID = 0;
    private static final int __TIMEOUTMS_ISSET_ID = 1;
    private static final int __THREADS_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    private _Fields[] optionals = new _Fields[]{_Fields.MAX_MEMORY, _Fields.TIMEOUT_MS, _Fields.THREADS, _Fields.AUTHORIZATIONS};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ConditionalWriterOptions() {
    }

    public ConditionalWriterOptions(ConditionalWriterOptions other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.maxMemory = other.maxMemory;
        this.timeoutMs = other.timeoutMs;
        this.threads = other.threads;
        if (other.isSetAuthorizations()) {
            HashSet<ByteBuffer> __this__authorizations = new HashSet<ByteBuffer>(other.authorizations);
            this.authorizations = __this__authorizations;
        }
    }

    public ConditionalWriterOptions deepCopy() {
        return new ConditionalWriterOptions(this);
    }

    public void clear() {
        this.setMaxMemoryIsSet(false);
        this.maxMemory = 0L;
        this.setTimeoutMsIsSet(false);
        this.timeoutMs = 0L;
        this.setThreadsIsSet(false);
        this.threads = 0;
        this.authorizations = null;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public ConditionalWriterOptions setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
        this.setMaxMemoryIsSet(true);
        return this;
    }

    public void unsetMaxMemory() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetMaxMemory() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setMaxMemoryIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public ConditionalWriterOptions setTimeoutMs(long timeoutMs) {
        this.timeoutMs = timeoutMs;
        this.setTimeoutMsIsSet(true);
        return this;
    }

    public void unsetTimeoutMs() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetTimeoutMs() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setTimeoutMsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getThreads() {
        return this.threads;
    }

    public ConditionalWriterOptions setThreads(int threads) {
        this.threads = threads;
        this.setThreadsIsSet(true);
        return this;
    }

    public void unsetThreads() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetThreads() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setThreadsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getAuthorizationsSize() {
        return this.authorizations == null ? 0 : this.authorizations.size();
    }

    public Iterator<ByteBuffer> getAuthorizationsIterator() {
        return this.authorizations == null ? null : this.authorizations.iterator();
    }

    public void addToAuthorizations(ByteBuffer elem) {
        if (this.authorizations == null) {
            this.authorizations = new HashSet<ByteBuffer>();
        }
        this.authorizations.add(elem);
    }

    public Set<ByteBuffer> getAuthorizations() {
        return this.authorizations;
    }

    public ConditionalWriterOptions setAuthorizations(Set<ByteBuffer> authorizations) {
        this.authorizations = authorizations;
        return this;
    }

    public void unsetAuthorizations() {
        this.authorizations = null;
    }

    public boolean isSetAuthorizations() {
        return this.authorizations != null;
    }

    public void setAuthorizationsIsSet(boolean value) {
        if (!value) {
            this.authorizations = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case MAX_MEMORY: {
                if (value == null) {
                    this.unsetMaxMemory();
                    break;
                }
                this.setMaxMemory((Long)value);
                break;
            }
            case TIMEOUT_MS: {
                if (value == null) {
                    this.unsetTimeoutMs();
                    break;
                }
                this.setTimeoutMs((Long)value);
                break;
            }
            case THREADS: {
                if (value == null) {
                    this.unsetThreads();
                    break;
                }
                this.setThreads((Integer)value);
                break;
            }
            case AUTHORIZATIONS: {
                if (value == null) {
                    this.unsetAuthorizations();
                    break;
                }
                this.setAuthorizations((Set)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case MAX_MEMORY: {
                return this.getMaxMemory();
            }
            case TIMEOUT_MS: {
                return this.getTimeoutMs();
            }
            case THREADS: {
                return this.getThreads();
            }
            case AUTHORIZATIONS: {
                return this.getAuthorizations();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case MAX_MEMORY: {
                return this.isSetMaxMemory();
            }
            case TIMEOUT_MS: {
                return this.isSetTimeoutMs();
            }
            case THREADS: {
                return this.isSetThreads();
            }
            case AUTHORIZATIONS: {
                return this.isSetAuthorizations();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ConditionalWriterOptions) {
            return this.equals((ConditionalWriterOptions)that);
        }
        return false;
    }

    public boolean equals(ConditionalWriterOptions that) {
        if (that == null) {
            return false;
        }
        boolean this_present_maxMemory = this.isSetMaxMemory();
        boolean that_present_maxMemory = that.isSetMaxMemory();
        if (this_present_maxMemory || that_present_maxMemory) {
            if (!this_present_maxMemory || !that_present_maxMemory) {
                return false;
            }
            if (this.maxMemory != that.maxMemory) {
                return false;
            }
        }
        boolean this_present_timeoutMs = this.isSetTimeoutMs();
        boolean that_present_timeoutMs = that.isSetTimeoutMs();
        if (this_present_timeoutMs || that_present_timeoutMs) {
            if (!this_present_timeoutMs || !that_present_timeoutMs) {
                return false;
            }
            if (this.timeoutMs != that.timeoutMs) {
                return false;
            }
        }
        boolean this_present_threads = this.isSetThreads();
        boolean that_present_threads = that.isSetThreads();
        if (this_present_threads || that_present_threads) {
            if (!this_present_threads || !that_present_threads) {
                return false;
            }
            if (this.threads != that.threads) {
                return false;
            }
        }
        boolean this_present_authorizations = this.isSetAuthorizations();
        boolean that_present_authorizations = that.isSetAuthorizations();
        if (this_present_authorizations || that_present_authorizations) {
            if (!this_present_authorizations || !that_present_authorizations) {
                return false;
            }
            if (!((Object)this.authorizations).equals(that.authorizations)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(ConditionalWriterOptions other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetMaxMemory()).compareTo(other.isSetMaxMemory());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxMemory() && (lastComparison = TBaseHelper.compareTo((long)this.maxMemory, (long)other.maxMemory)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTimeoutMs()).compareTo(other.isSetTimeoutMs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTimeoutMs() && (lastComparison = TBaseHelper.compareTo((long)this.timeoutMs, (long)other.timeoutMs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetThreads()).compareTo(other.isSetThreads());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetThreads() && (lastComparison = TBaseHelper.compareTo((int)this.threads, (int)other.threads)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAuthorizations()).compareTo(other.isSetAuthorizations());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAuthorizations() && (lastComparison = TBaseHelper.compareTo(this.authorizations, other.authorizations)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConditionalWriterOptions(");
        boolean first = true;
        if (this.isSetMaxMemory()) {
            sb.append("maxMemory:");
            sb.append(this.maxMemory);
            first = false;
        }
        if (this.isSetTimeoutMs()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("timeoutMs:");
            sb.append(this.timeoutMs);
            first = false;
        }
        if (this.isSetThreads()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("threads:");
            sb.append(this.threads);
            first = false;
        }
        if (this.isSetAuthorizations()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("authorizations:");
            if (this.authorizations == null) {
                sb.append("null");
            } else {
                sb.append(this.authorizations);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ConditionalWriterOptionsStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ConditionalWriterOptionsTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.MAX_MEMORY, new FieldMetaData("maxMemory", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TIMEOUT_MS, new FieldMetaData("timeoutMs", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.THREADS, new FieldMetaData("threads", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.AUTHORIZATIONS, new FieldMetaData("authorizations", 2, (FieldValueMetaData)new SetMetaData(14, new FieldValueMetaData(11, true))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ConditionalWriterOptions.class, metaDataMap);
    }

    private static class ConditionalWriterOptionsTupleScheme
    extends TupleScheme<ConditionalWriterOptions> {
        private ConditionalWriterOptionsTupleScheme() {
        }

        public void write(TProtocol prot, ConditionalWriterOptions struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetMaxMemory()) {
                optionals.set(0);
            }
            if (struct.isSetTimeoutMs()) {
                optionals.set(1);
            }
            if (struct.isSetThreads()) {
                optionals.set(2);
            }
            if (struct.isSetAuthorizations()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetMaxMemory()) {
                oprot.writeI64(struct.maxMemory);
            }
            if (struct.isSetTimeoutMs()) {
                oprot.writeI64(struct.timeoutMs);
            }
            if (struct.isSetThreads()) {
                oprot.writeI32(struct.threads);
            }
            if (struct.isSetAuthorizations()) {
                oprot.writeI32(struct.authorizations.size());
                for (ByteBuffer _iter110 : struct.authorizations) {
                    oprot.writeBinary(_iter110);
                }
            }
        }

        public void read(TProtocol prot, ConditionalWriterOptions struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                struct.maxMemory = iprot.readI64();
                struct.setMaxMemoryIsSet(true);
            }
            if (incoming.get(1)) {
                struct.timeoutMs = iprot.readI64();
                struct.setTimeoutMsIsSet(true);
            }
            if (incoming.get(2)) {
                struct.threads = iprot.readI32();
                struct.setThreadsIsSet(true);
            }
            if (incoming.get(3)) {
                TSet _set111 = new TSet(11, iprot.readI32());
                struct.authorizations = new HashSet<ByteBuffer>(2 * _set111.size);
                for (int _i112 = 0; _i112 < _set111.size; ++_i112) {
                    ByteBuffer _elem113 = iprot.readBinary();
                    struct.authorizations.add(_elem113);
                }
                struct.setAuthorizationsIsSet(true);
            }
        }
    }

    private static class ConditionalWriterOptionsTupleSchemeFactory
    implements SchemeFactory {
        private ConditionalWriterOptionsTupleSchemeFactory() {
        }

        public ConditionalWriterOptionsTupleScheme getScheme() {
            return new ConditionalWriterOptionsTupleScheme();
        }
    }

    private static class ConditionalWriterOptionsStandardScheme
    extends StandardScheme<ConditionalWriterOptions> {
        private ConditionalWriterOptionsStandardScheme() {
        }

        public void read(TProtocol iprot, ConditionalWriterOptions struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.maxMemory = iprot.readI64();
                            struct.setMaxMemoryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.timeoutMs = iprot.readI64();
                            struct.setTimeoutMsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.threads = iprot.readI32();
                            struct.setThreadsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 14) {
                            TSet _set106 = iprot.readSetBegin();
                            struct.authorizations = new HashSet<ByteBuffer>(2 * _set106.size);
                            for (int _i107 = 0; _i107 < _set106.size; ++_i107) {
                                ByteBuffer _elem108 = iprot.readBinary();
                                struct.authorizations.add(_elem108);
                            }
                            iprot.readSetEnd();
                            struct.setAuthorizationsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, ConditionalWriterOptions struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.isSetMaxMemory()) {
                oprot.writeFieldBegin(MAX_MEMORY_FIELD_DESC);
                oprot.writeI64(struct.maxMemory);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTimeoutMs()) {
                oprot.writeFieldBegin(TIMEOUT_MS_FIELD_DESC);
                oprot.writeI64(struct.timeoutMs);
                oprot.writeFieldEnd();
            }
            if (struct.isSetThreads()) {
                oprot.writeFieldBegin(THREADS_FIELD_DESC);
                oprot.writeI32(struct.threads);
                oprot.writeFieldEnd();
            }
            if (struct.authorizations != null && struct.isSetAuthorizations()) {
                oprot.writeFieldBegin(AUTHORIZATIONS_FIELD_DESC);
                oprot.writeSetBegin(new TSet(11, struct.authorizations.size()));
                for (ByteBuffer _iter109 : struct.authorizations) {
                    oprot.writeBinary(_iter109);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ConditionalWriterOptionsStandardSchemeFactory
    implements SchemeFactory {
        private ConditionalWriterOptionsStandardSchemeFactory() {
        }

        public ConditionalWriterOptionsStandardScheme getScheme() {
            return new ConditionalWriterOptionsStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        MAX_MEMORY(1, "maxMemory"),
        TIMEOUT_MS(2, "timeoutMs"),
        THREADS(3, "threads"),
        AUTHORIZATIONS(4, "authorizations");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return MAX_MEMORY;
                }
                case 2: {
                    return TIMEOUT_MS;
                }
                case 3: {
                    return THREADS;
                }
                case 4: {
                    return AUTHORIZATIONS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

