/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.proxy.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.proxy.thrift.Column;
import org.apache.accumulo.proxy.thrift.IteratorSetting;
import org.apache.accumulo.proxy.thrift.KeyExtent;
import org.apache.accumulo.proxy.thrift.ScanState;
import org.apache.accumulo.proxy.thrift.ScanType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ActiveScan
implements TBase<ActiveScan, _Fields>,
Serializable,
Cloneable,
Comparable<ActiveScan> {
    private static final TStruct STRUCT_DESC = new TStruct("ActiveScan");
    private static final TField CLIENT_FIELD_DESC = new TField("client", 11, 1);
    private static final TField USER_FIELD_DESC = new TField("user", 11, 2);
    private static final TField TABLE_FIELD_DESC = new TField("table", 11, 3);
    private static final TField AGE_FIELD_DESC = new TField("age", 10, 4);
    private static final TField IDLE_TIME_FIELD_DESC = new TField("idleTime", 10, 5);
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 6);
    private static final TField STATE_FIELD_DESC = new TField("state", 8, 7);
    private static final TField EXTENT_FIELD_DESC = new TField("extent", 12, 8);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 9);
    private static final TField ITERATORS_FIELD_DESC = new TField("iterators", 15, 10);
    private static final TField AUTHORIZATIONS_FIELD_DESC = new TField("authorizations", 15, 11);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public String client;
    public String user;
    public String table;
    public long age;
    public long idleTime;
    public ScanType type;
    public ScanState state;
    public KeyExtent extent;
    public List<Column> columns;
    public List<IteratorSetting> iterators;
    public List<ByteBuffer> authorizations;
    private static final int __AGE_ISSET_ID = 0;
    private static final int __IDLETIME_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ActiveScan() {
    }

    public ActiveScan(String client, String user, String table, long age, long idleTime, ScanType type, ScanState state, KeyExtent extent, List<Column> columns, List<IteratorSetting> iterators, List<ByteBuffer> authorizations) {
        this();
        this.client = client;
        this.user = user;
        this.table = table;
        this.age = age;
        this.setAgeIsSet(true);
        this.idleTime = idleTime;
        this.setIdleTimeIsSet(true);
        this.type = type;
        this.state = state;
        this.extent = extent;
        this.columns = columns;
        this.iterators = iterators;
        this.authorizations = authorizations;
    }

    public ActiveScan(ActiveScan other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetClient()) {
            this.client = other.client;
        }
        if (other.isSetUser()) {
            this.user = other.user;
        }
        if (other.isSetTable()) {
            this.table = other.table;
        }
        this.age = other.age;
        this.idleTime = other.idleTime;
        if (other.isSetType()) {
            this.type = other.type;
        }
        if (other.isSetState()) {
            this.state = other.state;
        }
        if (other.isSetExtent()) {
            this.extent = new KeyExtent(other.extent);
        }
        if (other.isSetColumns()) {
            ArrayList<Column> __this__columns = new ArrayList<Column>(other.columns.size());
            for (Column column : other.columns) {
                __this__columns.add(new Column(column));
            }
            this.columns = __this__columns;
        }
        if (other.isSetIterators()) {
            ArrayList<IteratorSetting> __this__iterators = new ArrayList<IteratorSetting>(other.iterators.size());
            for (IteratorSetting iteratorSetting : other.iterators) {
                __this__iterators.add(new IteratorSetting(iteratorSetting));
            }
            this.iterators = __this__iterators;
        }
        if (other.isSetAuthorizations()) {
            ArrayList<ByteBuffer> __this__authorizations = new ArrayList<ByteBuffer>(other.authorizations);
            this.authorizations = __this__authorizations;
        }
    }

    public ActiveScan deepCopy() {
        return new ActiveScan(this);
    }

    public void clear() {
        this.client = null;
        this.user = null;
        this.table = null;
        this.setAgeIsSet(false);
        this.age = 0L;
        this.setIdleTimeIsSet(false);
        this.idleTime = 0L;
        this.type = null;
        this.state = null;
        this.extent = null;
        this.columns = null;
        this.iterators = null;
        this.authorizations = null;
    }

    public String getClient() {
        return this.client;
    }

    public ActiveScan setClient(String client) {
        this.client = client;
        return this;
    }

    public void unsetClient() {
        this.client = null;
    }

    public boolean isSetClient() {
        return this.client != null;
    }

    public void setClientIsSet(boolean value) {
        if (!value) {
            this.client = null;
        }
    }

    public String getUser() {
        return this.user;
    }

    public ActiveScan setUser(String user) {
        this.user = user;
        return this;
    }

    public void unsetUser() {
        this.user = null;
    }

    public boolean isSetUser() {
        return this.user != null;
    }

    public void setUserIsSet(boolean value) {
        if (!value) {
            this.user = null;
        }
    }

    public String getTable() {
        return this.table;
    }

    public ActiveScan setTable(String table) {
        this.table = table;
        return this;
    }

    public void unsetTable() {
        this.table = null;
    }

    public boolean isSetTable() {
        return this.table != null;
    }

    public void setTableIsSet(boolean value) {
        if (!value) {
            this.table = null;
        }
    }

    public long getAge() {
        return this.age;
    }

    public ActiveScan setAge(long age) {
        this.age = age;
        this.setAgeIsSet(true);
        return this;
    }

    public void unsetAge() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetAge() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setAgeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public ActiveScan setIdleTime(long idleTime) {
        this.idleTime = idleTime;
        this.setIdleTimeIsSet(true);
        return this;
    }

    public void unsetIdleTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetIdleTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setIdleTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public ScanType getType() {
        return this.type;
    }

    public ActiveScan setType(ScanType type) {
        this.type = type;
        return this;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    public ScanState getState() {
        return this.state;
    }

    public ActiveScan setState(ScanState state) {
        this.state = state;
        return this;
    }

    public void unsetState() {
        this.state = null;
    }

    public boolean isSetState() {
        return this.state != null;
    }

    public void setStateIsSet(boolean value) {
        if (!value) {
            this.state = null;
        }
    }

    public KeyExtent getExtent() {
        return this.extent;
    }

    public ActiveScan setExtent(KeyExtent extent) {
        this.extent = extent;
        return this;
    }

    public void unsetExtent() {
        this.extent = null;
    }

    public boolean isSetExtent() {
        return this.extent != null;
    }

    public void setExtentIsSet(boolean value) {
        if (!value) {
            this.extent = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public Iterator<Column> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(Column elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
        }
        this.columns.add(elem);
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public ActiveScan setColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public int getIteratorsSize() {
        return this.iterators == null ? 0 : this.iterators.size();
    }

    public Iterator<IteratorSetting> getIteratorsIterator() {
        return this.iterators == null ? null : this.iterators.iterator();
    }

    public void addToIterators(IteratorSetting elem) {
        if (this.iterators == null) {
            this.iterators = new ArrayList<IteratorSetting>();
        }
        this.iterators.add(elem);
    }

    public List<IteratorSetting> getIterators() {
        return this.iterators;
    }

    public ActiveScan setIterators(List<IteratorSetting> iterators) {
        this.iterators = iterators;
        return this;
    }

    public void unsetIterators() {
        this.iterators = null;
    }

    public boolean isSetIterators() {
        return this.iterators != null;
    }

    public void setIteratorsIsSet(boolean value) {
        if (!value) {
            this.iterators = null;
        }
    }

    public int getAuthorizationsSize() {
        return this.authorizations == null ? 0 : this.authorizations.size();
    }

    public Iterator<ByteBuffer> getAuthorizationsIterator() {
        return this.authorizations == null ? null : this.authorizations.iterator();
    }

    public void addToAuthorizations(ByteBuffer elem) {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<ByteBuffer>();
        }
        this.authorizations.add(elem);
    }

    public List<ByteBuffer> getAuthorizations() {
        return this.authorizations;
    }

    public ActiveScan setAuthorizations(List<ByteBuffer> authorizations) {
        this.authorizations = authorizations;
        return this;
    }

    public void unsetAuthorizations() {
        this.authorizations = null;
    }

    public boolean isSetAuthorizations() {
        return this.authorizations != null;
    }

    public void setAuthorizationsIsSet(boolean value) {
        if (!value) {
            this.authorizations = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case CLIENT: {
                if (value == null) {
                    this.unsetClient();
                    break;
                }
                this.setClient((String)value);
                break;
            }
            case USER: {
                if (value == null) {
                    this.unsetUser();
                    break;
                }
                this.setUser((String)value);
                break;
            }
            case TABLE: {
                if (value == null) {
                    this.unsetTable();
                    break;
                }
                this.setTable((String)value);
                break;
            }
            case AGE: {
                if (value == null) {
                    this.unsetAge();
                    break;
                }
                this.setAge((Long)value);
                break;
            }
            case IDLE_TIME: {
                if (value == null) {
                    this.unsetIdleTime();
                    break;
                }
                this.setIdleTime((Long)value);
                break;
            }
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((ScanType)((Object)value));
                break;
            }
            case STATE: {
                if (value == null) {
                    this.unsetState();
                    break;
                }
                this.setState((ScanState)((Object)value));
                break;
            }
            case EXTENT: {
                if (value == null) {
                    this.unsetExtent();
                    break;
                }
                this.setExtent((KeyExtent)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
                break;
            }
            case ITERATORS: {
                if (value == null) {
                    this.unsetIterators();
                    break;
                }
                this.setIterators((List)value);
                break;
            }
            case AUTHORIZATIONS: {
                if (value == null) {
                    this.unsetAuthorizations();
                    break;
                }
                this.setAuthorizations((List)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case CLIENT: {
                return this.getClient();
            }
            case USER: {
                return this.getUser();
            }
            case TABLE: {
                return this.getTable();
            }
            case AGE: {
                return this.getAge();
            }
            case IDLE_TIME: {
                return this.getIdleTime();
            }
            case TYPE: {
                return this.getType();
            }
            case STATE: {
                return this.getState();
            }
            case EXTENT: {
                return this.getExtent();
            }
            case COLUMNS: {
                return this.getColumns();
            }
            case ITERATORS: {
                return this.getIterators();
            }
            case AUTHORIZATIONS: {
                return this.getAuthorizations();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case CLIENT: {
                return this.isSetClient();
            }
            case USER: {
                return this.isSetUser();
            }
            case TABLE: {
                return this.isSetTable();
            }
            case AGE: {
                return this.isSetAge();
            }
            case IDLE_TIME: {
                return this.isSetIdleTime();
            }
            case TYPE: {
                return this.isSetType();
            }
            case STATE: {
                return this.isSetState();
            }
            case EXTENT: {
                return this.isSetExtent();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
            case ITERATORS: {
                return this.isSetIterators();
            }
            case AUTHORIZATIONS: {
                return this.isSetAuthorizations();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ActiveScan) {
            return this.equals((ActiveScan)that);
        }
        return false;
    }

    public boolean equals(ActiveScan that) {
        if (that == null) {
            return false;
        }
        boolean this_present_client = this.isSetClient();
        boolean that_present_client = that.isSetClient();
        if (this_present_client || that_present_client) {
            if (!this_present_client || !that_present_client) {
                return false;
            }
            if (!this.client.equals(that.client)) {
                return false;
            }
        }
        boolean this_present_user = this.isSetUser();
        boolean that_present_user = that.isSetUser();
        if (this_present_user || that_present_user) {
            if (!this_present_user || !that_present_user) {
                return false;
            }
            if (!this.user.equals(that.user)) {
                return false;
            }
        }
        boolean this_present_table = this.isSetTable();
        boolean that_present_table = that.isSetTable();
        if (this_present_table || that_present_table) {
            if (!this_present_table || !that_present_table) {
                return false;
            }
            if (!this.table.equals(that.table)) {
                return false;
            }
        }
        boolean this_present_age = true;
        boolean that_present_age = true;
        if (this_present_age || that_present_age) {
            if (!this_present_age || !that_present_age) {
                return false;
            }
            if (this.age != that.age) {
                return false;
            }
        }
        boolean this_present_idleTime = true;
        boolean that_present_idleTime = true;
        if (this_present_idleTime || that_present_idleTime) {
            if (!this_present_idleTime || !that_present_idleTime) {
                return false;
            }
            if (this.idleTime != that.idleTime) {
                return false;
            }
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals((Object)that.type)) {
                return false;
            }
        }
        boolean this_present_state = this.isSetState();
        boolean that_present_state = that.isSetState();
        if (this_present_state || that_present_state) {
            if (!this_present_state || !that_present_state) {
                return false;
            }
            if (!this.state.equals((Object)that.state)) {
                return false;
            }
        }
        boolean this_present_extent = this.isSetExtent();
        boolean that_present_extent = that.isSetExtent();
        if (this_present_extent || that_present_extent) {
            if (!this_present_extent || !that_present_extent) {
                return false;
            }
            if (!this.extent.equals(that.extent)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!((Object)this.columns).equals(that.columns)) {
                return false;
            }
        }
        boolean this_present_iterators = this.isSetIterators();
        boolean that_present_iterators = that.isSetIterators();
        if (this_present_iterators || that_present_iterators) {
            if (!this_present_iterators || !that_present_iterators) {
                return false;
            }
            if (!((Object)this.iterators).equals(that.iterators)) {
                return false;
            }
        }
        boolean this_present_authorizations = this.isSetAuthorizations();
        boolean that_present_authorizations = that.isSetAuthorizations();
        if (this_present_authorizations || that_present_authorizations) {
            if (!this_present_authorizations || !that_present_authorizations) {
                return false;
            }
            if (!((Object)this.authorizations).equals(that.authorizations)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(ActiveScan other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetClient()).compareTo(other.isSetClient());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetClient() && (lastComparison = TBaseHelper.compareTo((String)this.client, (String)other.client)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUser()).compareTo(other.isSetUser());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUser() && (lastComparison = TBaseHelper.compareTo((String)this.user, (String)other.user)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTable()).compareTo(other.isSetTable());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTable() && (lastComparison = TBaseHelper.compareTo((String)this.table, (String)other.table)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAge()).compareTo(other.isSetAge());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAge() && (lastComparison = TBaseHelper.compareTo((long)this.age, (long)other.age)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIdleTime()).compareTo(other.isSetIdleTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIdleTime() && (lastComparison = TBaseHelper.compareTo((long)this.idleTime, (long)other.idleTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetType()).compareTo(other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)other.type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetState()).compareTo(other.isSetState());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetState() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.state), (Comparable)((Object)other.state))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetExtent()).compareTo(other.isSetExtent());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExtent() && (lastComparison = TBaseHelper.compareTo((Comparable)this.extent, (Comparable)other.extent)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(other.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, other.columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIterators()).compareTo(other.isSetIterators());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIterators() && (lastComparison = TBaseHelper.compareTo(this.iterators, other.iterators)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAuthorizations()).compareTo(other.isSetAuthorizations());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAuthorizations() && (lastComparison = TBaseHelper.compareTo(this.authorizations, other.authorizations)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ActiveScan(");
        boolean first = true;
        sb.append("client:");
        if (this.client == null) {
            sb.append("null");
        } else {
            sb.append(this.client);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("user:");
        if (this.user == null) {
            sb.append("null");
        } else {
            sb.append(this.user);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("table:");
        if (this.table == null) {
            sb.append("null");
        } else {
            sb.append(this.table);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("age:");
        sb.append(this.age);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("idleTime:");
        sb.append(this.idleTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("type:");
        if (this.type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.type);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("state:");
        if (this.state == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.state);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("extent:");
        if (this.extent == null) {
            sb.append("null");
        } else {
            sb.append(this.extent);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columns:");
        if (this.columns == null) {
            sb.append("null");
        } else {
            sb.append(this.columns);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("iterators:");
        if (this.iterators == null) {
            sb.append("null");
        } else {
            sb.append(this.iterators);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("authorizations:");
        if (this.authorizations == null) {
            sb.append("null");
        } else {
            sb.append(this.authorizations);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.extent != null) {
            this.extent.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ActiveScanStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ActiveScanTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.CLIENT, new FieldMetaData("client", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.USER, new FieldMetaData("user", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE, new FieldMetaData("table", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.AGE, new FieldMetaData("age", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.IDLE_TIME, new FieldMetaData("idleTime", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 3, (FieldValueMetaData)new EnumMetaData(16, ScanType.class)));
        tmpMap.put(_Fields.STATE, new FieldMetaData("state", 3, (FieldValueMetaData)new EnumMetaData(16, ScanState.class)));
        tmpMap.put(_Fields.EXTENT, new FieldMetaData("extent", 3, (FieldValueMetaData)new StructMetaData(12, KeyExtent.class)));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, Column.class))));
        tmpMap.put(_Fields.ITERATORS, new FieldMetaData("iterators", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, IteratorSetting.class))));
        tmpMap.put(_Fields.AUTHORIZATIONS, new FieldMetaData("authorizations", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11, true))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ActiveScan.class, metaDataMap);
    }

    private static class ActiveScanTupleScheme
    extends TupleScheme<ActiveScan> {
        private ActiveScanTupleScheme() {
        }

        public void write(TProtocol prot, ActiveScan struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetClient()) {
                optionals.set(0);
            }
            if (struct.isSetUser()) {
                optionals.set(1);
            }
            if (struct.isSetTable()) {
                optionals.set(2);
            }
            if (struct.isSetAge()) {
                optionals.set(3);
            }
            if (struct.isSetIdleTime()) {
                optionals.set(4);
            }
            if (struct.isSetType()) {
                optionals.set(5);
            }
            if (struct.isSetState()) {
                optionals.set(6);
            }
            if (struct.isSetExtent()) {
                optionals.set(7);
            }
            if (struct.isSetColumns()) {
                optionals.set(8);
            }
            if (struct.isSetIterators()) {
                optionals.set(9);
            }
            if (struct.isSetAuthorizations()) {
                optionals.set(10);
            }
            oprot.writeBitSet(optionals, 11);
            if (struct.isSetClient()) {
                oprot.writeString(struct.client);
            }
            if (struct.isSetUser()) {
                oprot.writeString(struct.user);
            }
            if (struct.isSetTable()) {
                oprot.writeString(struct.table);
            }
            if (struct.isSetAge()) {
                oprot.writeI64(struct.age);
            }
            if (struct.isSetIdleTime()) {
                oprot.writeI64(struct.idleTime);
            }
            if (struct.isSetType()) {
                oprot.writeI32(struct.type.getValue());
            }
            if (struct.isSetState()) {
                oprot.writeI32(struct.state.getValue());
            }
            if (struct.isSetExtent()) {
                struct.extent.write((TProtocol)oprot);
            }
            if (struct.isSetColumns()) {
                oprot.writeI32(struct.columns.size());
                for (Column _iter126 : struct.columns) {
                    _iter126.write((TProtocol)oprot);
                }
            }
            if (struct.isSetIterators()) {
                oprot.writeI32(struct.iterators.size());
                for (IteratorSetting _iter127 : struct.iterators) {
                    _iter127.write((TProtocol)oprot);
                }
            }
            if (struct.isSetAuthorizations()) {
                oprot.writeI32(struct.authorizations.size());
                for (ByteBuffer _iter128 : struct.authorizations) {
                    oprot.writeBinary(_iter128);
                }
            }
        }

        public void read(TProtocol prot, ActiveScan struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(11);
            if (incoming.get(0)) {
                struct.client = iprot.readString();
                struct.setClientIsSet(true);
            }
            if (incoming.get(1)) {
                struct.user = iprot.readString();
                struct.setUserIsSet(true);
            }
            if (incoming.get(2)) {
                struct.table = iprot.readString();
                struct.setTableIsSet(true);
            }
            if (incoming.get(3)) {
                struct.age = iprot.readI64();
                struct.setAgeIsSet(true);
            }
            if (incoming.get(4)) {
                struct.idleTime = iprot.readI64();
                struct.setIdleTimeIsSet(true);
            }
            if (incoming.get(5)) {
                struct.type = ScanType.findByValue(iprot.readI32());
                struct.setTypeIsSet(true);
            }
            if (incoming.get(6)) {
                struct.state = ScanState.findByValue(iprot.readI32());
                struct.setStateIsSet(true);
            }
            if (incoming.get(7)) {
                struct.extent = new KeyExtent();
                struct.extent.read((TProtocol)iprot);
                struct.setExtentIsSet(true);
            }
            if (incoming.get(8)) {
                TList _list129 = new TList(12, iprot.readI32());
                struct.columns = new ArrayList<Column>(_list129.size);
                for (int _i130 = 0; _i130 < _list129.size; ++_i130) {
                    Column _elem131 = new Column();
                    _elem131.read((TProtocol)iprot);
                    struct.columns.add(_elem131);
                }
                struct.setColumnsIsSet(true);
            }
            if (incoming.get(9)) {
                TList _list132 = new TList(12, iprot.readI32());
                struct.iterators = new ArrayList<IteratorSetting>(_list132.size);
                for (int _i133 = 0; _i133 < _list132.size; ++_i133) {
                    IteratorSetting _elem134 = new IteratorSetting();
                    _elem134.read((TProtocol)iprot);
                    struct.iterators.add(_elem134);
                }
                struct.setIteratorsIsSet(true);
            }
            if (incoming.get(10)) {
                TList _list135 = new TList(11, iprot.readI32());
                struct.authorizations = new ArrayList<ByteBuffer>(_list135.size);
                for (int _i136 = 0; _i136 < _list135.size; ++_i136) {
                    ByteBuffer _elem137 = iprot.readBinary();
                    struct.authorizations.add(_elem137);
                }
                struct.setAuthorizationsIsSet(true);
            }
        }
    }

    private static class ActiveScanTupleSchemeFactory
    implements SchemeFactory {
        private ActiveScanTupleSchemeFactory() {
        }

        public ActiveScanTupleScheme getScheme() {
            return new ActiveScanTupleScheme();
        }
    }

    private static class ActiveScanStandardScheme
    extends StandardScheme<ActiveScan> {
        private ActiveScanStandardScheme() {
        }

        public void read(TProtocol iprot, ActiveScan struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.client = iprot.readString();
                            struct.setClientIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.user = iprot.readString();
                            struct.setUserIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.table = iprot.readString();
                            struct.setTableIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.age = iprot.readI64();
                            struct.setAgeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.idleTime = iprot.readI64();
                            struct.setIdleTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.type = ScanType.findByValue(iprot.readI32());
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.state = ScanState.findByValue(iprot.readI32());
                            struct.setStateIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 12) {
                            struct.extent = new KeyExtent();
                            struct.extent.read(iprot);
                            struct.setExtentIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 15) {
                            TList _list114 = iprot.readListBegin();
                            struct.columns = new ArrayList<Column>(_list114.size);
                            for (int _i115 = 0; _i115 < _list114.size; ++_i115) {
                                Column _elem116 = new Column();
                                _elem116.read(iprot);
                                struct.columns.add(_elem116);
                            }
                            iprot.readListEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 15) {
                            TList _list117 = iprot.readListBegin();
                            struct.iterators = new ArrayList<IteratorSetting>(_list117.size);
                            for (int _i118 = 0; _i118 < _list117.size; ++_i118) {
                                IteratorSetting _elem119 = new IteratorSetting();
                                _elem119.read(iprot);
                                struct.iterators.add(_elem119);
                            }
                            iprot.readListEnd();
                            struct.setIteratorsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 15) {
                            TList _list120 = iprot.readListBegin();
                            struct.authorizations = new ArrayList<ByteBuffer>(_list120.size);
                            for (int _i121 = 0; _i121 < _list120.size; ++_i121) {
                                ByteBuffer _elem122 = iprot.readBinary();
                                struct.authorizations.add(_elem122);
                            }
                            iprot.readListEnd();
                            struct.setAuthorizationsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, ActiveScan struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.client != null) {
                oprot.writeFieldBegin(CLIENT_FIELD_DESC);
                oprot.writeString(struct.client);
                oprot.writeFieldEnd();
            }
            if (struct.user != null) {
                oprot.writeFieldBegin(USER_FIELD_DESC);
                oprot.writeString(struct.user);
                oprot.writeFieldEnd();
            }
            if (struct.table != null) {
                oprot.writeFieldBegin(TABLE_FIELD_DESC);
                oprot.writeString(struct.table);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(AGE_FIELD_DESC);
            oprot.writeI64(struct.age);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(IDLE_TIME_FIELD_DESC);
            oprot.writeI64(struct.idleTime);
            oprot.writeFieldEnd();
            if (struct.type != null) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeI32(struct.type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.state != null) {
                oprot.writeFieldBegin(STATE_FIELD_DESC);
                oprot.writeI32(struct.state.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.extent != null) {
                oprot.writeFieldBegin(EXTENT_FIELD_DESC);
                struct.extent.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.columns != null) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.columns.size()));
                for (Column _iter123 : struct.columns) {
                    _iter123.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.iterators != null) {
                oprot.writeFieldBegin(ITERATORS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.iterators.size()));
                for (IteratorSetting _iter124 : struct.iterators) {
                    _iter124.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.authorizations != null) {
                oprot.writeFieldBegin(AUTHORIZATIONS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.authorizations.size()));
                for (ByteBuffer _iter125 : struct.authorizations) {
                    oprot.writeBinary(_iter125);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ActiveScanStandardSchemeFactory
    implements SchemeFactory {
        private ActiveScanStandardSchemeFactory() {
        }

        public ActiveScanStandardScheme getScheme() {
            return new ActiveScanStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        CLIENT(1, "client"),
        USER(2, "user"),
        TABLE(3, "table"),
        AGE(4, "age"),
        IDLE_TIME(5, "idleTime"),
        TYPE(6, "type"),
        STATE(7, "state"),
        EXTENT(8, "extent"),
        COLUMNS(9, "columns"),
        ITERATORS(10, "iterators"),
        AUTHORIZATIONS(11, "authorizations");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return CLIENT;
                }
                case 2: {
                    return USER;
                }
                case 3: {
                    return TABLE;
                }
                case 4: {
                    return AGE;
                }
                case 5: {
                    return IDLE_TIME;
                }
                case 6: {
                    return TYPE;
                }
                case 7: {
                    return STATE;
                }
                case 8: {
                    return EXTENT;
                }
                case 9: {
                    return COLUMNS;
                }
                case 10: {
                    return ITERATORS;
                }
                case 11: {
                    return AUTHORIZATIONS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

