/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.proxy;

import com.google.common.base.Charsets;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.ConditionalMutation;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.proxy.Util;
import org.apache.accumulo.proxy.thrift.AccumuloException;
import org.apache.accumulo.proxy.thrift.AccumuloProxy;
import org.apache.accumulo.proxy.thrift.AccumuloSecurityException;
import org.apache.accumulo.proxy.thrift.ActiveCompaction;
import org.apache.accumulo.proxy.thrift.ActiveScan;
import org.apache.accumulo.proxy.thrift.BatchScanOptions;
import org.apache.accumulo.proxy.thrift.Column;
import org.apache.accumulo.proxy.thrift.ColumnUpdate;
import org.apache.accumulo.proxy.thrift.CompactionReason;
import org.apache.accumulo.proxy.thrift.CompactionType;
import org.apache.accumulo.proxy.thrift.Condition;
import org.apache.accumulo.proxy.thrift.ConditionalStatus;
import org.apache.accumulo.proxy.thrift.ConditionalUpdates;
import org.apache.accumulo.proxy.thrift.ConditionalWriterOptions;
import org.apache.accumulo.proxy.thrift.DiskUsage;
import org.apache.accumulo.proxy.thrift.IteratorScope;
import org.apache.accumulo.proxy.thrift.IteratorSetting;
import org.apache.accumulo.proxy.thrift.Key;
import org.apache.accumulo.proxy.thrift.KeyExtent;
import org.apache.accumulo.proxy.thrift.KeyValue;
import org.apache.accumulo.proxy.thrift.KeyValueAndPeek;
import org.apache.accumulo.proxy.thrift.MutationsRejectedException;
import org.apache.accumulo.proxy.thrift.NoMoreEntriesException;
import org.apache.accumulo.proxy.thrift.PartialKey;
import org.apache.accumulo.proxy.thrift.Range;
import org.apache.accumulo.proxy.thrift.ScanColumn;
import org.apache.accumulo.proxy.thrift.ScanOptions;
import org.apache.accumulo.proxy.thrift.ScanResult;
import org.apache.accumulo.proxy.thrift.ScanState;
import org.apache.accumulo.proxy.thrift.ScanType;
import org.apache.accumulo.proxy.thrift.SystemPermission;
import org.apache.accumulo.proxy.thrift.TableExistsException;
import org.apache.accumulo.proxy.thrift.TableNotFoundException;
import org.apache.accumulo.proxy.thrift.TablePermission;
import org.apache.accumulo.proxy.thrift.TimeType;
import org.apache.accumulo.proxy.thrift.UnknownScanner;
import org.apache.accumulo.proxy.thrift.UnknownWriter;
import org.apache.accumulo.proxy.thrift.WriterOptions;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class ProxyServer
implements AccumuloProxy.Iface {
    public static final Logger logger = Logger.getLogger(ProxyServer.class);
    protected Instance instance;
    protected Class<? extends AuthenticationToken> tokenClass;
    protected Cache<UUID, ScannerPlusIterator> scannerCache;
    protected Cache<UUID, BatchWriterPlusException> writerCache;
    protected Cache<UUID, ConditionalWriter> conditionalWriterCache;
    private static final ColumnVisibility EMPTY_VIS = new ColumnVisibility();

    public ProxyServer(Properties props) {
        String useMock = props.getProperty("useMockInstance");
        this.instance = useMock != null && Boolean.parseBoolean(useMock) ? new MockInstance() : new ZooKeeperInstance((Configuration)ClientConfiguration.loadDefault().withInstance(props.getProperty("instance")).withZkHosts(props.getProperty("zookeepers")));
        try {
            String tokenProp = props.getProperty("tokenClass", PasswordToken.class.getName());
            this.tokenClass = Class.forName(tokenProp).asSubclass(AuthenticationToken.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.scannerCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(1000L).removalListener((RemovalListener)new CloseScanner()).build();
        this.writerCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(1000L).removalListener((RemovalListener)new CloseWriter()).build();
        this.conditionalWriterCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(1000L).removalListener((RemovalListener)new CloseConditionalWriter()).build();
    }

    protected Connector getConnector(ByteBuffer login2) throws Exception {
        String[] pair = new String(login2.array(), login2.position(), login2.remaining(), Charsets.UTF_8).split(",", 2);
        if (this.instance.getInstanceID().equals(pair[0])) {
            Credentials creds = Credentials.deserialize((String)pair[1]);
            return this.instance.getConnector(creds.getPrincipal(), creds.getToken());
        }
        throw new org.apache.accumulo.core.client.AccumuloSecurityException(pair[0], org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode.INVALID_INSTANCEID);
    }

    private void handleAccumuloException(org.apache.accumulo.core.client.AccumuloException e) throws TableNotFoundException, AccumuloException {
        if (e.getCause() instanceof ThriftTableOperationException) {
            ThriftTableOperationException ttoe = (ThriftTableOperationException)e.getCause();
            if (ttoe.type == TableOperationExceptionType.NOTFOUND) {
                throw new TableNotFoundException(e.toString());
            }
        }
        throw new AccumuloException(e.toString());
    }

    private void handleAccumuloSecurityException(org.apache.accumulo.core.client.AccumuloSecurityException e) throws TableNotFoundException, AccumuloSecurityException {
        if (e.getSecurityErrorCode().equals((Object)SecurityErrorCode.TABLE_DOESNT_EXIST)) {
            throw new TableNotFoundException(e.toString());
        }
        throw new AccumuloSecurityException(e.toString());
    }

    private void handleExceptionTNF(Exception ex) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            throw ex;
        }
        catch (org.apache.accumulo.core.client.AccumuloException e) {
            Throwable cause = e.getCause();
            if (null != cause && org.apache.accumulo.core.client.TableNotFoundException.class.equals(cause.getClass())) {
                throw new TableNotFoundException(cause.toString());
            }
            this.handleAccumuloException(e);
        }
        catch (org.apache.accumulo.core.client.AccumuloSecurityException e) {
            this.handleAccumuloSecurityException(e);
        }
        catch (org.apache.accumulo.core.client.TableNotFoundException e) {
            throw new TableNotFoundException(ex.toString());
        }
        catch (Exception e) {
            throw new AccumuloException(e.toString());
        }
    }

    private void handleExceptionTEE(Exception ex) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException, TException {
        try {
            throw ex;
        }
        catch (org.apache.accumulo.core.client.AccumuloException e) {
            this.handleAccumuloException(e);
        }
        catch (org.apache.accumulo.core.client.AccumuloSecurityException e) {
            this.handleAccumuloSecurityException(e);
        }
        catch (org.apache.accumulo.core.client.TableNotFoundException e) {
            throw new TableNotFoundException(ex.toString());
        }
        catch (org.apache.accumulo.core.client.TableExistsException e) {
            throw new TableExistsException(e.toString());
        }
        catch (Exception e) {
            throw new AccumuloException(e.toString());
        }
    }

    private void handleExceptionMRE(Exception ex) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, MutationsRejectedException, TException {
        try {
            throw ex;
        }
        catch (org.apache.accumulo.core.client.MutationsRejectedException e) {
            throw new MutationsRejectedException(ex.toString());
        }
        catch (org.apache.accumulo.core.client.AccumuloException e) {
            this.handleAccumuloException(e);
        }
        catch (org.apache.accumulo.core.client.AccumuloSecurityException e) {
            this.handleAccumuloSecurityException(e);
        }
        catch (org.apache.accumulo.core.client.TableNotFoundException e) {
            throw new TableNotFoundException(ex.toString());
        }
        catch (Exception e) {
            throw new AccumuloException(e.toString());
        }
    }

    private void handleException(Exception ex) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            throw ex;
        }
        catch (org.apache.accumulo.core.client.AccumuloException e) {
            throw new AccumuloException(e.toString());
        }
        catch (org.apache.accumulo.core.client.AccumuloSecurityException e) {
            throw new AccumuloSecurityException(e.toString());
        }
        catch (Exception e) {
            throw new AccumuloException(e.toString());
        }
    }

    @Override
    public int addConstraint(ByteBuffer login2, String tableName, String constraintClassName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            return this.getConnector(login2).tableOperations().addConstraint(tableName, constraintClassName);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return -1;
        }
    }

    @Override
    public void addSplits(ByteBuffer login2, String tableName, Set<ByteBuffer> splits) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            TreeSet<Text> sorted = new TreeSet<Text>();
            for (ByteBuffer split : splits) {
                sorted.add(ByteBufferUtil.toText((ByteBuffer)split));
            }
            this.getConnector(login2).tableOperations().addSplits(tableName, sorted);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public void clearLocatorCache(ByteBuffer login2, String tableName) throws TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().clearLocatorCache(tableName);
        }
        catch (org.apache.accumulo.core.client.TableNotFoundException e) {
            throw new TableNotFoundException(e.toString());
        }
        catch (Exception e) {
            throw new TException(e.toString());
        }
    }

    @Override
    public void compactTable(ByteBuffer login2, String tableName, ByteBuffer startRow, ByteBuffer endRow, List<IteratorSetting> iterators, boolean flush2, boolean wait) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, TException {
        try {
            this.getConnector(login2).tableOperations().compact(tableName, ByteBufferUtil.toText((ByteBuffer)startRow), ByteBufferUtil.toText((ByteBuffer)endRow), this.getIteratorSettings(iterators), flush2, wait);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public void cancelCompaction(ByteBuffer login2, String tableName) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, TException {
        try {
            this.getConnector(login2).tableOperations().cancelCompaction(tableName);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    private List<org.apache.accumulo.core.client.IteratorSetting> getIteratorSettings(List<IteratorSetting> iterators) {
        ArrayList<org.apache.accumulo.core.client.IteratorSetting> result = new ArrayList<org.apache.accumulo.core.client.IteratorSetting>();
        if (iterators != null) {
            for (IteratorSetting is : iterators) {
                result.add(this.getIteratorSetting(is));
            }
        }
        return result;
    }

    @Override
    public void createTable(ByteBuffer login2, String tableName, boolean versioningIter, TimeType type) throws AccumuloException, AccumuloSecurityException, TableExistsException, TException {
        try {
            if (type == null) {
                type = TimeType.MILLIS;
            }
            this.getConnector(login2).tableOperations().create(tableName, versioningIter, org.apache.accumulo.core.client.admin.TimeType.valueOf((String)type.toString()));
        }
        catch (org.apache.accumulo.core.client.TableExistsException e) {
            throw new TableExistsException(e.toString());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void deleteTable(ByteBuffer login2, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().delete(tableName);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public void deleteRows(ByteBuffer login2, String tableName, ByteBuffer startRow, ByteBuffer endRow) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().deleteRows(tableName, ByteBufferUtil.toText((ByteBuffer)startRow), ByteBufferUtil.toText((ByteBuffer)endRow));
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public boolean tableExists(ByteBuffer login2, String tableName) throws TException {
        try {
            return this.getConnector(login2).tableOperations().exists(tableName);
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    @Override
    public void flushTable(ByteBuffer login2, String tableName, ByteBuffer startRow, ByteBuffer endRow, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().flush(tableName, ByteBufferUtil.toText((ByteBuffer)startRow), ByteBufferUtil.toText((ByteBuffer)endRow), wait);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public Map<String, Set<String>> getLocalityGroups(ByteBuffer login2, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            Map groups = this.getConnector(login2).tableOperations().getLocalityGroups(tableName);
            HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
            for (Map.Entry entry : groups.entrySet()) {
                HashSet<String> value = new HashSet<String>();
                ret.put((String)entry.getKey(), (Set<String>)value);
                for (Text val : (Set)entry.getValue()) {
                    value.add(val.toString());
                }
            }
            return ret;
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return null;
        }
    }

    @Override
    public ByteBuffer getMaxRow(ByteBuffer login2, String tableName, Set<ByteBuffer> auths, ByteBuffer startRow, boolean startInclusive, ByteBuffer endRow, boolean endInclusive) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            Connector connector = this.getConnector(login2);
            Text startText = ByteBufferUtil.toText((ByteBuffer)startRow);
            Text endText = ByteBufferUtil.toText((ByteBuffer)endRow);
            Authorizations auth = auths != null ? this.getAuthorizations(auths) : connector.securityOperations().getUserAuthorizations(connector.whoami());
            Text max = connector.tableOperations().getMaxRow(tableName, auth, startText, startInclusive, endText, endInclusive);
            return TextUtil.getByteBuffer((Text)max);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return null;
        }
    }

    @Override
    public Map<String, String> getTableProperties(ByteBuffer login2, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            HashMap<String, String> ret = new HashMap<String, String>();
            for (Map.Entry entry : this.getConnector(login2).tableOperations().getProperties(tableName)) {
                ret.put((String)entry.getKey(), (String)entry.getValue());
            }
            return ret;
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return null;
        }
    }

    @Override
    public List<ByteBuffer> listSplits(ByteBuffer login2, String tableName, int maxSplits) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            Collection splits = this.getConnector(login2).tableOperations().listSplits(tableName, maxSplits);
            ArrayList<ByteBuffer> ret = new ArrayList<ByteBuffer>();
            for (Text split : splits) {
                ret.add(TextUtil.getByteBuffer((Text)split));
            }
            return ret;
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return null;
        }
    }

    @Override
    public Set<String> listTables(ByteBuffer login2) throws TException {
        try {
            return this.getConnector(login2).tableOperations().list();
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    @Override
    public Map<String, Integer> listConstraints(ByteBuffer login2, String tableName) throws AccumuloException, TableNotFoundException, TException {
        try {
            return this.getConnector(login2).tableOperations().listConstraints(tableName);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return null;
        }
    }

    @Override
    public void mergeTablets(ByteBuffer login2, String tableName, ByteBuffer startRow, ByteBuffer endRow) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().merge(tableName, ByteBufferUtil.toText((ByteBuffer)startRow), ByteBufferUtil.toText((ByteBuffer)endRow));
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public void offlineTable(ByteBuffer login2, String tableName, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().offline(tableName, wait);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public void onlineTable(ByteBuffer login2, String tableName, boolean wait) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().online(tableName, wait);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public void removeConstraint(ByteBuffer login2, String tableName, int constraint) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().removeConstraint(tableName, constraint);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public void removeTableProperty(ByteBuffer login2, String tableName, String property) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().removeProperty(tableName, property);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public void renameTable(ByteBuffer login2, String oldTableName, String newTableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException, TException {
        try {
            this.getConnector(login2).tableOperations().rename(oldTableName, newTableName);
        }
        catch (Exception e) {
            this.handleExceptionTEE(e);
        }
    }

    @Override
    public void setLocalityGroups(ByteBuffer login2, String tableName, Map<String, Set<String>> groupStrings) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            HashMap groups = new HashMap();
            for (Map.Entry<String, Set<String>> groupEntry : groupStrings.entrySet()) {
                groups.put(groupEntry.getKey(), new HashSet());
                for (String val : groupEntry.getValue()) {
                    ((Set)groups.get(groupEntry.getKey())).add(new Text(val));
                }
            }
            this.getConnector(login2).tableOperations().setLocalityGroups(tableName, groups);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public void setTableProperty(ByteBuffer login2, String tableName, String property, String value) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().setProperty(tableName, property, value);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public Map<String, String> tableIdMap(ByteBuffer login2) throws TException {
        try {
            return this.getConnector(login2).tableOperations().tableIdMap();
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    @Override
    public List<DiskUsage> getDiskUsage(ByteBuffer login2, Set<String> tables) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            List diskUsages = this.getConnector(login2).tableOperations().getDiskUsage(tables);
            ArrayList<DiskUsage> retUsages = new ArrayList<DiskUsage>();
            for (org.apache.accumulo.core.client.admin.DiskUsage diskUsage : diskUsages) {
                DiskUsage usage = new DiskUsage();
                usage.setTables(new ArrayList<String>(diskUsage.getTables()));
                usage.setUsage(diskUsage.getUsage());
                retUsages.add(usage);
            }
            return retUsages;
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return null;
        }
    }

    @Override
    public Map<String, String> getSiteConfiguration(ByteBuffer login2) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            return this.getConnector(login2).instanceOperations().getSiteConfiguration();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public Map<String, String> getSystemConfiguration(ByteBuffer login2) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            return this.getConnector(login2).instanceOperations().getSystemConfiguration();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public List<String> getTabletServers(ByteBuffer login2) throws TException {
        try {
            return this.getConnector(login2).instanceOperations().getTabletServers();
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    @Override
    public List<ActiveScan> getActiveScans(ByteBuffer login2, String tserver) throws AccumuloException, AccumuloSecurityException, TException {
        ArrayList<ActiveScan> result = new ArrayList<ActiveScan>();
        try {
            List activeScans = this.getConnector(login2).instanceOperations().getActiveScans(tserver);
            for (org.apache.accumulo.core.client.admin.ActiveScan scan : activeScans) {
                ActiveScan pscan = new ActiveScan();
                pscan.client = scan.getClient();
                pscan.user = scan.getUser();
                pscan.table = scan.getTable();
                pscan.age = scan.getAge();
                pscan.idleTime = scan.getIdleTime();
                pscan.type = ScanType.valueOf(scan.getType().toString());
                pscan.state = ScanState.valueOf(scan.getState().toString());
                org.apache.accumulo.core.data.KeyExtent e = scan.getExtent();
                pscan.extent = new KeyExtent(e.getTableId().toString(), TextUtil.getByteBuffer((Text)e.getEndRow()), TextUtil.getByteBuffer((Text)e.getPrevEndRow()));
                pscan.columns = new ArrayList<Column>();
                if (scan.getColumns() != null) {
                    for (org.apache.accumulo.core.data.Column c : scan.getColumns()) {
                        Column column = new Column();
                        column.setColFamily(c.getColumnFamily());
                        column.setColQualifier(c.getColumnQualifier());
                        column.setColVisibility(c.getColumnVisibility());
                        pscan.columns.add(column);
                    }
                }
                pscan.iterators = new ArrayList<IteratorSetting>();
                for (String iteratorString : scan.getSsiList()) {
                    String[] parts = iteratorString.split("[=,]");
                    if (parts.length != 3) continue;
                    String name = parts[0];
                    int priority = Integer.parseInt(parts[1]);
                    String classname = parts[2];
                    IteratorSetting settings = new IteratorSetting(priority, name, classname, (Map)scan.getSsio().get(name));
                    pscan.iterators.add(settings);
                }
                pscan.authorizations = new ArrayList<ByteBuffer>();
                if (scan.getAuthorizations() != null) {
                    for (byte[] a : scan.getAuthorizations()) {
                        pscan.authorizations.add(ByteBuffer.wrap(a));
                    }
                }
                result.add(pscan);
            }
            return result;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public List<ActiveCompaction> getActiveCompactions(ByteBuffer login2, String tserver) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            ArrayList<ActiveCompaction> result = new ArrayList<ActiveCompaction>();
            List active = this.getConnector(login2).instanceOperations().getActiveCompactions(tserver);
            for (org.apache.accumulo.core.client.admin.ActiveCompaction comp : active) {
                ActiveCompaction pcomp = new ActiveCompaction();
                pcomp.age = comp.getAge();
                pcomp.entriesRead = comp.getEntriesRead();
                pcomp.entriesWritten = comp.getEntriesWritten();
                org.apache.accumulo.core.data.KeyExtent e = comp.getExtent();
                pcomp.extent = new KeyExtent(e.getTableId().toString(), TextUtil.getByteBuffer((Text)e.getEndRow()), TextUtil.getByteBuffer((Text)e.getPrevEndRow()));
                pcomp.inputFiles = new ArrayList<String>();
                if (comp.getInputFiles() != null) {
                    pcomp.inputFiles.addAll(comp.getInputFiles());
                }
                pcomp.localityGroup = comp.getLocalityGroup();
                pcomp.outputFile = comp.getOutputFile();
                pcomp.reason = CompactionReason.valueOf(comp.getReason().toString());
                pcomp.type = CompactionType.valueOf(comp.getType().toString());
                pcomp.iterators = new ArrayList<IteratorSetting>();
                if (comp.getIterators() != null) {
                    for (org.apache.accumulo.core.client.IteratorSetting setting : comp.getIterators()) {
                        IteratorSetting psetting = new IteratorSetting(setting.getPriority(), setting.getName(), setting.getIteratorClass(), setting.getOptions());
                        pcomp.iterators.add(psetting);
                    }
                }
                result.add(pcomp);
            }
            return result;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void removeProperty(ByteBuffer login2, String property) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            this.getConnector(login2).instanceOperations().removeProperty(property);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void setProperty(ByteBuffer login2, String property, String value) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            this.getConnector(login2).instanceOperations().setProperty(property, value);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public boolean testClassLoad(ByteBuffer login2, String className, String asTypeName) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            return this.getConnector(login2).instanceOperations().testClassLoad(className, asTypeName);
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean authenticateUser(ByteBuffer login2, String user, Map<String, String> properties) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            return this.getConnector(login2).securityOperations().authenticateUser(user, this.getToken(user, properties));
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public void changeUserAuthorizations(ByteBuffer login2, String user, Set<ByteBuffer> authorizations) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            HashSet<String> auths = new HashSet<String>();
            for (ByteBuffer auth : authorizations) {
                auths.add(ByteBufferUtil.toString((ByteBuffer)auth));
            }
            this.getConnector(login2).securityOperations().changeUserAuthorizations(user, new Authorizations(auths.toArray(new String[0])));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void changeLocalUserPassword(ByteBuffer login2, String user, ByteBuffer password) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            this.getConnector(login2).securityOperations().changeLocalUserPassword(user, new PasswordToken(password));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void createLocalUser(ByteBuffer login2, String user, ByteBuffer password) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            this.getConnector(login2).securityOperations().createLocalUser(user, new PasswordToken(password));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void dropLocalUser(ByteBuffer login2, String user) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            this.getConnector(login2).securityOperations().dropLocalUser(user);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public List<ByteBuffer> getUserAuthorizations(ByteBuffer login2, String user) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            return this.getConnector(login2).securityOperations().getUserAuthorizations(user).getAuthorizationsBB();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void grantSystemPermission(ByteBuffer login2, String user, SystemPermission perm) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            this.getConnector(login2).securityOperations().grantSystemPermission(user, org.apache.accumulo.core.security.SystemPermission.getPermissionById((byte)((byte)perm.getValue())));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void grantTablePermission(ByteBuffer login2, String user, String table, TablePermission perm) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).securityOperations().grantTablePermission(user, table, org.apache.accumulo.core.security.TablePermission.getPermissionById((byte)((byte)perm.getValue())));
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public boolean hasSystemPermission(ByteBuffer login2, String user, SystemPermission perm) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            return this.getConnector(login2).securityOperations().hasSystemPermission(user, org.apache.accumulo.core.security.SystemPermission.getPermissionById((byte)((byte)perm.getValue())));
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean hasTablePermission(ByteBuffer login2, String user, String table, TablePermission perm) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            return this.getConnector(login2).securityOperations().hasTablePermission(user, table, org.apache.accumulo.core.security.TablePermission.getPermissionById((byte)((byte)perm.getValue())));
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return false;
        }
    }

    @Override
    public Set<String> listLocalUsers(ByteBuffer login2) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            return this.getConnector(login2).securityOperations().listLocalUsers();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void revokeSystemPermission(ByteBuffer login2, String user, SystemPermission perm) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            this.getConnector(login2).securityOperations().revokeSystemPermission(user, org.apache.accumulo.core.security.SystemPermission.getPermissionById((byte)((byte)perm.getValue())));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void revokeTablePermission(ByteBuffer login2, String user, String table, TablePermission perm) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).securityOperations().revokeTablePermission(user, table, org.apache.accumulo.core.security.TablePermission.getPermissionById((byte)((byte)perm.getValue())));
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    private Authorizations getAuthorizations(Set<ByteBuffer> authorizations) {
        ArrayList<String> auths = new ArrayList<String>();
        for (ByteBuffer bbauth : authorizations) {
            auths.add(ByteBufferUtil.toString((ByteBuffer)bbauth));
        }
        return new Authorizations(auths.toArray(new String[0]));
    }

    @Override
    public String createScanner(ByteBuffer login2, String tableName, ScanOptions opts) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            Connector connector = this.getConnector(login2);
            Authorizations auth = opts != null && opts.isSetAuthorizations() ? this.getAuthorizations(opts.authorizations) : connector.securityOperations().getUserAuthorizations(connector.whoami());
            Scanner scanner = connector.createScanner(tableName, auth);
            if (opts != null) {
                Range prange;
                if (opts.iterators != null) {
                    for (IteratorSetting iter : opts.iterators) {
                        org.apache.accumulo.core.client.IteratorSetting is = new org.apache.accumulo.core.client.IteratorSetting(iter.getPriority(), iter.getName(), iter.getIteratorClass(), iter.getProperties());
                        scanner.addScanIterator(is);
                    }
                }
                if ((prange = opts.range) != null) {
                    org.apache.accumulo.core.data.Range range = new org.apache.accumulo.core.data.Range(Util.fromThrift(prange.getStart()), prange.startInclusive, Util.fromThrift(prange.getStop()), prange.stopInclusive);
                    scanner.setRange(range);
                }
                if (opts.columns != null) {
                    for (ScanColumn col : opts.columns) {
                        if (col.isSetColQualifier()) {
                            scanner.fetchColumn(ByteBufferUtil.toText((ByteBuffer)col.colFamily), ByteBufferUtil.toText((ByteBuffer)col.colQualifier));
                            continue;
                        }
                        scanner.fetchColumnFamily(ByteBufferUtil.toText((ByteBuffer)col.colFamily));
                    }
                }
            }
            UUID uuid = UUID.randomUUID();
            ScannerPlusIterator spi = new ScannerPlusIterator();
            spi.scanner = scanner;
            spi.iterator = scanner.iterator();
            this.scannerCache.put((Object)uuid, (Object)spi);
            return uuid.toString();
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return null;
        }
    }

    @Override
    public String createBatchScanner(ByteBuffer login2, String tableName, BatchScanOptions opts) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            Connector connector = this.getConnector(login2);
            int threads = 10;
            Authorizations auth = opts != null && opts.isSetAuthorizations() ? this.getAuthorizations(opts.authorizations) : connector.securityOperations().getUserAuthorizations(connector.whoami());
            if (opts != null && opts.threads > 0) {
                threads = opts.threads;
            }
            BatchScanner scanner = connector.createBatchScanner(tableName, auth, threads);
            if (opts != null) {
                if (opts.iterators != null) {
                    for (IteratorSetting iter : opts.iterators) {
                        org.apache.accumulo.core.client.IteratorSetting is = new org.apache.accumulo.core.client.IteratorSetting(iter.getPriority(), iter.getName(), iter.getIteratorClass(), iter.getProperties());
                        scanner.addScanIterator(is);
                    }
                }
                ArrayList<org.apache.accumulo.core.data.Range> ranges = new ArrayList<org.apache.accumulo.core.data.Range>();
                if (opts.ranges == null) {
                    ranges.add(new org.apache.accumulo.core.data.Range());
                } else {
                    for (Range range : opts.ranges) {
                        org.apache.accumulo.core.data.Range aRange = new org.apache.accumulo.core.data.Range(range.getStart() == null ? null : Util.fromThrift(range.getStart()), true, range.getStop() == null ? null : Util.fromThrift(range.getStop()), false);
                        ranges.add(aRange);
                    }
                }
                scanner.setRanges(ranges);
                if (opts.columns != null) {
                    for (ScanColumn col : opts.columns) {
                        if (col.isSetColQualifier()) {
                            scanner.fetchColumn(ByteBufferUtil.toText((ByteBuffer)col.colFamily), ByteBufferUtil.toText((ByteBuffer)col.colQualifier));
                            continue;
                        }
                        scanner.fetchColumnFamily(ByteBufferUtil.toText((ByteBuffer)col.colFamily));
                    }
                }
            }
            UUID uuid = UUID.randomUUID();
            ScannerPlusIterator spi = new ScannerPlusIterator();
            spi.scanner = scanner;
            spi.iterator = scanner.iterator();
            this.scannerCache.put((Object)uuid, (Object)spi);
            return uuid.toString();
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return null;
        }
    }

    private ScannerPlusIterator getScanner(String scanner) throws UnknownScanner {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(scanner);
        }
        catch (IllegalArgumentException e) {
            throw new UnknownScanner(e.getMessage());
        }
        ScannerPlusIterator spi = (ScannerPlusIterator)this.scannerCache.getIfPresent((Object)uuid);
        if (spi == null) {
            throw new UnknownScanner("Scanner never existed or no longer exists");
        }
        return spi;
    }

    @Override
    public boolean hasNext(String scanner) throws UnknownScanner, TException {
        ScannerPlusIterator spi = this.getScanner(scanner);
        return spi.iterator.hasNext();
    }

    @Override
    public KeyValueAndPeek nextEntry(String scanner) throws NoMoreEntriesException, UnknownScanner, AccumuloSecurityException, TException {
        ScanResult scanResult = this.nextK(scanner, 1);
        if (scanResult.results.size() > 0) {
            return new KeyValueAndPeek(scanResult.results.get(0), scanResult.isMore());
        }
        throw new NoMoreEntriesException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult nextK(String scanner, int k) throws NoMoreEntriesException, UnknownScanner, AccumuloSecurityException, TException {
        Iterator<Map.Entry<org.apache.accumulo.core.data.Key, Value>> batchScanner;
        ScannerPlusIterator spi = this.getScanner(scanner);
        Iterator<Map.Entry<org.apache.accumulo.core.data.Key, Value>> iterator = batchScanner = spi.iterator;
        synchronized (iterator) {
            ScanResult ret = new ScanResult();
            ret.setResults(new ArrayList<KeyValue>());
            try {
                int numRead;
                for (numRead = 0; batchScanner.hasNext() && numRead < k; ++numRead) {
                    Map.Entry<org.apache.accumulo.core.data.Key, Value> next = batchScanner.next();
                    ret.addToResults(new KeyValue(Util.toThrift(next.getKey()), ByteBuffer.wrap(next.getValue().get())));
                }
                ret.setMore(numRead == k);
            }
            catch (Exception ex) {
                this.closeScanner(scanner);
                throw new AccumuloSecurityException(ex.toString());
            }
            return ret;
        }
    }

    @Override
    public void closeScanner(String scanner) throws UnknownScanner, TException {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(scanner);
        }
        catch (IllegalArgumentException e) {
            throw new UnknownScanner(e.getMessage());
        }
        try {
            if (this.scannerCache.asMap().remove(uuid) == null) {
                throw new UnknownScanner("Scanner never existed or no longer exists");
            }
        }
        catch (UnknownScanner e) {
            throw e;
        }
        catch (Exception e) {
            throw new TException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAndFlush(ByteBuffer login2, String tableName, Map<ByteBuffer, List<ColumnUpdate>> cells) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, MutationsRejectedException, TException {
        BatchWriterPlusException bwpe = null;
        try {
            bwpe = this.getWriter(login2, tableName, null);
            this.addCellsToWriter(cells, bwpe);
            if (bwpe.exception != null) {
                throw bwpe.exception;
            }
            bwpe.writer.flush();
        }
        catch (Exception e) {
            this.handleExceptionMRE(e);
        }
        finally {
            if (null != bwpe) {
                try {
                    bwpe.writer.close();
                }
                catch (org.apache.accumulo.core.client.MutationsRejectedException e) {
                    this.handleExceptionMRE((Exception)((Object)e));
                }
            }
        }
    }

    void addCellsToWriter(Map<ByteBuffer, List<ColumnUpdate>> cells, BatchWriterPlusException bwpe) {
        if (bwpe.exception != null) {
            return;
        }
        HashMap<Text, ColumnVisibility> vizMap = new HashMap<Text, ColumnVisibility>();
        for (Map.Entry<ByteBuffer, List<ColumnUpdate>> entry : cells.entrySet()) {
            Mutation m = new Mutation(ByteBufferUtil.toBytes((ByteBuffer)entry.getKey()));
            this.addUpdatesToMutation(vizMap, m, entry.getValue());
            try {
                bwpe.writer.addMutation(m);
            }
            catch (org.apache.accumulo.core.client.MutationsRejectedException mre) {
                bwpe.exception = mre;
            }
        }
    }

    private void addUpdatesToMutation(HashMap<Text, ColumnVisibility> vizMap, Mutation m, List<ColumnUpdate> cu) {
        for (ColumnUpdate update2 : cu) {
            ColumnVisibility viz = EMPTY_VIS;
            if (update2.isSetColVisibility()) {
                viz = ProxyServer.getCahcedCV(vizMap, update2.getColVisibility());
            }
            byte[] value = new byte[]{};
            if (update2.isSetValue()) {
                value = update2.getValue();
            }
            if (update2.isSetTimestamp()) {
                if (update2.isSetDeleteCell() && update2.isDeleteCell()) {
                    m.putDelete(update2.getColFamily(), update2.getColQualifier(), viz, update2.getTimestamp());
                    continue;
                }
                m.put(update2.getColFamily(), update2.getColQualifier(), viz, update2.getTimestamp(), value);
                continue;
            }
            if (update2.isSetDeleteCell() && update2.isDeleteCell()) {
                m.putDelete(new Text(update2.getColFamily()), new Text(update2.getColQualifier()), viz);
                continue;
            }
            m.put(new Text(update2.getColFamily()), new Text(update2.getColQualifier()), viz, new Value(value));
        }
    }

    private static ColumnVisibility getCahcedCV(HashMap<Text, ColumnVisibility> vizMap, byte[] cv) {
        Text vizText = new Text(cv);
        ColumnVisibility viz = vizMap.get(vizText);
        if (viz == null) {
            viz = new ColumnVisibility(vizText);
            vizMap.put(vizText, viz);
        }
        return viz;
    }

    @Override
    public String createWriter(ByteBuffer login2, String tableName, WriterOptions opts) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            BatchWriterPlusException writer = this.getWriter(login2, tableName, opts);
            UUID uuid = UUID.randomUUID();
            this.writerCache.put((Object)uuid, (Object)writer);
            return uuid.toString();
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return null;
        }
    }

    @Override
    public void update(String writer, Map<ByteBuffer, List<ColumnUpdate>> cells) throws TException {
        try {
            BatchWriterPlusException bwpe = this.getWriter(writer);
            this.addCellsToWriter(cells, bwpe);
        }
        catch (UnknownWriter unknownWriter) {
            // empty catch block
        }
    }

    @Override
    public void flush(String writer) throws UnknownWriter, MutationsRejectedException, TException {
        try {
            BatchWriterPlusException bwpe = this.getWriter(writer);
            if (bwpe.exception != null) {
                throw bwpe.exception;
            }
            bwpe.writer.flush();
        }
        catch (org.apache.accumulo.core.client.MutationsRejectedException e) {
            throw new MutationsRejectedException(e.toString());
        }
        catch (UnknownWriter uw) {
            throw uw;
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    @Override
    public void closeWriter(String writer) throws UnknownWriter, MutationsRejectedException, TException {
        try {
            BatchWriterPlusException bwpe = this.getWriter(writer);
            if (bwpe.exception != null) {
                throw bwpe.exception;
            }
            bwpe.writer.close();
            this.writerCache.invalidate((Object)UUID.fromString(writer));
        }
        catch (UnknownWriter uw) {
            throw uw;
        }
        catch (org.apache.accumulo.core.client.MutationsRejectedException e) {
            throw new MutationsRejectedException(e.toString());
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    private BatchWriterPlusException getWriter(String writer) throws UnknownWriter {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(writer);
        }
        catch (IllegalArgumentException iae) {
            throw new UnknownWriter(iae.getMessage());
        }
        BatchWriterPlusException bwpe = (BatchWriterPlusException)this.writerCache.getIfPresent((Object)uuid);
        if (bwpe == null) {
            throw new UnknownWriter("Writer never existed or no longer exists");
        }
        return bwpe;
    }

    BatchWriterPlusException getWriter(ByteBuffer login2, String tableName, WriterOptions opts) throws Exception {
        BatchWriterConfig cfg = new BatchWriterConfig();
        if (opts != null) {
            if (opts.maxMemory != 0L) {
                cfg.setMaxMemory(opts.maxMemory);
            }
            if (opts.threads != 0) {
                cfg.setMaxWriteThreads(opts.threads);
            }
            if (opts.timeoutMs != 0L) {
                cfg.setTimeout(opts.timeoutMs, TimeUnit.MILLISECONDS);
            }
            if (opts.latencyMs != 0L) {
                cfg.setMaxLatency(opts.latencyMs, TimeUnit.MILLISECONDS);
            }
        }
        BatchWriterPlusException result = new BatchWriterPlusException();
        result.writer = this.getConnector(login2).createBatchWriter(tableName, cfg);
        return result;
    }

    private org.apache.accumulo.core.client.IteratorSetting getIteratorSetting(IteratorSetting setting) {
        return new org.apache.accumulo.core.client.IteratorSetting(setting.priority, setting.name, setting.iteratorClass, setting.getProperties());
    }

    private IteratorUtil.IteratorScope getIteratorScope(IteratorScope scope) {
        return IteratorUtil.IteratorScope.valueOf((String)scope.toString().toLowerCase());
    }

    private EnumSet<IteratorUtil.IteratorScope> getIteratorScopes(Set<IteratorScope> scopes) {
        EnumSet<IteratorUtil.IteratorScope> scopes_ = EnumSet.noneOf(IteratorUtil.IteratorScope.class);
        for (IteratorScope scope : scopes) {
            scopes_.add(this.getIteratorScope(scope));
        }
        return scopes_;
    }

    private EnumSet<IteratorScope> getProxyIteratorScopes(Set<IteratorUtil.IteratorScope> scopes) {
        EnumSet<IteratorScope> scopes_ = EnumSet.noneOf(IteratorScope.class);
        for (IteratorUtil.IteratorScope scope : scopes) {
            scopes_.add(IteratorScope.valueOf(scope.toString().toUpperCase()));
        }
        return scopes_;
    }

    @Override
    public void attachIterator(ByteBuffer login2, String tableName, IteratorSetting setting, Set<IteratorScope> scopes) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().attachIterator(tableName, this.getIteratorSetting(setting), this.getIteratorScopes(scopes));
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public void checkIteratorConflicts(ByteBuffer login2, String tableName, IteratorSetting setting, Set<IteratorScope> scopes) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().checkIteratorConflicts(tableName, this.getIteratorSetting(setting), this.getIteratorScopes(scopes));
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public void cloneTable(ByteBuffer login2, String tableName, String newTableName, boolean flush2, Map<String, String> propertiesToSet, Set<String> propertiesToExclude) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException, TException {
        try {
            propertiesToExclude = propertiesToExclude == null ? new HashSet() : propertiesToExclude;
            propertiesToSet = propertiesToSet == null ? new HashMap() : propertiesToSet;
            this.getConnector(login2).tableOperations().clone(tableName, newTableName, flush2, propertiesToSet, propertiesToExclude);
        }
        catch (Exception e) {
            this.handleExceptionTEE(e);
        }
    }

    @Override
    public void exportTable(ByteBuffer login2, String tableName, String exportDir) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().exportTable(tableName, exportDir);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public void importTable(ByteBuffer login2, String tableName, String importDir) throws AccumuloException, AccumuloSecurityException, TableExistsException, TException {
        try {
            this.getConnector(login2).tableOperations().importTable(tableName, importDir);
        }
        catch (org.apache.accumulo.core.client.TableExistsException e) {
            throw new TableExistsException(e.toString());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public IteratorSetting getIteratorSetting(ByteBuffer login2, String tableName, String iteratorName, IteratorScope scope) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            org.apache.accumulo.core.client.IteratorSetting is = this.getConnector(login2).tableOperations().getIteratorSetting(tableName, iteratorName, this.getIteratorScope(scope));
            return new IteratorSetting(is.getPriority(), is.getName(), is.getIteratorClass(), is.getOptions());
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return null;
        }
    }

    @Override
    public Map<String, Set<IteratorScope>> listIterators(ByteBuffer login2, String tableName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            Map iterMap = this.getConnector(login2).tableOperations().listIterators(tableName);
            HashMap<String, Set<IteratorScope>> result = new HashMap<String, Set<IteratorScope>>();
            for (Map.Entry entry : iterMap.entrySet()) {
                result.put((String)entry.getKey(), (Set<IteratorScope>)this.getProxyIteratorScopes((Set)entry.getValue()));
            }
            return result;
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return null;
        }
    }

    @Override
    public void removeIterator(ByteBuffer login2, String tableName, String iterName, Set<IteratorScope> scopes) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            this.getConnector(login2).tableOperations().removeIterator(tableName, iterName, this.getIteratorScopes(scopes));
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public Set<Range> splitRangeByTablets(ByteBuffer login2, String tableName, Range range, int maxSplits) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            Set ranges = this.getConnector(login2).tableOperations().splitRangeByTablets(tableName, this.getRange(range), maxSplits);
            HashSet<Range> result = new HashSet<Range>();
            for (org.apache.accumulo.core.data.Range r : ranges) {
                result.add(this.getRange(r));
            }
            return result;
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return null;
        }
    }

    private Range getRange(org.apache.accumulo.core.data.Range r) {
        return new Range(this.getProxyKey(r.getStartKey()), r.isStartKeyInclusive(), this.getProxyKey(r.getEndKey()), r.isEndKeyInclusive());
    }

    private Key getProxyKey(org.apache.accumulo.core.data.Key k) {
        if (k == null) {
            return null;
        }
        Key result = new Key(TextUtil.getByteBuffer((Text)k.getRow()), TextUtil.getByteBuffer((Text)k.getColumnFamily()), TextUtil.getByteBuffer((Text)k.getColumnQualifier()), TextUtil.getByteBuffer((Text)k.getColumnVisibility()));
        result.setTimestamp(k.getTimestamp());
        return result;
    }

    private org.apache.accumulo.core.data.Range getRange(Range range) {
        return new org.apache.accumulo.core.data.Range(Util.fromThrift(range.start), Util.fromThrift(range.stop));
    }

    @Override
    public void importDirectory(ByteBuffer login2, String tableName, String importDir, String failureDir, boolean setTime) throws TableNotFoundException, AccumuloException, AccumuloSecurityException, TException {
        try {
            this.getConnector(login2).tableOperations().importDirectory(tableName, importDir, failureDir, setTime);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
        }
    }

    @Override
    public Range getRowRange(ByteBuffer row) throws TException {
        return this.getRange(new org.apache.accumulo.core.data.Range(ByteBufferUtil.toText((ByteBuffer)row)));
    }

    @Override
    public Key getFollowing(Key key, PartialKey part) throws TException {
        org.apache.accumulo.core.data.Key key_ = Util.fromThrift(key);
        org.apache.accumulo.core.data.PartialKey part_ = org.apache.accumulo.core.data.PartialKey.valueOf((String)part.toString());
        org.apache.accumulo.core.data.Key followingKey = key_.followingKey(part_);
        return this.getProxyKey(followingKey);
    }

    @Override
    public void pingTabletServer(ByteBuffer login2, String tserver) throws AccumuloException, AccumuloSecurityException, TException {
        try {
            this.getConnector(login2).instanceOperations().ping(tserver);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public ByteBuffer login(String principal, Map<String, String> loginProperties) throws AccumuloSecurityException, TException {
        try {
            AuthenticationToken token = this.getToken(principal, loginProperties);
            ByteBuffer login2 = ByteBuffer.wrap((this.instance.getInstanceID() + "," + new Credentials(principal, token).serialize()).getBytes(Charsets.UTF_8));
            this.getConnector(login2);
            return login2;
        }
        catch (org.apache.accumulo.core.client.AccumuloSecurityException e) {
            throw new AccumuloSecurityException(e.toString());
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    private AuthenticationToken getToken(String principal, Map<String, String> properties) throws org.apache.accumulo.core.client.AccumuloSecurityException, org.apache.accumulo.core.client.AccumuloException {
        AuthenticationToken token;
        AuthenticationToken.Properties props = new AuthenticationToken.Properties();
        props.putAllStrings(properties);
        try {
            token = this.tokenClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new org.apache.accumulo.core.client.AccumuloException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new org.apache.accumulo.core.client.AccumuloException((Throwable)e);
        }
        token.init(props);
        return token;
    }

    @Override
    public boolean testTableClassLoad(ByteBuffer login2, String tableName, String className, String asTypeName) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            return this.getConnector(login2).tableOperations().testClassLoad(tableName, className, asTypeName);
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return false;
        }
    }

    @Override
    public String createConditionalWriter(ByteBuffer login2, String tableName, ConditionalWriterOptions options) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        try {
            ConditionalWriterConfig cwc = new ConditionalWriterConfig();
            if (options.getMaxMemory() != 0L) {
                // empty if block
            }
            if (options.isSetThreads() && options.getThreads() != 0) {
                cwc.setMaxWriteThreads(options.getThreads());
            }
            if (options.isSetTimeoutMs() && options.getTimeoutMs() != 0L) {
                cwc.setTimeout(options.getTimeoutMs(), TimeUnit.MILLISECONDS);
            }
            if (options.isSetAuthorizations() && options.getAuthorizations() != null) {
                cwc.setAuthorizations(this.getAuthorizations(options.getAuthorizations()));
            }
            ConditionalWriter cw = this.getConnector(login2).createConditionalWriter(tableName, cwc);
            UUID id = UUID.randomUUID();
            this.conditionalWriterCache.put((Object)id, (Object)cw);
            return id.toString();
        }
        catch (Exception e) {
            this.handleExceptionTNF(e);
            return null;
        }
    }

    @Override
    public Map<ByteBuffer, ConditionalStatus> updateRowsConditionally(String conditionalWriter, Map<ByteBuffer, ConditionalUpdates> updates) throws UnknownWriter, AccumuloException, AccumuloSecurityException, TException {
        ConditionalWriter cw = (ConditionalWriter)this.conditionalWriterCache.getIfPresent((Object)UUID.fromString(conditionalWriter));
        if (cw == null) {
            throw new UnknownWriter();
        }
        try {
            HashMap<Text, ColumnVisibility> vizMap = new HashMap<Text, ColumnVisibility>();
            ArrayList<ConditionalMutation> cmuts = new ArrayList<ConditionalMutation>(updates.size());
            for (Map.Entry<ByteBuffer, ConditionalUpdates> cu : updates.entrySet()) {
                ConditionalMutation cmut = new ConditionalMutation(ByteBufferUtil.toBytes((ByteBuffer)cu.getKey()), new org.apache.accumulo.core.data.Condition[0]);
                for (Condition tcond : cu.getValue().conditions) {
                    org.apache.accumulo.core.data.Condition cond = new org.apache.accumulo.core.data.Condition(tcond.column.getColFamily(), tcond.column.getColQualifier());
                    if (tcond.getColumn().getColVisibility() != null && tcond.getColumn().getColVisibility().length > 0) {
                        cond.setVisibility(ProxyServer.getCahcedCV(vizMap, tcond.getColumn().getColVisibility()));
                    }
                    if (tcond.isSetValue()) {
                        cond.setValue(tcond.getValue());
                    }
                    if (tcond.isSetTimestamp()) {
                        cond.setTimestamp(tcond.getTimestamp());
                    }
                    if (tcond.isSetIterators()) {
                        cond.setIterators(this.getIteratorSettings(tcond.getIterators()).toArray(new org.apache.accumulo.core.client.IteratorSetting[tcond.getIterators().size()]));
                    }
                    cmut.addCondition(cond);
                }
                this.addUpdatesToMutation(vizMap, (Mutation)cmut, cu.getValue().updates);
                cmuts.add(cmut);
            }
            Iterator results = cw.write(cmuts.iterator());
            HashMap<ByteBuffer, ConditionalStatus> resultMap = new HashMap<ByteBuffer, ConditionalStatus>();
            while (results.hasNext()) {
                ConditionalWriter.Result result = (ConditionalWriter.Result)results.next();
                ByteBuffer row = ByteBuffer.wrap(result.getMutation().getRow());
                ConditionalStatus status = ConditionalStatus.valueOf(result.getStatus().name());
                resultMap.put(row, status);
            }
            return resultMap;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void closeConditionalWriter(String conditionalWriter) throws TException {
        ConditionalWriter cw = (ConditionalWriter)this.conditionalWriterCache.getIfPresent((Object)UUID.fromString(conditionalWriter));
        if (cw != null) {
            cw.close();
            this.conditionalWriterCache.invalidate((Object)UUID.fromString(conditionalWriter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConditionalStatus updateRowConditionally(ByteBuffer login2, String tableName, ByteBuffer row, ConditionalUpdates updates) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TException {
        String cwid = this.createConditionalWriter(login2, tableName, new ConditionalWriterOptions());
        try {
            ConditionalStatus conditionalStatus = this.updateRowsConditionally(cwid, Collections.singletonMap(row, updates)).get(row);
            return conditionalStatus;
        }
        finally {
            this.closeConditionalWriter(cwid);
        }
    }

    public static class CloseConditionalWriter
    implements RemovalListener<UUID, ConditionalWriter> {
        public void onRemoval(RemovalNotification<UUID, ConditionalWriter> notification) {
            ((ConditionalWriter)notification.getValue()).close();
        }
    }

    static class CloseScanner
    implements RemovalListener<UUID, ScannerPlusIterator> {
        public void onRemoval(RemovalNotification<UUID, ScannerPlusIterator> notification) {
            ScannerBase base = ((ScannerPlusIterator)notification.getValue()).scanner;
            if (base instanceof BatchScanner) {
                BatchScanner scanner = (BatchScanner)base;
                scanner.close();
            }
        }
    }

    static class CloseWriter
    implements RemovalListener<UUID, BatchWriterPlusException> {
        public void onRemoval(RemovalNotification<UUID, BatchWriterPlusException> notification) {
            try {
                BatchWriterPlusException value = (BatchWriterPlusException)notification.getValue();
                if (value.exception != null) {
                    throw value.exception;
                }
                ((BatchWriterPlusException)notification.getValue()).writer.close();
            }
            catch (org.apache.accumulo.core.client.MutationsRejectedException e) {
                logger.warn((Object)e, (Throwable)e);
            }
        }
    }

    protected static class BatchWriterPlusException {
        public BatchWriter writer;
        public org.apache.accumulo.core.client.MutationsRejectedException exception = null;

        protected BatchWriterPlusException() {
        }
    }

    protected static class ScannerPlusIterator {
        public ScannerBase scanner;
        public Iterator<Map.Entry<org.apache.accumulo.core.data.Key, Value>> iterator;

        protected ScannerPlusIterator() {
        }
    }
}

