/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.reservations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jline.console.ConsoleReader;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Condition;
import org.apache.accumulo.core.data.ConditionalMutation;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ARS {
    private static final Logger log = LoggerFactory.getLogger(ARS.class);
    private Connector conn;
    private String rTable;

    public ARS(Connector conn, String rTable) {
        this.conn = conn;
        this.rTable = rTable;
    }

    public List<String> setCapacity(String what, String when, int count) {
        throw new UnsupportedOperationException();
    }

    /*
     * Exception decompiling
     */
    public ReservationResult reserve(String what, String when, String who) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 19[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cancel(String what, String when, String who) throws Exception {
        String row = what + ":" + when;
        try (ConditionalWriter cwriter = this.conn.createConditionalWriter(this.rTable, new ConditionalWriterConfig());
             IsolatedScanner scanner = new IsolatedScanner(this.conn.createScanner(this.rTable, Authorizations.EMPTY));){
            ConditionalWriter.Status status;
            block28: while (true) {
                scanner.setRange(new Range((CharSequence)row));
                int seq = -1;
                String reservation = null;
                for (Map.Entry entry : scanner) {
                    String cf = ((Key)entry.getKey()).getColumnFamilyData().toString();
                    String cq = ((Key)entry.getKey()).getColumnQualifierData().toString();
                    String val = ((Value)entry.getValue()).toString();
                    if (cf.equals("tx") && cq.equals("seq")) {
                        seq = Integer.parseInt(val);
                        continue;
                    }
                    if (!cf.equals("res") || !val.equals(who)) continue;
                    reservation = cq;
                }
                if (reservation == null) return;
                ConditionalMutation update = new ConditionalMutation((CharSequence)row, new Condition[]{new Condition((CharSequence)"tx", (CharSequence)"seq").setValue((CharSequence)(seq + ""))});
                update.putDelete((CharSequence)"res", reservation);
                update.put((CharSequence)"tx", (CharSequence)"seq", (CharSequence)(seq + 1 + ""));
                status = cwriter.write(update).getStatus();
                switch (status) {
                    case ACCEPTED: {
                        return;
                    }
                    case REJECTED: 
                    case UNKNOWN: {
                        continue block28;
                    }
                }
                break;
            }
            throw new RuntimeException("Unexpected status " + status);
        }
    }

    public List<String> list(String what, String when) throws Exception {
        String row = what + ":" + when;
        try (IsolatedScanner scanner = new IsolatedScanner(this.conn.createScanner(this.rTable, Authorizations.EMPTY));){
            scanner.setRange(new Range((CharSequence)row));
            scanner.fetchColumnFamily(new Text("res"));
            ArrayList<String> reservations = new ArrayList<String>();
            for (Map.Entry entry : scanner) {
                String val = ((Value)entry.getValue()).toString();
                reservations.add(val);
            }
            ArrayList<String> arrayList = reservations;
            return arrayList;
        }
    }

    public static void main(String[] args) throws Exception {
        String line;
        final ConsoleReader reader = new ConsoleReader();
        ARS ars = null;
        while ((line = reader.readLine(">")) != null) {
            final String[] tokens = line.split("\\s+");
            if (tokens[0].equals("reserve") && tokens.length >= 4 && ars != null) {
                final ARS fars = ars;
                ArrayList<Thread> threads = new ArrayList<Thread>();
                int i = 3;
                while (i < tokens.length) {
                    final int whoIndex = i++;
                    Runnable reservationTask = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                reader.println((CharSequence)("  " + String.format("%20s", tokens[whoIndex]) + " : " + (Object)((Object)fars.reserve(tokens[1], tokens[2], tokens[whoIndex]))));
                            }
                            catch (Exception e) {
                                log.warn("Could not write to the ConsoleReader.", (Throwable)e);
                            }
                        }
                    };
                    threads.add(new Thread(reservationTask));
                }
                for (Thread thread : threads) {
                    thread.start();
                }
                for (Thread thread : threads) {
                    thread.join();
                }
                continue;
            }
            if (tokens[0].equals("cancel") && tokens.length == 4 && ars != null) {
                ars.cancel(tokens[1], tokens[2], tokens[3]);
                continue;
            }
            if (tokens[0].equals("list") && tokens.length == 3 && ars != null) {
                List<String> reservations = ars.list(tokens[1], tokens[2]);
                if (reservations.size() <= 0) continue;
                reader.println((CharSequence)("  Reservation holder : " + reservations.get(0)));
                if (reservations.size() <= 1) continue;
                reader.println((CharSequence)("  Wait list : " + reservations.subList(1, reservations.size())));
                continue;
            }
            if (tokens[0].equals("quit") && tokens.length == 1) break;
            if (tokens[0].equals("connect") && tokens.length == 6 && ars == null) {
                ZooKeeperInstance zki = new ZooKeeperInstance((Configuration)new ClientConfiguration(new Configuration[0]).withInstance(tokens[1]).withZkHosts(tokens[2]));
                Connector conn = zki.getConnector(tokens[3], (AuthenticationToken)new PasswordToken((CharSequence)tokens[4]));
                if (conn.tableOperations().exists(tokens[5])) {
                    ars = new ARS(conn, tokens[5]);
                    reader.println((CharSequence)"  connected");
                    continue;
                }
                reader.println((CharSequence)"  No Such Table");
                continue;
            }
            System.out.println("  Commands : ");
            if (ars == null) {
                reader.println((CharSequence)"    connect <instance> <zookeepers> <user> <pass> <table>");
                continue;
            }
            reader.println((CharSequence)"    reserve <what> <when> <who> {who}");
            reader.println((CharSequence)"    cancel <what> <when> <who>");
            reader.println((CharSequence)"    list <what> <when>");
        }
    }

    public static enum ReservationResult {
        RESERVED,
        WAIT_LISTED;

    }
}

