/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.lucene5;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ansj.library.AmbiguityLibrary;
import org.ansj.library.CrfLibrary;
import org.ansj.library.DicLibrary;
import org.ansj.library.StopLibrary;
import org.ansj.library.SynonymsLibrary;
import org.ansj.lucene.util.AnsjTokenizer;
import org.ansj.recognition.impl.StopRecognition;
import org.ansj.recognition.impl.SynonymsRecgnition;
import org.ansj.splitWord.Analysis;
import org.ansj.splitWord.analysis.BaseAnalysis;
import org.ansj.splitWord.analysis.DicAnalysis;
import org.ansj.splitWord.analysis.IndexAnalysis;
import org.ansj.splitWord.analysis.NlpAnalysis;
import org.ansj.splitWord.analysis.ToAnalysis;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.util.StringUtil;
import org.nlpcn.commons.lang.util.logging.Log;
import org.nlpcn.commons.lang.util.logging.LogFactory;

public class AnsjAnalyzer
extends Analyzer {
    public static final Log LOG = LogFactory.getLog();
    private Map<String, String> args;

    public AnsjAnalyzer(Map<String, String> args) {
        this.args = args;
    }

    public AnsjAnalyzer(TYPE type, String dics) {
        this.args = new HashMap<String, String>();
        this.args.put("type", type.name());
        this.args.put("dic", dics);
    }

    public AnsjAnalyzer(TYPE type) {
        this.args = new HashMap<String, String>();
        this.args.put("type", type.name());
    }

    protected Analyzer.TokenStreamComponents createComponents(String text) {
        BufferedReader reader = new BufferedReader(new StringReader(text));
        Tokenizer tokenizer = null;
        tokenizer = AnsjAnalyzer.getTokenizer(reader, this.args);
        return new Analyzer.TokenStreamComponents(tokenizer);
    }

    public static Tokenizer getTokenizer(Reader reader, Map<String, String> args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("to create tokenizer " + args);
        }
        BaseAnalysis analysis = null;
        String temp = null;
        String type = args.get("type");
        if (type == null) {
            type = TYPE.base_ansj.name();
        }
        switch (TYPE.valueOf(type)) {
            case base_ansj: {
                analysis = new BaseAnalysis();
                break;
            }
            case index_ansj: {
                analysis = new IndexAnalysis();
                break;
            }
            case dic_ansj: {
                analysis = new DicAnalysis();
                break;
            }
            case query_ansj: {
                analysis = new ToAnalysis();
                break;
            }
            case nlp_ansj: {
                analysis = new NlpAnalysis();
                temp = args.get("crf");
                if (!StringUtil.isNotBlank((CharSequence)temp)) break;
                ((NlpAnalysis)analysis).setCrfModel(CrfLibrary.get((String)temp));
                break;
            }
            default: {
                analysis = new BaseAnalysis();
            }
        }
        if (reader != null) {
            analysis.resetContent(reader);
        }
        if (StringUtil.isNotBlank((CharSequence)(temp = args.get("dic")))) {
            String[] split = temp.split(",");
            Forest[] forests = new Forest[split.length];
            for (int i = 0; i < forests.length; ++i) {
                if (StringUtil.isBlank((CharSequence)split[i])) continue;
                forests[i] = DicLibrary.get((String)split[i]);
            }
            analysis.setForests(forests);
        }
        ArrayList<StopRecognition> filters = null;
        temp = args.get("stop");
        if (StringUtil.isNotBlank((CharSequence)temp)) {
            String[] split = temp.split(",");
            filters = new ArrayList<StopRecognition>();
            for (String key : split) {
                StopRecognition stop = StopLibrary.get((String)key.trim());
                if (stop == null) continue;
                filters.add(stop);
            }
        }
        ArrayList<SynonymsRecgnition> synonyms = null;
        temp = args.get("synonyms");
        if (StringUtil.isNotBlank((CharSequence)temp)) {
            String[] split = temp.split(",");
            synonyms = new ArrayList<SynonymsRecgnition>();
            for (String key : split) {
                SmartForest sf = SynonymsLibrary.get((String)key.trim());
                if (sf == null) continue;
                synonyms.add(new SynonymsRecgnition(sf));
            }
        }
        if (StringUtil.isNotBlank((CharSequence)(temp = args.get("ambiguity")))) {
            analysis.setAmbiguityForest(AmbiguityLibrary.get((String)temp.trim()));
        }
        if (StringUtil.isNotBlank((CharSequence)(temp = args.get("isNameRecognition")))) {
            analysis.setIsNameRecognition(Boolean.valueOf(temp));
        }
        if (StringUtil.isNotBlank((CharSequence)(temp = args.get("isNumRecognition")))) {
            analysis.setIsNumRecognition(Boolean.valueOf(temp));
        }
        if (StringUtil.isNotBlank((CharSequence)(temp = args.get("isQuantifierRecognition")))) {
            analysis.setIsQuantifierRecognition(Boolean.valueOf(temp));
        }
        if (StringUtil.isNotBlank((CharSequence)(temp = args.get("isRealName")))) {
            analysis.setIsRealName(Boolean.valueOf(temp));
        }
        return new AnsjTokenizer((Analysis)analysis, filters, synonyms);
    }

    public static enum TYPE {
        base_ansj,
        index_ansj,
        query_ansj,
        dic_ansj,
        nlp_ansj;

    }
}

