/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.errors;

import java.io.PrintStream;
import java.util.Objects;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.errors.DistinctErrorLog;

public class LoggingErrorHandler
implements ErrorHandler {
    private final DistinctErrorLog log;
    private final PrintStream errorOverflow;

    public LoggingErrorHandler(DistinctErrorLog log) {
        this(log, System.err);
    }

    public LoggingErrorHandler(DistinctErrorLog log, PrintStream errorOverflow) {
        Objects.requireNonNull(log, "log");
        Objects.requireNonNull(log, "errorOverflow");
        this.log = log;
        this.errorOverflow = errorOverflow;
    }

    public DistinctErrorLog distinctErrorLog() {
        return this.log;
    }

    public PrintStream errorOverflow() {
        return this.errorOverflow;
    }

    @Override
    public void onError(Throwable throwable) {
        if (!this.log.record(throwable)) {
            this.errorOverflow.println("error Log is full, consider increasing length of error buffer");
            throwable.printStackTrace(this.errorOverflow);
        }
    }
}

