/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.agrona.AsciiEncoding;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.UnsafeAccess;

public class ExpandableArrayBuffer
implements MutableDirectBuffer {
    private static final boolean SHOULD_PRINT_ARRAY_CONTENT = !Boolean.getBoolean("agrona.disable.array.printout");
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    public static final int INITIAL_CAPACITY = 128;
    private byte[] byteArray;

    public ExpandableArrayBuffer() {
        this(128);
    }

    public ExpandableArrayBuffer(int initialCapacity) {
        this.byteArray = new byte[initialCapacity];
    }

    @Override
    public void wrap(byte[] buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(byte[] buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(long address, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressOffset() {
        return BufferUtil.ARRAY_BASE_OFFSET;
    }

    @Override
    public byte[] byteArray() {
        return this.byteArray;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return null;
    }

    @Override
    public void setMemory(int index, int length, byte value) {
        this.ensureCapacity(index, length);
        Arrays.fill(this.byteArray, index, index + length, value);
    }

    @Override
    public int capacity() {
        return this.byteArray.length;
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public void checkLimit(int limit) {
        this.ensureCapacity(limit, 1);
    }

    @Override
    public long getLong(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 8);
        long bits = UnsafeAccess.UNSAFE.getLong(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putLong(int index, long value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 8);
        long bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putLong(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
    }

    @Override
    public long getLong(int index) {
        this.boundsCheck0(index, 8);
        return UnsafeAccess.UNSAFE.getLong(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putLong(int index, long value) {
        this.ensureCapacity(index, 8);
        UnsafeAccess.UNSAFE.putLong(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
    }

    @Override
    public int getInt(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 4);
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putInt(int index, int value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 4);
        int bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
    }

    @Override
    public int getInt(int index) {
        this.boundsCheck0(index, 4);
        return UnsafeAccess.UNSAFE.getInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putInt(int index, int value) {
        this.ensureCapacity(index, 4);
        UnsafeAccess.UNSAFE.putInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
    }

    @Override
    public double getDouble(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 8);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = UnsafeAccess.UNSAFE.getLong(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
            return Double.longBitsToDouble(Long.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getDouble(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putDouble(int index, double value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 8);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = Long.reverseBytes(Double.doubleToRawLongBits(value));
            UnsafeAccess.UNSAFE.putLong(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
        } else {
            UnsafeAccess.UNSAFE.putDouble(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
        }
    }

    @Override
    public double getDouble(int index) {
        this.boundsCheck0(index, 8);
        return UnsafeAccess.UNSAFE.getDouble(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putDouble(int index, double value) {
        this.ensureCapacity(index, 8);
        UnsafeAccess.UNSAFE.putDouble(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
    }

    @Override
    public float getFloat(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 4);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
            return Float.intBitsToFloat(Integer.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getFloat(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putFloat(int index, float value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 4);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = Integer.reverseBytes(Float.floatToRawIntBits(value));
            UnsafeAccess.UNSAFE.putInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
        } else {
            UnsafeAccess.UNSAFE.putFloat(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
        }
    }

    @Override
    public float getFloat(int index) {
        this.boundsCheck0(index, 4);
        return UnsafeAccess.UNSAFE.getFloat(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putFloat(int index, float value) {
        this.ensureCapacity(index, 4);
        UnsafeAccess.UNSAFE.putFloat(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
    }

    @Override
    public short getShort(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 2);
        short bits = UnsafeAccess.UNSAFE.getShort(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putShort(int index, short value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 2);
        short bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putShort(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
    }

    @Override
    public short getShort(int index) {
        this.boundsCheck0(index, 2);
        return UnsafeAccess.UNSAFE.getShort(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putShort(int index, short value) {
        this.ensureCapacity(index, 2);
        UnsafeAccess.UNSAFE.putShort(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
    }

    @Override
    public byte getByte(int index) {
        return this.byteArray[index];
    }

    @Override
    public void putByte(int index, byte value) {
        this.ensureCapacity(index, 1);
        this.byteArray[index] = value;
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        this.getBytes(index, dst, 0, dst.length);
    }

    @Override
    public void getBytes(int index, byte[] dst, int offset, int length) {
        System.arraycopy(this.byteArray, index, dst, offset, length);
    }

    @Override
    public void getBytes(int index, MutableDirectBuffer dstBuffer, int dstIndex, int length) {
        dstBuffer.putBytes(dstIndex, this, index, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dstBuffer, int length) {
        int dstOffset = dstBuffer.position();
        this.getBytes(index, dstBuffer, dstOffset, length);
        dstBuffer.position(dstOffset + length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dstBuffer, int dstOffset, int length) {
        long dstBaseOffset;
        byte[] dstByteArray;
        this.boundsCheck0(index, length);
        BufferUtil.boundsCheck(dstBuffer, (long)dstOffset, length);
        if (dstBuffer.isDirect()) {
            dstByteArray = null;
            dstBaseOffset = BufferUtil.address(dstBuffer);
        } else {
            dstByteArray = BufferUtil.array(dstBuffer);
            dstBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(dstBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, dstByteArray, dstBaseOffset + (long)dstOffset, length);
    }

    @Override
    public void putBytes(int index, byte[] src) {
        this.putBytes(index, src, 0, src.length);
    }

    @Override
    public void putBytes(int index, byte[] src, int offset, int length) {
        this.ensureCapacity(index, length);
        System.arraycopy(src, offset, this.byteArray, index, length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int length) {
        int srcIndex = srcBuffer.position();
        this.putBytes(index, srcBuffer, srcIndex, length);
        srcBuffer.position(srcIndex + length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int srcIndex, int length) {
        long srcBaseOffset;
        byte[] srcByteArray;
        this.ensureCapacity(index, length);
        BufferUtil.boundsCheck(srcBuffer, (long)srcIndex, length);
        if (srcBuffer.isDirect()) {
            srcByteArray = null;
            srcBaseOffset = BufferUtil.address(srcBuffer);
        } else {
            srcByteArray = BufferUtil.array(srcBuffer);
            srcBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(srcBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(srcByteArray, srcBaseOffset + (long)srcIndex, this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, length);
    }

    @Override
    public void putBytes(int index, DirectBuffer srcBuffer, int srcIndex, int length) {
        this.ensureCapacity(index, length);
        srcBuffer.boundsCheck(srcIndex, length);
        UnsafeAccess.UNSAFE.copyMemory(srcBuffer.byteArray(), srcBuffer.addressOffset() + (long)srcIndex, this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, length);
    }

    @Override
    public char getChar(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 2);
        char bits = UnsafeAccess.UNSAFE.getChar(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        return bits;
    }

    @Override
    public void putChar(int index, char value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 2);
        char bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        UnsafeAccess.UNSAFE.putChar(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
    }

    @Override
    public char getChar(int index) {
        this.boundsCheck0(index, 2);
        return UnsafeAccess.UNSAFE.getChar(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putChar(int index, char value) {
        this.ensureCapacity(index, 2);
        UnsafeAccess.UNSAFE.putChar(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
    }

    @Override
    public String getStringAscii(int index) {
        this.boundsCheck0(index, 4);
        int length = UnsafeAccess.UNSAFE.getInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        return this.getStringAscii(index, length);
    }

    @Override
    public int getStringAscii(int index, Appendable appendable) {
        this.boundsCheck0(index, 4);
        int length = UnsafeAccess.UNSAFE.getInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        return this.getStringAscii(index, length, appendable);
    }

    @Override
    public String getStringAscii(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 4);
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        int length = bits;
        return this.getStringAscii(index, length);
    }

    @Override
    public int getStringAscii(int index, Appendable appendable, ByteOrder byteOrder) {
        this.boundsCheck0(index, 4);
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        int length = bits;
        return this.getStringAscii(index, length, appendable);
    }

    @Override
    public String getStringAscii(int index, int length) {
        byte[] stringInBytes = new byte[length];
        System.arraycopy(this.byteArray, index + 4, stringInBytes, 0, length);
        return new String(stringInBytes, StandardCharsets.US_ASCII);
    }

    @Override
    public int getStringAscii(int index, int length, Appendable appendable) {
        try {
            int limit = index + 4 + length;
            for (int i = index + 4; i < limit; ++i) {
                char c = (char)this.byteArray[i];
                appendable.append(c > '\u007f' ? (char)'?' : (char)c);
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return length;
    }

    @Override
    public int putStringAscii(int index, String value) {
        int length = value != null ? value.length() : 0;
        this.ensureCapacity(index, length + 4);
        UnsafeAccess.UNSAFE.putInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, length);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + 4L + (long)index + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public int putStringAscii(int index, String value, ByteOrder byteOrder) {
        int length = value != null ? value.length() : 0;
        this.ensureCapacity(index, length + 4);
        int bits = length;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + 4L + (long)index + (long)i, (byte)c);
        }
        return 4 + length;
    }

    @Override
    public String getStringWithoutLengthAscii(int index, int length) {
        byte[] stringInBytes = new byte[length];
        System.arraycopy(this.byteArray, index, stringInBytes, 0, length);
        return new String(stringInBytes, StandardCharsets.US_ASCII);
    }

    @Override
    public int getStringWithoutLengthAscii(int index, int length, Appendable appendable) {
        try {
            int limit = index + length;
            for (int i = index; i < limit; ++i) {
                char c = (char)this.byteArray[i];
                appendable.append(c > '\u007f' ? (char)'?' : (char)c);
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return length;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, String value) {
        int length = value != null ? value.length() : 0;
        this.ensureCapacity(index, length);
        for (int i = 0; i < length; ++i) {
            int c = value.charAt(i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index + (long)i, (byte)c);
        }
        return length;
    }

    @Override
    public int putStringWithoutLengthAscii(int index, String value, int valueOffset, int length) {
        int len = value != null ? Math.min(value.length() - valueOffset, length) : 0;
        this.ensureCapacity(index, len);
        for (int i = 0; i < len; ++i) {
            int c = value.charAt(valueOffset + i);
            if (c > 127) {
                c = 63;
            }
            UnsafeAccess.UNSAFE.putByte(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index + (long)i, (byte)c);
        }
        return len;
    }

    @Override
    public String getStringUtf8(int index) {
        this.boundsCheck0(index, 4);
        int length = UnsafeAccess.UNSAFE.getInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        return this.getStringUtf8(index, length);
    }

    @Override
    public String getStringUtf8(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 4);
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        int length = bits;
        return this.getStringUtf8(index, length);
    }

    @Override
    public String getStringUtf8(int index, int length) {
        byte[] stringInBytes = new byte[length];
        System.arraycopy(this.byteArray, index + 4, stringInBytes, 0, length);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringUtf8(int index, String value) {
        return this.putStringUtf8(index, value, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int index, String value, ByteOrder byteOrder) {
        return this.putStringUtf8(index, value, byteOrder, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int index, String value, int maxEncodedLength) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedLength) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedLength);
        }
        this.ensureCapacity(index, 4 + bytes.length);
        UnsafeAccess.UNSAFE.putInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bytes.length);
        System.arraycopy(bytes, 0, this.byteArray, index + 4, bytes.length);
        return 4 + bytes.length;
    }

    @Override
    public int putStringUtf8(int index, String value, ByteOrder byteOrder, int maxEncodedLength) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedLength) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedLength);
        }
        this.ensureCapacity(index, 4 + bytes.length);
        int bits = bytes.length;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
        System.arraycopy(bytes, 0, this.byteArray, index + 4, bytes.length);
        return 4 + bytes.length;
    }

    @Override
    public String getStringWithoutLengthUtf8(int index, int length) {
        byte[] stringInBytes = new byte[length];
        System.arraycopy(this.byteArray, index, stringInBytes, 0, length);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringWithoutLengthUtf8(int index, String value) {
        byte[] bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        this.ensureCapacity(index, bytes.length);
        System.arraycopy(bytes, 0, this.byteArray, index, bytes.length);
        return bytes.length;
    }

    @Override
    public int parseNaturalIntAscii(int index, int length) {
        this.boundsCheck0(index, length);
        int end = index + length;
        int tally = 0;
        for (int i = index; i < end; ++i) {
            tally = tally * 10 + AsciiEncoding.getDigit(i, this.byteArray[i]);
        }
        return tally;
    }

    @Override
    public long parseNaturalLongAscii(int index, int length) {
        this.boundsCheck0(index, length);
        int end = index + length;
        long tally = 0L;
        for (int i = index; i < end; ++i) {
            tally = tally * 10L + (long)AsciiEncoding.getDigit(i, this.byteArray[i]);
        }
        return tally;
    }

    @Override
    public int parseIntAscii(int index, int length) {
        this.boundsCheck0(index, length);
        int endExclusive = index + length;
        byte first = this.getByte(index);
        int i = index;
        if (first == 45) {
            ++i;
        }
        int tally = 0;
        while (i < endExclusive) {
            tally = tally * 10 + AsciiEncoding.getDigit(i, this.byteArray[i]);
            ++i;
        }
        if (first == 45) {
            tally = -tally;
        }
        return tally;
    }

    @Override
    public long parseLongAscii(int index, int length) {
        this.boundsCheck0(index, length);
        int endExclusive = index + length;
        byte first = this.getByte(index);
        int i = index;
        if (first == 45) {
            ++i;
        }
        long tally = 0L;
        while (i < endExclusive) {
            tally = tally * 10L + (long)AsciiEncoding.getDigit(i, this.byteArray[i]);
            ++i;
        }
        if (first == 45) {
            tally = -tally;
        }
        return tally;
    }

    @Override
    public int putIntAscii(int index, int value) {
        int i;
        if (value == 0) {
            this.putByte(index, (byte)48);
            return 1;
        }
        if (value == Integer.MIN_VALUE) {
            this.putBytes(index, AsciiEncoding.MIN_INTEGER_VALUE);
            return AsciiEncoding.MIN_INTEGER_VALUE.length;
        }
        int start = index;
        int quotient = value;
        int length = 1;
        if (value < 0) {
            this.putByte(index, (byte)45);
            ++start;
            ++length;
            quotient = -quotient;
        }
        this.ensureCapacity(index, length += i);
        for (i = AsciiEncoding.endOffset(quotient); i >= 0; --i) {
            int remainder = quotient % 10;
            quotient /= 10;
            this.byteArray[i + start] = (byte)(48 + remainder);
        }
        return length;
    }

    @Override
    public int putNaturalIntAscii(int index, int value) {
        int i;
        if (value == 0) {
            this.putByte(index, (byte)48);
            return 1;
        }
        int length = i + 1;
        this.ensureCapacity(index, length);
        int quotient = value;
        for (i = AsciiEncoding.endOffset(value); i >= 0; --i) {
            int remainder = quotient % 10;
            quotient /= 10;
            this.byteArray[i + index] = (byte)(48 + remainder);
        }
        return length;
    }

    @Override
    public void putNaturalPaddedIntAscii(int offset, int length, int value) {
        int end = offset + length;
        int remainder = value;
        for (int index = end - 1; index >= offset; --index) {
            int digit = remainder % 10;
            remainder /= 10;
            this.putByte(index, (byte)(48 + digit));
        }
        if (remainder != 0) {
            throw new NumberFormatException(String.format("Cannot write %d in %d bytes", value, length));
        }
    }

    @Override
    public int putNaturalIntAsciiFromEnd(int value, int endExclusive) {
        int index = endExclusive;
        for (int remainder = value; remainder > 0; remainder /= 10) {
            int digit = remainder % 10;
            this.putByte(--index, (byte)(48 + digit));
        }
        return index;
    }

    @Override
    public int putNaturalLongAscii(int index, long value) {
        int i;
        if (value == 0L) {
            this.putByte(index, (byte)48);
            return 1;
        }
        int length = i + 1;
        this.ensureCapacity(index, length);
        long quotient = value;
        for (i = AsciiEncoding.endOffset(value); i >= 0; --i) {
            long remainder = quotient % 10L;
            quotient /= 10L;
            this.byteArray[i + index] = (byte)(48L + remainder);
        }
        return length;
    }

    @Override
    public int putLongAscii(int index, long value) {
        int i;
        if (value == 0L) {
            this.putByte(index, (byte)48);
            return 1;
        }
        if (value == Long.MIN_VALUE) {
            this.putBytes(index, AsciiEncoding.MIN_LONG_VALUE);
            return AsciiEncoding.MIN_LONG_VALUE.length;
        }
        int start = index;
        long quotient = value;
        int length = 1;
        if (value < 0L) {
            this.putByte(index, (byte)45);
            ++start;
            ++length;
            quotient = -quotient;
        }
        this.ensureCapacity(index, length += i);
        for (i = AsciiEncoding.endOffset(quotient); i >= 0; --i) {
            long remainder = quotient % 10L;
            quotient /= 10L;
            this.byteArray[i + start] = (byte)(48L + remainder);
        }
        return length;
    }

    private void ensureCapacity(int index, int length) {
        if (index < 0 || length < 0) {
            throw new IndexOutOfBoundsException("negative value: index=" + index + " length=" + length);
        }
        long resultingPosition = (long)index + (long)length;
        int currentArrayLength = this.byteArray.length;
        if (resultingPosition > (long)currentArrayLength) {
            if (currentArrayLength >= 0x7FFFFFF7) {
                throw new IndexOutOfBoundsException("index=" + index + " length=" + length + " maxCapacity=" + 0x7FFFFFF7);
            }
            this.byteArray = Arrays.copyOf(this.byteArray, this.calculateExpansion(currentArrayLength, (int)resultingPosition));
        }
    }

    private int calculateExpansion(int currentLength, int requiredLength) {
        long value = currentLength;
        while (value < (long)requiredLength) {
            if ((value += value >> 1) <= 0x7FFFFFF7L) continue;
            value = 0x7FFFFFF7L;
        }
        return (int)value;
    }

    private void boundsCheck0(int index, int length) {
        int currentArrayLength = this.byteArray.length;
        long resultingPosition = (long)index + (long)length;
        if (index < 0 || length < 0 || resultingPosition > (long)currentArrayLength) {
            throw new IndexOutOfBoundsException("index=" + index + " length=" + length + " capacity=" + currentArrayLength);
        }
    }

    @Override
    public void boundsCheck(int index, int length) {
        this.boundsCheck0(index, length);
    }

    @Override
    public int wrapAdjustment() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExpandableArrayBuffer that = (ExpandableArrayBuffer)obj;
        return Arrays.equals(this.byteArray, that.byteArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.byteArray);
    }

    @Override
    public int compareTo(DirectBuffer that) {
        int thisCapacity = this.capacity();
        int thatCapacity = that.capacity();
        byte[] thisByteArray = this.byteArray;
        byte[] thatByteArray = that.byteArray();
        long thisOffset = this.addressOffset();
        long thatOffset = that.addressOffset();
        int length = Math.min(thisCapacity, thatCapacity);
        for (int i = 0; i < length; ++i) {
            int cmp = Byte.compare(UnsafeAccess.UNSAFE.getByte(thisByteArray, thisOffset + (long)i), UnsafeAccess.UNSAFE.getByte(thatByteArray, thatOffset + (long)i));
            if (0 == cmp) continue;
            return cmp;
        }
        if (thisCapacity != thatCapacity) {
            return thisCapacity - thatCapacity;
        }
        return 0;
    }

    public String toString() {
        return "ExpandableArrayBuffer{byteArray=" + (SHOULD_PRINT_ARRAY_CONTENT ? (Object)Arrays.toString(this.byteArray) : this.byteArray) + '}';
    }
}

