/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.nio.charset.StandardCharsets;
import org.agrona.AsciiNumberFormatException;

public class AsciiEncoding {
    public static final byte ZERO = 48;
    private static final int[] INT_ROUNDS = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final long[] LONG_ROUNDS = new long[]{9L, 99L, 999L, 9999L, 99999L, 999999L, 9999999L, 99999999L, 999999999L, 9999999999L, 99999999999L, 999999999999L, 9999999999999L, 99999999999999L, 999999999999999L, 9999999999999999L, 99999999999999999L, 999999999999999999L, Long.MAX_VALUE};
    public static final byte[] MIN_INTEGER_VALUE = String.valueOf(Integer.MIN_VALUE).getBytes(StandardCharsets.US_ASCII);
    public static final byte[] MIN_LONG_VALUE = String.valueOf(Long.MIN_VALUE).getBytes(StandardCharsets.US_ASCII);
    public static final byte MINUS_SIGN = 45;

    public static int endOffset(int value) {
        int i = 0;
        while (value > INT_ROUNDS[i]) {
            ++i;
        }
        return i;
    }

    public static int endOffset(long value) {
        int i = 0;
        while (value > LONG_ROUNDS[i]) {
            ++i;
        }
        return i;
    }

    public static int getDigit(int index, byte value) {
        if (value < 48 || value > 57) {
            throw new AsciiNumberFormatException("'" + (char)value + "' is not a valid digit @ " + index);
        }
        return value - 48;
    }

    public static int getDigit(int index, char value) {
        if (value < '0' || value > '9') {
            throw new AsciiNumberFormatException("'" + value + "' is not a valid digit @ " + index);
        }
        return value - 48;
    }

    public static int parseIntAscii(CharSequence cs, int index, int length) {
        int endExclusive = index + length;
        char first = cs.charAt(index);
        int i = index;
        if (first == '-') {
            ++i;
        }
        int tally = 0;
        while (i < endExclusive) {
            tally = tally * 10 + AsciiEncoding.getDigit(i, cs.charAt(i));
            ++i;
        }
        if (first == '-') {
            tally = -tally;
        }
        return tally;
    }

    public static long parseLongAscii(CharSequence cs, int index, int length) {
        int endExclusive = index + length;
        char first = cs.charAt(index);
        int i = index;
        if (first == '-') {
            ++i;
        }
        long tally = 0L;
        while (i < endExclusive) {
            tally = tally * 10L + (long)AsciiEncoding.getDigit(i, cs.charAt(i));
            ++i;
        }
        if (first == '-') {
            tally = -tally;
        }
        return tally;
    }
}

